#include <windows.h>
#include "resource.h"

#define NAME "Window Test"

LRESULT CALLBACK WndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
void    Init(HWND hWnd);
void    ExitInit();
void    UpdateFrame();

#include "DirectDraw.h"

CDirectDraw *g_pDirectDraw;  //DirectDraw ϱ Ѻ

int g_x;
int g_y;

//  .
int WINAPI WinMain ( HINSTANCE hInstance,
					 HINSTANCE hPrevInstance,
					 LPSTR lpCmdLine,
					 int nShowCmd)

{
	// Ŭ
	WNDCLASS wc;

	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH)GetStockObject( BLACK_BRUSH);
	wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	wc.hIcon   = LoadIcon ( hInstance, "IDI_ICON1");
	wc.hInstance = hInstance;
	wc.lpfnWndProc = WndProc;
	wc.lpszClassName = NAME;
	wc.lpszMenuName = NULL;
	wc.style = CS_VREDRAW|CS_HREDRAW;

	RegisterClass (&wc);   //

	//
	HWND hWnd = CreateWindowEx (
		WS_EX_APPWINDOW,
		NAME,
		NAME,
		WS_POPUP,
		0,
		0,
		800,
		600,
		NULL,
		NULL,
		hInstance,
		NULL);

	ShowWindow (hWnd, SW_SHOW);
	UpdateWindow ( hWnd);

	Init(hWnd);

	//  ޼ ޾Ƽ WndProc ѱ.
	MSG msg;
	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0))
				return msg.wParam;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}else
		if (1)
		{
			UpdateFrame();
		}
	}

	return TRUE;
}



//  ޼ ޾Ƽ óϴ κ
LRESULT CALLBACK WndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{

	switch ( msg)
	{
		// Ű ƾ.
		case WM_KEYDOWN:
			if(wParam == VK_ESCAPE)	ExitInit();

			if(wParam == VK_LEFT) g_x --;
			if(wParam == VK_UP)   g_y --;
			if(wParam == VK_RIGHT) g_x ++;
			if(wParam == VK_DOWN)  g_y ++;

			break;
	}

	return DefWindowProc ( hWnd, msg, wParam, lParam);
}

void Init(HWND hWnd)
{
	g_pDirectDraw = new CDirectDraw();
	g_pDirectDraw->Init(hWnd, 800, 600);
}

void ExitInit()
{
	g_pDirectDraw->ExitInit();
	PostQuitMessage(0);
}

void UpdateFrame()
{
	RECT rect;
	SetRect(&rect, 0, 0, 800, 600);

	g_pDirectDraw->ClearBack();
	g_pDirectDraw->PutPixel(g_x,g_y,0xf000);
	g_pDirectDraw->BltBack(rect);
}

