#include "Study3.h"
#include "cdirectdraw.h"
#include "ccharacter.h"
#include "cmap.h"
//#include "chan.h"
#include "chan2.h"
#include <stdio.h>
#include "resource.h"

CDirectDraw *m_pDirectDraw;
CCharacter	*m_pCharacter;
CMap		*m_pMap;
CHan2		*m_pHan2;



int WINAPI WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstsance, LPSTR lpCmdLine, int nShowCmd)
{
	WNDCLASS wc;

	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	wc.hIcon   = LoadIcon   (hInstance, "IDI_ICON1");
	wc.hInstance = hInstance;
	wc.lpfnWndProc = WndProc;
	wc.lpszClassName = NAME;
	wc.lpszMenuName = NULL;
	wc.style = CS_VREDRAW|CS_HREDRAW;

	RegisterClass(&wc);

	g_OverScreenResult = 4;
	

	HWND hWnd = CreateWindowEx(
		WS_EX_APPWINDOW,
		NAME,
		NAME,
		WS_POPUP,
		0,
		0,
		800,
		600,
		NULL,
		NULL,
		hInstance,
		NULL);



	m_pDirectDraw = new CDirectDraw();
	if(!m_pDirectDraw->Init(hWnd,800,600,16)) MessageBox(NULL, "FAILD : Direct Draw Class", "TRYOVER MESSAGE", MB_OK);

	m_pCharacter = new CCharacter();
	if(!m_pCharacter->Init(m_pDirectDraw->GetDirectDraw(), m_pDirectDraw->GetBackSurface()))MessageBox(NULL, "FAILD : Character Object", "TRYOVER MESSAGE", MB_OK);

	m_pMap = new CMap();
	if(!m_pMap->Init(m_pDirectDraw->GetDirectDraw(), m_pDirectDraw->GetBackSurface())) MessageBox(NULL, "FAILD : Map Object", "TRYOVER MESSAGE", MB_OK);

	m_pHan2 = new CHan2();
	if(!m_pHan2->Init(m_pDirectDraw->GetDirectDraw(), m_pDirectDraw->GetBackSurface())) MessageBox(NULL, "FAILD : Hangul Object", "TRYOVER MESSAGE", MB_OK);

	
	m_pDirectDraw->ClearBack();
	
	m_pMap->LoadMap();
	m_pCharacter->LoadCharacter();

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow( hWnd);

	g_MessageString = ( char *) malloc (80);
	memset((char*)g_MessageString, 0, 80);
	
	HWND hDlg;
	hDlg = CreateDialog(hInstance,"IDD_DIALOG",hWnd,DlgProc);
	SetWindowPos(hDlg, NULL, 0, 580, 800, 20,NULL);

	g_FileName = (char *) malloc (80);
	memset((char*) g_FileName,0, 80);
	
	SetFocus(hWnd);

	g_bActive = TRUE;
	MSG msg;
	while(1)
	{
		if( PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if( !GetMessage (&msg, NULL, 0, 0))
				return msg.wParam;

			if(!IsDialogMessage(hDlg,&msg))
			{
				TranslateMessage( &msg);
				DispatchMessage( &msg);
			}
		}
		else if ( g_bActive)
		{
			MainLoop();
		}
		else
			WaitMessage();
	}

	return TRUE;
}

LRESULT CALLBACK WndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{


	switch( msg)
	{
		case WM_KEYDOWN:
			KeyLoop((int)wParam, lParam);
			break;			
	
		
	}

	return DefWindowProc(hWnd,msg,wParam, lParam);
}

void MainLoop()
{	

	switch ( g_OverScreenResult)
	{
		case 0:
			
			g_MapX = g_MapX- 128;
			if( g_MapX < 0) g_MapX=0;
			break;

		case 1:
			
			g_MapX = g_MapX + 128;
			if( g_MapX > 3072) g_MapX = 3072;
			break;

		case 2:
			
			g_MapY = g_MapY - 64;
			if( g_MapY < 0) g_MapY=0;
			break;

		case 3:
			
			g_MapY = g_MapY + 64;
			if (g_MapY > 2304) g_MapY= 2304;
			break;

	}
	g_OverScreenResult = 4;

	m_pMap->BltMap(g_MapX,g_MapY);

	POINT pt = m_pMap->BltTileEdit();


	int Pos;
	Pos = m_pMap->ComplexPosition(g_MapX, g_MapY, pt.x, pt.y);

	static char String[50];
//	static char String2[50];
//	static char String3[50];


	ZeroMemory(String,50);
	sprintf(String," Std X=%d Std Y=%d ",g_MapX,g_MapY);

//	ZeroMemory(String2,50);
//	sprintf(String2," Ŀ x = %d y = %d",pt.x, pt.y);

//	ZeroMemory(String3,50);
//	sprintf(String3," %d",Pos);


	m_pDirectDraw->PutString(0,0,String,50);
//	m_pDirectDraw->PutString(0,20,String2,50);
//	m_pDirectDraw->PutString(0,40,String3,50);


	static Count;
	Count++;
	if(Count==5)Count=0;
	m_pCharacter->SetPos(380,300);

	m_pCharacter->BltCharacter(0,Count);

	m_pDirectDraw->PutString(0, 560, g_FileName,80);
	
	m_pDirectDraw->BltBack();
}

void KeyLoop(int nVirtKey, LPARAM lKeyData)
{


	if(nVirtKey == VK_ESCAPE) 
	{		
		m_pCharacter->ExitInit();
		delete m_pCharacter;

		m_pMap->ExitInit();
		delete m_pMap;

		delete m_pHan2;

		m_pDirectDraw->ExitInit();
		delete m_pDirectDraw;
		
		PostQuitMessage (0);
	}

	g_OverScreenResult = m_pMap->InKey( nVirtKey, lKeyData);
	
}

BOOL WINAPI DlgProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch ( msg)
	{
		case WM_COMMAND:
			switch( LOWORD ( wParam))
			{
				case IDOK:
					GetDlgItemText(hWnd, IDC_EDIT1, g_MessageString,80);
					memset((char*) g_FileName,0,80);
					strcpy(g_FileName,g_MessageString);
					m_pMap->GetFileName(g_FileName);
					memset((char*)g_MessageString,0,80);
					SetDlgItemText(hWnd,IDC_EDIT1,g_MessageString);
					break;

				case IDC_EDIT1:
					break;

			}
			break;

	}
	return 0;
}

					

