#ifndef _CCHARACTER_H
#define _CCHARACTER_H

#include <windows.h>
#include "cdirectdraw.h"

class CCharacter:public CDirectDraw
{

	public:
		BOOL	m_bActive;
		int		m_Scene;
		int     m_CurPosX;
		int     m_CurPosY;
		RECT    m_charRect;


		LPDIRECTDRAWSURFACE m_pDDS_Image[5];
		// 0:LEFT 1:RIGHT 2:TOP 3:DOWN 4:ATTACK 5:DEFENCE
		LPDIRECTDRAWSURFACE m_pDDS_Buffer;

	public:
		virtual BOOL Init(LPDIRECTDRAW2 lpDD, LPDIRECTDRAWSURFACE lpDDS);
		virtual void ExitInit();

		void LoadCharacter();
		void BltCharacter(int SceneNum, int FrameNum); 

	public:
		void SetPos(int PosX, int PosY);
		int GetCurPosX();				// Map Position
		int GetCurPosY();
		
		void Pattern_Move_Left	(int Range);
		void Pattern_Move_Right	(int Range);
		void Pattern_Move_Up		(int Range);
		void Pattern_Move_Down	(int Range);

//		Pattern_Attack_Normal_Left();
//		Pattern_Attack_Normal_Right();
//		Pattern_Attack_Normal_Up();
//		Pattern_Attack_Normal_Down();

//		Pattern_Attack_Special_Left();
//		Pattern_Attack_Special_Right();
//		Pattern_Attack_Special_Up();
//		Pattern_Attack_Special_Down();

//		Pattern_Defence_Normal_Left();
//		Pattern_Defence_Normal_Right();
//		Pattern_Defence_Normal_Up();
//		Pattern_Defence_Normal_Down();
	
		

		
};


#endif _CCHARACTER_H