#include "cmap.h"
#include <stdio.h>

BOOL CMap::Init(LPDIRECTDRAW2 lpDD, LPDIRECTDRAWSURFACE lpDDS)
{
	CDirectDraw::m_pDD2 = lpDD;
	CDirectDraw::m_pDDSBack = lpDDS;

	int i;
	for(i=0; i<20; i++)
		m_pDDS_Dirt[i]=NULL;

	m_pWorld=NULL;

	m_x =0;
	m_y =0;
	m_SelectCelNum =0;

	m_FileName = (char *) malloc(80);
	memset((char *)m_FileName,0,80);


	return TRUE;
}


void CMap::ExitInit()
{
	int i;
	for(i=0; i< 20; i++)
		if( m_pDDS_Dirt[i]!=NULL) m_pDDS_Dirt[i]->Release();

	if( m_pWorld != NULL) free(m_pWorld);
}

int CMap::GetCurPosX()
{
	return m_CurPosX;
}

int CMap::GetCurPosY()
{
	return m_CurPosY;
}

void CMap::SetCurPos(int PosX, int PosY)
{
	m_CurPosX = PosX;
	m_CurPosY = PosY;
}

void CMap::LoadMap()
{
	m_pDDS_Dirt[0] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[0],"..\\׸\\1.BMP");

	m_pDDS_Dirt[1] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[1],"..\\׸\\2.BMP");

	m_pDDS_Dirt[2] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[2],"..\\׸\\3.BMP");

	m_pDDS_Dirt[3] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[3],"..\\׸\\4.BMP");

	m_pDDS_Dirt[4] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[4],"..\\׸\\5.BMP");

	m_pDDS_Dirt[5] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[5],"..\\׸\\6.BMP");

	m_pDDS_Dirt[6] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[6],"..\\׸\\7.BMP");

	m_pDDS_Dirt[7] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[7],"..\\׸\\8.BMP");

	m_pDDS_Dirt[8] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[8],"..\\׸\\9.BMP");

	m_pDDS_Dirt[9] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[9],"..\\׸\\10.BMP");

	m_pDDS_Dirt[10] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[10],"..\\׸\\11.BMP");

	m_pDDS_Dirt[11] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[11],"..\\׸\\12.BMP");

	m_pDDS_Dirt[12] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[12],"..\\׸\\13.BMP");

	m_pDDS_Dirt[13] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[13],"..\\׸\\14.BMP");

	m_pDDS_Dirt[14] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[14],"..\\׸\\15.BMP");

	m_pDDS_Dirt[15] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[15],"..\\׸\\16.BMP");

	m_pDDS_Dirt[16] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[16],"..\\׸\\17.BMP");

	m_pDDS_Dirt[17] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[17],"..\\׸\\18.BMP");

	m_pDDS_Dirt[18] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[18],"..\\׸\\19.BMP");

	m_pDDS_Dirt[19] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[19],"..\\׸\\20.BMP");

	m_pDDS_Dirt[20] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[20],"..\\׸\\21.BMP");

	m_pDDS_Dirt[21] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[21],"..\\׸\\22.BMP");

	m_pDDS_Dirt[22] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[22],"..\\׸\\23.BMP");

	m_pDDS_Dirt[23] = CDirectDraw::_CreateSurface(128,64);
	CDirectDraw::_LoadImage(m_pDDS_Dirt[23],"..\\׸\\24.BMP");



	MakeWorld();
}

void CMap::BltMap(int CurPosX, int CurPosY) // x (0 -  (3968-800)=3168 )
											// y (0 -  (2944-600)=2344 )
{		
	DDSURFACEDESC ddsd;
	ZeroMemory (&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof( ddsd);

	m_pDDSBack->GetSurfaceDesc(&ddsd);
	
	int x, y;
	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	unsigned short *p = (unsigned short *) ddsd.lpSurface;
	
	for( y=0; y<580; y++)   // 600-20 For Text Dialog Box
	for( x=0; x<800; x++)
		memcpy((unsigned short *)p+x+y*800,(unsigned short*)m_pWorld+CurPosX+CurPosY*3968+x+y*3968, 2);
	
	m_pDDSBack->Unlock(ddsd.lpSurface);

	
}

void CMap::MakeWorld()
{	
	if( (m_pWorld = (unsigned short *) malloc( 3968*2944*2))==NULL)
		MessageBox(NULL,"FAILD : Map Memory Allocation","TRYOVER MESSAGE", MB_OK);

	memset((unsigned short*)m_pWorld,0, 3968*2944*2);

	// 31 * 46 = 
	m_pMapData = (int *) malloc ( 31*46*4);
	memset((int *)m_pMapData,0, 31*46*4);


	int x, y, i;
	for( y=0,i=0; y< 46; y++)
		for( x=0; x< 31; x++,i++)
				PutCel(x*128,y*64,m_pMapData[i]);

}


void CMap::PutCel(int PosX, int PosY , int Cel)
{
	
	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd, sizeof(ddsd));	
	int  y;
	ddsd.dwSize = sizeof(ddsd);
	m_pDDS_Dirt[Cel]->GetSurfaceDesc(&ddsd);

	m_pDDS_Dirt[Cel]->Lock(NULL,&ddsd,DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL);
	unsigned short *p = (unsigned short*) ddsd.lpSurface;

	for( y=0; y<64; y++)
		memcpy((unsigned short*) m_pWorld+PosX+PosY*3968+y*3968, (unsigned short*)p+y*128,256);

	m_pDDS_Dirt[Cel]->Unlock(ddsd.lpSurface);
}


////////////////////////////////////////

int CMap::InKey(int nVirtKey, LPARAM lKeyData)
{
	int OverScreenResult;
	switch (nVirtKey)
	{
		case VK_LEFT:	// x = 9 ũ ,  y = 6 ũ
			m_x--;
			if ( m_x<0) 
			{
				m_x=0;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
				return OverScreenResult = 0;
			}
			break;
				
			
			

		case VK_RIGHT:
			m_x++;
			if ( m_x>5) 
			{
				m_x=5;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE",MB_OK);
				return OverScreenResult = 1;
			}
			break;

	    case VK_UP:
			m_y--;
			if( m_y<0) 
			{
				m_y=0;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
				return OverScreenResult = 2;
			}
			break;
	

		case VK_DOWN:
			m_y++;
			if (m_y>8) 
			{
				m_y=8;//MessageBox(NULL,"Over Screen","TRYOVER Message", MB_OK);
				return OverScreenResult = 3;
			}
			break;

		case VK_F1:
			m_SelectCelNum--;
			if(m_SelectCelNum < 0) m_SelectCelNum = 0;
			//MessageBox(NULL, "Cel Change UP","TRYOVER MESSAGE", MB_OK);
			break;

		case VK_F2:
			m_SelectCelNum++;
			if(m_SelectCelNum >23) m_SelectCelNum = 23;
			//MessageBox(NULL, "Cel Change DOWN","TRYOVER MESSAGE", MB_OK);
			break;

		case 32:	// Space Bar Key Value
			UpdateMapData( m_stdX, m_stdY,m_usedx, m_usedy, m_Value, m_SelectCelNum);
			break;

		case VK_F3:
			FileSaveMap();
			break;

		case VK_F4:
			FileLoadMap();
			break;
			
	}
	return OverScreenResult=4;
}

POINT CMap::BltTileEdit()
{
	POINT pt;
	pt.x = m_x;
	pt.y = m_y;
	SelectRect(m_x, m_y);

	return pt;
}

void CMap::SelectRect(int x, int y)
{
	// x , y, m_SelectCelNum //
	int tx = x*128 , ty = y*64;

	m_pDDSBack->BltFast(tx, ty, m_pDDS_Dirt[m_SelectCelNum],NULL,DDBLTFAST_WAIT);

//   .
	int i,j;
//	for(j=ty; j< ty+64; j++)
//		for( i=tx; i< tx+128; i++)
//			CDirectDraw::PutPixelMix(i,j,0xffff);

		for(j=ty; j< ty+30; j++)
		for( i=tx; i< tx+30; i++)
			CDirectDraw::PutPixelMix(i,j,0xffff);

}

int CMap::ComplexPosition(int stdx, int stdy, int x, int y)
{	
	m_stdX = stdx;
	m_stdY = stdy;
	m_usedx = x;
	m_usedy = y;

	m_Value = stdx/128 + stdy/64*31 + x + y*31;

//	UpdateMapData(int ValuePosition, int CelNum);

	return m_Value;
}

void CMap::UpdateMapData(int stdx, int stdy,int x, int y, int Value, int Cel)
{

	m_pMapData[Value] = Cel;	

//  
	PutCel( (stdx/128+x)*128 ,(stdy/64+y)*64 , m_pMapData[Value]);

//	int x, y, i;
//	for( y=0,i=0; y< 46; y++)
//		for( x=0; x< 31; x++,i++)
//				PutCel(x*128,y*64,m_pMapData[i]);

}

void CMap::FileSaveMap()
{
	// m_pMapData To File

	FILE *fp;
//	if( m_FileName==NULL)
		fp = fopen("MapData.dat","wb");
//	else
//		fp = fopen(m_FileName,"wb");

	fseek(fp,0,SEEK_SET);
	fwrite((int *)m_pMapData, 1426*4,1,fp);
	fclose(fp);

}

void CMap::FileLoadMap()
{
	FILE *fp;
//	if ( m_FileName==NULL)
		fp = fopen("MapData.dat","rb");
//	else
//		fp = fopen(m_FileName, "rb");

	fseek(fp,0,SEEK_SET);
	fread((int*) m_pMapData, 1426*4, 1, fp);
	fclose(fp);

	int x, y, i;
	for( y=0,i=0; y< 46; y++)
		for( x=0; x< 31; x++,i++)
				PutCel(x*128,y*64,m_pMapData[i]);

}

void CMap::GetFileName(char *FileName)
{
	memset( m_FileName, 0, 80);
	strcpy( m_FileName, FileName);
}