#include "DirectDraw.h"

CDirectDraw::CDirectDraw()
{
	m_bMode555 = FALSE;
	m_bMode565 = FALSE;
	m_screenX = 0;
	m_screenY = 0;
}
CDirectDraw::~CDirectDraw()
{

}


BOOL CDirectDraw::Init(HWND hWnd, int width, int height)  //ʱȭ Լ
{
	HRESULT hr;
	LPDIRECTDRAW lpDD;

	m_hWnd = hWnd;
	m_screenX = width;
	m_screenY = height;

	hr = DirectDrawCreate(NULL, &lpDD, NULL);
	if(hr != DD_OK) return FALSE;

	hr = lpDD->QueryInterface( IID_IDirectDraw2, (LPVOID *)&m_pDD2);
	if(hr != DD_OK) return FALSE;
	
	lpDD->Release();
	lpDD=NULL;
	
	hr = m_pDD2->SetCooperativeLevel( m_hWnd, DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE|DDSCL_NOWINDOWCHANGES);
	if(hr != DD_OK) return FALSE;

	hr = m_pDD2->SetDisplayMode( m_screenX, m_screenY, 16, 0, 0);
	if( hr != DD_OK) return FALSE;

	DDSURFACEDESC ddsd;

	ZeroMemory ( &ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof (ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	hr = m_pDD2->CreateSurface( &ddsd, &m_pDDSPrimary, NULL);
	if(hr != DD_OK) return FALSE;

	ZeroMemory ( &ddsd, sizeof(ddsd) );
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN|DDSCAPS_VIDEOMEMORY|DDSCAPS_LOCALVIDMEM;
	ddsd.dwWidth  = m_screenX;
	ddsd.dwHeight = m_screenY;
	hr = m_pDD2->CreateSurface( &ddsd, &m_pDDSBack, NULL);
	if(hr != DD_OK) return FALSE;

	GetDDSDBack();

	ClearBack();
	
	return TRUE;


}

BOOL CDirectDraw::ExitInit()
{
	if( m_pDDSBack != NULL)
	{
		m_pDDSBack->Release();
		m_pDDSBack = NULL;
	}
	if( m_pDDSPrimary != NULL)
	{
		m_pDDSPrimary->Release();
		m_pDDSPrimary = NULL;
	}
	if( m_pDD2 != NULL)
	{
		m_pDD2->Release();
		m_pDD2 = NULL;
	}


	return TRUE;
}
	
void CDirectDraw::BltBack(RECT bkRect)
{
	m_pDDSPrimary->BltFast(0,0,m_pDDSBack, &bkRect, DDBLTFAST_WAIT);
}

void CDirectDraw::GetDDSDBack()
{
	
	ZeroMemory( &m_pDDSDBack, sizeof(m_pDDSDBack));
	m_pDDSDBack.dwSize = sizeof(m_pDDSDBack);
	m_pDDSBack->GetSurfaceDesc(&m_pDDSDBack);

}

void CDirectDraw::ClearBack()
{
	m_pDDSBack->Lock(NULL, &m_pDDSDBack, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL);
	unsigned short *p = (unsigned short *) m_pDDSDBack.lpSurface;

	for(int i = 0; i< (int)m_pDDSDBack.dwHeight; i++)
		for(int j = 0; j<(int) m_pDDSDBack.dwWidth; j++)
			* (p + i * 800 + j )= 0x0000 ; 

	m_pDDSBack->Unlock(m_pDDSDBack.lpSurface);
}

void CDirectDraw::PutPixel(int x, int y, unsigned short color)
{
	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	m_pDDSBack->GetSurfaceDesc(&ddsd);
	
	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL);
	unsigned short *p = (unsigned short *)ddsd.lpSurface;
	
	*(p+x+y*800) = color;
	
	m_pDDSBack->Unlock(ddsd.lpSurface);
}

LPDIRECTDRAWSURFACE CDirectDraw::_CreateSurface ( int width, int height )
{
	LPDIRECTDRAWSURFACE lpDDS = NULL;
	DDSURFACEDESC ddsd;
	HRESULT hr;

	ZeroMemory ( &ddsd, sizeof (ddsd));
	ddsd.dwSize = sizeof (ddsd);
	ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwHeight = height;
	ddsd.dwWidth = width;

	if( lpDDS == NULL) hr = m_pDD2->CreateSurface(&ddsd, &lpDDS,NULL);
	if( hr != DD_OK) return FALSE;

	return lpDDS;
}

BOOL CDirectDraw::_LoadImage( LPDIRECTDRAWSURFACE lpDDS, LPSTR szImage)
{
	HBITMAP hbm;
	HDC		hdcImage = NULL;
	HDC		hdcSurf  = NULL;
	DDSURFACEDESC ddsd;
	HRESULT hr;

	ZeroMemory (&ddsd, sizeof (ddsd));
	ddsd.dwSize = sizeof (ddsd);

	hr = lpDDS->GetSurfaceDesc(&ddsd);
	if( hr != DD_OK) return FALSE;

	hbm = (HBITMAP) LoadImage ( NULL, szImage, IMAGE_BITMAP, ddsd.dwWidth, ddsd.dwHeight,
								LR_LOADFROMFILE|LR_CREATEDIBSECTION);
	if ( hbm==NULL) return FALSE;

	hdcImage = CreateCompatibleDC(NULL);
	SelectObject ( hdcImage, hbm);

	hr = lpDDS->GetDC(&hdcSurf);
	if( hr != DD_OK) return FALSE;

	if ( BitBlt ( hdcSurf, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, 0, 0, SRCCOPY ) == FALSE ) return FALSE;

	if ( hdcSurf ) lpDDS->ReleaseDC(hdcSurf);
	if ( hdcImage) DeleteDC(hdcImage);
	if ( hbm ) DeleteObject (hbm);

	return TRUE;
}
