// ImeView.cpp : implementation file
//

#include "stdafx.h"
#include "ImeView.h"


/////////////////////////////////////////////////////////////////////////////
// CImeView


CImeView::CImeView()
{
	//m_hKeyWnd = NULL;
	m_TextCurCount = 0;
	m_hKeyLayout = NULL;
    m_nState = 0;   // Current Ime state.
    m_nCompLen = 0;   // To save previous composition string length.
    m_property = 0;
	m_charWidth = 0;
	m_charHeight = 0;
	m_hIMC = NULL;
    memset(m_hwndCand, 0, sizeof(HWND) * MAX_LISTCAND);
    memset(m_CandList, 0, sizeof(LPCANDIDATELIST) * MAX_LISTCAND);
    memset(m_Text, 0, sizeof(char) * MAX_CHAR_100);
    memset(m_TextComp, 0, sizeof(char) * 3);

}

CImeView::~CImeView()
{
}
/*

BEGIN_MESSAGE_MAP(CImeView, CView)
	//{{AFX_MSG_MAP(CImeView)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_MESSAGE( WM_INPUTLANGCHANGE, OnInputLangChange )
	ON_MESSAGE( WM_IME_SETCONTEXT, OnIMESetContext )
	ON_MESSAGE( WM_IME_STARTCOMPOSITION, OnIMEStartComposition )
	ON_MESSAGE( WM_IME_COMPOSITION, OnIMEComposition )
	ON_MESSAGE( WM_IME_ENDCOMPOSITION, OnIMEEndComposition )
	ON_MESSAGE( WM_IME_NOTIFY, OnIMENotify )
	ON_MESSAGE( WM_IME_COMPOSITIONFULL, OnIMECompositionFull )
	ON_MESSAGE( WM_IME_CONTROL, OnIMEControl )
END_MESSAGE_MAP()
*/
/*
LRESULT CALLBACK HanjaWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch(msg) {
		case WM_PAINT: {
			CImeView* pImeView = (CImeView*)GetWindowLong(hwnd, 0);
			if (pImeView)
//				pImeView->CandPaint(hwnd);
            break;
		}
        default:
            return DefWindowProc( hwnd, msg, wParam, lParam );
    }
    return 0;
}

BOOL CImeView::InitImeClass(HINSTANCE hInst)
{
	WNDCLASS wc;
	
	memset(&wc, 0, sizeof(wc));

	wc.hCursor = ::LoadCursor(NULL, IDC_ARROW);
    wc.hIcon   = NULL;
    wc.lpszMenuName  = NULL;
    wc.hInstance     = hInst;
    wc.lpszClassName = CANDWND_CLASS;
    wc.lpfnWndProc   = HanjaWndProc;
    wc.hbrBackground = (HBRUSH)::GetStockObject(LTGRAY_BRUSH);
	wc.style         = CS_HREDRAW | CS_VREDRAW;
    
    if (!::RegisterClass(&wc))
		return FALSE;
	else
		return TRUE;
}
*/
void CImeView::InitIme(HWND hwnd)
{
	char ga[] = "";
	SIZE size;
	HFONT hFont;
	LOGFONT lf;
	if(hwnd)
		m_hWnd = hwnd;

	hFont = (HFONT)SendMessage(m_hWnd,WM_GETFONT, 0, 0);
	if (hFont) {
		if (GetObject(hFont, sizeof(LOGFONT), &lf)) {
			SetCompositionFont(&lf);
		}
	}

	//m_hKeyWnd = hwnd;
	m_hKeyLayout = GetKeyboardLayout(0);	// 0 means Current thread
	m_property = ImmGetProperty(m_hKeyLayout, IGP_PROPERTY);
	for (int i = 0; i < MAX_LISTCAND; i++) {
		m_hwndCand[i] = NULL;
		m_CandList[i] = NULL;
	}

	HDC hDC = ::GetDC(m_hWnd);
    HFONT hScrFont = (HFONT)GetStockObject(SYSTEM_FIXED_FONT);
    HFONT hOldFont = (HFONT)SelectObject(hDC, hScrFont);
    GetTextExtentPoint(hDC, (LPSTR)&ga, 2, &size);
	SelectObject(hDC, hOldFont);
    ::ReleaseDC(m_hWnd, hDC);

	m_charWidth = size.cx / 2;
	m_charHeight = size.cy;
}

BOOL CImeView::IsProcessEvent()
{
	if (m_nState & IME_IN_CHOSECAND ||
			(m_nState & IME_IN_COMPOSITION && GetCompCursorPos()) ) {
		return FALSE;
	} else
		return TRUE;
}

// Set IME open state 
void CImeView::SetState(BOOL fOpen)
{
	if (Enter()) {
		ImmSetOpenStatus(m_hIMC, fOpen);
		Leave();
	}
}

CImeView::SetCompositionFont(LPLOGFONT lf)
{
	BOOL ret;
	if (Enter()) {
		ret = ImmSetCompositionFont(m_hIMC, lf);
		Leave();
	} else
		ret = FALSE;
	return ret;
}

void CImeView::SetCompWndPos(POINT& pt)
{
	if (m_property & IME_PROP_SPECIAL_UI || m_property & IME_PROP_AT_CARET)
		return;
	// at_near

	if (Enter()) {
		COMPOSITIONFORM cf;

		cf.dwStyle = CFS_POINT;
		cf.ptCurrentPos = pt;
		ImmSetCompositionWindow(m_hIMC, &cf);
		Leave();
	}
}

int CImeView::GetCompCursorPos()
{
	if (!Enter())
		return 0;
    int ret = LOWORD(ImmGetCompositionString(m_hIMC, GCS_CURSORPOS, NULL, 0));
	Leave();
	return ret;
}

void CImeView::ClearData()
{
    for(int i = 0; i < MAX_LISTCAND; i++) {
        if (m_hwndCand[i]) {
            ::DestroyWindow(m_hwndCand[i]);
			m_hwndCand[i] = NULL;
            delete m_CandList[i];
			m_CandList[i] = NULL;
        }
    }
    m_nCompLen = m_nState = 0;
}

void CImeView::CandPaint(HWND hwnd)
{
    int         index;
    HDC         hdc;
    PAINTSTRUCT ps;

    hdc = ::BeginPaint(hwnd, (LPPAINTSTRUCT)&ps);
    
    for (index = 0; index < MAX_LISTCAND; index ++ )
        if (m_hwndCand[index] == hwnd)
            break;

	if ( index != MAX_LISTCAND && m_CandList[index]) {
	    DisplayCandStrings(hwnd, m_CandList[index]);
	}
    ::EndPaint( hwnd, (LPPAINTSTRUCT)&ps );
}

BOOL CImeView::GetResultString()
{
    DWORD       len;					// Storage for length of result str.
    LPSTR       str;					// Pointer to result string.

	if (Enter()) {
		if ((len = ImmGetCompositionString(m_hIMC, GCS_RESULTSTR, NULL, 0)) > 0) {
			str = new char[len + 1];
			ImmGetCompositionString(m_hIMC, GCS_RESULTSTR, str, len);
			str[len] = 0;
			ProcessResultString(str);
			delete str;
		}
		Leave();
	}
	return TRUE;
}

BOOL CImeView::GetCompString(LONG flag)
{
    DWORD      len;              // Stogare for len. of composition str
    LPSTR      str;              // Pointer to composition str.
    LPSTR      strAttr;          // Pointer to composition str array.
    DWORD      lenAttr;
   
	if (!Enter())
		return FALSE;
    if ((len = ImmGetCompositionString(m_hIMC, GCS_COMPSTR, NULL, 0)) > 0) {
		str = new char[len+1];
		ImmGetCompositionString(m_hIMC, GCS_COMPSTR, str, len);
		str[len] = 0;
		strAttr = NULL;
		if (flag & GCS_COMPATTR) {
			if ((lenAttr = ImmGetCompositionString(m_hIMC, GCS_COMPATTR, NULL, 0)) > 0) {
				strAttr = new char[lenAttr+1];
				ImmGetCompositionString(m_hIMC, GCS_COMPATTR, strAttr, lenAttr);
				strAttr[lenAttr] = 0;
			}
		} 
		// Override function
		ProcessCompString(str, strAttr);
		m_nCompLen = (UINT)len;
		if (strAttr)
			delete strAttr;
		if (str)
			delete str;
	}
	Leave();
	return TRUE;
}

///////////////////////////////////////////////////////////////
// for IME Control Message

LONG CImeView::OnInputLangChange(WPARAM dwCommand, LPARAM dwData)
{
    if (ImmIsIME(m_hKeyLayout) && m_property & IME_PROP_AT_CARET)
		ClearData();

    // Set new keyboard layout.
	InitIme();

	if(Enter()) {
		for (int i = 0; i < MAX_LISTCAND; i++) {
			CANDIDATEFORM cf;

			if (m_property & IME_PROP_AT_CARET) {
	/*
				// This application do not want to set candidate window to
				// any position. Anyway, if an application need to set the
				// candiadet position, it should remove the if 0 code
				// the position you want to set
				cf.dwIndex = i;
				cf.dwStyle = CFS_CANDIDATEPOS;
				cf.ptCurrentPos.x = ptAppWantPosition[i].x;
				cf.ptCurrentPos.y = ptAppWantPosition[i].y;
				ImmSetCandidateWindow(m_hIMC, &CandForm );
	*/
			} else {
				if (!ImmGetCandidateWindow(m_hIMC, i, &cf))
					continue;
				if (cf.dwStyle == CFS_DEFAULT)
					continue;
				cf.dwStyle = CFS_DEFAULT;
				ImmSetCandidateWindow(m_hIMC, &cf);
			}
		}
		Leave();
	}
	return DefWindowProc(m_hWnd,WM_INPUTLANGCHANGE, dwCommand, dwData);
}

LONG CImeView::OnIMESetContext(WPARAM dwCommand, LPARAM dwData)
{
	if (m_property & IME_PROP_AT_CARET) {
		// application wants to draw UI by itself.
		dwData &= ~(ISC_SHOWUICOMPOSITIONWINDOW | ISC_SHOWUIALLCANDIDATEWINDOW);
	}
	return DefWindowProc(m_hWnd,WM_IME_SETCONTEXT, dwCommand, dwData);
}

LONG CImeView::OnIMEStartComposition(WPARAM dwCommand, LPARAM dwData)
{
	if (Check()) { // !IME_PROP_SPECIAL_UI && IME_PROP_AT_CARET
		m_nCompLen = 0; // length of composition string.
		m_nState |= IME_IN_COMPOSITION;
		IMEStartComposition(dwData);
		return TRUE;
	} else
		return FALSE;
}

LONG CImeView::OnIMEComposition(WPARAM dwCommand, LPARAM dwData)
{
	if (Check()) { // !IME_PROP_SPECIAL_UI && IME_PROP_AT_CARET
		if (dwData & GCS_RESULTSTR)
			GetResultString(); // Result String
		else if (dwData & GCS_COMPSTR)
			GetCompString(dwData); // Composition string
	}
	return 0;
}

LONG CImeView::OnIMEEndComposition(WPARAM dwCommand, LPARAM dwData)
{
	if (Check()) { // !IME_PROP_SPECIAL_UI && IME_PROP_AT_CARET
		m_nCompLen = 0;
		m_nState &= ~IME_IN_COMPOSITION;
		IMEEndComposition(dwData);
		return TRUE;
	} else
		return FALSE;
}

LONG CImeView::OnIMECompositionFull(WPARAM dwCommand, LPARAM dwData)
{
	// Make sure the size for drawing the composition string.
	// Application should draw the composition string correctly.
	return 0;
}

LONG CImeView::OnIMENotify(WPARAM dwCommand, LPARAM dwData)
{
	// This class does not handle all notification message.
	// So we pass those notification messages which are not hanlded
	// by this application to the DefWindowProc.

    switch (dwCommand) {
        case IMN_OPENCANDIDATE:
			return OpenCandidate(dwData);

        case IMN_CLOSECANDIDATE:
			return CloseCandidate(dwData);

        case IMN_CHANGECANDIDATE:
			return ChangeCandidate(dwData);

        case IMN_SETOPENSTATUS:
			return SetOpenStatus();
    }
    return DefWindowProc(m_hWnd,WM_IME_NOTIFY, dwCommand, dwData);
}

LONG CImeView::OnIMEControl(WPARAM dwCommand, LPARAM dwData)
{
	// This message is not received by the application window.
	// But don't pass it to DefWindowProc().
	return 0;
}

/////////////////////////////////////////////////////////////////
// for Candidate window

// IMN_OPENCANDIDATE:
BOOL CImeView::OpenCandidate(LONG lParam)
{
    LPCANDIDATELIST lpCandList;         // Storage for LP to candidate list.
    DWORD       dwBufLen;               // Storage for candidate strings.
    LPSTR       lpStr;                  // Storage for LP to a string.
    int         max_width = 0;          // Storage for width of listCand
    int         CurNumCandList = 0;     // Storage for number of cand. lists.
    DWORD       dwPreferNumPerPage;     // Storage for PreferNumPerPage
 //   POINT       point;                  // Storage for caret position.

    if (!Enter())
        return FALSE;

    // SetWindowText(hwnd, (LPSTR)TITLE_CAND);
    for (int i = 0; i < MAX_LISTCAND; i++ ) {
        if (m_hwndCand[i])
            CurNumCandList++;
    }
    for (int index = 0; index < MAX_LISTCAND; index++ ) {
        if (lParam & (1 << index)) {   
            if (!(dwBufLen = ImmGetCandidateList(m_hIMC, index, lpCandList, 0)))                      
                goto exit_opencand;
            if( !(m_CandList[index] = (LPCANDIDATELIST)new char[dwBufLen]))
                goto exit_opencand;
            lpCandList = m_CandList[index];
            ImmGetCandidateList(m_hIMC, index, lpCandList, dwBufLen);

            POINT pt ;
			GetCaretPos(&pt);
            ClientToScreen(m_hWnd,&pt);

            dwPreferNumPerPage = ( !lpCandList->dwPageSize ) ?
                                 DEFAULT_CAND_NUM_PER_PAGE :
                                 lpCandList->dwPageSize;

			// get the longest string length
            for (int i = 0; i < (int)lpCandList->dwCount; i++ ) {
                lpStr = (LPSTR)lpCandList + lpCandList->dwOffset[i];
                max_width = (max_width < lstrlen(lpStr)) ? lstrlen(lpStr) : max_width;
            }

            m_hwndCand[index] = CreateWindow(          
                                 "HanjaCandidate", "CandWindow",
                                 WS_BORDER | WS_POPUP | WS_DISABLED,
                                 CurNumCandList * m_charWidth + pt.x, pt.y + m_charHeight + 2,
                                 (max_width + 3) * m_charWidth + 4,
                                 (int)dwPreferNumPerPage * m_charHeight + 5,
                                 m_hWnd,
                                 (HMENU)NULL,
                                 (HINSTANCE)GetWindowLong(m_hWnd, GWL_HINSTANCE ),
                                 (LPVOID)NULL
                                 );

            if (m_hwndCand[index] == NULL) {
				delete m_CandList[index];
				m_CandList[index] = NULL;
                goto exit_opencand;
            }
			SetWindowLong(m_hwndCand[index], 0, (LONG)this);

            ::ShowWindow(m_hwndCand[index], SW_SHOWNOACTIVATE);
            DisplayCandStrings(m_hwndCand[index], lpCandList);
            CurNumCandList++;
        }
    }
    m_nState |= IME_IN_CHOSECAND;

exit_opencand:
    Leave();
	return TRUE;
}

// IMN_CLOSECANDIDATE:
BOOL CImeView::CloseCandidate(LONG CandList)
{
    for (int i = 0; i < MAX_LISTCAND; i++) {
        if ((CandList & ( 1 << i ) ) && m_CandList[i]) {
            ::DestroyWindow(m_hwndCand[i]);
            m_hwndCand[i] = NULL;
			delete m_CandList[i];
			m_CandList[i] = NULL;
        }
    }
    m_nState &= ~IME_IN_CHOSECAND;
	return TRUE;
}

// IMN_CHANGECANDIDATE:
BOOL CImeView::ChangeCandidate(LONG CandList)
{
    LPCANDIDATELIST lpCandList = NULL;         
    DWORD           dwIndex;
    DWORD 			dwBufLen;
    LPSTR			lpStr;
    DWORD			i = 1;
    RECT			rect;
    int				max_width = 0;
    DWORD			dwPreferNumPerPage;


	if (!Enter())
		return FALSE;

    for (dwIndex = 0; dwIndex < MAX_LISTCAND; dwIndex++) {
        if (CandList & i)
            break;
		else
			i <<= 1;
	}

    if (dwIndex == MAX_LISTCAND)
        goto exit_changecand;

    if (!(dwBufLen = ImmGetCandidateList(m_hIMC, dwIndex, lpCandList, 0))) {
		goto exit_changecand;
	}
	delete m_CandList[dwIndex];
	m_CandList[dwIndex] = lpCandList = (LPCANDIDATELIST)new char[dwBufLen];

    ImmGetCandidateList(m_hIMC, dwIndex, lpCandList, dwBufLen);
    dwPreferNumPerPage = (!lpCandList->dwPageSize ) ?
                         DEFAULT_CAND_NUM_PER_PAGE : lpCandList->dwPageSize;

    for( i = 0; i < lpCandList->dwCount; i++ ) {
        lpStr = (LPSTR)lpCandList + lpCandList->dwOffset[i];
        max_width = (max_width < lstrlen(lpStr)) ? lstrlen(lpStr) : max_width;
    }

    ::GetWindowRect(m_hwndCand[dwIndex], (LPRECT) &rect);
    ::SetWindowPos(m_hwndCand[dwIndex], m_hWnd, rect.left, rect.top,
		  (max_width + 3) * m_charWidth + 4,
		  (int)(dwPreferNumPerPage) * m_charHeight + 5,
		  SWP_NOZORDER | SWP_NOACTIVATE );
		  
	DisplayCandStrings(m_hwndCand[dwIndex], lpCandList);

exit_changecand:
	Leave();
	return TRUE;
}

// IMN_SETOPENSTATUS:
BOOL CImeView::SetOpenStatus()
{
    if (!Enter())
        return FALSE;

    if (ImmGetOpenStatus(m_hIMC)) {
        // the IME conversion engine is open
    } else {
        // Here we close and destroy all of candidate windows
        // if IME conversion engine is closed.

        for (int i = 0; i < MAX_LISTCAND; i++ ) {
            if (m_CandList[i]) {
                ::DestroyWindow(m_hwndCand[i]);
                m_hwndCand[i] = NULL;
				delete m_CandList[i];
				m_CandList[i] = NULL;
            }
        }
		m_nCompLen = 0;
		m_nState = 0;
    }
	Leave();
	return TRUE;
}

BOOL CImeView::DisplayCandStrings(HWND hwnd, LPCANDIDATELIST lpCandList)
{
    HDC         hdc;            // Storage for device context handle.
    LPSTR       lpStr;          // Storage for LP to a string.
    DWORD       dwNumPerPage;   // Storage for num per page
    DWORD       dwStartIndex;   // Storage for candidate index
    DWORD       dwEndIndex;     // Storage for candidate index
    RECT        rect;           // Storage for client rect.
    int         y;				// 
    DWORD       dwBackColor;    // Storage for background color value
    DWORD       dwTextColor;
	char		buf[255];

    dwNumPerPage = (!lpCandList->dwPageSize ) ? 
						DEFAULT_CAND_NUM_PER_PAGE : 
						lpCandList->dwPageSize;
    dwStartIndex = lpCandList->dwPageStart;

    dwEndIndex = dwStartIndex + dwNumPerPage;
    dwEndIndex = ( dwEndIndex >= lpCandList->dwCount ) ?
                 lpCandList->dwCount : dwEndIndex;
                 
    hdc = ::GetDC(hwnd);
	// Draw Background
    dwBackColor = SetBkColor(hdc, RGB(0xc0 ,0xc0, 0xc0));
    ::GetClientRect(hwnd, &rect);
    ExtTextOut( hdc, 0, 0, ETO_OPAQUE, &rect, NULL, 0, 0);

	// Draw Selection
    rect.top = rect.top + ( lpCandList->dwSelection - dwStartIndex ) *
               m_charHeight;
    rect.bottom = rect.top + m_charHeight;
    SetBkColor(hdc, RGB(0x00, 0x00, 0x80));
    ExtTextOut( hdc, 0, rect.top, ETO_OPAQUE, &rect, NULL, 0, 0);

    SetBkMode( hdc, TRANSPARENT );
    dwTextColor = GetTextColor(hdc); 

    for (y = 0 ; dwStartIndex < dwEndIndex; dwStartIndex++, y++ ) {
        lpStr = (LPSTR) lpCandList + lpCandList->dwOffset[dwStartIndex];
        if ( dwStartIndex == lpCandList->dwSelection )
            SetTextColor(hdc, RGB(255, 255, 255));
        else
            SetTextColor(hdc, dwTextColor);
		wsprintf(buf, "%d :%s", y + 1, lpStr);
        TextOut(hdc, 2, y * m_charHeight, buf, lstrlen(buf));
    }

    SetTextColor( hdc, dwTextColor );
    SetBkColor( hdc, dwBackColor );
    ::ReleaseDC( hwnd, hdc );
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CImeView drawing
/*
void CImeView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}
*/
/////////////////////////////////////////////////////////////////////////////
// CImeView diagnostics
/*
#ifdef _DEBUG
void CImeView::AssertValid() const
{
	CView::AssertValid();
}

void CImeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG
*/
/////////////////////////////////////////////////////////////////////////////
// CImeView overriding functions

void CImeView::ProcessResultString(LPSTR str)
{
	PutString(str);
}

void CImeView::ProcessCompString(LPSTR str, LPSTR strAttr)
{

	int len = lstrlen(str);
	if(len >2)
		return;
	strcpy(m_TextComp,str);
	// draw composition string
}

void CImeView::IMEStartComposition(LONG dwData)
{
}

void CImeView::IMEEndComposition(LONG dwData)
{
}

/////////////////////////////////////////////////////////////////////////////
// CImeView message handlers
/*
int CImeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	InitIme();
	
	return 0;
}
*/
/*

BEGIN_MESSAGE_MAP(CImeView, CView)
	//{{AFX_MSG_MAP(CImeView)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_MESSAGE( WM_INPUTLANGCHANGE, OnInputLangChange )
	ON_MESSAGE( WM_IME_SETCONTEXT, OnIMESetContext )
	ON_MESSAGE( WM_IME_STARTCOMPOSITION, OnIMEStartComposition )
	ON_MESSAGE( WM_IME_COMPOSITION, OnIMEComposition )
	ON_MESSAGE( WM_IME_ENDCOMPOSITION, OnIMEEndComposition )
	ON_MESSAGE( WM_IME_NOTIFY, OnIMENotify )
	ON_MESSAGE( WM_IME_COMPOSITIONFULL, OnIMECompositionFull )
	ON_MESSAGE( WM_IME_CONTROL, OnIMEControl )
END_MESSAGE_MAP()
*/

BOOL CImeView::IsYouMessage(UINT msg,WPARAM wparam, LPARAM lparam)
{
	if(!m_hWnd)
		return FALSE;
	switch (msg) { 
		case WM_IME_STARTCOMPOSITION:     //   . WM_IME_COMPOSITION ޽           //  غ Ѵ. 
			OnIMEStartComposition(wparam,lparam);
         return TRUE;    
		case WM_IME_ENDCOMPOSITION:          //   . յ ڿ ó           break; 
			OnIMEEndComposition(wparam,lparam);
         return TRUE;    
      case WM_IME_COMPOSITION:          //   ڿ̳ ϼ ڿ  ȭ  
			OnIMEComposition(wparam,lparam);
			InvalidateRect(m_hWnd,NULL,TRUE);
         return TRUE;    
	  case WM_IME_SETCONTEXT:    //     ȯ 츦 ǥ ʰ ٲ 
			OnIMESetContext(wparam,lparam);
         return TRUE;    
      case WM_IME_NOTIFY:        
		  OnIMENotify(wparam,lparam);
         return TRUE;             
      case WM_INPUTLANGCHANGE:       // Ű ̾ƿ ٲ  IME ʱȭ      
		  OnInputLangChange(wparam,lparam);
           return TRUE;    
	  case WM_IME_CONTROL:
		  OnIMEControl(wparam,lparam);
         return TRUE;    
	  case WM_IME_COMPOSITIONFULL:
		  OnIMECompositionFull(wparam,lparam);
         return TRUE;    
	  case WM_CHAR:
			OnChar(wparam);
			InvalidateRect(m_hWnd,NULL,TRUE);
		  break;
    }
	return FALSE;
}

void CImeView::OnChar(UINT nChar)
{
	if((nChar == 8 )|| (nChar == 27))
	{
		if(!m_TextCurCount)
			return;
		m_Text[m_TextCurCount-1] = '\n';
		m_TextCurCount--;
	
	
	}else{
		char str[2];
		str[0] = nChar & 0xff;
		str[1] = 0;
		PutString(str);
	}
}

void CImeView::PutString(LPSTR str)
{
	int len = strlen(str); 
	if((len+m_TextCurCount) >= MAX_CHAR_100)
		return;
	strcpy(m_Text+m_TextCurCount,str);
	m_TextCurCount += len;

/*	CDC* dc = GetDC();

	m_text += str;
	RedrawText(dc);
	m_nCaretPos = dc->GetTextExtent(m_text).cx;
	SetCaretPos(CPoint(10 + m_nCaretPos, (30 - 10 - m_charHeight)/2 + 10 - 2));
	ReleaseDC(dc);
*/
}

void CImeView::Darw(HDC dc,POINT * ppo)
{
	RECT rc= {ppo->x,ppo->y,ppo->x+500,ppo->y+20};
	DrawText(dc, m_Text, strlen(m_Text), &rc, DT_LEFT | DT_VCENTER);
	rc.top = ppo->y+20;
	rc.bottom = ppo->y+40;
	DrawText(dc, m_TextComp, strlen(m_TextComp), &rc, DT_LEFT | DT_VCENTER);
	

}
