#include "dib.h"
#include <stdio.h>
#include <commctrl.h>

BOOL CDib::Draw(HWND hwnd,HDC hdc)
{
	CheckPalette(hdc);


	HBITMAP hBitmap;
	HDC memdc;
	memdc = CreateCompatibleDC(hdc);
	hBitmap=CreateCompatibleBitmap(hdc, BitmapInfoHeader->biWidth, BitmapInfoHeader->biHeight);
	
	SelectObject(memdc, hBitmap);
	MoveWindow(hwnd, 0, 0, BitmapInfoHeader->biWidth, BitmapInfoHeader->biHeight+46, true);//bmp ũ 츦 
	StretchDIBits(memdc, 0, 0, BitmapInfoHeader->biWidth,
		BitmapInfoHeader->biHeight, 0, 0, BitmapInfoHeader->biWidth,
		BitmapInfoHeader->biHeight, szBits, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);

	BitBlt(hdc, 0, 0, BitmapInfoHeader->biWidth,
		BitmapInfoHeader->biHeight, memdc, 0,0, SRCCOPY);
	
	sprintf(m_BitmapInfo, "File Information : %s \nSize : %d X %d X %dbpp",m_strFileName, 
		BitmapInfoHeader->biWidth,	BitmapInfoHeader->biHeight, BitmapInfoHeader->biBitCount);
	MessageBox(hwnd, m_BitmapInfo, "Bitmap Information", 0);
	
	DeleteObject(hBitmap);
	DeleteDC(memdc);
	free(Dib);
	return true;
}

BOOL CDib::DrawResize(HDC hdc, int x, int y)//ȭ ø  쿡 
{
	HBITMAP hBitmap;
	HDC memdc;
	memdc = CreateCompatibleDC(hdc);
	hBitmap=CreateCompatibleBitmap(hdc, x, y);
	SelectObject(memdc, hBitmap);
	
	
	StretchDIBits(memdc, 0, 0, x,	y,
		0, 0, BitmapInfoHeader->biWidth,
		BitmapInfoHeader->biHeight, szBits, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);

	BitBlt(hdc, 0, 0, x, y,
		memdc, 0,0, SRCCOPY);

	DeleteObject(hBitmap);
	DeleteDC(memdc);
	free(Dib);
	return true;
}

BOOL CDib::LoadBitMap(char *szBitMapFile)
{
	
	if(HFILE_ERROR!=(hFile=_lopen(szBitMapFile, OF_READ)))
		_lread(hFile, &BitmapFileHeader, sizeof(BITMAPFILEHEADER));
	else 
	{
		sprintf(m_strMessageTemp,"%s File Open Error", m_strFileName);
		return false;
	}
	
	if(BitmapFileHeader.bfType!=0x4d42)
	{
		sprintf(m_strMessageTemp,"%s Cannot Read File Header.", m_strFileName);
		return false;
	}
	else
	{
		nRealSize=BitmapFileHeader.bfSize-sizeof(BITMAPFILEHEADER);
		Dib=(char *)malloc(nRealSize);
		_lread(hFile, Dib, nRealSize);
		
		BitmapInfo=(BITMAPINFO *)Dib;
		BitmapInfoHeader=(BITMAPINFOHEADER *)Dib;
		RgbQuad=(RGBQUAD *)(Dib+BitmapInfoHeader->biSize);
		
		if((BitmapInfoHeader->biClrUsed==0) &&
			(BitmapInfoHeader->biBitCount<=8))
			nColorNumber=(1<<BitmapInfoHeader->biBitCount);

		else
			nColorNumber=BitmapInfoHeader->biClrUsed;

		if(BitmapInfoHeader->biSizeImage==0)
		{
			BitmapInfoHeader->biSizeImage=BitmapInfoHeader->biWidth*BitmapInfoHeader->biHeight;
		}
		
		dwTableSize=nColorNumber*sizeof(RGBQUAD);
		szBits=Dib+BitmapInfoHeader->biSize+dwTableSize;

		strcpy(m_strFileName,szBitMapFile);
		
		_lclose(hFile);
		
		//CheckPalette(hdc);
			
		
		
	}
	return true;
}


CDib::CDib(LPSTR filename)
{

	lstrcpy((LPSTR)m_strFileName, (LPSTR)filename);
	LoadBitMap(filename);
	

}

int CDib::CheckPalette(HDC &hdc)
{
	if(BitmapInfoHeader->biBitCount<=8)
	{
		LOGICALPALETTE.version=0x300;
		LOGICALPALETTE.NumberOfEntries=256;
		for(int n=0;n<nColorNumber;n++)
		{
			LOGICALPALETTE.PaletteEntry[n].peRed=RgbQuad[n].rgbRed;
			LOGICALPALETTE.PaletteEntry[n].peGreen=RgbQuad[n].rgbGreen;
			LOGICALPALETTE.PaletteEntry[n].peBlue=RgbQuad[n].rgbBlue;
			LOGICALPALETTE.PaletteEntry[n].peFlags=0;
		}
		
		hPalette=CreatePalette((LPLOGPALETTE)&LOGICALPALETTE);
		hOldPalette=SelectPalette(hdc, hPalette, false);
		SelectPalette(hdc, hOldPalette, FALSE);
		DeleteObject(hPalette);
		RealizePalette(hdc);
	}
	return BitmapInfoHeader->biBitCount;
		
}


