#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <commdlg.h>
#include <commctrl.h>
#include <stdio.h>
#include "resource.h"
#include "popfile.h"
#include "dib.h"

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
//BOOL PrintDIBFormat(HWND hwnd, HDC hdc, char *szBitMapFile);
void DrawOutLine(HWND hWnd, POINT down, POINT up);
void DrawCross(HWND hwnd, POINT pt);
HINSTANCE hInst;

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	static TCHAR szAppName[] = TEXT("HomeWork");
	HWND hWnd;
	MSG msg;
	WNDCLASS WndClass;

	WndClass.cbClsExtra=0;
	WndClass.cbWndExtra=0;
	WndClass.hbrBackground=(HBRUSH)GetStockObject(WHITE_BRUSH);
	WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	WndClass.hIcon=LoadIcon(NULL, IDI_APPLICATION);
	WndClass.hInstance=hInstance;
	WndClass.lpfnWndProc=WndProc;
	WndClass.lpszClassName=szAppName;
	WndClass.lpszMenuName=MAKEINTRESOURCE(IDR_MENU);
	WndClass.style=CS_HREDRAW|CS_VREDRAW;

	if(!RegisterClass(&WndClass))
	{ 
		MessageBox(NULL, TEXT("Program requires Windows NT!"), szAppName, MB_ICONERROR);
		return FALSE;
	}

	hInst=hInstance;

	hWnd = CreateWindow(
		szAppName,
		szAppName,
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL
		);
	
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	
	return msg.wParam;
}
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static TCHAR szFileName[MAX_PATH], szTitleName[MAX_PATH];
	HDC hdc;
	RECT rect;
	static POINT m_ptMouse,m_ptDown, m_ptUp,ptBoxBeg, ptBoxEnd;
	static BOOL bFlag,bBox,bLoad;
	CDib temp;

	
	switch (message)
	{
	case WM_CREATE:
		
		PopFileInit(hwnd);
		return 0;

	case WM_SYSCOMMAND:
		bFlag=false;
		//DrawCross(hwnd, m_ptDown);
		break;
		return 0;

	case WM_SIZE:
	if(bLoad)
		{
			
			hdc=GetDC(hwnd);
			CDib dib(szFileName);
			GetClientRect(hwnd, &rect);
			dib.DrawResize(hdc, rect.right, rect.bottom);
			ReleaseDC(hwnd, hdc);
			break;

		}
				

		return 0;
	
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDM_OPEN:
			if(PopFileOpen(hwnd, szFileName, szTitleName))
			{
				CDib dib(szFileName);
				temp=dib;
				hdc=GetDC(hwnd);
				dib.Draw(hwnd,hdc);
				ReleaseDC(hwnd, hdc);
				bLoad=true;
				DrawCross(hwnd, m_ptMouse);
				//bFlag=false;
				
			}
			
			break;

		case IDM_EXIT:
			SendMessage(hwnd, WM_DESTROY, wParam, lParam);
			break;

		DrawCross(hwnd, m_ptMouse);
				
		}
		
					
		return 0;

		
	/*case WM_ERASEBKGND:
	return 0;*/
	
	
	case WM_MOUSEMOVE:
		if(bFlag)
		{
		
		GetClientRect(hwnd, &rect); 
	
		DrawOutLine(hwnd, m_ptDown, m_ptUp);
		m_ptUp.y = m_ptMouse.x=HIWORD(lParam);
		m_ptUp.x = m_ptMouse.y=LOWORD(lParam);
		
		DrawOutLine(hwnd, m_ptDown, m_ptUp);
				
		}

		else 
		{
			DrawCross(hwnd, m_ptMouse);
			//bFlag=true;
			m_ptMouse.x=LOWORD(lParam);
			m_ptMouse.y=HIWORD(lParam);
			
			DrawCross(hwnd, m_ptMouse);
				
		}
		return 0;

	case WM_LBUTTONDOWN:
		bBox=true;
		bFlag=true;
		
		m_ptUp.x=m_ptDown.x=LOWORD(lParam);
		m_ptUp.y=m_ptDown.y=HIWORD(lParam);
		DrawOutLine(hwnd, m_ptDown, m_ptUp);
		DrawCross(hwnd, m_ptMouse);
		
	
		return false;

	case WM_LBUTTONUP:
		if(bFlag)
		{

		DrawCross(hwnd, m_ptDown);
		DrawOutLine(hwnd, m_ptDown, m_ptUp);
		ptBoxBeg=m_ptDown;
		ptBoxEnd.x=m_ptMouse.x=LOWORD(lParam);
		ptBoxEnd.y=m_ptMouse.y=HIWORD(lParam);
		bBox=true;
		//if(bLoad)
		if(bBox)
		{
			hdc=GetDC(hwnd);
			//SetROP2(hdc, R2_NOTXORPEN);
			SetROP2(hdc, R2_NOT);
			SelectObject(hdc, GetStockObject(BLACK_BRUSH));
			Rectangle(hdc, ptBoxBeg.x, ptBoxBeg.y, ptBoxEnd.x, ptBoxEnd.y);
			bBox=false;
			//bLoad=false;	
			ReleaseDC(hwnd, hdc);
			
		}
		
		
		m_ptUp.x=m_ptMouse.x=LOWORD(lParam);
		m_ptUp.y=m_ptMouse.y=HIWORD(lParam);
		bFlag=false;
		DrawCross(hwnd, m_ptDown);
		DrawCross(hwnd, m_ptUp);
		
		
		}	
		return false;

	

	
	case WM_DESTROY:
	/*	if(pDib!=NULL)
		{
			delete pDib;
			pDib=NULL;
		}*/
		PostQuitMessage(0);
		return 0;
	
	
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

void DrawOutLine(HWND hWnd, POINT down, POINT up)
{
	HDC hdc;
	hdc=GetDC(hWnd);
	SetROP2(hdc,R2_NOT);
	SelectObject(hdc, GetStockObject(NULL_BRUSH));
	Rectangle(hdc, down.x, down.y, up.x, up.y);
	ReleaseDC(hWnd,hdc);

}
	

void DrawCross(HWND hwnd, POINT pt)
{
	HDC		hdc;
	RECT	rect;
	GetClientRect(hwnd,&rect);

	hdc=GetDC(hwnd);

	SetROP2(hdc, R2_NOT);
	SelectObject(hdc, GetStockObject (NULL_BRUSH));
	
	MoveToEx(hdc, 0, pt.y, NULL);
	LineTo(hdc, rect.right, pt.y);
	MoveToEx(hdc, pt.x, 0,NULL);
	LineTo(hdc, pt.x, rect.bottom);

	

	ReleaseDC(hwnd, hdc);
}

