// Default Include ///////////////////
#include <windows.h>
#include <stdio.h>
#include "resource.h"

// User Include //////////////////////
#include "cdirectdraw.h"
#include "ccharacter.h"
#include "cmap.h"
#include "chan2.h"
#include "cnpc.h"
#include "cblocking.h"

// Define ////////////////////////////
#define NAME "TryOver Program"

// Variable /////////////////////////
BOOL g_bActive = FALSE;

int  g_MapX, g_MapY;
int  g_OverScreenResult;

char *g_MessageString;
char *g_FileName;
char *g_SendMessage;

// Function /////////////////////////
LRESULT CALLBACK WndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI DlgProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
void MainLoop();
void InKeyLoop(int nVirtKey, LPARAM lKeyData);
void Init(HINSTANCE hInstance, HWND hWnd);

// Class ////////////////////////////
CDirectDraw *g_pDirectDraw;
CCharacter	*g_pCharacter;
CMap		*g_pMap;
CHan2		*g_pHan2;
CNpc		*g_pNpc;
CBlocking   *g_pBlocking;


void Init(HINSTANCE hInstance, HWND hWnd)
{
	

	g_pDirectDraw = new CDirectDraw();
	if(!g_pDirectDraw->Init(hWnd,800,600,16)) MessageBox(NULL, "FAILD : Direct Draw Class", "TRYOVER MESSAGE", MB_OK);

	g_pCharacter = new CCharacter();
	if(!g_pCharacter->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface(),hInstance, hWnd ))MessageBox(NULL, "FAILD : Character Object", "TRYOVER MESSAGE", MB_OK);

	g_pMap = new CMap();
	if(!g_pMap->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface())) MessageBox(NULL, "FAILD : Map Object", "TRYOVER MESSAGE", MB_OK);

	g_pHan2 = new CHan2();
	if(!g_pHan2->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface())) MessageBox(NULL, "FAILD : Hangul Object", "TRYOVER MESSAGE", MB_OK);

	g_pNpc = new CNpc();
	g_pNpc->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface());

	g_pBlocking = new CBlocking();
	g_pBlocking->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface());

	g_pDirectDraw->ClearBack();
	
	g_pMap->LoadMap();
	g_pMap->SetFileName("MapData1.dat");
	g_pMap->FileLoadMap();

	g_pCharacter->LoadCharacter();

	g_OverScreenResult = 4;

	g_MessageString = ( char *) malloc (80);
	memset((char*)g_MessageString, 0, 80);


	g_SendMessage = (char *) malloc (80);
	memset((char*) g_SendMessage,0, 80);

	g_pCharacter->SetPos(380,300);

	g_bActive = TRUE;


}


int WINAPI WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstsance, LPSTR lpCmdLine, int nShowCmd)
{
	WNDCLASS wc;

	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	wc.hIcon   = LoadIcon   (hInstance, "IDI_ICON1");
	wc.hInstance = hInstance;
	wc.lpfnWndProc = WndProc;
	wc.lpszClassName = NAME;
	wc.lpszMenuName = NULL;
	wc.style = CS_VREDRAW|CS_HREDRAW;

	RegisterClass(&wc);

	HWND hWnd = CreateWindowEx(
		WS_EX_APPWINDOW,
		NAME,
		NAME,
		WS_POPUP,
		0,
		0,
		800,
		600,
		NULL,
		NULL,
		hInstance,
		NULL);

	::Init(hInstance, hWnd);


	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow( hWnd);

	HWND hDlg;	
	hDlg = CreateDialog(hInstance,"IDD_DIALOG",hWnd,DlgProc);
	SetWindowPos(hDlg, NULL, 0, 577, 800, 20,NULL);

	
	SetFocus(hWnd);

	MSG msg;
	while(1)
	{
		if( PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if( !GetMessage (&msg, NULL, 0, 0))
				return msg.wParam;

			if(!IsDialogMessage(hDlg,&msg))
			{
				TranslateMessage( &msg);
				DispatchMessage( &msg);
			}
		}
		else if ( g_bActive)
		{
			g_OverScreenResult = g_pCharacter->PollDevice();
			MainLoop();
		}
		else
			WaitMessage();
	}

	return TRUE;
}

LRESULT CALLBACK WndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{


	switch( msg)
	{
		case WM_KEYDOWN:
			InKeyLoop((int)wParam, lParam);
			// g_OverScreenResult = m_pMap->InKey( (int) wParam, lParam);
			g_OverScreenResult = g_pCharacter->InKey( (int) wParam, lParam);
			break;

		case WM_KEYUP:
			 g_pCharacter->OutKey((int) wParam,lParam);
			break;
		
	}

	return DefWindowProc(hWnd,msg,wParam, lParam);
}

void MainLoop()
{	

	switch ( g_OverScreenResult)
	{
		case 0:
			
			g_MapX = g_MapX- 8;
			if( g_MapX < 0) g_MapX=0;
			break;

		case 1:
			
			g_MapX = g_MapX + 8;
			if( g_MapX > 3072) g_MapX = 3072;
			break;

		case 2:
			
			g_MapY = g_MapY - 8;
			if( g_MapY < 0) g_MapY=0;
			break;

		case 3:
			
			g_MapY = g_MapY + 8;
			if (g_MapY > 2304) g_MapY= 2304;
			break;

	}
	g_pCharacter->PutMapPos(g_MapX, g_MapY);

	g_OverScreenResult = 4;

	
	g_pMap->BltMap(g_MapX,g_MapY);

//	POINT pt = m_pMap->BltTileEdit();


//	int Pos;
//	Pos = m_pMap->ComplexPosition(g_MapX, g_MapY, pt.x, pt.y);

//	static char String[50];
	static char String2[50];
	static char String3[50];


//	ZeroMemory(String,50);
//	sprintf(String," Std X=%d Std Y=%d ",g_MapX,g_MapY);

	ZeroMemory(String2,50);
	sprintf(String2,"ĳ ǥ ô : x = %d y = %d",g_pCharacter->GetCurPosX(),g_pCharacter->GetCurPosY());

	ZeroMemory(String3,50);
	sprintf(String3," : %d",g_pCharacter->m_direction);


//	g_pDirectDraw->PutString(0,0,String,50);
	g_pDirectDraw->PutString(0,20,String2,50);
	g_pDirectDraw->PutString(0,40,String3,50);


	g_pCharacter->Pattern_Move_Normal(g_pCharacter->GetDirection(),g_pCharacter->GetActiveState());
	
	g_pNpc->Pattern_1(g_MapX, g_MapY);
	
//	m_pDirectDraw->PutString(0, 560, g_SendMessage,80);

	g_pBlocking->BltBlock();

	
	g_pDirectDraw->BltBack();
}

void InKeyLoop(int nVirtKey, LPARAM lKeyData)
{


	if(nVirtKey == VK_ESCAPE) 
	{		
		g_pCharacter->ExitInit();
		delete g_pCharacter;

		g_pMap->ExitInit();
		delete g_pMap;

		delete g_pHan2;

		g_pDirectDraw->ExitInit();
		delete g_pDirectDraw;

		
		PostQuitMessage (0);
	}

	
	
}

BOOL WINAPI DlgProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch ( msg)
	{
		case WM_COMMAND:
			switch( LOWORD ( wParam))
			{
				case IDOK:
					GetDlgItemText(hWnd, IDC_EDIT1, g_MessageString,80);
					memset((char*) g_SendMessage,0,80);
					strcpy(g_SendMessage,g_MessageString);
					memset((char*)g_MessageString,0,80);
					SetDlgItemText(hWnd,IDC_EDIT1,g_MessageString);
					break;

				case IDC_EDIT1:
					break;

			}
			break;

	}
	return 0;
}

					

