#include "cnpc.h"

CNpc::CNpc()
{
}

void CNpc::Init(LPDIRECTDRAW2 lpDD2, LPDIRECTDRAWSURFACE lpDDS)
{
	m_pDD2 = lpDD2;
	m_pDDSBack = lpDDS;

	LoadCharacter();
}

void CNpc::ExitInit()
{
	for(int i = 0; i< 4; i++)
		m_pDDS_Image[i]->Release();
}


LPDIRECTDRAWSURFACE CNpc::_CreateSurface(int width, int height)
{

	LPDIRECTDRAWSURFACE lpDDS=NULL;
	DDSURFACEDESC ddsd;
	HRESULT hr;

	ZeroMemory(&ddsd, sizeof(ddsd) );
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwHeight = height;
	ddsd.dwWidth  = width;

	if( lpDDS==NULL) hr = m_pDD2->CreateSurface (&ddsd, &lpDDS, NULL);
	if (hr != DD_OK) return FALSE;

	return lpDDS;
}

BOOL CNpc::_LoadImage ( LPDIRECTDRAWSURFACE lpDDS, LPSTR szImage)
{
	HBITMAP				hbm;
	HDC					hdcImage = NULL;
	HDC					hdcSurf  = NULL;
	DDSURFACEDESC		ddsd;
	HRESULT hr;
	
	ZeroMemory (&ddsd, sizeof (ddsd));
	ddsd.dwSize = sizeof(ddsd);
	
	hr = lpDDS->GetSurfaceDesc(&ddsd);
	if( hr != DD_OK) return FALSE;
	
	hbm = (HBITMAP) LoadImage ( NULL, szImage, IMAGE_BITMAP, ddsd.dwWidth, ddsd.dwHeight, 
								LR_LOADFROMFILE|LR_CREATEDIBSECTION);
	if (hbm==NULL) return FALSE;

	hdcImage = CreateCompatibleDC(NULL);
	SelectObject( hdcImage, hbm);

	hr = lpDDS->GetDC(&hdcSurf);
	if( hr != DD_OK) return FALSE;

	if( BitBlt(hdcSurf, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, 0, 0, SRCCOPY ) == FALSE) return FALSE;


	if( hdcSurf) lpDDS->ReleaseDC( hdcSurf);
	if( hdcImage) DeleteDC( hdcImage);
	if( hbm ) DeleteObject (hbm);

	return TRUE;
}

HRESULT CNpc::_SetColorKey(LPDIRECTDRAWSURFACE pdds)
{
	DDCOLORKEY ddck;

	ddck.dwColorSpaceHighValue = 0xffff;
	ddck.dwColorSpaceLowValue  = 0xffff;
	return pdds->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

void CNpc::LoadCharacter()
{
	m_pDDS_Image[0] = _CreateSurface(32, 160);
	_LoadImage(m_pDDS_Image[0], "..\\׸\\left.BMP");
	_SetColorKey(m_pDDS_Image[0]);

	m_pDDS_Image[1] = _CreateSurface(32, 160);
	_LoadImage(m_pDDS_Image[1], "..\\׸\\.BMP");
	_SetColorKey(m_pDDS_Image[1]);

	m_pDDS_Image[2] = _CreateSurface(32, 160);
	_LoadImage(m_pDDS_Image[2], "..\\׸\\.BMP");
	_SetColorKey(m_pDDS_Image[2]);

	
	m_pDDS_Image[3] = _CreateSurface(32, 160);
	_LoadImage(m_pDDS_Image[3], "..\\׸\\Ʒ.BMP");
	_SetColorKey(m_pDDS_Image[3]);
}

void CNpc::BltCharacter( int SceneNum, int FrameNum )
{	
	
	SetRect(&m_charRect, 0, 32*FrameNum, 32, 32*FrameNum+32);
	m_pDDSBack->BltFast(m_currentX,m_currentY,m_pDDS_Image[SceneNum],&m_charRect, DDBLTFAST_WAIT|DDBLTFAST_SRCCOLORKEY);
	
}

void CNpc::SetPosition(int PosX, int PosY)
{
	m_currentX = PosX - m_groundX;
	m_currentY = PosY - m_groundY;
}

void CNpc::Pattern_1(int GroundX, int GroundY)
{
	m_groundX = GroundX;
	m_groundY = GroundY;


	SetPosition(1000,400);	
	BltCharacter(0,0);
	
}
