#include "CBlock.h"
#include <stdio.h>

BOOL CBlock::Init(LPDIRECTDRAW2 pDD2, LPDIRECTDRAWSURFACE pDDS)
{
	m_pDD2 = pDD2;
	m_pDDSBack = pDDS;

	// SET : Map Blocking Data Buffer 
	// 3968/8= 496 2944/8 = 368
	m_pBlockData = (int *) malloc( 496 * 368 * 4);
	memset(m_pBlockData, 0, 496 * 368 * 4);

	m_currentX = 0;
	m_currentY = 0;

	return TRUE;
}

void CBlock::ExitInit()
{
	if( m_pBlockData != NULL) free( m_pBlockData);
}

void CBlock::BltBlock(int MapX, int MapY)
{
//	int x, y;
//	for(y=0; y<71; y++)
//	for(x=0; x<99; x++)
//		if( (m_BlockData+y*99+x)==0) 
	m_MapX = MapX;
	m_MapY = MapY;

// ...  ////////////////////////////////////////
	int x, y;
	for(y=0; y<=71; y++)
	for(x=0; x<=99; x++)
		 if( m_pBlockData[MapX/8+MapY/8*496+x+y*496]==0) 
			 CDirectDraw::PutPixel(x*8,y*8,0xf000);
		 else
			 CDirectDraw::PutPixel(x*8,y*8,0x0f00);

// ...  //////////////////////////////////////////



	CDirectDraw::RectangleBox(m_currentX,m_currentY, 8, 8, 0xf000);
}

void CBlock::SetCurrentPos(int x, int y)
{
	m_currentX = x;
	m_currentY = y;
}

void CBlock::GetCurrentMap(int MapX, int MapY)
{
	m_DataX=(MapX+m_currentX)/8;
	m_DataY=(MapY+m_currentY)/8;
}

int CBlock::InKey(int nVirtKey, int lKeyData)
{

	switch(nVirtKey)
	{
		case VK_LEFT:
			
			if(m_currentX <=0 ) 
			{
				m_currentX=0;
				return 0;
			}
			m_currentX -=8;
			break;
		
		case VK_RIGHT:
			
			if(m_currentX >=792) 
			{
				m_currentX = 792; //99
				return 1;
			}
			m_currentX +=8;
			break;

		case VK_UP:
			
			if(m_currentY <=0) 
			{
				m_currentY = 0;
				return 2;
			}
			m_currentY -=8;
			break;
		
		case VK_DOWN:
			if(m_currentY >= 568) 
			{
				m_currentY = 568; //71
				return 3;
			}
			
			m_currentY +=8;
			break;

		case 32:	// SPACE BAR
			m_pBlockData[m_MapX/8+m_MapY/8*496+m_currentX/8+m_currentY/8*496] = 1;
			break;

		case VK_F1:
			m_pBlockData[m_MapX/8+m_MapY/8*496+m_currentX/8+m_currentY/8*496] = 1;
			break;

		case VK_F2:
			m_pBlockData[m_MapX/8+m_MapY/8*496+m_currentX/8+m_currentY/8*496] = 0;
			break;


		case VK_F3:
			FileSaveBlock();
			break;
		case VK_F4:
			FileLoadBlock();
			break;
	}
	return 4;
}


void CBlock::FileSaveBlock()
{
	// m_pMapData To File

	FILE *fp;
	fp = fopen("BlockData.dat","wb");
	
	fseek(fp,0,SEEK_SET);
	fwrite((int *)m_pBlockData, 182528*4,1,fp);
	fclose(fp);

}

void CBlock::FileLoadBlock()
{
	FILE *fp;
	fp = fopen("BlockData.dat","rb");

	fseek(fp,0,SEEK_SET);
	fread((int*) m_pBlockData, 182528*4, 1, fp);
	fclose(fp);

}

