#ifndef _CHAN_H
#define _CHAN_H

#include "cdirectdraw.h"

static unsigned char table[3][32] = 
{
	{ 0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,0,0,0,0,0,0,0,0,0,0 },
	{ 0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21,0,0 },
	{ 0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,17,18,19,20,21,22,23,24,25,26,27,0,0 }
};
static unsigned char fsttable[2][20] = 
{
	{ 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1 },
	{ 0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3 }
};

static unsigned char midtable[3][22] = 
{
	{ 0,0,2,0,2,1,2,1,2,3,0,2,1,3,3,1,2,1,3,3,1,1 },
	{ 0,0,0,0,0,0,0,0,0,1,3,3,3,1,2,4,4,4,2,1,3,0 },
	{ 0,5,5,5,5,5,5,5,5,6,7,7,7,6,6,7,7,7,6,6,7,5 }
};

static unsigned char AsciiKeyCode[2][128] = 
{
    {  0 ,  0 , 49 , 50 , 51 , 52 , 53 , 54 , 55 , 56 , 57 , 48 , 45 , 61 ,  0 ,  0 ,
      113, 119, 101, 114, 116, 121, 117, 105, 111, 112, 91 , 93 ,  0 ,  0 , 97 , 115,
      100, 102, 103, 104, 106, 107, 108, 59 , 39 , 96 ,  0 , 92 , 122, 120, 99 , 118,
      98 , 110, 109, 44 , 46 , 47 ,  0 , 42 ,  0 , 32 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 , 45 ,  0 ,  0 ,  0 , 43 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
    },
	// Shift Key Down
    {  0 ,  0 , 33 , 64 , 35 , 36 , 37 , 94 , 38 , 42 , 40 , 41 , 95 , 43 ,  0 ,  0 ,
      81 , 87 , 69 , 82 , 84 , 89 , 85 , 73 , 79 , 80 ,123 ,125 ,  0 ,  0 , 65 , 83 ,
      68 , 70 , 71 , 72 , 74 , 75 , 76 , 58 , 34 ,126 ,  0 ,124 , 90 , 88 , 67 , 86 ,
      66 , 78 , 77 , 60 , 62 , 63 ,  0 , 42 ,  0 , 32 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 , 45 ,  0 ,  0 ,  0 , 43 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
        0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
    }
};

static unsigned char AsciiHanOkCode[128] = {                         
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 1 , 1 ,
    1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 1 , 1 , 1 , 1 ,
    1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
};

// ħ  .
static unsigned char IsJaMo[128] = {
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    1 , 1 , 1 , 1 , 1 , 2 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 1 , 1 ,
    1 , 1 , 1 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 1 , 1 , 1 , 1 ,
    2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
    0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
};


static unsigned char HanData[2][3][128] = {                         
    { { 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         9 , 14, 5 , 2 , 11, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 8 , 4 ,
         13, 7 , 20, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 17, 18, 16, 19,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
      },
      { 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 19, 11, 5 , 4 , 10, 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 13, 7 , 3 , 29, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         26, 20, 27, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
      },
      { 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         19, 24, 8 , 2 , 21, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 17, 5 ,
         23, 9 , 29, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 26, 27, 25, 28,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
      }
    },
    { { 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         10, 15, 6 , 3 , 12, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
      },
      { 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 6 , 12, 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
      },
      { 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 3 , 22, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
         0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
      }
    }
};

static unsigned char JSungJo[7][3] = { 
    { 0x0D , 0x03 , 0x0E },
    { 0x0D , 0x04 , 0x0F },
    { 0x0D , 0x1D , 0x12 },
    { 0x14 , 0x07 , 0x15 },
    { 0x14 , 0x0A , 0x16 },
    { 0x14 , 0x1D , 0x17 },
    { 0x1B , 0x1D , 0x1C }
};

static unsigned char ESungJo[11][3] = { 
    { 0x02 , 0x15 , 0x04 },
    { 0x05 , 0x18 , 0x06 },
    { 0x05 , 0x1D , 0x07 },
    { 0x09 , 0x02 , 0x0A },
    { 0x09 , 0x11 , 0x0B },
    { 0x09 , 0x13 , 0x0C },
    { 0x09 , 0x15 , 0x0D },
    { 0x09 , 0x1B , 0x0E },
    { 0x09 , 0x1C , 0x0F },
    { 0x09 , 0x1D , 0x10 },
    { 0x13 , 0x15 , 0x14 }
};



class CHan : public CDirectDraw
{
	public:

	public:
		unsigned char H_FONT1[8][20][32];			
		unsigned char H_FONT2[4][22][32];
		unsigned char H_FONT3[4][28][32];
		unsigned char E_FONT[2656][16];

		unsigned char han_image[32];
		unsigned char eng_image[16];

	public:
		void ReadFont ( char *HanFile, char * EngFile);
		void Hputs(int x, int y, char *string, unsigned short color);
		
		void or_img( unsigned char *src, unsigned char *dest, int size);
		void put_font ( int x, int y, unsigned char * fnt, int size, unsigned short color);

	public:
		virtual BOOL Init(LPDIRECTDRAW2 lpDD2, LPDIRECTDRAWSURFACE lpDDS);

	public:
		void GetKeyboard( int nVirtKey, LPARAM lKeyData);
		char * Hgets( int x, int y, unsigned short color);

	public:
		unsigned char m_GetKCode;
		char *m_Temp;
		int m_count;
		BOOL m_bFirst;
			
};



#endif _CHAN_H