#ifndef _CMAP_H
#define _CMAP_H

#include "cdirectdraw.h"

class CMap :public CDirectDraw
{
	public:
		int m_MapWidth;
		int m_MapHeight;
		
		int m_CurPosX;
		int m_CurPosY;

	    int * m_pMapData;  //[504];		// 31 * 46 = 

		// 0:Dirt 1:Mud 2:Water 3:Grass 4:Structure 5:Asphalt 6:Rocky
		LPDIRECTDRAWSURFACE m_pDDS_Dirt[24]; // 0-23

		unsigned short * m_pWorld;		//.	
	
	public:
		virtual BOOL Init(LPDIRECTDRAW2 lpDD, LPDIRECTDRAWSURFACE lpDDS);
		virtual void ExitInit();

		void LoadMap();
		void MakeWorld();
		void BltMap(int CurPosX, int CurPosY); 

	public:
		int GetCurPosX();
		int GetCurPosY();
		void SetCurPos(int PosX, int PosY);

	
	public:
		void PutCel(int PosX, int PosY, int Cel);
		

//  Edit Logic
	public:
		int m_x;
		int m_y;
		int m_stdX;
		int m_stdY;
		int m_usedx;
		int m_usedy;

		int m_SelectCelNum;
		int m_Value;
		
	public:
		int InKey ( int nVirtKey, LPARAM lKeyData);
		POINT BltTileEdit();
	public:

		void SelectRect(int x, int y);
				
		int ComplexPosition(int stdx, int stdy, int x, int y);
		void UpdateMapData(int stdx, int stdy, int x, int y, int Value, int Cel);


		char * m_FileName;
		void FileSaveMap();
		void FileLoadMap();
		void GetFileName(char *FileName);
		

};


#endif _CMAP_H