#include "CCharacter.h"
#include <stdio.h>

int CCharacter::GetCurPosX()
{
	return m_x+m_mapX;
}

int CCharacter::GetCurPosY()
{
	return m_y+m_mapY;
}

BOOL CCharacter::Init(LPDIRECTDRAW2 lpDD, LPDIRECTDRAWSURFACE lpDDS, HINSTANCE hInstance, HWND hWnd)
{
	m_pDD2	   = lpDD;
	m_pDDSBack = lpDDS;

	int i;
	for ( i=0; i<5; i++)
		m_pDDS_Image[i]=NULL;
	
//	m_pDDS_Buffer = NULL;

	m_x = 320;
	m_y = 320;

	m_mapX = 0;
	m_mapY = 0;

	m_direction = 3;
	m_bActive = FALSE;
	
	_Init(hInstance, hWnd);

	return TRUE;

}

void CCharacter::ExitInit()
{
	int i;
	for ( i=0; i<5; i++)
		if(m_pDDS_Image[i]!=NULL) m_pDDS_Image[i]->Release();
	
//	if(m_pDDS_Buffer) m_pDDS_Buffer->Release();
	_ExitInit();

}

void CCharacter::SetPos( int PosX, int PosY)
{
	m_x = PosX;
	m_y = PosY;
}


void CCharacter::LoadCharacter()
{
//	m_pDDS_Buffer = CDirectDraw::_CreateSurface(32, 32);
	
	m_pDDS_Image[0] = CDirectDraw::_CreateSurface(32, 160);
	CDirectDraw::_LoadImage(m_pDDS_Image[0], "..\\׸\\.BMP");
	CDirectDraw::SetColorKey(m_pDDS_Image[0]);

	m_pDDS_Image[1] = CDirectDraw::_CreateSurface(32, 160);
	CDirectDraw::_LoadImage(m_pDDS_Image[1], "..\\׸\\.BMP");
	CDirectDraw::SetColorKey(m_pDDS_Image[1]);

	m_pDDS_Image[2] = CDirectDraw::_CreateSurface(32, 160);
	CDirectDraw::_LoadImage(m_pDDS_Image[2], "..\\׸\\.BMP");
	CDirectDraw::SetColorKey(m_pDDS_Image[2]);

	
	m_pDDS_Image[3] = CDirectDraw::_CreateSurface(32, 160);
	CDirectDraw::_LoadImage(m_pDDS_Image[3], "..\\׸\\Ʒ.BMP");
	CDirectDraw::SetColorKey(m_pDDS_Image[3]);
}


void CCharacter::BltCharacter( int SceneNum, int FrameNum )
{	
	
	SetRect(&m_charRect, 0, 32*FrameNum, 32, 32*FrameNum+32);
	m_pDDSBack->BltFast(m_x-16,m_y-32,m_pDDS_Image[SceneNum],&m_charRect, DDBLTFAST_WAIT|DDBLTFAST_SRCCOLORKEY);
	
}

void CCharacter::Pattern_Move_Normal(int Direction, int Activate)//, int * BlockData, int MapX, int MapY)
{	
	static int count;
	// m_x, m_y, MapX, MapY

	if(!Activate) BltCharacter(Direction,0);
	else 
	{
		count++;
		if(count==5)count=0;
		BltCharacter(Direction,count);
	
	}

}

void CCharacter::Pattern_Move_Left(int Range)
{
}

void CCharacter::Pattern_Move_Right(int Range)
{
}

void CCharacter::Pattern_Move_Up(int Range)
{
}

void CCharacter::Pattern_Move_Down(int Range)
{
}

void CCharacter::OutKey(int nVirtKey, LPARAM lKeyData)
{
	switch (nVirtKey)
	{
		case VK_LEFT:
			this->m_bActive = FALSE;
			break;

		case VK_RIGHT:
			this->m_bActive = FALSE;
			break;

		case VK_UP:
			this->m_bActive = FALSE;
			break;
			
		case VK_DOWN:
			this->m_bActive = FALSE;
			break;
	}


}

int CCharacter::InKey(int nVirtKey, LPARAM lKeyData)
{
	int OverScreenResult;
	switch (nVirtKey)
	{
		case VK_LEFT:
			m_bActive = TRUE;

			m_direction --;
			if( m_direction<0)m_direction=3;

			break;

		case VK_RIGHT:
			m_bActive = TRUE;


			m_direction ++;
			if(m_direction>3)m_direction=0;

			break;
		
	}
	return OverScreenResult=4;
}

int CCharacter::GetDirection()
{
	return m_direction;
}

void CCharacter::PutMapPos(int x, int y)
{
	m_mapX = x;
	m_mapY = y;
}

BOOL CCharacter::GetActiveState()
{
	return this->m_bActive;
}

////////////////////////////////////////////////
//////////////////////////////////////////////
///////////////////////////////////////////////

void CCharacter::_Init(HINSTANCE hInstance, HWND hWnd)
{
	DirectInputCreate( hInstance, DIRECTINPUT_VERSION, &m_lpdi, NULL);
	

	LPDIRECTINPUTDEVICE lpdid1;
	m_lpdi->CreateDevice ( GUID_SysKeyboard,&lpdid1, NULL);
	lpdid1->QueryInterface ( IID_IDirectInputDevice2, (void**) &m_lpdid2);
	lpdid1->Release();

	m_lpdid2->SetDataFormat ( &c_dfDIKeyboard);
	
	DWORD cl, cl1;
	cl = DISCL_NONEXCLUSIVE;
	cl1 = DISCL_FOREGROUND;

	m_lpdid2->SetCooperativeLevel( hWnd, cl|cl1);

	DIPROPDWORD dipdw =
	{
		{
			sizeof(DIPROPDWORD),
			sizeof(DIPROPHEADER),
			0,
			DIPH_DEVICE,
		},
		BUFFERSIZE,
	};
	
	m_lpdid2->SetProperty ( DIPROP_BUFFERSIZE, &dipdw.diph);
	
	SetAcquireState(TRUE);
	

}

BOOL CCharacter::SetAcquireState( BOOL acq)
{
	HRESULT hr;

	if( ! acq)
	{
		hr = m_lpdid2->Unacquire();
	}
	else
	{
		hr = m_lpdid2->Acquire();
	}


	return ( SUCCEEDED (hr));
}



void CCharacter::_ExitInit()
{
    if ( m_lpdid2 != NULL ) 
    {
        SetAcquireState( FALSE );
        m_lpdid2->Release();
        m_lpdid2 = NULL;
    }

    if ( m_lpdi != NULL )
    { 
        m_lpdi->Release();
        m_lpdi = NULL;
    }
}

int CCharacter::PollDevice(int blockF, int blockB)
{
//    DIJOYSTATE   dijs;
    char         keys[256]; 
    static       DWORD LastClickTime;
     
    HRESULT            hr;
    DIDEVICEOBJECTDATA rgdod[BUFFERSIZE];
    DWORD              dwItems; 

    if ( !m_lpdid2 ) return FALSE;

getBufferedData:
    m_lpdid2->Poll();  // May be unnecessary but never hurts.

    dwItems = BUFFERSIZE;
    hr = m_lpdid2->GetDeviceData( sizeof( DIDEVICEOBJECTDATA ), 
                     rgdod,         // Where to put data?
                     &dwItems,      // How many items?
                     0 );           // Flags.

    // If data stream was interrupted, reacquire the device and try again.
    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetAcquireState( TRUE ) )
            goto getBufferedData;
    }

    // We can't get the device. Quit.
    if ( hr == DIERR_NOTACQUIRED )
    {
        OutputDebugString( "Device not acquired!" );
        return FALSE;
    }


getImmediateData:
    hr = m_lpdid2->GetDeviceState( sizeof( keys ), keys );  

    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetAcquireState( TRUE ) )
            goto getImmediateData;
    }
    if ( hr == DIERR_NOTACQUIRED )
    {
        OutputDebugString( "Device not acquired!" );
        return FALSE;
    }

    // We got immediate input, let's act on it.  
    if ( SUCCEEDED( hr ) )
    {

		int OverScreenResult;

		if( BUTTONDOWN( keys[DIK_LEFT] ) &
			BUTTONDOWN( keys[DIK_UP] ) )
		{
			return 4;
		}
		if( BUTTONDOWN( keys[DIK_LEFT] ) &
			BUTTONDOWN( keys[DIK_DOWN] ) )
		{
			return 4;
		}
		if( BUTTONDOWN( keys[DIK_RIGHT] ) &
			BUTTONDOWN( keys[DIK_UP] ) )
		{
			return 4;
		}

		if( BUTTONDOWN( keys[DIK_RIGHT] ) &
			BUTTONDOWN( keys[DIK_DOWN] ) )
		{
			return 4;
		}

		if( blockF == 0)
        if ( BUTTONDOWN( keys[DIK_UP] ) )			
		{
			m_bActive = TRUE;
			if ( m_direction==0)  // left
			{
				m_x-=8;					// 4 ũ 
				if ( m_x<50) 
				{
					m_x=50;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
					return OverScreenResult = 0;
				}
	
			}
			if ( m_direction==1)  // up
			{
				
				m_y-=8;
				if( m_y<50) 
				{
					m_y=50;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
					return OverScreenResult = 2;
				}
				
			}
			if ( m_direction==2) // right
			{
				
				m_x+=8;
				if ( m_x>700) //768)	// 800 - 32
				{
					m_x=700;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE",MB_OK);
					return OverScreenResult = 1;
				}
			}
			if ( m_direction==3) // down
			{
				
				m_y+=8;
				if (m_y>500)//545)		// 577 - 32
				{
					m_y=500;//MessageBox(NULL,"Over Screen","TRYOVER Message", MB_OK);
					return OverScreenResult = 3;
				}
				
			}
			

		}
       
		if( blockB == 0)
        if ( BUTTONDOWN( keys[DIK_DOWN] ) )
		{
			m_bActive = TRUE;

			if ( m_direction==0)
			{
				m_x+=8;
				if ( m_x>700) //768)	// 800 - 32
				{
					m_x=700;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE",MB_OK);
					return OverScreenResult = 1;
				}
			
			}
			if ( m_direction==1)
			{
				m_y+=8;
				if (m_y>500)//545)		// 577 - 32
				{
					m_y=500;//MessageBox(NULL,"Over Screen","TRYOVER Message", MB_OK);
					return OverScreenResult = 3;
				}
				
			}
			if ( m_direction==2) 
			{
				m_x-=8;					// 4 ũ 
				if ( m_x<50) 
				{
					m_x=50;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
					return OverScreenResult = 0;
				}

			
			}
			if ( m_direction==3)
			{
				m_y-=8;
				if( m_y<50) 
				{
					m_y=50;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
					return OverScreenResult = 2;
				}

			}
				
		}
        
		return OverScreenResult=4;
    }
    else              // FAILED( hr )
        return FALSE;
}  // PollDevice()



int CCharacter::GetBlockDataF(int MapX, int MapY, const int *pBlockData)
{


	int mapx = MapX;
	int mapy = MapY;
	int value=4;

	switch(m_direction)
	{
		case 0:	// left
			PutString( 0, 0, "LEFT ", 5);
			value = pBlockData[mapx/8+mapy/8*496+m_x/8-1+m_y/8*496];
			break;
		case 1: // up
			PutString( 0, 0, "UP   ", 5);
			value = pBlockData[mapx/8+mapy/8*496+m_x/8+(m_y/8-1)*496];	
			break;
		case 2: // right
			PutString( 0, 0, "RIGHT", 5);
			value = pBlockData[mapx/8+mapy/8*496+m_x/8+1+m_y/8*496];
			break;
			
		case 3: // down
			PutString( 0, 0, "DOWN ", 5);	
			value = pBlockData[mapx/8+mapy/8*496+m_x/8+(m_y/8+1)*496];
			break;

	}
	
//	int x, y;
//	for(y=0; y<=71; y++)
//	for(x=0; x<=99; x++)
//		 if( pBlockData[MapX/8+MapY/8*496+x+y*496]==0) 
//			 CDirectDraw::PutPixel(x*8,y*8,0xf000);
//		 else
//			 CDirectDraw::PutPixel(x*8,y*8,0x0f00);

//	char string[5];
//	sprintf(string,"%d",value);
//	PutString( 0, 20, string, 5);
	return value;



}


int CCharacter::GetBlockDataB(int MapX, int MapY, const int *pBlockData)
{


	int mapx = MapX;
	int mapy = MapY;
	int value=4;

	switch(m_direction)
	{
		case 0:	// left
			value = pBlockData[mapx/8+mapy/8*496+m_x/8+1+m_y/8*496];
			break;
		case 1: // up
			value = pBlockData[mapx/8+mapy/8*496+m_x/8+(m_y/8+1)*496];
			break;
		case 2: // right
			value = pBlockData[mapx/8+mapy/8*496+m_x/8-1+m_y/8*496];
			break;
			
		case 3: // down
			value = pBlockData[mapx/8+mapy/8*496+m_x/8+(m_y/8-1)*496];	
			break;

	}
	
	return value;



}