#ifndef _CCHARACTER_H
#define _CCHARACTER_H

#include <windows.h>
#include <dinput.h>

#include "cdirectdraw.h"

#define BUFFERSIZE 32
#define BUTTONDOWN(b) (b & 0x80)

class CCharacter:public CDirectDraw
{

	public:
				
		BOOL	m_bActive;
		int		m_Scene;
//		int     m_CurPosX;
//		int     m_CurPosY;
		RECT    m_charRect;
		int     m_direction;

		LPDIRECTDRAWSURFACE m_pDDS_Image[5];
		// 0:LEFT 1:RIGHT 2:TOP 3:DOWN 4:ATTACK 5:DEFENCE
		LPDIRECTDRAWSURFACE m_pDDS_Buffer;

	public:
		virtual BOOL Init(LPDIRECTDRAW2 lpDD, LPDIRECTDRAWSURFACE lpDDS, HINSTANCE hInstance, HWND hWnd);
		virtual void ExitInit();

		void LoadCharacter();
		void BltCharacter(int SceneNum, int FrameNum); 
		void SetPos(int PosX, int PosY);

	public:
		int GetCurPosX();				// Map Position
		int GetCurPosY();
		
		void Pattern_Move_Normal (int Direction,BOOL Activate);//,int * BlockData, int MapX, int MapY);
		void Pattern_Move_Left	(int Range);
		void Pattern_Move_Right	(int Range);
		void Pattern_Move_Up	(int Range);
		void Pattern_Move_Down	(int Range);

	public:
		int m_x;
		int m_y;
		int m_mapX;
		int m_mapY;

	public:
		int InKey(int nVirtKey, LPARAM lKeyData);
		void OutKey(int nVirtKey, LPARAM lKeyData);

		int GetDirection ();
		void PutMapPos(int x, int y);
		BOOL GetActiveState();
		

//		Pattern_Attack_Normal_Left();
//		Pattern_Attack_Normal_Right();
//		Pattern_Attack_Normal_Up();
//		Pattern_Attack_Normal_Down();

//		Pattern_Attack_Special_Left();
//		Pattern_Attack_Special_Right();
//		Pattern_Attack_Special_Up();
//		Pattern_Attack_Special_Down();

//		Pattern_Defence_Normal_Left();
//		Pattern_Defence_Normal_Right();
//		Pattern_Defence_Normal_Up();
//		Pattern_Defence_Normal_Down();
	
	//////////////////////////////////
	
	public:
		LPDIRECTINPUT m_lpdi;
		LPDIRECTINPUTDEVICE2 m_lpdid2;

	public:
		void _Init(HINSTANCE hInstsance, HWND hWnd);
		void _ExitInit();

	public:
		BOOL SetAcquireState( BOOL acq);
		int PollDevice(int blockF, int blockB);
		int GetBlockDataF(int MapX, int MapY, const int * pBlockData);
		int GetBlockDataB(int MapX, int MapY, const int * pBlockData);
		

		
};


#endif _CCHARACTER_H