#include "CDirectDraw.h"


BOOL CDirectDraw::Init(HWND hWnd, int width, int height, int bpp)
{
	m_bMode555 = FALSE;
	m_bMode565 = FALSE;

	HRESULT hr;
	LPDIRECTDRAW lpDD;
	
	hr = DirectDrawCreate( NULL, &lpDD, NULL);
	if (hr != DD_OK) return FALSE;
	
	hr = lpDD->QueryInterface ( IID_IDirectDraw2, (LPVOID *) &m_pDD2);
	if (hr != DD_OK) return FALSE;

	lpDD->Release();
	lpDD = NULL;

	hr = m_pDD2->SetCooperativeLevel ( hWnd, DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE|DDSCL_NOWINDOWCHANGES);
	if (hr != DD_OK) return FALSE;

	hr = m_pDD2->SetDisplayMode ( width, height, bpp, 0, 0);
	if (hr != DD_OK) return FALSE;

	DDSURFACEDESC ddsd;

	ZeroMemory( &ddsd, sizeof (ddsd));
	ddsd.dwSize = sizeof( ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	hr = m_pDD2->CreateSurface ( &ddsd, &m_pDDSPrimary, NULL);
	if (hr != DD_OK) return FALSE;

	ZeroMemory(&ddsd, sizeof(ddsd) );
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN|DDSCAPS_VIDEOMEMORY|DDSCAPS_LOCALVIDMEM;	// Video Memory 2M ̻.
	ddsd.dwHeight = BACK_HEIGHT;
	ddsd.dwWidth  = BACK_WIDTH;

	hr = m_pDD2->CreateSurface (&ddsd, &m_pDDSBack, NULL);
	if (hr != DD_OK) return FALSE;

	SetRect(&m_bkRect, 0,0, 800, 577);	// Front/Back Blt Image RECT

	CheckMode();

	return TRUE;
}




void CDirectDraw::ExitInit()
{
	if( m_pDDSBack != NULL)
	{
		m_pDDSBack->Release();
		m_pDDSBack = NULL;
	}
	if (m_pDDSPrimary != NULL)
	{
		m_pDDSPrimary->Release();
		m_pDDSPrimary = NULL;
	}
	if( m_pDD2 != NULL)
	{
		m_pDD2->Release();
		m_pDD2 = NULL;
	}
}

void CDirectDraw::ClearBack()
{
	DDSURFACEDESC ddsd;
	ZeroMemory( &ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	m_pDDSBack->GetSurfaceDesc(&ddsd);

	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	unsigned short *p = (unsigned short *) ddsd.lpSurface;
	
	for ( int i = 0; i< (int)ddsd.dwHeight; i++)
		for ( int j = 0; j< (int)ddsd.dwWidth; j++)
			p[i*800+j] = 0x0000;

	m_pDDSBack->Unlock(ddsd.lpSurface);

}


void CDirectDraw::BltBack()
{
	m_pDDSPrimary->BltFast(0,0, m_pDDSBack, &m_bkRect, DDBLTFAST_WAIT);
}


LPDIRECTDRAWSURFACE CDirectDraw::GetBackSurface()
{
	return m_pDDSBack;
}

LPDIRECTDRAW2 CDirectDraw::GetDirectDraw()
{
	return m_pDD2;
}

LPDIRECTDRAWSURFACE CDirectDraw::_CreateSurface(int width, int height)
{

	LPDIRECTDRAWSURFACE lpDDS=NULL;
	DDSURFACEDESC ddsd;
	HRESULT hr;

	ZeroMemory(&ddsd, sizeof(ddsd) );
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwHeight = height;
	ddsd.dwWidth  = width;

	if( lpDDS==NULL) hr = m_pDD2->CreateSurface (&ddsd, &lpDDS, NULL);
	if (hr != DD_OK) return FALSE;

	return lpDDS;
}

BOOL CDirectDraw::_LoadImage ( LPDIRECTDRAWSURFACE lpDDS, LPSTR szImage)
{
	HBITMAP				hbm;
	HDC					hdcImage = NULL;
	HDC					hdcSurf  = NULL;
	DDSURFACEDESC		ddsd;
	HRESULT hr;
	
	ZeroMemory (&ddsd, sizeof (ddsd));
	ddsd.dwSize = sizeof(ddsd);
	
	hr = lpDDS->GetSurfaceDesc(&ddsd);
	if( hr != DD_OK) return FALSE;
	
	hbm = (HBITMAP) LoadImage ( NULL, szImage, IMAGE_BITMAP, ddsd.dwWidth, ddsd.dwHeight, 
								LR_LOADFROMFILE|LR_CREATEDIBSECTION);
	if (hbm==NULL) return FALSE;

	hdcImage = CreateCompatibleDC(NULL);
	SelectObject( hdcImage, hbm);

	hr = lpDDS->GetDC(&hdcSurf);
	if( hr != DD_OK) return FALSE;

	if( BitBlt(hdcSurf, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, 0, 0, SRCCOPY ) == FALSE) return FALSE;


	if( hdcSurf) lpDDS->ReleaseDC( hdcSurf);
	if( hdcImage) DeleteDC( hdcImage);
	if( hbm ) DeleteObject (hbm);

	return TRUE;
}


void CDirectDraw::PutPixel(int x, int y, unsigned short color)
{

	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof (ddsd);
	m_pDDSBack->GetSurfaceDesc(&ddsd);
	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL);
	unsigned short *p = (unsigned short*) ddsd.lpSurface;

	*(p+x+y*800) = color;
	
	m_pDDSBack->Unlock(ddsd.lpSurface);
}

void CDirectDraw::ColorBox(int x, int y, int width, int height, unsigned short color)
{
	DDSURFACEDESC ddsd;
	ZeroMemory( &ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	m_pDDSBack->GetSurfaceDesc(&ddsd);

	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	unsigned short *p = (unsigned short *) ddsd.lpSurface;
	
	for ( int j = y; j< y+height; j++)
	for ( int i = x; i< x+width; i++)
			p[i+800*j] = color;

	m_pDDSBack->Unlock(ddsd.lpSurface);

}

void CDirectDraw::PutString ( int x, int y, char *string, int size)
{

	HDC hdc;
	m_pDDSBack->GetDC(&hdc);
	TextOut(hdc,x,y,string, size);
	m_pDDSBack->ReleaseDC(hdc);
}

void CDirectDraw::GetScreenPointer()
{
	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd, sizeof (ddsd));
	ddsd.dwSize = sizeof(ddsd);

	m_pDDSPrimary->GetSurfaceDesc(&ddsd);
	m_pDDSPrimary->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL);
	m_ScrPtr = (unsigned short *) ddsd.lpSurface;
	m_pDDSPrimary->Unlock(ddsd.lpSurface);
}

void CDirectDraw::GetBackScreenPointer()
{
	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	m_pDDSBack->GetSurfaceDesc(&ddsd);
	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	m_BakPtr = (unsigned short *) ddsd.lpSurface;
	m_pDDSBack->Unlock(ddsd.lpSurface);
}


void CDirectDraw::CheckMode()
{
	HDC hdc;
	unsigned short check_value = 0;

	m_pDDSPrimary->GetDC(&hdc);
	SetPixel(hdc, 0, 0, RGB(255,255,255));
	m_pDDSPrimary->ReleaseDC(hdc);

	GetScreenPointer();
	GetBackScreenPointer();

	check_value = m_ScrPtr[0];
	if( check_value == 0xffff)	m_bMode565 = TRUE;
	else						m_bMode555 = TRUE;
}


unsigned short CDirectDraw::Rgb ( unsigned short Red, unsigned short Green, unsigned short Blue)
{
	if(m_bMode565) return (Red<<11)|(Green<<5)|Blue;
	else if(m_bMode555) return (Red<<10)|(Green<<5)|Blue;
	else return 0;
}



void CDirectDraw::PutPixelMix(int x, int y, unsigned short UsePixel)
{
	unsigned short rRed, rGreen, rBlue;

	DDSURFACEDESC ddsd;
	ddsd.dwSize = sizeof( ddsd);
	m_pDDSBack->GetSurfaceDesc(&ddsd);

	unsigned short *ptr;
	unsigned short SurfacePixel;

	
	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	ptr = (unsigned short *) ddsd.lpSurface ;

	SurfacePixel = ptr[x+y*ddsd.dwWidth];

	if ( m_bMode555)
	{
		rRed    = (UsePixel	   >>10 )&	0x001f/2  + (SurfacePixel>>10)& 0x001f /2;
		rGreen  = (UsePixel     >>5  )&	0x001f/2  + (SurfacePixel>>5 )& 0x001f /2;
		rBlue	= UsePixel			&	0x001f/2  + SurfacePixel 	& 0x001f /2;
	}
	if( m_bMode565)
	{
		rRed	= (UsePixel>>11)& 0x001f/2  + (SurfacePixel>>11)&0x001f/2;
		rGreen  = (UsePixel>>5 )& 0x003f /2 + (SurfacePixel>>5 )&0x003f/2;
		rBlue	= UsePixel    & 0x001f /2 + SurfacePixel    & 0x001f/2;
	}
	
	ptr[x+y*ddsd.dwWidth] = Rgb( rRed, rGreen, rBlue);
	m_pDDSBack->Unlock(ddsd.lpSurface);


}

HRESULT CDirectDraw::SetColorKey(LPDIRECTDRAWSURFACE pdds)
{
	DDCOLORKEY ddck;

	ddck.dwColorSpaceHighValue = 0xffff;
	ddck.dwColorSpaceLowValue  = 0xffff;
	return pdds->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

void CDirectDraw::RectangleBox(int x, int y, int width, int height, unsigned short color)
{
	for( int i = x; i< x+width; i++)
	{
		PutPixel(i,y, color);
		PutPixel(i,y+height, color);
	}

	for( i = y; i < y+height; i++)
	{
		PutPixel(x,i,color);
		PutPixel(x+width, i, color);
	}
}