#ifndef _CDIRECTDRAW_H
#define _CDIRECTDRAW_H

#include <ddraw.h>

#define BACK_WIDTH	800
#define BACK_HEIGHT 600

class CDirectDraw
{
	public:
		LPDIRECTDRAW2 m_pDD2;
		LPDIRECTDRAWSURFACE m_pDDSPrimary;
		LPDIRECTDRAWSURFACE m_pDDSBack;
		RECT m_bkRect;

	
	public:
		BOOL Init(HWND hWnd,int width, int height, int bpp);
		void ExitInit();
		void ClearBack();
		void PutPixel(int x, int y, unsigned short color);
		void ColorBox(int x, int y, int width, int height, unsigned short color);
		void BltBack();
		LPDIRECTDRAWSURFACE GetBackSurface();
		LPDIRECTDRAW2		GetDirectDraw();

	public:
		LPDIRECTDRAWSURFACE		_CreateSurface(int width, int height);
		BOOL					_LoadImage(LPDIRECTDRAWSURFACE lpDDS, LPSTR szImage);

	public:
		void PutString( int x, int y, char * string, int size);

	public:
		int m_bMode555;
		int m_bMode565;
		
		unsigned short * m_ScrPtr;
		unsigned short * m_BakPtr;

		void CheckMode();
		void GetScreenPointer();
		void GetBackScreenPointer();

		unsigned short Rgb ( unsigned short Red, unsigned short Green, unsigned short Blue);
		void PutPixelMix(int x, int y, unsigned short srcColor);
		HRESULT SetColorKey ( LPDIRECTDRAWSURFACE pdds);
		
	public:
		void RectangleBox(int x, int y, int width, int height, unsigned short color);
		

};

#endif _CDIRECTDRAW_H