// Default Include /////////////////////
#include <windows.h>
#include <stdio.h>
#include "resource.h"

// User Include ////////////////////////
#include "CDirectDraw.h"
#include "CMap.h"
#include "CBlock.h"
#include "CCharacter.h"

// Define //////////////////////////////
#define NAME "TryOver Program"

// Variable ////////////////////////////
BOOL g_bActive = FALSE;
int g_MapX, g_MapY;
int g_OverScreenResult;
int g_blockF;
int g_blockB;

// Function ////////////////////////////
LRESULT CALLBACK WndProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
void Init(HINSTANCE hInstance, HWND hWnd);
void Loop();
void InKeyLoop(int nVirtKey, LPARAM lKeyData);

// Class ///////////////////////////////
CDirectDraw *g_pDirectDraw;
CMap        *g_pMap;
CBlock      *g_pBlock;
CCharacter  *g_pCharacter;

void Init(HINSTANCE hInstance, HWND hWnd)
{
	/////////////////////////////////////////////
	g_pDirectDraw = new CDirectDraw();
	if(!g_pDirectDraw->Init(hWnd, 800, 600,16)) MessageBox(NULL, "FAILD : Direct Draw Class", "TRYOVER MESSAGE", MB_OK);

	////////////////////////////////////////////
	g_pMap = new CMap();
	if(!g_pMap->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface()))MessageBox(NULL, "FAILD : Map Object", "TRYOVER MESSAGE", MB_OK);

	//g_pDirectDraw->ClearBack();

	g_pMap->LoadMap();
	g_pMap->SetFileName("MapData1.dat");
	g_pMap->FileLoadMap();

	g_bActive = TRUE;
	g_MapX =0;
	g_MapY =0;
	g_OverScreenResult=4;

	/////////////////////////////////////////////
	g_pBlock = new CBlock();
	if(! g_pBlock->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface()))MessageBox(NULL, "FAILD : Block Object", "TRYOVER MESSAGE", MB_OK);;
	
	g_pBlock->FileLoadBlock();

	/////////////////////////////////////////////
	g_pCharacter = new CCharacter();
	if(!g_pCharacter->Init(g_pDirectDraw->GetDirectDraw(), g_pDirectDraw->GetBackSurface(),hInstance, hWnd ))MessageBox(NULL, "FAILD : Character Object", "TRYOVER MESSAGE", MB_OK);

	g_pCharacter->LoadCharacter();
	g_pCharacter->SetPos(380,300);
}

void Loop()
{	
	switch ( g_OverScreenResult)
	{
		case 0:	// LEFT
			
			g_MapX = g_MapX- 8;
			if( g_MapX < 0) g_MapX=0;
			break;

		case 1:	// RIGHT
			
			g_MapX = g_MapX + 8;
			if( g_MapX > 3072) g_MapX = 3072;
			break;

		case 2:	// UP
			
			g_MapY = g_MapY - 8;
			if( g_MapY < 0) g_MapY=0;
			break;

		case 3:	// DOWN
			
			g_MapY = g_MapY + 8;
	
			if (g_MapY > 2304) g_MapY= 2304;
			break;

	}
	
	g_pMap->BltMap(g_MapX, g_MapY);

	g_OverScreenResult = 4;

	g_pBlock->GetCurrentMap(g_MapX, g_MapY);

//	g_pBlock->BltBlock(g_MapX, g_MapY);

//	char Text[50];
//	sprintf(Text,"%d %d",g_pBlock->m_DataX,g_pBlock->m_DataY);
//	g_pDirectDraw->PutString(100,100,Text,50);

	g_blockF=g_pCharacter->GetBlockDataF(g_MapX, g_MapY, g_pBlock->m_pBlockData);
	g_blockB=g_pCharacter->GetBlockDataB(g_MapX, g_MapY, g_pBlock->m_pBlockData);
		
	g_OverScreenResult = g_pCharacter->PollDevice(g_blockF,g_blockB );
	


	
	g_pCharacter->PutMapPos(g_MapX, g_MapY);
	g_pCharacter->Pattern_Move_Normal(g_pCharacter->GetDirection(),g_pCharacter->GetActiveState());

	g_pDirectDraw->BltBack();
}


void InKeyLoop(int nVirtKey, LPARAM lKeyData)
{
	if( nVirtKey == VK_ESCAPE)
	{
		g_pBlock->ExitInit();
		delete g_pBlock;

		g_pMap->ExitInit();
		delete g_pMap;

		g_pDirectDraw->ExitInit();
		delete g_pDirectDraw;

		PostQuitMessage(0);
	}
}

int WINAPI WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	WNDCLASS wc;

	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	wc.hIcon = LoadIcon ( hInstance, "IDI_ICON1");
	wc.hInstance = hInstance;
	wc.lpfnWndProc = WndProc;
	wc.lpszClassName = NAME;
	wc.lpszMenuName = NULL;
	wc.style = CS_VREDRAW|CS_HREDRAW;

	RegisterClass(&wc);

	HWND hWnd = CreateWindowEx(
		WS_EX_APPWINDOW,
		NAME,
		NAME,
		WS_POPUP,
		0,
		0,
		800,
		600,
		NULL,
		NULL,
		hInstance,
		NULL);

	Init(hInstance, hWnd);

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow ( hWnd);

	SetFocus(hWnd);

	MSG msg;

	while(1)
	{
		if( PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0))
				return msg.wParam;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else if( g_bActive)
		{
			Loop();
		}
		else
			WaitMessage();
	}

	return TRUE;
}

LRESULT CALLBACK WndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_KEYDOWN:
			InKeyLoop((int)wParam, lParam);
//			g_OverScreenResult = g_pBlock->InKey((int)wParam,lParam);
			g_OverScreenResult = g_pCharacter->InKey( (int) wParam, lParam);
			break;

		case WM_KEYUP:
			g_pCharacter->OutKey((int) wParam,lParam);
			break;

	}

	return DefWindowProc(hWnd, msg, wParam, lParam);
}

