unit ChrEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, Main;

type
  Tchreditform = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    label3: TLabel;
    label4: TLabel;
    label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Label12: TLabel;
    chrname: TEdit;
    chrfname: TEdit;
    chrsex: TComboBox;
    chrjob: TComboBox;
    chrrace: TComboBox;
    chrstr: TComboBox;
    chrint: TComboBox;
    chrwis: TComboBox;
    chrchr: TComboBox;
    chrhlt: TComboBox;
    chrmtype: TComboBox;
    chralign: TComboBox;
    Button1: TButton;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Open1: TMenuItem;
    SaveFile1: TMenuItem;
    SaveFileAs1: TMenuItem;
    N4: TMenuItem;
    Exit1: TMenuItem;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    chrwp1: TComboBox;
    chrwp2: TComboBox;
    chrhelmet: TComboBox;
    chrarmor: TComboBox;
    Label19: TLabel;
    chronadven: TComboBox;
    chrdex: TComboBox;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Edit1: TEdit;
    Label14: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure chrnameChange(Sender: TObject);
    procedure chrsexChange(Sender: TObject);
    procedure chrfnameChange(Sender: TObject);
    procedure chralignChange(Sender: TObject);
    procedure chrjobChange(Sender: TObject);
    procedure chrraceChange(Sender: TObject);
    procedure chrstrChange(Sender: TObject);
    procedure chrintChange(Sender: TObject);
    procedure chrwisChange(Sender: TObject);
    procedure chrdexChange(Sender: TObject);
    procedure chrchrChange(Sender: TObject);
    procedure chrhltChange(Sender: TObject);
    procedure chrmtypeChange(Sender: TObject);
    procedure chronadvenChange(Sender: TObject);
    procedure chrwp1Change(Sender: TObject);
    procedure chrwp2Change(Sender: TObject);
    procedure chrarmorChange(Sender: TObject);
    procedure chrhelmetChange(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure dongi;
    procedure SaveFile1Click(Sender: TObject);
    procedure SaveFileAs1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  function rightstr(strs: string; num: integer): string;
  procedure dongi;




var
  chreditform: Tchreditform;
  filename: string;
  adven: TAdven;

implementation

{$R *.DFM}
procedure Tchreditform.dongi;
var
tempint: integer;
begin
chrname.text := adven.name;
chrfname.text := adven.fname;
chrsex.ItemIndex := adven.sex - 1;
chralign.itemindex := adven.align - 1;
chrjob.itemindex := adven.job - 1;
chrrace.itemindex := adven.race - 1;
chrstr.itemindex := adven.prop[1] - 1;
chrint.itemindex := adven.prop[2] - 1;
chrwis.itemindex := adven.prop[3] - 1;
chrdex.itemindex := adven.prop[4] - 1;
chrchr.itemindex := adven.prop[5] - 1;
chrhlt.itemindex := adven.prop[6] - 1;
chrmtype.itemindex := adven.mtype;
if adven.onadv = true then chronadven.ItemIndex := 1 else chronadven.itemindex := 0;
tempint := adven.wp1 div 10;
if tempint = 0 then chrwp1.itemindex:= 0;
if tempint = 11 then chrwp1.itemindex := 1;
if tempint = 12 then chrwp1.itemindex := 2;
if tempint = 13 then chrwp1.itemindex := 3;
if tempint = 14 then chrwp1.itemindex := 4;
if tempint = 21 then chrwp1.itemindex := 5;
if tempint = 22 then chrwp1.itemindex := 6;
if tempint = 23 then chrwp1.itemindex := 7;
if tempint = 24 then chrwp1.itemindex := 8;
if tempint = 31 then chrwp1.itemindex := 9;
if tempint = 32 then chrwp1.itemindex := 10;
if tempint = 33 then chrwp1.itemindex := 11;
if tempint = 41 then chrwp1.itemindex := 12;
if tempint = 42 then chrwp1.itemindex := 13;
if tempint = 51 then chrwp1.itemindex := 14;
if tempint = 52 then chrwp1.itemindex := 15;
tempint := adven.wp2 div 10;
if tempint = 0 then chrwp2.itemindex:= 0;
if tempint = 11 then chrwp2.itemindex := 1;
if tempint = 12 then chrwp2.itemindex := 2;
if tempint = 13 then chrwp2.itemindex := 3;
if tempint = 14 then chrwp2.itemindex := 4;
if tempint = 21 then chrwp2.itemindex := 5;
if tempint = 22 then chrwp2.itemindex := 6;
if tempint = 23 then chrwp2.itemindex := 7;
if tempint = 24 then chrwp2.itemindex := 8;
if tempint = 31 then chrwp2.itemindex := 9;
if tempint = 32 then chrwp2.itemindex := 10;
if tempint = 33 then chrwp2.itemindex := 11;
if tempint = 41 then chrwp2.itemindex := 12;
if tempint = 42 then chrwp2.itemindex := 13;
if tempint = 51 then chrwp2.itemindex := 14;
if tempint = 52 then chrwp2.itemindex := 15;
tempint := adven.armor div 10;
chrarmor.itemindex := tempint - 1;
tempint := adven.helmet div 10;
chrhelmet.itemindex := tempint;
edit1.text := inttostr(adven.age);
end;
procedure dongi;
var
tempobj: TObject;
begin
tempobj := TObject.Create;
chreditform.chrname.OnChange(tempObj);
chreditform.chrfname.OnChange(tempobj);
chreditform.chrsex.OnChange(tempobj);
chreditform.chrjob.OnChange(tempobj);
chreditform.chrrace.OnChange(tempobj);
chreditform.chralign.OnChange(tempobj);
chreditform.chrstr.OnChange(tempobj);
chreditform.chrint.OnChange(tempobj);
chreditform.chrwis.OnChange(tempobj);
chreditform.chrdex.OnChange(tempobj);
chreditform.chrchr.OnChange(tempobj);
chreditform.chrhlt.OnChange(tempobj);
chreditform.chrwp1.OnChange(tempobj);
chreditform.chrwp2.OnChange(tempobj);
chreditform.chrarmor.OnChange(tempobj);
chreditform.chrhelmet.OnChange(tempobj);
chreditform.chronadven.OnChange(tempobj);
chreditform.chrmtype.OnChange(tempobj);
chreditform.edit1.onChange(tempobj);


end;

function rightstr(strs: string; num: integer): string;
begin
if Length(strs) < num then rightstr := strs;
rightstr := Copy(strs, Length(strs) - num + 1, num);
end;
procedure Tchreditform.Button1Click(Sender: TObject);
begin
{label14.caption := inttostr(Adven.sex);}
adven.make;
chreditform.dongi;
{dongi;
adven.savefile('data\silhum.txt');}
end;

procedure Tchreditform.FormActivate(Sender: TObject);
begin
filename := '';
adven := TAdven.create;

end;

procedure Tchreditform.chrnameChange(Sender: TObject);
begin
Adven.name := chrname.Text;
end;

procedure Tchreditform.chrsexChange(Sender: TObject);
begin
Adven.sex := strtoint(rightstr(chrsex.text , 1));
end;

procedure Tchreditform.chrfnameChange(Sender: TObject);
begin
Adven.fname := chrfname.Text;
end;

procedure Tchreditform.chralignChange(Sender: TObject);
begin
adven.align := strtoint(rightstr(chralign.text, 1));
end;

procedure Tchreditform.chrjobChange(Sender: TObject);
begin
adven.job := strtoint(rightstr(chrjob.text, 1));
end;

procedure Tchreditform.chrraceChange(Sender: TObject);
begin
adven.race := strtoint(rightstr(chrrace.text, 1));
end;

procedure Tchreditform.chrstrChange(Sender: TObject);
begin
adven.prop[1] := strtoint(rightstr(chrstr.text, 1));
end;

procedure Tchreditform.chrintChange(Sender: TObject);
begin
adven.prop[2] := strtoint(rightstr(chrint.text, 1));
end;

procedure Tchreditform.chrwisChange(Sender: TObject);
begin
adven.prop[3] := strtoint(rightstr(chrwis.text, 1));
end;

procedure Tchreditform.chrdexChange(Sender: TObject);
begin
adven.prop[4] := strtoint(rightstr(chrdex.text, 1));
end;

procedure Tchreditform.chrchrChange(Sender: TObject);
begin
adven.prop[5] := strtoint(rightstr(chrchr.text, 1));
end;

procedure Tchreditform.chrhltChange(Sender: TObject);
begin
adven.prop[6] := strtoint(rightstr(chrhlt.text, 1));
end;

procedure Tchreditform.chrmtypeChange(Sender: TObject);
begin
adven.mtype := strtoint(rightstr(chrmtype.text, 1));
end;

procedure Tchreditform.chronadvenChange(Sender: TObject);
begin
if strtoint(rightstr(chrmtype.text, 1)) = 0 then adven.onadv := false else adven.onadv := true;
end;

procedure Tchreditform.chrwp1Change(Sender: TObject);
begin
adven.wp1 := strtoint(rightstr(chrwp1.text, 3));
end;

procedure Tchreditform.chrwp2Change(Sender: TObject);
begin
adven.wp2 := strtoint(rightstr(chrwp2.text, 3));
end;

procedure Tchreditform.chrarmorChange(Sender: TObject);
begin
adven.armor := strtoint(rightstr(chrarmor.text, 2));
end;

procedure Tchreditform.chrhelmetChange(Sender: TObject);
begin
adven.helmet := strtoint(rightstr(chrhelmet.text, 1));
end;

procedure Tchreditform.Open1Click(Sender: TObject);
var
tempbool: boolean;
tempint: integer;
begin
tempbool := OpenDialog1.Execute;
filename := OpenDialog1.fileName;
while tempbool do begin
adven.loadfile(filename);
chreditform.dongi;
break;
end;
end;

procedure Tchreditform.SaveFile1Click(Sender: TObject);
begin
if filename = '' then chreditform.SaveFileAs1Click(Sender);
end;

procedure Tchreditform.SaveFileAs1Click(Sender: TObject);
var
tempbool: boolean;
begin
tempbool := SaveDialog1.Execute;
filename := SaveDialog1.fileName;
while tempbool do begin
adven.savefile(filename);
chreditform.dongi;
break;
end;
end;

procedure Tchreditform.Exit1Click(Sender: TObject);
begin
halt;
end;

procedure Tchreditform.Edit1Change(Sender: TObject);
begin
if edit1.text <> '' then Adven.age := strtoint(edit1.Text);
end;

end.
