unit EventEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Spin;

type
  TEEditorForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    N1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    EventSpin: TSpinEdit;
    Addbtn: TButton;
    RemoveButton: TButton;
    GroupBox1: TGroupBox;
    Optlist: TListBox;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddbtnClick(Sender: TObject);
    procedure EventSpinChange(Sender: TObject);
    procedure OptlistEnter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  procedure loadevent(objfile: string);
  procedure loadopt(Index: integer);
  function skiptext(toskip: string; var F: textfile): string;


var
  EEditorForm: TEEditorForm;
  {̺Ʈ }
  eventnum: integer;
  filename: string;

implementation

{$R *.DFM}

function skiptext(toskip: string; var F: textfile): string;
var
tempstr: string;
begin
While tempstr <> toskip do begin
readln(F, tempstr);
end;
skiptext := tempstr;
end;

procedure loadopt(Index: integer);
var
tempstr: string;
F: textfile;
i: integer;
begin
assignfile(F, filename);
reset(F);
for i:=1 to Index do begin
tempstr := skiptext('[start]', F);
end;
tempstr := skiptext('-opt-', F);
While tempstr <> '-event-' do begin
if tempstr = ':obvious' then EEditorform.optlist.items.add(' ');
if tempstr = ':money' then EEditorform.optlist.items.add('');
readln(F, tempstr);
end;
closefile(F);
;
end;
procedure loadevent(objFile: string);
var
F: textfile;
tempstr: string;
begin
assignfile(F, objfile);
reset(F);
eventnum := 0;
While not EOF(f) do begin
if tempstr = '[start]' then eventnum := eventnum + 1;
readln(F, tempstr);
end;



if eventnum <> 1 then EEditorForm.EventSpin.MaxValue := eventnum else EEditorForm.EventSpin.enabled := false;
{
While tempstr <> '-opt-' do begin
readln(F, tempstr);
end;
While tempstr <> '-event-' do begin
if tempstr = ':obvious' then EEditorform.optlist.items.add('obvious');
if tempstr = ':money' then EEditorform.optlist.items.add('money');
readln(F, tempstr);
end;}
closefile(F);
;
end;

procedure TEEditorForm.Exit1Click(Sender: TObject);
begin
halt;
end;

procedure TEEditorForm.Open1Click(Sender: TObject);
var
tempbool: boolean;
begin
tempbool := OpenDialog1.Execute;
if tempbool = true then begin
optlist.Items.Clear;
filename := opendialog1.filename;
loadevent(OpenDialog1.filename);
if eventnum > 1 then EventSpin.enabled := true else EventSpin.enabled := false;
loadopt(EventSpin.Value);
end;
end;

procedure TEEditorForm.FormActivate(Sender: TObject);
begin
Eventnum := 0;

end;

procedure TEEditorForm.AddbtnClick(Sender: TObject);
begin
if eventnum > 1 then begin
EventSpin.Enabled := true;
EventSpin.MaxValue := eventnum;
end;
end;

procedure TEEditorForm.EventSpinChange(Sender: TObject);
begin
OptList.Items.clear;
loadopt(EventSpin.Value);
end;

procedure TEEditorForm.OptlistEnter(Sender: TObject);
begin
MessageDlg('߳?', mtInformation,
      [mbOk], 0);
end;

end.
