unit doadvunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin;

type
  Tdoadvform = class(TForm)
    namelabel: TLabel;
    typecombo: TComboBox;
    datacombo: TComboBox;
    startbtn: TButton;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    procedure typecomboChange(Sender: TObject);
    procedure startbtnClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  procedure data_dongi;
  procedure load_search_data;
  procedure load_war_data;
  procedure load_dungeon_data;
  procedure load_quest_data;

var
  doadvform: Tdoadvform;
  partynum: integer;
  herecity: integer;
  dataindex: array[1..100] of integer;

implementation
uses Main;
{$R *.DFM}


procedure data_dongi;
begin
doadvform.namelabel.caption := 'Ƽ: ' + Main.party[1, partynum].name;
doadvform.typecombo.itemindex := -1;
doadvform.datacombo.itemindex := -1;
end;

procedure Tdoadvform.typecomboChange(Sender: TObject);
begin
if typecombo.ItemIndex <> -1 then
        begin
        case typecombo.itemindex of
                0: begin
                   load_quest_data;
                   label1.caption := '';
                   spinedit1.enabled := false;
                   end;
                1: begin
                   load_search_data;
                   label1.caption := '';
                   spinedit1.enabled := true;
                   end;
                2: begin
                   load_war_data;
                   label1.caption := '';
                   spinedit1.enabled := false;
                   end;
                3: begin
                   load_dungeon_data;
                   label1.caption := '';
                   spinedit1.Enabled := true;
                   end;
                end;
        end;
end;

procedure load_search_data;
var
i: integer;
begin
doadvform.datacombo.items.clear;
for i := 1 to 100 do
        begin
        if (Main.search[herecity, i, 1] <> 'None') and (Main.search[herecity, i, 2] <> 'None') and (Main.searchb[herecity, i] = true) then
                begin
                doadvform.datacombo.Items.add(Main.search[herecity, i, 1]);
                dataindex[doadvform.datacombo.items.Count] := i;
                end;
        end;
end;

procedure load_war_data;
var
i: integer;
begin
doadvform.datacombo.items.clear;
for i := 1 to 100 do
        begin
        if (Main.war[i, 1] <> 'None') and (Main.war[i, 2] <> 'None') and (Main.warb[i] = true) then
                begin
                doadvform.datacombo.Items.add(Main.war[i, 1]);
                dataindex[doadvform.datacombo.items.Count] := i;
                end;
        end;
end;

procedure load_quest_data;
var
i: integer;
begin
doadvform.datacombo.items.clear;
for i := 1 to 100 do
        begin
        if (Main.quest[i, 1] <> 'None') and (Main.quest[i, 2] <> 'None') and (Main.questb[i] = true) then
                begin
                doadvform.datacombo.Items.add(Main.quest[i, 1]);
                dataindex[doadvform.datacombo.items.Count] := i;
                end;
        end;
end;



procedure Tdoadvform.startbtnClick(Sender: TObject);
begin
if (typecombo.ItemIndex <> -1) and (datacombo.ItemIndex <> -1) then
        begin
        case typecombo.itemindex of
                0: Main.party[1, partynum].quest(dataindex[datacombo.itemindex + 1]);
                1: Main.party[1, partynum].search(Main.search[herecity, dataindex[datacombo.itemindex + 1], 2], doadvform.spinedit1.value);
                2: Main.party[1, partynum].war(Main.war[dataindex[datacombo.itemindex + 1], 2]);
                3: Main.party[1, partynum].dungeon(Main.dungeon[herecity, dataindex[datacombo.itemindex + 1], 2], doadvform.SpinEdit1.Value, herecity, dataindex[datacombo.itemindex + 1]);
                end;
        end;
close;
end;

procedure Tdoadvform.Button2Click(Sender: TObject);
begin
{messagedlg('spinedits value: '+inttostr(spinedit1.value), mtInformation, [mbOk], 0);}
close;
end;

procedure load_dungeon_data;
var
i: integer;
begin
doadvform.datacombo.items.clear;
for i := 1 to 100 do
        begin
        if (Main.dungeon[herecity, i, 1] <> 'None') and (Main.dungeon[herecity, i, 2] <> 'None') and (Main.dungeonb[herecity, i] = true) then
                begin
                doadvform.datacombo.Items.add(Main.dungeon[herecity, i, 1]);
                dataindex[doadvform.datacombo.items.Count] := i;
                end;
        end;
end;

end.
