unit movecityunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  Tmovecityform = class(TForm)
    destcombo: TComboBox;
    waycombo: TComboBox;
    costlabel: TLabel;
    timelabel: TLabel;
    cancelbtn: TButton;
    okbtn: TButton;
    procedure destcomboChange(Sender: TObject);
    procedure waycomboChange(Sender: TObject);
    procedure okbtnClick(Sender: TObject);
    procedure cancelbtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  TWay = class(TObject)
        {index: integer;}
        esta: boolean;
        wayname: string;
        timecost: integer;
        goldcost: integer;
        eventfile: string;
        dest: integer;
        danger: integer;
        constructor Create;
  end;
  procedure move_dongi;
  procedure move_load;
  procedure way_dongi(tocity: integer);

var
  movecityform: Tmovecityform;
  herecity: integer;
  waydata: array[1..100] of TWay;
  wayindex: array[1..100] of integer;
  { }
  waynum: integer;
  destcity: array[1..100] of integer;
  destdata: array[1..100] of integer;
  targetparty: integer;


implementation
Uses Main;
{$R *.DFM}

constructor TWay.create;
begin
{index := 0;}
timecost := 0;
goldcost := 0;
eventfile := '';
dest := 0;
danger := 0;
esta := false;
end;

procedure move_dongi;
var
i: integer;
begin
movecityform.destcombo.Items.clear;
for i := 1 to 100 do
        begin
        if destcity[i] <> 0 then
                begin
                movecityform.destcombo.Items.add(Main.cities[destcity[i]]);
                destdata[movecityform.destcombo.items.Count] := i;
                {destcity[movecityform.destcombo.items.Count] := i;}
                end;
        end;

;
end;


procedure move_load;
var
F: textfile;
tempstr: string;
tempint, indexint: integer;
i: integer;
begin
for i := 1 to 100 do
        begin
        destcity[i] := 0;
        end;

assignfile(F, 'data\' + Main.citymove[herecity]);
reset(F);
readln(F, tempstr);
i := 0;
readln(F, tempstr);
while not (tempstr = '[END]') do
        begin
        i := i + 1;
        destcity[i] := strtoint(tempstr);
        readln(F, tempstr);
        end;


readln(F, waynum);
for i := 1 to 100 do
        begin
        waydata[i] := TWay.Create;
        end;
i := 0;
{tempstr := Main.skiptext('[START]', F);}
while not EOF(F) do
begin
readln(F, tempstr);

if tempstr = '[START]' then begin
        i := i + 1;
        waydata[i].esta := true;
        readln(F, tempstr);
        waydata[i].wayname := tempstr;
        readln(F, tempint);
        waydata[i].timecost := tempint;
        readln(F, tempint);
        waydata[i].goldcost := tempint;
        readln(F, tempstr);
        waydata[i].eventfile := tempstr;
        readln(F, tempint);
        {messagedlg('dest: '+ inttostr(tempint), mtInformation, [mbOK], 0);
        messagedlg('i: '+ inttostr(i), mtInformation, [mbOK], 0);}
        waydata[i].dest := tempint;
        readln(F, tempint);
        waydata[i].danger := tempint;


end;

end;

closefile(F);
end;

procedure way_dongi(tocity: integer);
var
i: integer;
begin
movecityform.waycombo.Items.clear;
{messagedlg('tocity : '+ inttostr(tocity), mtInformation, [mbOK], 0);}
for i := 1 to 100 do
        begin

        if (waydata[i].esta = true) and (waydata[i].dest = destcity[tocity]) then
        {if (waydata[i].esta = true) and (waydata[i].dest = tocity) then}
                begin
                movecityform.waycombo.Items.Add(waydata[i].wayname);
                wayindex[movecityform.waycombo.items.Count] := i;
                end;
        end;

end;

procedure Tmovecityform.destcomboChange(Sender: TObject);
begin
if destcombo.ItemIndex <> -1 then
        begin
        way_dongi(destdata[destcombo.ItemIndex + 1]);
        {way_dongi(destcity[destcombo.ItemIndex + 1]);}
        waycombo.itemindex := -1;
        end;

end;

procedure Tmovecityform.waycomboChange(Sender: TObject);
begin
if waycombo.ItemIndex <> -1 then
        begin
        costlabel.Caption := 'ҿ ݾ(1): ' + inttostr(waydata[wayindex[waycombo.itemindex + 1]].goldcost);
        timelabel.Caption := 'ҿ ð: ' +inttostr(waydata[wayindex[waycombo.itemindex + 1]].timecost);
        end;
end;

procedure Tmovecityform.okbtnClick(Sender: TObject);
begin
if (destcombo.itemindex <> -1) and (waycombo.ItemIndex <> -1) and (Main.citynat[waydata[wayindex[waycombo.itemindex + 1]].dest] <> Main.chrnat) then
        begin
        messagedlg(' ̵ Ұմϴ.', mtInformation, [MbOK], 0);
        exit;
        end;
if (destcombo.itemindex <> -1) and (waycombo.ItemIndex <> -1) then
        begin
        if (Main.gp > (waydata[waycombo.itemindex + 1].goldcost) * (Main.party[1, targetparty].counts)) then
                begin
                Main.gp := Main.gp - (waydata[wayindex[waycombo.itemindex + 1]].goldcost) * (Main.party[1, targetparty].counts);
                {messagedlg(': '+inttostr(waydata[wayindex[waycombo.itemindex + 1]].dest), mtInformation, [MbOK], 0);}
                {messagedlg('i: '+inttostr(waycombo.itemindex + 1), mtInformation, [MbOK], 0);}
                Main.party[1, targetparty].takeonmove(waydata[wayindex[waycombo.itemindex + 1]].timecost, waydata[wayindex[waycombo.itemindex + 1]].dest);
                messagedlg('̵ '+inttostr(waydata[wayindex[waycombo.itemindex + 1]].timecost)+' ɸϴ.', mtInformation, [MbOK], 0);
                end
                else begin
                messagedlg(' ڶϴ.', mtInformation, [MbOK], 0);
                exit;
                end;
        end;
close;
end;

procedure Tmovecityform.cancelbtnClick(Sender: TObject);
begin
close;
end;

end.
