///////////////////////////////////////////////////////////////////////////////////////
//
//   ̾... -_-;;; (~)  ø === DirectX  α׷ 3
//
///////////////////////////////////////////////////////////////////////////////////////


#include <windows.h>
// #include <windowsx.h>			// ̰  ʿ?
#include <ddraw.h>
#include <stdlib.h>
#include <stdarg.h>
#include "resource.h"
#include "ddutil.h"
#include "CnRWindow.h"


#define TIMER_ID		1
#define TIMER_RATE		1000




LPDIRECTDRAW			lpDD;
LPDIRECTDRAWSURFACE		lpDDSPrimary;
LPDIRECTDRAWSURFACE		lpDDSBack;
LPDIRECTDRAWSURFACE		lpDDSOne;				// ũ 1
LPDIRECTDRAWSURFACE		lpDDSTwo;				// ũ 2
//LPDIRECTDRAWPALETTE		lpDDPal;

BOOL	bActive;
HINSTANCE g_hInst;


static char szCrazy1[] = "IDC1";				// ׸ ̸1
static char szCrazy2[] = "IDC2";				// ׸ ̸2



///////////////////////////////////////////////////////////////////////////////////////
//
//  DirectDraw  ʱȭ  ֻ ǥ Ĺ  ,
//  
//    ۿ ׸ ̹ ϴ ۾ Ѵ
//
////////////////////////////////////////////////////////////////////////////////////////
BOOL DirectDraw_Init(HWND hwnd)
{
	DDSURFACEDESC	ddsd;				// DDSURFACEDESC  
	DDSCAPS			ddscaps;			// DDSCAPS	 
	HRESULT			hr;					// ڵ...  ̰Ŵ   ֳ ã ɹۿ Ѵ

	hr = DirectDrawCreate(NULL, &lpDD, NULL);			// DirectDraw ü 
	if(hr != DD_OK)			// ̷   ˻縸...
	{
		MessageBox(hwnd, "DirectDrawCreate ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	hr = lpDD->SetCooperativeLevel(hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);		// SetCooperativeLevel 
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "lpDD->SetCooperativeLevel ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	hr = lpDD->SetDisplayMode(640, 480, 8);				// Display  
	if(hr != DD_OK)
	{	
		MessageBox(hwnd, "lpDD->SetDisplayMode ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	
	ZeroMemory(&ddsd, sizeof(ddsd));			// ޸ 
	ddsd.dwSize = sizeof(ddsd);					// DDSURFACEDESC 
	ddsd.dwBackBufferCount = 1;					//   1
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;			//  ٲ ˷ִ ÷
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
									DDSCAPS_FLIP |
									DDSCAPS_COMPLEX;			// ٲܰ͵ ˷ִ ÷

	hr = lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL);			// ǥ ... Pri 
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "lpDD->CreateSurface ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}


	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;			// ̰Ŵ ۸ Ѵٰ ˷
	
	hr = lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);		// ĸ ۸ Ѵ
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "lpDDPrimary->GetAttachedSurface ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	


	////////////////////////  ũ ÷  /////////////////////////////////////////

	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;			// ÷... -_-
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;				// off-screen.  ʰ ׳ ġ°...
	ddsd.dwHeight = 480;
	ddsd.dwWidth = 640;

	hr = lpDD->CreateSurface(&ddsd, &lpDDSOne, NULL);		// ǥ 
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "lpDD->CreateSurface ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	hr = lpDD->CreateSurface(&ddsd, &lpDDSTwo, NULL);		//  ǥ 
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "lpDD->CreateSurface ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

/*	
	lpDDPal = DDLoadPalette(lpDD, szCrazy1);				// ȷƮ εѴ.(ddutil.cpp, ddutil.h)
	if(!lpDDPal)
	{
		MessageBox(hwnd, "ȷƮ ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	hr = lpDDSPrimary->SetPalette(lpDDPal);						// ȷƮ 
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "ȷƮ ÿ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

*/
	hr = DDReLoadBitmap(lpDDSOne, szCrazy1);				// ̸ ǵ Լ
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "DDReLoadBitmap ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	hr = DDReLoadBitmap(lpDDSTwo, szCrazy2);				// ̸ ǵ Լ
	if(hr != DD_OK)
	{
		MessageBox(hwnd, "DDReLoadBitmap ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	if(!SetTimer(hwnd, TIMER_ID, TIMER_RATE, NULL))
	{
		MessageBox(hwnd, "SetTimer ", "̷Ʈ ο ", MB_ICONERROR);
		return FALSE;
	}

	return TRUE;
}






/////////////////////////////////////////////////////////////////////////////////////////
//
//  DirectDraw_End
//   ü Ѵ
//
/////////////////////////////////////////////////////////////////////////////////////////
void DirectDraw_End()
{
	if(lpDD != NULL)
	{
		if(lpDDSPrimary != NULL)
		{
			lpDDSPrimary->Release();
			lpDDSPrimary = NULL;
		}
		if(lpDDSOne != NULL)
		{
			lpDDSOne->Release();
			lpDDSOne = NULL;
		}		
		if(lpDDSTwo != NULL)
		{
			lpDDSTwo->Release();
			lpDDSTwo = NULL;
		}
/*		if(lpDDPal != NULL)
		{
			lpDDPal->Release();
			lpDDPal = NULL;
		}

*/	
		lpDD->Release();
		lpDD = NULL;
	}
	return;
}



/////////////////////////////////////////////////////////////////////////////////////////
//
//  DirectDraw_Restore
//    Ҿ ̹ ٽ  ش
//
/////////////////////////////////////////////////////////////////////////////////////////
HRESULT DirectDraw_Restore()
{
	HRESULT hr;

	hr = lpDDSPrimary->Restore();
	if(hr == DD_OK)
	{
		hr = lpDDSOne->Restore();
		if(hr == DD_OK)
		{
			hr = lpDDSTwo->Restore();
			if(hr == DD_OK)
			{
				hr = DDReLoadBitmap(lpDDSOne, szCrazy1);
				hr = DDReLoadBitmap(lpDDSOne, szCrazy2);
			}
		}
	}

	return hr;
}






		

/////////////////////////////////////////////////////////////////////////////////////////
//
//  WndProc
//
/////////////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static int phase = 0;
	RECT rect;

	switch(msg)
	{
	case WM_ACTIVATEAPP:
		bActive = wParam;
		return 0;

	case WM_TIMER:
		if(bActive)
		{
			MessageBeep(NULL);	
			while(TRUE)
			{
				HRESULT hr;
				LPDIRECTDRAWSURFACE lpTempSurface;
				SetRect(&rect, 0, 0, 640, 480);

				if(phase)
				{
					lpTempSurface = lpDDSTwo;
					phase = 0;
				}
				else
				{
					lpTempSurface = lpDDSOne;
					phase = 1;
				}	

				while(TRUE)
				{
					hr = lpDDSPrimary->BltFast(0, 0, lpTempSurface, &rect, DDBLTFAST_NOCOLORKEY);
					if(hr == DD_OK)				return 0;
					if(hr == DDERR_SURFACELOST)
					{
						hr = DirectDraw_Restore();
						if(hr != DD_OK)					return 0;
					}

					if(hr != DDERR_WASSTILLDRAWING)				return 0;
				}

				hr = lpDDSPrimary->Flip(NULL, 0);
				if(hr == DD_OK)		return 0;

				if(hr == DDERR_SURFACELOST)
				{
					hr = DirectDraw_Restore();
					if(hr != DD_OK)					return 0;
				}
			}
			return 0;
		}


	case WM_SETCURSOR:
		SetCursor(NULL);
		return TRUE;


	case WM_KEYDOWN:
		switch(wParam)
		{
		case VK_ESCAPE:
			SendMessage(hwnd, WM_DESTROY, NULL, NULL);
			DestroyWindow(hwnd);
			return 0;
		}
		return 0;


	case WM_DESTROY:
		DirectDraw_End();
		PostQuitMessage(0);
		return 0;
	}

	return DefWindowProc(hwnd, msg, wParam, lParam);
}



/////////////////////////////////////////////////////////////////////////////////////////////
//
//  WinMain
//
/////////////////////////////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR szCmdShow, int nCmdShow)
{
	HWND hwnd;
	MSG msg;

	hwnd = CreateNRegisterWin(hInstance, nCmdShow, WndProc);

	// ̷Ʈ ο ü 

	
	if(!DirectDraw_Init(hwnd))			
	{
		DirectDraw_End();
		DestroyWindow(hwnd);
		return NULL;
	}


	msg.wParam = 0;

	if(hwnd)
		while(TRUE)
			if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}

	return msg.wParam;
}
