#include <mtalloc.h>
#include <stdio.h>

#define ID_CODE_1 'M'
#define ID_CODE_2 't'
#define ID_CODE_3 'A'

#define FREE_BLOCK 0
#define ALLOCATED_BLOCK 1

#define ACB_SIZE 8
struct _ACB {
  char IDcode[3];
  char Status;
  unsigned size;
};

typedef unsigned char byte;

static byte *AllocBuffer=NULL;
static unsigned AllocBuffersize=0;

static unsigned modify_size(unsigned size)
{
  if (size%ACB_SIZE!=0) size+=ACB_SIZE;
  return ACB_SIZE*(size/ACB_SIZE);
}

static void make_acb(struct _ACB *ACB)
{
  ACB->IDcode[0]=ID_CODE_1;
  ACB->IDcode[1]=ID_CODE_2;
  ACB->IDcode[2]=ID_CODE_3;
}

static char askif_correct_acb(struct _ACB *ACB)
{
  byte *p=(byte *)ACB;

  return (p[0]==ID_CODE_1 && p[1]==ID_CODE_2 && p[2]==ID_CODE_3);
}

static struct _ACB *find_bestfit_block(unsigned size)
{
  struct _ACB *pBlock;
  struct _ACB *BestFitBlock=NULL;
  unsigned Differencesize=AllocBuffersize;
  unsigned Offset=0;

  do {
    (byte *)pBlock=AllocBuffer+Offset;
    if (pBlock->Status==FREE_BLOCK && pBlock->size>=size)
      if ((pBlock->size-size)<=Differencesize) {
        Differencesize=pBlock->size-size;
        BestFitBlock=pBlock;
      }

    Offset+=pBlock->size+ACB_SIZE;
  } while (Offset<AllocBuffersize);

  return BestFitBlock;
}

static void rearrange_free_block()
{
  struct _ACB *RearrangeBlock,*FollowingBlock;
  unsigned RearrangeOffset,FollowingOffset;

  RearrangeOffset=0;
  do {
    RearrangeBlock=(struct _ACB *)(AllocBuffer+RearrangeOffset);
    if (RearrangeBlock->Status==FREE_BLOCK) {
      FollowingOffset=RearrangeOffset+RearrangeBlock->size+ACB_SIZE;
      (byte *)FollowingBlock=AllocBuffer+FollowingOffset;
      while (FollowingOffset<AllocBuffersize && FollowingBlock->Status==FREE_BLOCK) {
        FollowingOffset+=FollowingBlock->size+ACB_SIZE;
        RearrangeBlock->size+=FollowingBlock->size+ACB_SIZE;
        (byte *)FollowingBlock=AllocBuffer+FollowingOffset;
      }
    }
    RearrangeOffset+=RearrangeBlock->size+ACB_SIZE;
  } while (RearrangeOffset<AllocBuffersize);
}


void init_mtalloc(void *Buffer,unsigned size)
{
  struct _ACB *InitBlock;

  AllocBuffer=Buffer; AllocBuffersize=size;

  InitBlock=(struct _ACB *)AllocBuffer;
  make_acb(InitBlock);
  InitBlock->Status=FREE_BLOCK;
  InitBlock->size=size-ACB_SIZE;
}

void *mt_malloc(unsigned size)
{
  struct _ACB *AllocatedBlock;

  if (size==0) return NULL;
  size=modify_size(size);

  AllocatedBlock=find_bestfit_block(size);
  if (AllocatedBlock==NULL) return NULL;
  else {
    AllocatedBlock->Status=ALLOCATED_BLOCK;
    if (AllocatedBlock->size>size) {
      struct _ACB *NewFreeBlock;
      
      (byte *)NewFreeBlock=(byte *)AllocatedBlock+size+ACB_SIZE;
      make_acb(NewFreeBlock);
      NewFreeBlock->Status=FREE_BLOCK;
      NewFreeBlock->size=(AllocatedBlock->size-size-ACB_SIZE);

      AllocatedBlock->size=size;
    }

    return (byte *)AllocatedBlock+ACB_SIZE;
  }
}

void *mt_calloc(unsigned size,unsigned char FillerByte)
{
  unsigned size4=modify_size(size)/4;
  void *p=mt_malloc(size);

  if (p==NULL) return NULL;
  else {
    asm {
      push EDI
      mov AX,DS
      mov ES,AX
      mov AL,FillerByte
      mov AH,AL
      shl EAX,16
      mov AL,FillerByte
      mov AH,AL
      mov EDI,p
      mov ECX,size4
      cld
      rep stosd
      pop EDI
    }
    return p;
  }
}

void *mt_realloc(void *OldBuffer,unsigned NewSize)
{
  struct _ACB *FollowingBlock,*BlockCurrent=(struct _ACB *)((byte *)OldBuffer-ACB_SIZE);
  unsigned OldSize;
  NewSize=modify_size(NewSize);

  if (NewSize==0) {
    mt_free(OldBuffer);
    return NULL;
  }
  else
  if (OldBuffer==NULL || askif_correct_acb(BlockCurrent)==0 || BlockCurrent->Status!=ALLOCATED_BLOCK) {
    return mt_malloc(NewSize);
  }

  OldSize=BlockCurrent->size;
  if (NewSize==OldSize) return OldBuffer;
  else
  if (NewSize<OldSize) { // reduced
    BlockCurrent->size=NewSize;
    (byte *)FollowingBlock=(byte *)BlockCurrent+NewSize+ACB_SIZE;
    make_acb(FollowingBlock); 
    FollowingBlock->Status=FREE_BLOCK;
    FollowingBlock->size=OldSize-NewSize-ACB_SIZE;
    rearrange_free_block();

    return OldBuffer;
  }
  else { // increased
    char isNewlyAllocated=0;

    FollowingBlock=(struct _ACB *)((byte *)BlockCurrent+BlockCurrent->size+ACB_SIZE);
    if (askif_correct_acb(FollowingBlock)==0 || 
        FollowingBlock->Status!=FREE_BLOCK) isNewlyAllocated=1;
    else
    if ((ACB_SIZE+FollowingBlock->size)<(NewSize-OldSize)) isNewlyAllocated=1;

    if (isNewlyAllocated==1) {
      void *NewBuffer=mt_malloc(NewSize);
      if (NewBuffer==NULL) { free(OldBuffer); return NULL; }
      else {
        asm {
          push ESI
          push EDI
          mov AX,DS
          mov ES,AX
          mov ESI,OldBuffer
          mov EDI,NewBuffer
          mov ECX,OldSize
          shr ECX,2
          rep movsd
          pop EDI
          pop ESI
        }
        mt_free(OldBuffer);
        return NewBuffer;
      }
    }
    else { // modify the following free block
      struct _ACB *NewFreeBlock;

      BlockCurrent->size=NewSize;
      if ((NewSize-OldSize)<FollowingBlock->size+ACB_SIZE) {
        (byte *)NewFreeBlock=(byte *)BlockCurrent+BlockCurrent->size+ACB_SIZE;
        make_acb(NewFreeBlock);
        NewFreeBlock->Status=FREE_BLOCK;
        NewFreeBlock->size=FollowingBlock->size-(NewSize-OldSize);
      }

      return OldBuffer;
    }
  } // increased.
}

void mt_free(void *FreedBuffer)
{
  struct _ACB *FreedBlock;
  if (FreedBuffer==NULL) return;

  (byte *)FreedBlock=((byte *)FreedBuffer-ACB_SIZE);
  if (askif_correct_acb(FreedBlock)==1 && FreedBlock->Status==ALLOCATED_BLOCK) {
    FreedBlock->Status=FREE_BLOCK;
    rearrange_free_block();
  }
}

unsigned mt_coreleft()
{
  struct _ACB *pBlock;
  byte *p;
  unsigned Offset=0,Largestsize=0;

  do {
    (byte *)pBlock=(AllocBuffer+Offset);
    if (pBlock->Status==FREE_BLOCK && Largestsize<pBlock->size) Largestsize=pBlock->size;
    Offset+=pBlock->size+ACB_SIZE;
  } while (Offset<AllocBuffersize);

  return Largestsize;
}
