#include "stdafx.h"
#include "stdlib.h"
#include "modelobj.h"

//to avoid global variables..
//we used static members..
//status variable


////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
//   RGB COLOR                                                                    //
// min: 0.0 , max: 1.0
//////////////////////////////////////////////////////////////////////////////////// 
CRGBColor::CRGBColor(void) {
	r=g=b=0;
}

CRGBColor::~CRGBColor(void) {
}

CRGBColor::CRGBColor(int R, int G, int B) {
		r=R, g=G, b=B;
}

////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
// MATERIAL                                                                       
//                                                                                //
//////////////////////////////////////////////////////////////////////////////////// 
CMtl::CMtl(const char * NAME) {
		strcpy(name,NAME);
}	
CMtl::CMtl(void) {
	
}

void CMtl::Set(void)
{
	if (glIsEnabled(GL_COLOR_MATERIAL)) {
		glColor3fv(m_fvDiffuse);
	}
	else {
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, m_fvAmbient);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, m_fvDiffuse);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, m_fvSpecular);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, m_fShine*128.0f);
	}

	//glColor4d(GV_fvDiffuse[0], GV_fvDiffuse[1], GV_fvDiffuse[2], 0.5);
}


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           
//                   NORMAL for smoothing 
// a vertex has normal vector per smoothing group                                                                         
//                                                                                           
//////////////////////////////////////////////////////////////////////////////////////////////
CNormal::CNormal(void) {
	v=VECTOR(0,0,0); //for average
}
CNormal::CNormal(int S, VECTOR N) {
	v=N;
	s=S;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           
//                   VERTEX                                                                         
//                                                                                           
//////////////////////////////////////////////////////////////////////////////////////////////
CVertex::CVertex(void) {
	v=VECTOR(0,0,0);
}

CVertex::CVertex(float X, float Y, float Z) {
	v=VECTOR(X,Y,Z);
}

//set normal
void CVertex::SetNormal(int S)
{
	//find the normal
	CNormalList::iterator ni;
	int found=false;

	//find existing normal
	VECTOR nor(0,0,0);
	int first=true;


	for (ni=n.begin(); ni!=n.end(); ni++) {
		if (1 << ni->s & S) {
			//ADD NORMAL
			if (first) {nor=ni->v;first=false;}
			else {
				nor += ni->v;
				nor /= 2.0f;
			} //end of if 

			found=true; //found the normal
		} //end of if
	} //end of for

	//if (found) ni->v.Normal();
	if (found) nor.Normal();

}

//make normal average by the smoothing group
void CVertex::AddNormal(int S, VECTOR N)
{
	//find the normal
	CNormalList::iterator ni;
	int found=false;

	//find existing normal
	for (ni=n.begin(); ni!=n.end(); ni++) {
		if (1 << ni->s & S) {
			//ADD NORMAL
			ni->v += N;
			ni->v /= 2.0f;
			found=true; //found the normal
		} //end of if
	} //end of for

	if (!found) { //not foun , add flag

		int i=0;
		for (i=0;i<32;i++) {
			if ((unsigned int) 1<<i & S)
			n.push_back(CNormal(i, N));
		}
	}
}


////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
//                     face                                                            //
//                                                                                //
//////////////////////////////////////////////////////////////////////////////////// 
CFace::CFace(void) {
	chosen=false;
	m_pObj=NULL;//parent object
	m_pMtl=NULL;// material pointer
}
CFace::~CFace(void) {
}
CFace::CFace(int A,int B, int C) {
	a=A, b=B, c=C;
	chosen=false;
	m_pObj=NULL;//parent object
	m_pMtl=NULL;// material pointer
}


////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
//                     object (face,edge,vertex)                                 
//                                                                                //
//////////////////////////////////////////////////////////////////////////////////// 
void MakeNormal(double x0, double y0, double z0, double x1, double y1, double z1)
{
        //   i    j   k
        //   +    -1  +
        //  x0    y0   z0
        //  x1    y1   z1

        double x,y,z;
        x=y0*z1 - z0*y1;
        y=-(x0*z1-z0*x1);
        z=x0*y1-y0*x1;
        glNormal3d(x,y,z);

}

//build display list
int CObj::BuildList(int List)
{
	//clear first
	if (m_nDisList!=-1) glDeleteLists(m_nDisList,1);
	glDeleteLists(List,1);//delete list in case it exist..

	//make
	glNewList(List, GL_COMPILE);
	ShowFaces();
	glEndList();
	//store display list number
	m_nDisList=List;

	return List+1;
}
CObj::CObj(const char* NAME){ strcpy(name, NAME);
	strcpy(mat,"none");
	m_pNode=NULL; //node pointer
	m_nDisList=-1; //display list
	m_bEditMode=false; //edit mode?
}

CObj::CObj(void) { 

	// bounding box
	m_vMin=VECTOR(-1,-1,-1);
	m_vMax=VECTOR(1, 1,1);

	strcpy(mat,"none");
	m_pNode=NULL; //node pointer
	m_nDisList=-1; //display list
	m_bEditMode=false; //edit mode?

}
void CObj::CalcBox(void)
{
	// valid?
	if (v.empty()) return;

	// starter
	m_vMin= v.front().v;
	m_vMax= v.front().v;

	// find
	CVertexList::iterator vi;
	for (vi=v.begin(); vi!=v.end(); vi++) {
		m_vMin.MakeMin(vi->v);
		m_vMax.MakeMax(vi->v);
	}// end of for
}
CObj::~CObj(void) {
	//clear node
	//CVertexList v;
	//FACE_LIST	f;
	v.clear(); //clear vertices
	f.clear(); //clear face
}

//it's irrelevant to transformation matrix
void CObj::ShowFaces(void)
{
	CFaceList::iterator fi;

	if (m_bEditMode) { //edit mode

		for (fi=f.begin(); fi!=f.end(); fi++) {

			// a -> b
			CVertex& va=v[fi->a];
			CVertex& vb=v[fi->b];
			CVertex& vc=v[fi->c];

			if (fi->chosen) glColor3d(1,0,0);
				else glColor3d(0.7, 0.7, 0.7);
			glBegin(GL_TRIANGLES);
			VECTOR n=(vb.v-va.v)*(vc.v-vb.v);
			glNormal3f(n.x, n.y, n.z);

			va.SetNormal(fi->s);va.v.Put();
			vb.SetNormal(fi->s);vb.v.Put();
			vc.SetNormal(fi->s);vc.v.Put();
			glEnd();

		}//end of for
	}//end of if
	else {

		for (fi=f.begin(); fi!=f.end(); fi++) {

			if (fi->m_pMtl) {
				fi->m_pMtl->Set();
			}

			// a -> b
			CVertex& va=v[fi->a];
			CVertex& vb=v[fi->b];
			CVertex& vc=v[fi->c];

			glBegin(GL_TRIANGLES);
			VECTOR n=(vb.v-va.v)*(vc.v-vb.v);
			glNormal3f(n.x, n.y, n.z);

			va.SetNormal(fi->s);va.v.Put();
			vb.SetNormal(fi->s);vb.v.Put();
			vc.SetNormal(fi->s);vc.v.Put();
			glEnd();

		}//end of for
	}//end of if



}
void CObj::Show(void) {
//	TRACE("my name is %s   vertices:%d faces:%d \n",name, v.size(),f.size());
//	TRACE("material %s :index %d\n", mat,FindMaterial(mat));



	static double mat[16]; //standard 4X4 matrix for 3d
	
	//setup matrix of this object

	glPushMatrix();
	m_Mat.Set();

	if (m_nDisList==-1) {
		ShowFaces(); //it's static unless you have skin 
	}
	else glCallList(m_nDisList);

	glPopMatrix();
}

void CObj::Tell(void) {
	TRACE("my name is %s   vertices:%d faces:%d \n",name, v.size(),f.size());

	int i,n;
	n=f.size();
	for (i=0;i<n;i++) {
		TRACE("%3d %3d %3d \n", f[i].a, f[i].b,  f[i].c);
		TRACE("%7.3f %7.3f %7.3f \n", v[f[i].a].v.x, v[f[i].a].v.y, v[f[i].a].v.z);
		TRACE("%7.3f %7.3f %7.3f \n", v[f[i].b].v.x, v[f[i].b].v.y, v[f[i].b].v.z);
		TRACE("%7.3f %7.3f %7.3f \n", v[f[i].c].v.x, v[f[i].c].v.y, v[f[i].c].v.z);
	}
}

//reset for animatioin
void CObj::ResetAni(void)
{
	//reset iterators
	m_pPosKey= m_PosKeys.begin();
	m_pRotKey= m_RotKeys.begin();
	m_pSclKey= m_SclKeys.begin();
}

//play for animation
void CObj::PlayAni(int Cur)
{
	//animation

	//proceed
	if( m_pPosKey != &m_PosKeys.back()) { //m_pPosKey+1 is valid!
		while( (m_pPosKey+1)->m_nFrame < Cur ) { //out of range ? 
			m_pPosKey++;//go to the next key
			if (m_pPosKey==&m_PosKeys.back()) break;
		}
	}

	if (m_pRotKey != &m_RotKeys.back()) { //m_pRotKey+1 is valid!
		while ( (m_pRotKey+1)->m_nFrame < Cur) {
			m_pRotKey++;
			if (m_pRotKey==&m_RotKeys.back()) break;
		}
	}

	if (m_pSclKey != &m_SclKeys.back()) { // m_pSclKey+1 is valid!
		while ( (m_pSclKey+1)->m_nFrame < Cur) { //out of range?, go to the next key
			m_pSclKey++;
			if (m_pSclKey==&m_SclKeys.back()) break;
		}
	}	


	//interpolate
	if (m_PosKeys.size()>=2 && m_pPosKey != &m_PosKeys.back()) {
				POSKEY_LIST::iterator pi=m_pPosKey;
				float t= (float) ( Cur - pi->m_nFrame)/ 
					(float) ( (pi+1)->m_nFrame - pi->m_nFrame);
				VECTOR p0=  pi->m_Pos;
				VECTOR p1=  (pi+1)->m_Pos;
				m_Pos= (p1-p0)*t+p0;
	}
	else m_Pos=m_pPosKey->m_Pos; //if it is over the range, use the last node

	if (m_RotKeys.size()>=2 && m_pRotKey != &m_RotKeys.back()) {
				ROTKEY_LIST::iterator ri=m_pRotKey;
				float t= (float) ( Cur - ri->m_nFrame)/ 
					(float) ( (ri+1)->m_nFrame - ri->m_nFrame);
				//interpolate
				QUA q0= ri->m_Rot.r;
				QUA q1= (ri+1)->m_Rot.r;
				
				float co=q0%q1;
				if (co<-1.0f) co=-1.0f;
				else if (co>1.0f) co=1.0f;
				//get angle
				float th=acos(co);
				if (sin(th)<=MATH_ZERO) m_Rot.r= q0;
				else 
					m_Rot.r = ( q0*(float)sin((1-t)*th)+q1*(float)sin(t*th) ) / (float)sin(th);

	}
	else m_Rot= m_pRotKey->m_Rot;

	//scale
	if (m_SclKeys.size()>=2 && m_pSclKey != &m_SclKeys.back()) {
				SCLKEY_LIST::iterator pi=m_pSclKey;
				float t= (float) ( Cur - pi->m_nFrame)/ 
					(float) ( (pi+1)->m_nFrame - pi->m_nFrame);
				VECTOR p0=  pi->m_Scl;
				VECTOR p1=  (pi+1)->m_Scl;
				m_Scl= (p1-p0)*t+p0;
	}
	else m_Scl=m_pSclKey->m_Scl; //if it is over the range, use the last node


}

//animate
void CObj::Animate(float Start, float End, float Cur)
{
	//find the position key
	POSKEY_LIST::iterator pi;
	//first?
	if (Cur== m_PosKeys.front().m_nFrame) m_Pos=m_PosKeys.front().m_Pos; //start?
	else if (Cur== m_PosKeys.back().m_nFrame) m_Pos=m_PosKeys.back().m_Pos; //end?
	else {
		for (pi=m_PosKeys.begin(); pi!= m_PosKeys.end()-1; pi++) { //middle
			if (Cur>= pi->m_nFrame && Cur< (pi+1)->m_nFrame) { 
				float t= (float) ( Cur - pi->m_nFrame)/ 
					(float) ( (pi+1)->m_nFrame - pi->m_nFrame);

				VECTOR p0=  pi->m_Pos;
				VECTOR p1=  (pi+1)->m_Pos;
				m_Pos= (p1-p0)*t+p0;
			
			}
		
		}//end of for
	}//end of else
	
	//m_Pos=m_PosKeys[(int)Cur].m_Pos;

	//find the rotation key
	ROTKEY_LIST::iterator ri;
	//first?
	if (Cur== m_RotKeys.front().m_nFrame) m_Rot=m_RotKeys.front().m_Rot; //start?
	else if (Cur== m_RotKeys.back().m_nFrame) m_Rot=m_RotKeys.back().m_Rot; //end?
	else {
		for (ri=m_RotKeys.begin(); ri!= m_RotKeys.end()-1; ri++) { //middle
			if (Cur> ri->m_nFrame && Cur< (ri+1)->m_nFrame) { 
				//interpolate
				QUA q0= ri->m_Rot.r;
				QUA q1= (ri+1)->m_Rot.r;
				ASSERT((ri+1)->m_nFrame - ri->m_nFrame>0);
				float t= (float) ( Cur - ri->m_nFrame)/ 
					(float) ( (ri+1)->m_nFrame - ri->m_nFrame);
 				TRACE("t %f\n",t);
				//get m_Rot!
				
				float co=q0%q1;
				if (co<-1.0f) co=-1.0f;
				else if (co>1.0f) co=1.0f;
				//get angle
				float th=acos(co);
				if (sin(th)<=MATH_ZERO) m_Rot.r= q0;
				else 
					m_Rot.r = ( q0*(float)sin((1-t)*th)+q1*(float)sin(t*th) ) / (float)sin(th);
			}
		
		}//end of for
	}//end of else
}

//object is rotated, translated and scaled.
//get transformation matrix
void CObj::UpdateData()
{
	MAT m(4,4);
	m.Identity();
	m(0,0)= m_Scl.x;
	m(1,1)= m_Scl.y;
	m(2,2)= m_Scl.z;

	ROT r=m_Rot;
	r.u=QUA(0, m_Pos.x, m_Pos.y, m_Pos.z);
	r.r = ~r.r; //inverse

	//vector->scale->rotation->translation = we got!
	m = m*r.GetMat();

	//store
	m_Mat=m;


	//report
	TRACE("Position Keys %d \n", m_PosKeys.size());
	TRACE("Scale Keys %d \n", m_SclKeys.size());
	TRACE("Rotatin Keys %d \n", m_RotKeys.size());
}

//calculate normals
void CObj::UpdateNormals()
{
	CFaceList::iterator fi;
	CVertexList::iterator vi;

	//delete normal verctors per vertex
	for (vi=v.begin(); vi!=v.end(); vi++) {
		vi->n.clear();
	}

	//make new normals
	for (fi=f.begin(); fi!= f.end(); fi++) {
		CVertex& va=v[fi->a];
		CVertex& vb=v[fi->b];
		CVertex& vc=v[fi->c];

		VECTOR n= (vb.v - va.v) * (vc.v - vb.v); //get face normal

		va.AddNormal(fi->s, n);
		vb.AddNormal(fi->s, n);
		vc.AddNormal(fi->s, n);

	}//end of for
}


////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
//                     MODEL                                                           //
//                                                                                //
//////////////////////////////////////////////////////////////////////////////////// 


CModel::CModel(void) {
	// bounding box
	m_vMin=VECTOR(-1,-1,-1);
	m_vMax=VECTOR(1,1,1);

	m_bShowAxis=false; //show axis? 
	///matrix setting
	m_vOri=VECTOR(0,0,0); //origin

	m_vPiv=VECTOR(0,0,0); //pivot
	m_vScl=VECTOR(1,1,1); //scale

	//root node setup
	m_Nodes.clear();

	//frame setup
	m_nStart=0;
	m_nEnd=100;
	m_nCur=0;


	//show material
	m_bShowMtr=true;

}
CModel::~CModel(void) {
	//celar nodes
	m_ObjList.clear();
	m_MatList.clear();
}
//find the index about the name of the material
CMtl* CModel::FindMaterial(const char* NAME) { //find index..
	CMtlList::iterator mi;

	for (mi=m_MatList.begin(); mi!= m_MatList.end(); mi++) {
		if (!strcmp(mi->name, NAME)) { //found
			return & (*mi);
		}
	}

	return NULL;
}


void DrawAxis2(double height);


int CModel::Save(FILE* Out) {
	if (Out==NULL) return false;

	//save
	fprintf(Out,"%s\n", fname);
	fprintf(Out,"%f %f %f\n", m_vOri.x, m_vOri.y, m_vOri.z);
	fprintf(Out,"%f %f %f\n", m_vPiv.x, m_vPiv.x, m_vPiv.z);
	fprintf(Out,"%f %f %f\n", m_vScl.x, m_vScl.y, m_vScl.z);

	return true;
}

int CModel::Load(FILE* In) {
	if (In==NULL) return false;

	//save
	fscanf(In,"%s", fname);
	if (!Read3DS(fname)) return false;


	//origin
	fscanf(In,"%f %f %f", &m_vOri.x, &m_vOri.y, &m_vOri.z);

	//pivot
	fscanf(In,"%f %f %f", &m_vPiv.x , & m_vPiv.y, &m_vPiv.z);

	//scale
	fscanf(In,"%f %f %f", &m_vScl.x, &m_vScl.y, &m_vScl.z);


	return true;
}

//this can be made as display list
void CModel::ShowObjects(void) 
{
	CMtl* m=NULL; //material pointer
	CObjList::iterator oi;

	for (oi=m_ObjList.begin(); oi!= m_ObjList.end(); oi++) {
		
		//showing axis?
		if (m_bShowMtr) { //show material?
			if (!m_bShowAxis ) { //not showing axis and showing material mode
						
				
				m=FindMaterial(oi->mat);
				if (m ) { //okay found
					m->Set();
				}
			}
			else { //showing axis..
				if (glIsEnabled(GL_COLOR_MATERIAL)) {
					glColor4d(1, 0, 0, 0.5);
				}
				else {
						float Copper[] = {
						0.191250f, 0.073500f, 0.022500f, 0.500000f,
						0.703800f, 0.270480f, 0.082800f, 0.600000f,
						0.256777f, 0.137622f, 0.086014f, 0.600000f,
						12.800000f
						};
						glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, Copper);
						glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, Copper+4);
						glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, Copper+8);
						glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, Copper[12]);
					}//end of else
			} //end of else
		}//end of if
	
		oi->Show();
	}
}
int CModel::BuildList(int List) {
	CObjList::iterator oi;
	for (oi=m_ObjList.begin(); oi!=m_ObjList.end(); oi++) {
		List=oi->BuildList(List);
	}
	return List; 
}

//play animation
void CModel::Play(void)
{
	//return to the beginning
	if (m_nCur>=m_nEnd) {
		m_nCur=m_nStart;
	}
	//m_nStart, m_nEnd it's film.

	//make transformation matrix
	CObjList::iterator oi;
	for (oi=m_ObjList.begin(); oi!= m_ObjList.end(); oi++) {
//		oi->Animate(m_nStart,m_nEnd, m_nCur); //process keys of a object
		
		if (m_nCur<= m_nStart) {
			//reset initial matrix ..
			oi->ResetAni();

			m_nCur=m_nStart; //start from the start frame number
		}
		oi->PlayAni(m_nCur);



		oi->UpdateData();//make a matrix
	}

	//update hierarchy
	Process(&m_Root);

	//go to the next frame
	m_nCur+=1;
}

void CModel::Show(void) {

	//adust matrix
	glPushMatrix();

	m_vOri.Move();



	//scaling.
	glPushMatrix();

	glTranslated(m_vPiv.x, m_vPiv.y, m_vPiv.z);
	glScaled( m_vScl.x, m_vScl.y, m_vScl.z);
	glTranslated(-m_vPiv.x, -m_vPiv.y, -m_vPiv.z);






	ShowObjects(); //special state

	glPopMatrix();


	if (m_bShowAxis) {
		glDisable(GL_DEPTH_TEST);
		DrawAxis2(500);
		

		glPushMatrix();
		glTranslated(m_vPiv.x, m_vPiv.y, m_vPiv.z);
		glColor4d(0.75, 1, 0, 0.75);
		glutSolidSphere(50, 10, 10);
		glPopMatrix();

		glEnable(GL_DEPTH_TEST);
	}

	glPopMatrix();
}

  
//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           
//                   MODEL DATA                                                                         
//                                                                                           
//////////////////////////////////////////////////////////////////////////////////////////////
CModelList::CModelList(void) {
	fname[0]=NULL;//initialize file name
	// bounding box
	m_vMin=VECTOR(-10,-10,-10);
	m_vMax=VECTOR(10,10,10);
}

//get data.
	
//file input and output
//dynamic data must contain size information
//so that the program can prepare proper memory..
//save i
int CModelList::Save(void)
{
	if (fname[0]==NULL) return false;
	return Save(fname);
}
int CModelList::Save(char *Name)
{
	//valid
	FILE* f= fopen(Name, "wt");
	if (f==NULL) return false;

	//save 
	//save the number of items
	fprintf(f,"%d \n", size()); 
	//copy the name
	strcpy(fname, Name);

	CModelList::iterator mi;
	for (mi=begin(); mi!= end(); mi++) {
		mi->Save(f);
	}

	//close
	fclose(f);
	//success
	return true;
}

//make display list for fast speed
int CModelList::BuildLists(int ListStart)
{
	iterator mi;
	for (mi=begin(); mi!=end(); mi++) {
		ListStart=mi->BuildList(ListStart);
	}

	return ListStart;
}
//load i
int CModelList::Load(void)
{
	if (fname[0]==NULL) return false;

	return Load(fname);
}

// load 2
int CModelList::Load(char *Name)
{
	//valid?

	FILE* f= fopen(Name, "rt");
	if (f==NULL) return false;

	//prepare memory
	clear();



	//save 
	//copy the name
	strcpy(fname, Name);

	int i,n;
	fscanf(f, "%d", &n); //read number of item

	for (i=0; i< n; i++) {
		push_back(CModel()); //add an item

		if (!back().Load(f)) {
			clear();
			return false;

		} //load the data
	}

	//close
	fclose(f);
	//success
	return true;
}


//find object by name
CObj* CModel::FindObj(const char *Name)
{
	CObjList::iterator oi;
	for (oi= m_ObjList.begin(); oi!=m_ObjList.end(); oi++) {
		if (!strcmp(Name, oi->name)) return & (*oi);
	}
	return NULL;
}


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           
//                   Global Functions                                                                         
//                                                                                           
//////////////////////////////////////////////////////////////////////////////////////////////
void DrawAxis2(double height)
{
	double height2= height*0.5;
	double base=height2*0.1;
	
	//colors
	float red[4]=	{	1.0f,	0.0f,	0.0f,	0.5f};
	float green[4]=	{	0.0f,	1.0f,	0.0f,	0.5f};
	float blue[4]=	{	0.0f,	0.0f,	1.0f,	0.5f};
	float yellow[4]={	1.0f,	1.0f,	0.0f,	0.5f};

	int cm=false;
	if (glIsEnabled(GL_COLOR_MATERIAL)) cm=true; //color material mode?

	//begin
	GLUquadricObj* obj=gluNewQuadric();
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);

	if (cm) glColor4fv(yellow);
	else glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, yellow);


	glutSolidCube(base*2);

	//draw Z
	if (cm) glColor4fv(blue);
	else glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, blue);
	glPushMatrix();
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw Y
	if (cm) glColor4fv(green);
	else glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, green);
	glPushMatrix();
	glRotated(90, -1, 0, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw X
	if (cm) glColor4fv(red);
	else glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, red);
	glPushMatrix();
	glRotated(90, 0, 1, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();


	gluDeleteQuadric(obj);
	//end

}

//make a tree
void CModel::MakeTree(CTreeCtrl* Tree)
{
	//valid
	if (Tree==NULL) return;

	MakeObjTree(&m_Root, Tree, 0);
}

//process hierarchy.
//it's binary tree 
void CModel::Process(CObjNode* Node)
{
	//valid?
	if (Node==NULL) return;

	CObjNode* child=Node->m_pChild;
	CObjNode* sib= Node->m_pSibling;

	//calculate
	if (Node)
	if (Node->m_pParent) {
		CObj* cur=Node->m_pObj;
		CObj* par=Node->m_pParent->m_pObj;

		if (cur && par) {
			cur->m_Mat = cur->m_Mat* par->m_Mat;
		}
	}
	
	if (sib!=Node) Process(sib);//sibling first
	if (child!=Node) Process(child); //child second

}
// calculate bounding box
void CModel::CalcBox(void)
{
	// valid?
	if (m_ObjList.empty()) return;

	// starter 
	VECTOR min,max;

	CObjList::iterator oi=m_ObjList.begin();
	min=oi->m_vMin * oi->m_Mat;
	max=oi->m_vMax * oi->m_Mat;
	m_vMin=min; // initial value
	m_vMax=max;

	//calculate bounding box
	for (oi=m_ObjList.begin(); oi!= m_ObjList.end(); oi++) {
		oi->CalcBox();
	}

	for (oi=m_ObjList.begin(); oi!=m_ObjList.end(); oi++) {
		min=oi->m_vMin * oi->m_Mat;
		max=oi->m_vMax * oi->m_Mat;

		// make
		m_vMin.MakeMin(min);
		m_vMax.MakeMax(max);
	}
}

void CModel::MakeObjTree(CObjNode* Node, CTreeCtrl* Tree, HTREEITEM Parent)
{
	//valid?
	if (Node==NULL) return;

	//prepare node
	TV_INSERTSTRUCT n;
	n.hParent= NULL;
	n.hInsertAfter= TVI_LAST;
	n.item.mask=  TVIF_TEXT;
	n.item.state=0;
	n.item.stateMask=0;
	n.item.cchTextMax=60;
	n.item.iSelectedImage=1;
	n.item.cChildren=0;

	n.item.pszText=fname;
	if (Node->m_pObj) n.item.pszText=Node->m_pObj->name;
	n.item.iImage=0;

	
	HTREEITEM hThis;
	//make a node
	n.hParent= Parent;
	hThis= Tree->InsertItem(&n);


	CObjNode* child=Node->m_pChild;
	CObjNode* sib= Node->m_pSibling;

		
	if (sib!=Node) MakeObjTree(sib,Tree,Parent);//sibling first
	if (child!=Node) MakeObjTree(child,Tree,hThis); //child second

}

//show all 3D models
void CModelList::Show()
{
	iterator mi;
	for (mi=begin(); mi!= end(); mi++) 
		mi->Show();
}

void CObj::ShowName()
{
		//setup matrix of this object

	glPushMatrix();
	m_Mat.Set();

	CFaceList::iterator fi;

	for (fi=f.begin(); fi!=f.end(); fi++) {

	// a -> b
	CVertex& va=v[fi->a];
	CVertex& vb=v[fi->b];
	CVertex& vc=v[fi->c];

	glLoadName((int) & *fi);
	glBegin(GL_TRIANGLES);
	VECTOR n=(vb.v-va.v)*(vc.v-vb.v);
	glNormal3f(n.x, n.y, n.z);

	va.v.Put();
	vb.v.Put();
	vc.v.Put();
	glEnd();

	}

	glPopMatrix();

}

void CModelList::ShowName()
{

}

void CModel::ShowName()
{
		//adust matrix
	glPushMatrix();

	m_vOri.Move();



	//scaling.
	glPushMatrix();

	glTranslated(m_vPiv.x, m_vPiv.y, m_vPiv.z);
	glScaled( m_vScl.x, m_vScl.y, m_vScl.z);
	glTranslated(-m_vPiv.x, -m_vPiv.y, -m_vPiv.z);

	CObjList::iterator oi;
	for (oi=m_ObjList.begin(); oi!= m_ObjList.end(); oi++) {
		oi->ShowName();
	}
	glPopMatrix();

	glPopMatrix();
}

void CModel::ShowEdit()
{
	CObjList::iterator oi;
	for (oi=m_ObjList.begin(); oi!= m_ObjList.end(); oi++) {
		oi->m_bEditMode=true;
	}

	Show();

	for (oi=m_ObjList.begin(); oi!= m_ObjList.end(); oi++) {
		oi->m_bEditMode=false;
	}
}


// find material by name
CMtlList::iterator CMtlList::Find(char* Name)
{
	iterator i;
	for (i=begin(); i!=end(); i++) {
		if (!strcmp(Name, i->name)) return i;

	}

	return NULL;
}