//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                           
//                   3DS ENGINE
//             coded by Jongwhan Lee                                                                         
//                                                                                           
//////////////////////////////////////////////////////////////////////////////////////////////
#ifndef __MESH_ENGINE_
#define __MESH_ENGINE_
#include <vector>
#include <list>
#include "mathobj.h" //math
using namespace std;

class CNormal;//normal per vertex
class CVertex;
class CObjNode;
class CMtl; //material
class CHalf;
class CFace;
class CObj; //one mesh object with one material
class CRGBColor; // material .. ambient, diffuse, specular
class CModel; //one model consisting of many meshes

typedef CVec<float> VECTOR; // Vector
typedef CMat<float> MAT; //Matrix
typedef CRot<float> ROT; //quaternion rotation
typedef CQua<float> QUA; //quaternion


//material 
// from 0.0 to 1.0
class AFX_EXT_CLASS CRGBColor{
public:
	int r, g, b;
	CRGBColor(void) ;
	~CRGBColor(void);
	CRGBColor(int R, int G, int B);
};

// list
class AFX_EXT_CLASS CRGBColors
:public list<CRGBColor> 
{

};

//normal vector per vertex
//this is for smoothing group
class AFX_EXT_CLASS CNormal {
public:
	
	VECTOR v; //vector
	int s; //smoothing group (from 1 to 32)
	CNormal(void); //default...
	CNormal(int S, VECTOR N);
};
class AFX_EXT_CLASS CNormalList
: public list<CNormal>
{
};

class AFX_EXT_CLASS CVertex
{
public:
	void SetNormal(int S);
	void AddNormal(int S, VECTOR N);
	VECTOR v; //vector

	CNormalList n; //normal vector list

	CVertex(float X, float Y, float Z);
	CVertex(void);
};
// list
class AFX_EXT_CLASS CVertexList:
public vector<CVertex>
{

};

class AFX_EXT_CLASS CFace {
public:
	int chosen;//chosen or not?
	CObj* m_pObj; //parent object
	CMtl* m_pMtl; //material pointer

	int a,b,c; //three vertices..index

	int s; //smoothing group data (from 1 to 32)

	CFace(void);
	~CFace(void);
	CFace(int A,int B, int C);
};
// list
class AFX_EXT_CLASS CFaceList:
public vector<CFace> { // need random access
};

// a 3ds model
//a tree node
class AFX_EXT_CLASS CObjNode {
public:
	CObjNode* m_pParent;

	CObjNode* m_pChild; //binary tree
	CObjNode* m_pSibling;

	CObj* m_pObj; //which object?

	//construct
	CObjNode(CObj* Obj) {
		m_pChild=NULL;
		m_pSibling=NULL;
		m_pParent=NULL;
		m_pObj=Obj;
	}
	CObjNode(void) {
		m_pChild=NULL;
		m_pSibling=NULL;
		m_pParent=NULL;
		m_pObj=NULL;
	}
	void AddChild(CObjNode* Node) {
		Node->m_pSibling = m_pChild; //save current child nodes
		m_pChild= Node;
		Node->m_pParent=this;
	}
	void AddSibling(CObjNode* Node) {
		Node->m_pSibling= m_pSibling;//save current siblings
		m_pSibling= Node;
		Node->m_pParent=this->m_pParent;
	}

};
// linked list
class AFX_EXT_CLASS CObjNodeList :
public list<CObjNode>
{
};


//frame data
//position key
class AFX_EXT_CLASS CPosKey  {
public:
	int m_nFrame; //frame number;
	VECTOR m_Pos; //position
	CPosKey(int Frame, VECTOR Pos) {
		m_nFrame=Frame, m_Pos= Pos;
	}
};
typedef vector<CPosKey> POSKEY_LIST;

//rotation key
class AFX_EXT_CLASS CRotKey  {
public:
	int m_nFrame; //frame number;
	ROT m_Rot; //position
	CRotKey(int Frame, ROT Rot) {
		m_nFrame=Frame, m_Rot=Rot;
	}
};
typedef vector<CRotKey> ROTKEY_LIST;

//scale key
class AFX_EXT_CLASS CSclKey  {
public:
	int m_nFrame; //frame number;
	VECTOR m_Scl; //position
	CSclKey(int Frame, VECTOR Scl) {
		m_nFrame=Frame, m_Scl= Scl;
	}
};
typedef vector<CSclKey> SCLKEY_LIST;

//object has frame data!
class AFX_EXT_CLASS CObj { // = face + edge + vertex
public:
	int m_bEditMode; //edit or not?

	void ShowName(void);
	void ResetAni(void); //reset for animation
	void PlayAni(int); //play for animation
	void UpdateNormals(void);
	void UpdateData(void);
	CVertexList v;
	CFaceList	f;
	char	mat[200]; //material name

	char name[200]; //object name


	//animation
	VECTOR m_Piv; //pivot .. don't changes between frames.

	//these are changed by the frame
	VECTOR m_Scl; //scale
	VECTOR m_Pos; //position
	ROT m_Rot; //rotation quaternion

	//transformation matrix calculated by the above values
	MAT m_Mat;

	//node for hierarchy
	CObjNode* m_pNode; 

	//display list
	int m_nDisList; //display list number 
	int BuildList(int List);
	//it's irrelevant to transformation matrix
	void ShowFaces(void);

	CObj(const char* NAME);
	void Tell(void);
	CObj(void);
	~CObj(void);
	void Show(void);

	//bounding box
	void CalcBox(void);// calculate bounding box
	VECTOR m_vMin, m_vMax;

	//position keys
	//these list have at least one node.
	POSKEY_LIST m_PosKeys; //position keys
	POSKEY_LIST::iterator m_pPosKey; //it's reset as ResetAni function

	ROTKEY_LIST m_RotKeys; //rotation keys
	ROTKEY_LIST::iterator m_pRotKey;

	SCLKEY_LIST m_SclKeys; //scale keys
	SCLKEY_LIST::iterator m_pSclKey;

	//animate
	void Animate(float Start, float End, float Cur);
};
// list
class AFX_EXT_CLASS CObjList:
public list<CObj> {

};
// list
class AFX_EXT_CLASS CObjpList:
public vector<CObj*> { // need random access

};

// material
class AFX_EXT_CLASS CMtl{ //material
public:
	char name[300];
	float m_fvAmbient[4];
	float m_fvDiffuse[4];
	float m_fvSpecular[4];
	float m_fShine;//shininess

	CMtl(const char * NAME);
	CMtl(void);

	void Set(void);
};
// material list
class AFX_EXT_CLASS CMtlList
: public list<CMtl>
{
public:
	iterator Find(char* Name);
};



//a model
class AFX_EXT_CLASS CModel {
public:
	void ShowEdit(void);
	void ShowName(void);
	void MakeObjTree(CObjNode* Node, CTreeCtrl* Tree, HTREEITEM Parent);
	void MakeTree(CTreeCtrl* Tree);//call the above function

	CObj* FindObj(const char* Name);
	char fname[100] ;//file name to save and load

	VECTOR m_vOri; //origin point of this model

	VECTOR m_vPiv; //for scaling
	VECTOR m_vScl; //scale factor 
	int m_bShowAxis;

	CObjList m_ObjList; //object list (mesh object)
	CMtlList m_MatList; //material list
	int m_bShowMtr; //show material

	//tracking
	CObjNode m_Root; //root node
	CObjNodeList m_Nodes; //nodes for trees
	CObjpList m_ObjpList; //object pointer list..(for grouping)


	void Show(void) ; //call show objects..
	CModel(void);
	~CModel(void);
	CMtl* FindMaterial(const char* NAME) ;

	//mesh input / output
	int Read3DS( char* name);

	//save and load
	int Save(FILE*);
	int Load(FILE*);

	//process nodes
	void Process(CObjNode* Node);

	// bounding box issue
	VECTOR m_vMin, m_vMax;
	void CalcBox(void);

	//display list
	void ShowObjects(void) ; //this can be made as a display list
	int BuildList(int); //return increased list number

	//animation
	float m_nStart, m_nEnd; //frame
	float m_nCur;//current frame
	void Play(void);//play animation
};

//3ds model archive
class AFX_EXT_CLASS CModelList:
public list<CModel> // iterator should be vaild, so use list
 {
public:
	void ShowName(void);
	void Show(void);
	//save and load
	int Save(char* Name);
	int Save(void); //re-save..
	int Load(char *Name);
	int Load(void); //update disk file

	char fname[100] ;//file name to save

	CModelList(void);
		
	//3ds management
	void Show3DS(int);
	void Show(int);//show with material

	void Read3DS(  char* name); //call Read3DS(char*0


	VECTOR m_vMin, m_vMax; // bounding box
	void CalcBox(void); // calculate bounding box
	
	//make display list for fast speed
	int BuildLists(int);
	
};
#endif