// MeshDoc.cpp : implementation file
//

#include "stdafx.h"
#include "skin.h"

#include "MeshDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMeshDoc

IMPLEMENT_DYNCREATE(CMeshDoc, CDocument)

CMeshDoc::CMeshDoc()
{
	m_bShowAxis=false; // show axis
	m_bShowNet=false; // show grid lines 
}

BOOL CMeshDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CMeshDoc::~CMeshDoc()
{
}


BEGIN_MESSAGE_MAP(CMeshDoc, CDocument)
	//{{AFX_MSG_MAP(CMeshDoc)
	ON_COMMAND(ID_SHOW_NET, OnShowNet)
	ON_UPDATE_COMMAND_UI(ID_SHOW_NET, OnUpdateShowNet)
	ON_COMMAND(ID_SHOW_AXIS, OnShowAxis)
	ON_UPDATE_COMMAND_UI(ID_SHOW_AXIS, OnUpdateShowAxis)
	ON_COMMAND(ID_PLAY_ALL, OnPlayAll)
	ON_COMMAND(ID_ADD_CHARACTER, OnAddCharacter)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeshDoc diagnostics

#ifdef _DEBUG
void CMeshDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMeshDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMeshDoc serialization

void CMeshDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMeshDoc commands

BOOL CMeshDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	

	//read
	char tmp[300];
	strcpy(tmp, lpszPathName);
	m_Models.Read3DS(tmp);

	// adjust viewbox
	AfxGetMainWnd()->SendMessage(WM_COMMAND, ID_UPDATE_BOUNDINGBOX_ALL);
	
	return TRUE;
}

// grid lines
void CMeshDoc::OnShowNet() 
{
	m_bShowNet= !m_bShowNet;
	
	UpdateAllViews(NULL);
}

void CMeshDoc::OnUpdateShowNet(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_bShowNet);
}

// show axis
void CMeshDoc::OnShowAxis() 
{
	m_bShowAxis= !m_bShowAxis;
	UpdateAllViews(NULL);
}

void CMeshDoc::OnUpdateShowAxis(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_bShowAxis);
}

void CMeshDoc::OnPlayAll() 
{
	if (m_Models.empty()) return;

	m_Models.front().Play();
	UpdateAllViews(NULL);
}

void CMeshDoc::OnAddCharacter() 
{
	char szFilter[]="3DS File(*.3ds)|*.3ds|All Files(*.*)| *.* ||";
	CFileDialog dlg(TRUE, NULL, NULL,
		OFN_HIDEREADONLY  | OFN_LONGNAMES , szFilter);
	if (dlg.DoModal()!=IDOK) return;

	char tmp[300];
	strcpy(tmp,dlg.GetPathName().GetBuffer(300));
	AfxMessageBox(tmp);

	m_Models.Read3DS(tmp);


	
}
