// MeshFrame.cpp : implementation file
//

#include "stdafx.h"
#include "skin.h"
#include "MeshFrame.h"

#include "meshview.h" // view class


int GV_bPlotViewMax=false; // one plot view mode?

/////////////////////////////////////////////////////////////////////////////
// CMeshFrame

IMPLEMENT_DYNCREATE(CMeshFrame, CCJMDIChildWnd)

CMeshFrame::CMeshFrame()
{
}

CMeshFrame::~CMeshFrame()
{
}


BEGIN_MESSAGE_MAP(CMeshFrame, CCJMDIChildWnd)
	//{{AFX_MSG_MAP(CMeshFrame)
	ON_COMMAND(ID_MAX_WND, OnMaxWnd)
	ON_COMMAND(ID_RESTORE_WND, OnRestoreWnd)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_UPDATE_MESHVIEWS, OnUpdateMeshviews)
	ON_COMMAND(ID_VIEW_EXTENTS_ALL, OnViewExtentsAll)
	ON_COMMAND(ID_WND_TOGGLE, OnWndToggle)
	ON_UPDATE_COMMAND_UI(ID_WND_TOGGLE, OnUpdateWndToggle)
	ON_COMMAND(ID_UPDATE_BOUNDINGBOX_ALL, OnUpdateBoundingboxAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeshFrame message handlers

#include "meshview.h"
extern HWND GV_hActiveView;
extern HWND GV_hActiveViewOld;

BOOL CMeshFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
//	return CCJMDIChildWnd::OnCreateClient(lpcs, pContext);
//	return m_wndSplitter.Create(this, 2, 2, CSize(10,10), pContext);
	// maximize
	ShowWindow(SW_SHOWMAXIMIZED);
	m_wndSplitter.CreateStatic(this, 2,2);

	CRect r;
	GetClientRect(&r);
	CSize s;
	s.cx=r.Width()/2;
	s.cy=r.Height()/2;

	m_wndSplitter.CreateView(0,0, RUNTIME_CLASS(CMeshView), s, pContext);
	m_wndSplitter.CreateView(0,1, RUNTIME_CLASS(CMeshView), s, pContext);
	m_wndSplitter.CreateView(1,0, RUNTIME_CLASS(CMeshView), s, pContext);
	m_wndSplitter.CreateView(1,1, RUNTIME_CLASS(CMeshView), s, pContext);

	//set active view
	m_wndSplitter.SetActivePane(0,0);
	CMeshView* view=(CMeshView*) m_wndSplitter.GetActivePane(0,0);
	if (view) {
		GV_hActiveViewOld=GV_hActiveView=view->GetSafeHwnd();
		
		view->m_bIsActive=true;
	}

	// set rotation
	SetRotation();

	return TRUE;
}

void CMeshFrame::OnMaxWnd() 
{
	CRect r;
	GetClientRect(&r);

	int i,j;
	for (i=0;i<2;i++) 
		for (j=0;j<2;j++) {
			m_wndSplitter.GetPane(i,j)->ShowWindow(SW_HIDE);
		}
	//m_wndSplitter.GetActivePane()->MoveWindow(0,0,r.Width(),r.Height());
		m_wndSplitter.GetActivePane()->ShowWindow(SW_SHOWMAXIMIZED);
	RecalcLayout();
	m_wndSplitter.GetActiveWindow()->InvalidateRect(NULL);
}

void CMeshFrame::OnRestoreWnd() 
{
	int i,j;
	for (i=0;i<2;i++) 
		for (j=0;j<2;j++) {
			m_wndSplitter.GetPane(i,j)->ShowWindow(SW_SHOWNORMAL);
	}
}

void CMeshFrame::OnMouseMove(UINT nFlags, CPoint point) 
{
	
	CCJMDIChildWnd::OnMouseMove(nFlags, point);

}

void CMeshFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{
	AfxMessageBox("got");
	CPaintDC dc(this);
	CPen pen(PS_SOLID, 2, RGB(255,0,0));
	dc.SelectObject(&pen);

	dc.Rectangle(0,0,100,10);
	
	CCJMDIChildWnd::OnLButtonDown(nFlags, point);
}

void CMeshFrame::OnUpdateMeshviews() 
{
	int i,j;
	for (i=0;i<2;i++)
		for(j=0;j<2;j++) {
			m_wndSplitter.GetPane(i,j)->InvalidateRect(NULL);
		}
}


void CMeshFrame::SetRotation(void)
{
		CMeshView* view=NULL;

	//set rotation 
	view=(CMeshView*) m_wndSplitter.GetPane(0,0);
	// z direction
	if (view) {
		// there are two rotation modes
		view->m_DegX=0, view->m_DegY=0;  // for regular rotation

		view->m_Rot=ROT_VIEW(VECTOR_VIEW(0,0,1), RAD(0)); // quaternion rotation
	}
	// y direction
	view=(CMeshView*) m_wndSplitter.GetPane(0,1);
	if (view) {
		view->m_DegX=0, view->m_DegY=90;
		view->m_Rot=ROT_VIEW(VECTOR_VIEW(0,0,1), RAD(0))*
		ROT_VIEW(VECTOR_VIEW(1,0,0), RAD(-90));
	}
	// x direction
	view=(CMeshView*) m_wndSplitter.GetPane(1,0);
	if (view) {
		view->m_DegX=90, view->m_DegY=0;
		view->m_Rot=ROT_VIEW(VECTOR_VIEW(0,0,1), RAD(-90))*
		ROT_VIEW(VECTOR_VIEW(0,1,0), RAD(-90)); //     -> Object

	}
	view=(CMeshView*) m_wndSplitter.GetPane(1,1);
	if (view) {
		view->m_DegX=30, view->m_DegY=45;
		view->m_Rot=
			ROT_VIEW(VECTOR_VIEW(1,0,0), RAD(30))*
			ROT_VIEW(VECTOR_VIEW(0,1,0), RAD(45))*

			ROT_VIEW(VECTOR_VIEW(0,0,1), RAD(0))*
			ROT_VIEW(VECTOR_VIEW(1,0,0), RAD(-90));
	}
}
void CMeshFrame::OnViewExtentsAll() 
{
	SetRotation();


		

	// view extents all
	int i,j;
	for (i=0;i<2;i++) 
	for (j=0;j<2;j++) {
		m_wndSplitter.GetPane(i,j)->SendMessage(WM_COMMAND, ID_VIEW_EXTENTS);
	}

}

// toggle windows
void CMeshFrame::OnWndToggle() 
{
	// toggle switch
	if (!GV_bPlotViewMax) OnWndMax();
	else OnWndRes();
}

void CMeshFrame::OnUpdateWndToggle(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!GV_bPlotViewMax);		
}
// maximize active window
void CMeshFrame::OnWndMax() 
{
	GV_bPlotViewMax=true; // splitter window turned off

	CRect r;
	GetClientRect(&r);

	CRect r2;
	m_wndSplitter.GetClientRect(&r2);

	int i,j;
	for (i=0;i<2;i++) 
		for (j=0;j<2;j++) {
			m_wndSplitter.GetPane(i,j)->ShowWindow(SW_HIDE);
		}

	CMeshView* view=(CMeshView*)CMeshView::FromHandle(GV_hActiveView);
	if (view) {
		view->ShowWindow(SW_SHOWNORMAL);
		view->MoveWindow(0,0,r2.Width(), r2.Height());
		view->InvalidateRect(NULL);
	}
}

// restore windows
void CMeshFrame::OnWndRes() 
{
	GV_bPlotViewMax=false; // splitter window turn on
	
	// show windows
	int i,j;
	for (i=0;i<2;i++) 
		for (j=0;j<2;j++) {
			m_wndSplitter.GetPane(i,j)->ShowWindow(SW_SHOW);
	}

	OnWndArrange();
}


// arrange windows
void CMeshFrame::OnWndArrange() 
{
	// arrange only in 4 windows mode
	if (GV_bPlotViewMax) return;


	CRect r;
	GetClientRect(&r);

	CRect cr;

	m_wndSplitter.SetColumnInfo(0,(r.Width())/2.0, 10);
	m_wndSplitter.SetColumnInfo(1,(r.Width())/2.0, 10);
	m_wndSplitter.SetRowInfo(0,r.Height()/2.0, 10);
	m_wndSplitter.SetRowInfo(1,r.Height()/2.0, 10);
	// adjust windows
	m_wndSplitter.RecalcLayout();

	// set rotation ,too
	SetRotation() ;


	// view extents all
	int i,j;
	for (i=0;i<2;i++) 
	for (j=0;j<2;j++) {
		m_wndSplitter.GetPane(i,j)->SendMessage(WM_COMMAND, ID_VIEW_EXTENTS);
	}
}
void CMeshFrame::OnUpdateBoundingboxAll() 
{
	int i,j;
	for (i=0;i<2;i++) 
	for (j=0;j<2;j++) {
		m_wndSplitter.GetPane(i,j)->SendMessage(WM_COMMAND, ID_UPDATE_BOUNDINGBOX);
	}	
}
