// MeshView.cpp : implementation file
//

#include "stdafx.h"
#include "skin.h"
#include "MeshView.h"
#include "meshdoc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "mathobj.h"
#define GET_DOC ((CMeshDoc*)GetDocument())
typedef CVec<float> VECTOR;
void DrawSolidBox(VECTOR Min, VECTOR Max);
/////////////////////////////////////////////////////////////////////////////
// CMeshView

HWND GV_hActiveView=NULL;
HWND GV_hActiveViewOld=NULL;

IMPLEMENT_DYNCREATE(CMeshView, CGLView)

CMeshView::CMeshView()
{
	m_bIsActive=false;
	MakeViewBox(20);
	m_bDrawNet=true;

	m_bViewBones=true; // view bones
	m_bViewMesh=true;

	
	// make skin mesh
	m_Skin.MakeSample();
}

CMeshView::~CMeshView()
{
}


BEGIN_MESSAGE_MAP(CMeshView, CGLView)
	//{{AFX_MSG_MAP(CMeshView)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_UPDATE_ACTIVEVIEW, OnUpdateActiveview)
	ON_COMMAND(ID_VIEW_BONES, OnViewBones)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BONES, OnUpdateViewBones)
	ON_COMMAND(ID_VIEW_SKINMESH, OnViewSkinmesh)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SKINMESH, OnUpdateViewSkinmesh)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_UPDATE_BOUNDINGBOX, OnUpdateBoundingbox)
	//}}AFX_MSG_MAP
	
	ON_COMMAND(ID_VIEW_EXTENTS, OnViewExtents) //this functions are of its parent
	ON_COMMAND(ID_VIEW_PAN, OnViewPan) //we can directly link it without overhead
	ON_COMMAND(ID_VIEW_ROTATE, OnViewRotate)
	ON_COMMAND(ID_VIEW_ZOOM, OnViewZoom)
	ON_COMMAND(ID_VIEW_PERS, OnViewPers)
	ON_COMMAND(ID_VIEW_X, OnViewX)
	ON_COMMAND(ID_VIEW_Y, OnViewY)
	ON_COMMAND(ID_VIEW_Z, OnViewZ)
	ON_COMMAND(ID_VIEW_SECTIONZOOM, OnViewSectionzoom)
	ON_COMMAND(ID_VIEW_PERS, OnViewPers)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PERS, OnUpdateViewPers) //directly linking to parent
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOM, OnUpdateViewZoom)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ROTATE, OnUpdateViewRotate)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PAN, OnUpdateViewPan)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeshView drawing

void CMeshView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	DrawScene();
		if (!m_bPicking) Draw2D(); //show 2d only if it's normal display mode

}

/////////////////////////////////////////////////////////////////////////////
// CMeshView diagnostics

#ifdef _DEBUG
void CMeshView::AssertValid() const
{
	CGLView::AssertValid();
}

void CMeshView::Dump(CDumpContext& dc) const
{
	CGLView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMeshView message handlers
int GV_nFrame=0;  //frame number

void CMeshView::DrawScene()
{
	//initialize name stack
	glClearColor(0, 0.2, 1.0,0);
	glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT | 
    GL_STENCIL_BUFFER_BIT);



	glPushMatrix();
	//lights..
	SetLight(); //fixed light
	glEnable(GL_COLOR_MATERIAL);
	
	glEnable(GL_LIGHT0);

	//screen rotation
	//Rotated(m_DegX, 1, 0, 0); //second
	//Rotated(m_DegY, 0, 1, 0); //first
	m_Rot.Set(); //quaternion rotation
	//glRotated(-90, 1, 0, 0);
	

	double c[3]={0.8,0.8,0.8};
	if (GET_DOC->m_bShowNet) {
		CModelList& mo=GET_DOC->m_Models;
		double size= (mo.m_vMax  - mo.m_vMin).Size();
		double step=size/20;
		glPushMatrix();
		glRotated(-90, 1, 0, 0);
		DrawNet(size, size, step, step);
		glPopMatrix();
	}
	

	glColor3f(1,0,0);

	// draw model
	glDisable(GL_CULL_FACE);
	glDisable(GL_COLOR_MATERIAL);
	glPushMatrix();
	CModelList& mo=GET_DOC->m_Models;
	VECTOR cen=(mo.m_vMax+ mo.m_vMin)/2.0;
	glTranslated(-cen.x, -cen.y, -cen.z);
	
	CModelList::iterator mi;
	CModelList& m=GET_DOC->m_Models;

	for (mi=m.begin(); mi!= m.end(); mi++) 
	{
		mi->m_bShowMtr=true;
		mi->ShowObjects();
	}
	glPopMatrix();
	glEnable(GL_COLOR_MATERIAL);


	// blending
	glEnable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	// show axis
	if (GET_DOC->m_bShowAxis) {
		CModelList& mo=GET_DOC->m_Models;
		double size= (mo.m_vMax  - mo.m_vMin).Size()/4.0;
		DrawAxis2(size);
	}



	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);

	
	
	glPopMatrix();
	
}

void CMeshView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting


	
	// TODO: Add your message handler code here
	//make current rendering context valid
	//wglMakeCurrent(m_hDC, m_hRC);
	m_hDC=GetDC()->GetSafeHdc();
	wglMakeCurrent(GetDC()->GetSafeHdc(), m_hRC);

	//make viewport updated
	glDrawBuffer(GL_FRONT_AND_BACK); // <- bug fixed
    glViewport(0,0,m_nViewX,m_nViewY);
	glDrawBuffer(GL_BACK);

	OnDraw(&dc);

	// swap buffers
	if (SwapBuffers(m_hDC)==FALSE) TRACE("cannot swap buffers");

	
}

void CMeshView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CGLView::OnLButtonDown(nFlags, point);



	// show boundary
	
	// update handle variables
	GV_hActiveViewOld= GV_hActiveView;

	// turn on new
	m_bIsActive=true;
	GV_hActiveView=GetSafeHwnd();
	InvalidateRect(NULL);


	// turn off old
	CMeshView* old=  (CMeshView*) CMeshView::FromHandle(GV_hActiveViewOld);
	// only if it's different
	if (old && GV_hActiveView!=GV_hActiveViewOld) {
		old->m_bIsActive=false;
		old->InvalidateRect(NULL);
	}


	
}

void CMeshView::Draw2D()
{
	double Pro[16]; //projection matrix
	double Mod[16]; //modelview matrix 
	double m_dvTextColor[3]={0,0,0};

	//backup matrix
	glGetDoublev(GL_PROJECTION_MATRIX, Pro); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, Mod); //get modelview matrix

	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, m_dViewX, m_dViewY,0, -1000, 1000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	//glprintf(0,24, "Z-Stamp");

	// save to 2d buffer
	glGetDoublev(GL_PROJECTION_MATRIX, m_dvPro2); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, m_dvMod2); //get modelview matrix


	if (m_nCursorID==CURSOR_SECTIONZOOM && m_bLeftButton) {
		CRect& box=m_rectZoom;

		//glColor3d(1,1,1);
		glColor4dv(m_dvTextColor);
			      
		glColor3d(1,0,0);
		glEnable(GL_LINE_STIPPLE);
		glLineWidth(2);
		glLineStipple (1, 0x0101);  /*  dotted  */
		glBegin(GL_LINE_LOOP);
		glVertex3d(box.left, box.top, 0);
		glVertex3d(box.left, box.bottom, 0);
		glVertex3d(box.right, box.bottom, 0);
		glVertex3d(box.right, box.top, 0);
		glEnd();
		glDisable(GL_LINE_STIPPLE);
	}

	if (m_bIsActive) {
		glLineWidth(2);
		glColor3d(1,0.5, 0);
		glBegin(GL_LINE_LOOP);
		glVertex3d(0,0,0);
		glVertex3d(m_dViewX-1,0,0);
		glVertex3d(m_dViewX-1,m_dViewY-1,0);
		glVertex3d(0,m_dViewY-1,0);

		glEnd();

	}





	//END
	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	//RESTORE MATRIX
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixd(Pro);
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixd(Mod);


	glEnable(GL_LIGHTING);
}


void DrawSolidBox(VECTOR Min, VECTOR Max)
{
	VECTOR v0(Min.x , Min.y , Max.z );
	VECTOR v1(Min.x , Max.y , Max.z );
	VECTOR v2(Max.x , Max.y , Max.z );
	VECTOR v3(Max.x , Min.y , Max.z );

	VECTOR v4(Min.x , Min.y , Min.z );
	VECTOR v5(Min.x , Max.y , Min.z );
	VECTOR v6(Max.x , Max.y , Min.z );
	VECTOR v7(Max.x , Min.y , Min.z );

	//top & bottom
	VECTOR n;
	glBegin(GL_QUADS);
	n=(v3-v0)*(v2-v3);
	n.Normal();
	v0.Put();
	v3.Put();
	v2.Put();
	v1.Put();

	n=(v5-v4)*(v6-v5);
	n.Normal();
	v4.Put();
	v5.Put();
	v6.Put();
	v7.Put();

	n=(v1-v0)*(v5-v1);
	n.Normal();
	v0.Put();
	v1.Put();
	v5.Put();
	v4.Put();

	n=(v2-v1)*(v6-v2);
	n.Normal();
	v1.Put();
	v2.Put();
	v6.Put();
	v5.Put();

	n=(v3-v2)*(v7-v3);
	n.Normal();
	v2.Put();
	v3.Put();
	v7.Put();
	v6.Put();

	n=(v0-v3)*(v4-v0);
	n.Normal();
	v3.Put();
	v0.Put();
	v4.Put();
	v7.Put();
	glEnd();
}


void CMeshView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	switch(nChar) {
		case 'F': AfxMessageBox("Front"); break;
		case 'B': AfxMessageBox("Back"); break;
		case 'L': AfxMessageBox("Left"); break;
		case 'R': AfxMessageBox("Right"); break;

	}
	
	CGLView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMeshView::OnUpdateActiveview() 
{
	InvalidateRect(NULL);	
}

void CMeshView::OnViewBones() 
{
	m_bViewBones= ! m_bViewBones;	
}

void CMeshView::OnUpdateViewBones(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_bViewBones);
}

void CMeshView::OnViewSkinmesh() 
{
	m_bViewMesh = !m_bViewMesh;	
	InvalidateRect(NULL);
}

void CMeshView::OnUpdateViewSkinmesh(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_bViewMesh);
}

void CMeshView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CMenu muTemp, *pContextMenu;
	muTemp.LoadMenu(IDR_SPOTMENU);

	pContextMenu= muTemp.GetSubMenu(0);
	pContextMenu->TrackPopupMenu(TPM_LEFTALIGN,
	 point.x ,  point.y , AfxGetMainWnd());
	
}

// adjust bounding box
void CMeshView::OnUpdateBoundingbox() 
{
	CModelList& m=GET_DOC->m_Models;
	double r= (m.m_vMax- m.m_vMin).Size();
	MakeViewBox(r);
	KeepAspectRatio(m_AspectRatio); //keep aspect ratio
	SetViewVolume();
	InvalidateRect(NULL);
}
