// SkinSpace.cpp: implementation of the CSkinSpace class.

#include "stdafx.h"
#include "skin.h"
#include "SkinSpace.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSkinSpace::CSkinSpace()
{

}

CSkinSpace::~CSkinSpace()
{

}
// make sample mesh
void CSkinMesh::ShowPoints(void)
{
	CSkinVerts::iterator vi;
	// set color
	glColor3d(1,0.5,0);
	glBegin(GL_POINTS);
	for (vi=m_Verts.begin(); vi!=m_Verts.end();vi++) {
		vi->p.Put();
	} // end of for
	glEnd();
}
void CSkinMesh::MakeSample(void)
{
	// clear first
	m_Verts.clear();
	m_Faces.clear();

	// make mesh
	double l=0;
	double d=0; // degrees

	int ring_num; // number of rings
	int pnt_num; // number of points per ring

	ring_num=20/2+1;
	pnt_num=360/10+1;

	for (l=0;l<=20;l+=2) {
		for (d=0;d<=360;d+=10) {
			m_Verts.push_back(CSkinVert());
			CSkinVert& v= m_Verts.back();
			v.p.x=-cos(d/180.0*3.141592)*3;
			v.p.y=sin(d/180.0*3.141592)*3;
			v.p.z=l;
		}
	}

	// make faces
	int i,j;
	for (i=0;i<ring_num-1;i++) { // this is index. range is 0 <-> n-1
		for (j=0;j<pnt_num-1;j++) {
			m_Faces.push_back(CSkinFace());
			CSkinFace& face1=m_Faces.back();
			face1.a=j+i*pnt_num;
			face1.b=j+(i+1)*pnt_num;
			face1.c=j+i*pnt_num+1;

			m_Faces.push_back(CSkinFace());
			CSkinFace& face=m_Faces.back();
			face.a=j+i*pnt_num+1;
			face.b=j+(i+1)*pnt_num;
			face.c=j+(i+1)*pnt_num+1;

		} // end of for
	} // end of for

	// make bones
	m_Bone.m_Rot=QUATER(VECTOR(0,0,0), // translation
		VECTOR(1,0,0), 0); // rotation

	CSkinBone* pBone=new CSkinBone();
	ASSERT(pBone);
	pBone->m_Rot=QUATER(
		VECTOR(0,0,10), // translation
		VECTOR(1,0,0), 0); // rotation
	m_Bone.AddChild(pBone);

	// bind bone and mesh
	int idx=0;
	for (i=0;i<ring_num;i++) { // this is index. range is 0 <-> n-1
		for (j=0;j<pnt_num;j++) {
			idx=j+i*pnt_num;
			if (i<ring_num/2) { // upper arm
				m_Bone.m_nvVerts.push_back(idx);
			}
			else { 
				pBone->m_nvVerts.push_back(idx);
			}
		}
	}


	//clear first
	pBone->m_Weights.clear();
	for (i=0;i<ring_num;i++) { // this is index. range is 0 <-> n-1
		for (j=0;j<pnt_num;j++) {
			idx=j+i*pnt_num;
			if (i<ring_num/2) { // upper arm
			}
			else { 
				double n=ring_num/2;

				pBone->m_Weights.push_back(CSkinWeight(idx, (i-n)/n));
			}
		}
	}


}

void CSkinMesh::Show()
{
//	ShowPoints();
	ShowFaces(m_Verts2);
	
}

void CSkinMesh::ShowFaces(CSkinVerts& Verts)
{
	CSkinFaces::iterator fi;
	glColor3d(1,0,0);
	int i,in;
	in=m_Faces.size();
	i=0;

	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(1, 1);

	glBegin(GL_TRIANGLES);
	for (fi=m_Faces.begin(); fi!=m_Faces.end(); fi++) {

		VECTOR& va=Verts[fi->a].p;
		VECTOR& vb=Verts[fi->b].p;
		VECTOR& vc=Verts[fi->c].p;
		VECTOR n=(vb-va)*(vc-va);
		n.Normal();
		va.Put();
		vb.Put();
		vc.Put();

	} // end of for
	glEnd();


	glDisable(GL_POLYGON_OFFSET_FILL);


	glColor3d(0,0,0);
	glLineWidth(1);
	
	for (fi=m_Faces.begin(); fi!=m_Faces.end(); fi++) {

		VECTOR& va=Verts[fi->a].p;
		VECTOR& vb=Verts[fi->b].p;
		VECTOR& vc=Verts[fi->c].p;
		glBegin(GL_LINE_LOOP);
		va.Put();
		vb.Put();
		vc.Put();
		glEnd();

	} // end of for
	
}

void CSkinMesh::Deform(int nFrame)
{
	// copy mesh data to deformed data
	m_Verts2=m_Verts;

	/*CSkinVerts::iterator vi;
	for (vi=m_Verts2.begin(); vi!=m_Verts2.end(); vi++) {
		vi->p = QUATER(VECTOR(0,1,0), nFrame)*vi->p;
	}*/
	// copy done!
	m_Bone.m_Rot= QUATER(VECTOR(0,1,0) , nFrame/180.0*3.141592);

	m_Bone.m_pChild->m_Rot.r= QUATER(VECTOR(0,-1,0) , nFrame*3/180.0*3.141592).r;

	//         frame, static, deformable
	m_Bone.Deform(QUATER(), nFrame,m_Verts,m_Verts2);
}


////////////////////////////////////////////////////////////////////////

void DrawAxis(double height)
{
	double height2= height*0.5;
	double base=height2*0.1;
	
	//begin
	GLUquadricObj* obj=gluNewQuadric();
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);

	glColor4d(1,1,0,0.5);
	glutSolidCube(base*2);

	//draw Z
	glColor4d(0,0,1,0.5);
	glPushMatrix();
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw Y
	glColor4d(0,1,0,0.5);
	glPushMatrix();
	glRotated(90, -1, 0, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw X
	glColor4d(1,0,0,0.5);
	glPushMatrix();
	glRotated(90, 0, 1, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();


	gluDeleteQuadric(obj);
	//end

}
void CSkinBone::Show(QUATER Rot)
{
	QUATER new_rot= Rot*m_Rot;

	glPushMatrix();
	new_rot.Set(); // set opengl matrix

	DrawAxis(3);
	glColor3d(1,0.5, 0);
	glutSolidSphere(1, 20, 20);

	glPopMatrix();

	// recursively..
	if (m_pSibling) m_pSibling->Show(Rot);
	if (m_pChild) m_pChild->Show(new_rot);
}

void CSkinBone::Deform(QUATER Rot, int nFrame, CSkinVerts& StaticVerts, CSkinVerts &Verts)
{
	INT_LIST::iterator vi;

	// calculate new rotation
	QUATER new_rot= Rot*m_Rot;

//	m_Rot= QUATER(VECTOR(0,1,0) , nFrame/180.0*3.141592);

	for(vi=m_nvVerts.begin(); vi!=m_nvVerts.end(); vi++) {
  		CSkinVert src= StaticVerts[*vi];
		CSkinVert& dst= Verts[*vi];


		dst.p = 
			new_rot.GetRot()* (src.p - m_Rot.GetTrs())
			+
			new_rot.GetTrs();
			
			;
		// ROTATION FIRST, THEN TRANSLATION
	} // end of for

	// calculate effect of children
	CSkinBone* pChild=m_pChild;
	while(pChild!=NULL) {
		// pChild is valid!
		QUATER& rot= pChild->m_Rot; // children's quaternion
		QUATER rot2=  new_rot*rot;

		int idx=0;
		for(vi=m_nvVerts.begin(); vi!=m_nvVerts.end(); vi++) {
  			CSkinVert src= StaticVerts[*vi];
			CSkinVert dst=Verts[*vi];
			CSkinVert dst2= Verts[*vi];
			CSkinVert& out= Verts[*vi];  // final output


			dst2.p = 
				rot2.GetRot()*(src.p - rot.GetTrs())+
				rot2.GetTrs()
			 ;

			// add effect of children
			//	dst.p = (dst2.p - src.p)*0.1;
			//dst.p =dst2.p;
			int wn= pChild->m_Weights.size();
			CSkinWeight& w=pChild->m_Weights[idx];

			out.p= dst.p*(1-w.m_dWeight) + dst2.p*w.m_dWeight;


			idx++;

		}

		// go to next
		pChild=pChild->m_pSibling;
	}


	if (m_pSibling) m_pSibling->Deform(Rot,nFrame, StaticVerts, Verts);
	if (m_pChild) m_pChild->Deform(new_rot,nFrame, StaticVerts, Verts);
}
