// SkinSpace.h: interface for the CSkinSpace class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SKINSPACE_H__973FB904_2310_4A19_9CA3_899D40E350AE__INCLUDED_)
#define AFX_SKINSPACE_H__973FB904_2310_4A19_9CA3_899D40E350AE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "mathobj.h"
#include <list>
using namespace std;

typedef CVec<float> VECTOR; //vector
typedef CRot<float> QUATER; // quaternion rotation
typedef list<int>	 INT_LIST; // integer list
class CSkinVert // vertex
{ 
public:
	VECTOR p;
	CSkinVert(void) {
		p=VECTOR(0,0,0);
	}
};
class CSkinFace{ // face
public:
	int a,b,c; // three points
	CSkinFace(void) {
		a=b=c=0;
	}
};
class CSkinVerts: public  vector<CSkinVert>
{
};

class CSkinFaces: public list<CSkinFace>
{
};

class CSkinBone;

class CSkinWeight {
public:
	int m_nIdx; // vertex index
	double m_dWeight; // weight
	CSkinWeight(int Idx, double Weight) {
		m_nIdx=Idx;
		m_dWeight=Weight;
	}
};
typedef vector<CSkinWeight> CSkinWeights;

class CSkinBone{ // binary tree
public:
	void Deform(QUATER, int ,CSkinVerts&,CSkinVerts&);
	int m_nID; // id of this bone
	char m_szName[300]; // name of this bone

	INT_LIST m_nvVerts; // vertex index list

	CSkinBone* m_pSibling;  // for hierarchy
	CSkinBone* m_pChild; 

	CSkinWeights m_Weights; //weights , number is the same with the number of vertices of parent

	// translatin and scaling
	QUATER m_Rot; // quaternion rotation
	VECTOR m_Trs; // translation

	CSkinBone(void) {
		m_pSibling=m_pChild=NULL;
		m_Rot=QUATER(VECTOR(0,1,0), 0); // dummy function
		m_Trs=VECTOR(0,0,0);
		m_nID=-1;
		m_szName[0]=NULL;
	}

	// link!
	void AddChild(CSkinBone* pChild){
		if (m_pChild==NULL) m_pChild=pChild;
		else m_pChild->AddSibling(pChild);
	}
	void AddSibling(CSkinBone* pSibling) {
		if (m_pSibling==NULL) m_pSibling=pSibling;
		else m_pSibling->AddSibling(pSibling);
	}

	void Show(QUATER Rot); // show skin bone
};	

class CSkinMesh {
public:
	void Deform(int);
	void ShowFaces(CSkinVerts& Verts);
	void Show(void);
	int m_nVerts; // number of vertices
	int m_nFaces; // number of faces


	CSkinBone m_Bone; // root bone
	CSkinVerts m_Verts; // vertices 
	CSkinVerts m_Verts2; // Deformed Vertices

	CSkinFaces m_Faces; // faces
	void MakeSample(void); // make sample mesh
	void ShowPoints(void);
};
class CSkinSpace  
{
public:
	CSkinSpace();
	virtual ~CSkinSpace();

};

#endif // !defined(AFX_SKINSPACE_H__973FB904_2310_4A19_9CA3_899D40E350AE__INCLUDED_)
