// Move.cpp: implementation of the CMove class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Move.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern GV_bFastMachine;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMove::CMove()
{
}

CMove::~CMove()
{

}

//END POINT
CMove::CMove(double X, double Y, double Z,double DEG_Y, double DEG_X)
{
	//define move..
	ex=X, ey=Y, ez=Z;
	edeg_y= DEG_Y, edeg_x=DEG_X;

	frame=0;
	max_frame=30;
}

CMove::CMove(double X, double Y, double Z,double DEG_Y, double DEG_X,
			 double LEFT, double RIGHT, double BOTTOM, double TOP)
{
	//define move..
	ex=X, ey=Y, ez=Z;
	edeg_y= DEG_Y, edeg_x=DEG_X;
	eleft=LEFT, eright=RIGHT, ebottom=BOTTOM, etop=TOP;

	frame=0;
	max_frame=30;
}

//START POINT
void CMove::SetStart(double X, double Y, double Z, double DEG_Y, double DEG_X,
					 double LEFT, double RIGHT, double BOTTOM, double TOP)
{
	double AR; //aspect raito

	// Ѵ.  ÿ  ִ.
	sx=X, sy=Y, sz=Z;
	sdeg_y= DEG_Y, sdeg_x= DEG_X;
	sleft=LEFT, sright=RIGHT, sbottom=BOTTOM, stop=TOP;
	AR=(RIGHT-LEFT)/(TOP-BOTTOM);

	// ִ ڷ Aspect Ratio ٸ  ִ.
	//׷   Aspect Ratio ߾ ش 
	double height = etop-ebottom;
    double width =  height*AR;
	double cenx=(eleft+ eright) / 2.;
	double ceny=(etop+ ebottom) /2.;

	//Ŭ   
	eleft=cenx - width/2.;
	eright=cenx + width/2.;
	etop = ceny + height/2.;
	ebottom= ceny - height/2.; 

	//  
	frame=0;
	max_frame=10;
}

BOOL CMove::Animate()
{

	if (frame<=max_frame) {
		/*x=sx+ (double)frame/(double)max_frame*(ex-sx);
		y=sy+ (double)frame/(double)max_frame*(ey-sy);
		z=sz+ (double)frame/(double)max_frame*(ez-sz);

		deg_y=sdeg_y+ (double)frame/(double)max_frame*(edeg_y-sdeg_y);
		deg_x=sdeg_x+ (double)frame/(double)max_frame*(edeg_x-sdeg_x);
		
	
		left=sleft+ (double)frame/(double)max_frame*(eleft-sleft);
		right=sright+ (double)frame/(double)max_frame*(eright-sright);
		bottom=sbottom+ (double)frame/(double)max_frame*(ebottom-sbottom);
		top=stop+ (double)frame/(double)max_frame*(etop-stop);*/
		double rate=(double)frame/(double)max_frame;
		x=sx+ rate*rate*(ex-sx);
		y=sy+ rate*rate*(ey-sy);
		z=sz+ rate*rate*(ez-sz);

		deg_y=sdeg_y+ rate*rate*(edeg_y-sdeg_y);
		deg_x=sdeg_x+ rate*rate*(edeg_x-sdeg_x);
		
	
		left=sleft+ rate*rate*(eleft-sleft);
		right=sright+ rate*rate*(eright-sright);
		bottom=sbottom+ rate*rate*(ebottom-sbottom);
		top=stop+ rate*rate*(etop-stop);

		frame++;
	}
	
	if (frame>=max_frame) return FALSE;
	return TRUE;
}

void CMove::Get(double *X, double *Y, double *Z, double *DEG_Y, double * DEG_X,
				double *LEFT, double *RIGHT, double* BOTTOM, double * TOP)
{
	*X=x, *Y=y, *Z=z;
	*DEG_Y=deg_y, *DEG_X=deg_x;
	*LEFT= left, *RIGHT= right, *BOTTOM= bottom, *TOP= top;
}

BOOL CMove::IsOver()
{
	if (frame>max_frame) return TRUE;
	else return FALSE;
}

BOOL CMove::IsStart()
{
	if (frame==0) return TRUE;
	else return FALSE;
}

