//---Classes code by Zippy Started 7/29/99---//

#ifndef __Classes_h
#define __Classes_h

//Moved from uox3.h
struct tile_st
{
 SI32 unknown1;  // longs must go at top to avoid bus errors - fur
 SI32 animation;
 unsigned char flag1;
 unsigned char flag2;
 unsigned char flag3;
 unsigned char flag4;
 unsigned char weight;
 signed char layer;
 signed char unknown2;
 signed char unknown3;
 signed char height;
 signed char name[23];	// manually padded to long to avoid bus errors - fur
} PACK_NEEDED;

struct land_st
{
 unsigned char flag1;
 unsigned char flag2;
 unsigned char flag3;
 unsigned char flag4;
 char unknown1;
 char unknown2;
 char name[20];
};

class cItemHandle
{
protected:
	item_st *DefaultItem;//The item send if an out of bounds is referenced.

	vector<item_st *> Items;//Vector of pointers to items, NULL if no item at that pos
	unsigned long Acctual; //Number of items in existance

	vector<unsigned long> FreeNums;//Vector of free item numbers
	unsigned int Free; //Number of free spaces in Acctual (Recyle item numbers)
	bool isFree( unsigned long Num );//Check to see if this item is marked free

public:
	cItemHandle( void ); //Class Constructor
	~cItemHandle();//Class Destructor

	unsigned long New( void );//Get Memory for a new item, Returns Item number
	void Delete( long int );//Free memory used by this item
	unsigned long Size( void );//Return the size (in bytes) of ram items are taking up
	void Reserve( unsigned int );//Reserve memory for this number of items (UNUSED)
	unsigned long Count( void );//Return Acctual-> the number of items in world.

	item_st& operator[] ( long int );//Reference an item
};

class cCharacterHandle
{
protected:
	char_st *DefaultChar;//The item send if an out of bounds is referenced.

	vector<char_st *> Chars;//Vector of pointers to items, NULL if no item at that pos
	unsigned long Acctual; //Number of items in existance

	vector<unsigned long> FreeNums;//Vector of free item numbers
	unsigned int Free; //Number of free spaces in Acctual (Recyle item numbers)
	bool isFree( unsigned long Num );//Check to see if this item is marked free

public:
	cCharacterHandle( void ); //Class Constructor
	~cCharacterHandle();//Class Destructor

	unsigned long New( void );//Get Memory for a new character, Returns char number
	void Delete( long int );//Free memory used by this character
	unsigned long Size( void );//Return the size (in bytes) of ram characters are taking up
	void Reserve( unsigned int );//Reserve memory for this number of characters (UNUSED)
	unsigned long Count( void );//Return Acctual-> the number of characters in world.

	char_st& operator[] ( long int );//Reference a character
};

class cShop
{
private:
//	void LogClassNPC();
	void iniSpawn(int uNpc);
	void setRestrict(int npc, int loc, int tempNum);
	void setLocation(int property, int where, int loc);
	void setMaxNPC(int amount, int loc);
	void setResource(int resource, int amount, int loc);
	void setResourceKey(int resource, int amount);
	int OrganizeResource();
	int FindShop(int town);
	bool CheckResource(int uShop);
	bool CheckPop(int uShop);
	bool CheckRestrict(int uShop, int uNpc);
public:
	void readClassNPC();
//	void loadShopRegions();
	void loadShop();
	Shops *shop;
	classnpc *cNpc;
	void PickNPC();
	void PickRandNPC();
	bool LocateShop(int shopNum);
	void AddCurrentNPC(int loc);
	void SubCurrentNPC(int loc);
	void setCurrentNPC(int amount, int loc);
	void FindCurrentNPC(int loc);
};


class cAdmin   // Revana*
{
private:
	void Account();
	void ReadString();
	void Wiped( void );
	void GumpALine( int line );
	void GumpAText( int line, int s );
public:
	void LoadAccounts();
	void ReadIni();
	void LoadWipe( void );
	void GumpAMenu( int s, int j );
	void CheckLocks( int nAcct );
};

class cCombat
{
private:
	void ItemCastSpell(int s, int c, int i);
	int TimerOk(int c);
	void ItemSpell(int attacker, int defender);
	void doSoundEffect( CHARACTER p, int fightskill, ITEM weapon ); // AntiChrist
	void doMissedSoundEffect( CHARACTER p ); // AntiChrist
public:
	int GetSwingRate( int iNPC, int weapon );
	int GetArrowType( int i );
	int GetBowType(int i);
	int GetWeapon(int i);
	int CalcAtt(int p);
	int CalcDef(int p, int x);
	void CombatOnHorse(int i);
	void CombatOnFoot(int i);
	void CombatHit(int a, int d, unsigned int currenttime, signed int arrowType = -1 );
	void DoCombat(int a, unsigned int currenttime);
	void SpawnGuard( CHARACTER s, CHARACTER i, int x, int y, signed char z);
	bool weapon2Handed( int weapon );
	int CalcDefA( int defend, int HitLoc_1, int damage );
};

class cCommands
{
public:
	void NextCall(int s, int type);
	void RepairWorld(int s);
	void KillSpawn(int s, int r);
	void RegSpawnMax(int s, int r);
	void RegSpawnNum(int s, int r, int n);
	void KillAll(int s, int percent, char * sysmsg);
	void AddHere(int s, char z);
	void ShowGMQue(int s, int type);
	void Wipe(int s);
	void WhoCommand(int s, int type, int buttonnum);
	void CPage(int s, char * reason);
	void GMPage(int s, char * reason);
	void MakePlace(int s, int i);
	void Command( int s);
	void MakeShop(int c);
  void RemoveShop(int s);
	void DyeItem(int s);
	void SetItemTrigger(int s);
	void SetTriggerType(int s);
	void SetTriggerWord(int s);
	void SetNPCTrigger(int s);
	void DupeItem(int s, int i, int amount);
	void Possess(int s);
	void Load( void );
	signed int FindIndex( char *toFind );
	int cmd_offset;
};

class cGuilds
{
private:
	void EraseMember(int c);
	void EraseGuild(int guildnumber);
	void ToggleAbbreviation(int s);
	int SearchSlot(int guildnumber, int type);
	void ChangeName(int s, char *text);
	void ChangeAbbreviation(int s, char *text);
	void ChangeTitle(int s, char *text);
	void ChangeCharter(int s, char *text);
	void ChangeWebpage(int s, char *text);
	int CheckValidPlace(int x, int y);
	void Broadcast(int guildnumber, char *text);
	void CalcMaster(int guildnumber);
	void SetType(int guildnumber, int type);
public:
	guild_st guilds[MAXGUILDS]; //lb, moved from uox3.h cauz global variabels cant be changed in constuctors ...
	cGuilds();
	virtual ~cGuilds();
	void StonePlacement(int s);
	void Menu(int s, int page);
	void Resign(int s);
	void Recruit(int s);
	void TargetWar(int s);
	void StoneMove(int s);
	int Compare(int player1, int player2);
	void GumpInput(int s, int type, int index, char *text);
	void GumpChoice(int s, int main, int sub);
	int SearchByStone(int s);
	//void Init();
	void Title(int s, int player2);
	void Read(int guildnumber);
	void Write( FILE *wscfile );
};

class cGump
{
public:
	void Button(int s, int button, unsigned char tser1, unsigned char tser2, unsigned char tser3, unsigned char tser4, char type);
	void Input(int s);
	void Menu(int s, int m);
	void Open(int s, int i, int num, int num2);
};

class cItem
{
public:
	void GlowItem( UOXSOCKET s, int i );
	int MemItemFree();
	void DeleItem(int i);
	int CreateScriptItem(int s, int itemnum, int nSpawned);
	int CreateRandomItem(char *sItemList);
	int CreateScriptRandomItem(int s, char *sItemList);
	int SpawnItem(UOXSOCKET nSocket, CHARACTER ch, int nAmount, char* cName, int nStackable,
        unsigned char cItemId1, unsigned char cItemId2, unsigned char cColorId1, unsigned char cColorId2, int nPack, int nSend);
	int SpawnItem(UOXSOCKET nSocket, int nAmount, char* cName, int nStackable, unsigned char cItemId1, unsigned char cItemId2, unsigned char cColorId1, unsigned char cColorId2, int nPack, int nSend);
	int SpawnItemBackpack2(UOXSOCKET s, CHARACTER ch, int nItem, int nDigging);
	void GetScriptItemSetting( int c ); // by Magius (CHE)
	void DecayItem(unsigned int currenttime, int i);
	void Decay(unsigned int currenttime);
	void RespawnItem(unsigned int Currenttime, int i);
	void AddRespawnItem(int s, int x, int y);
	void AddRandomItem(int s, char *itemlist, int spawnpoint);
	void InitItem(int nItem, char ser=1);
	char isFieldSpellItem(int i);
	bool isShieldType( int i );
	ARMORCLASS ArmorClass( ITEM i );
	unsigned char PackType( unsigned char id1, unsigned char id2 );
	void CheckEquipment( CHARACTER p );  // AntiChrist
	void BounceInBackpack( CHARACTER p, ITEM i ); // AntiChrist
	void BounceItemOnGround( CHARACTER p, ITEM i ); // AntiChrist
};

// full comments on this class are available in mapstuff.cpp
class MapStaticIterator
{
private:
	staticrecord staticArray;
	SI32 baseX, baseY, pos;
	unsigned char remainX, remainY;
	UI32 index, length, tileid;
	bool exactCoords;

public:
	MapStaticIterator(unsigned int x, unsigned int y, bool exact = true);
	~MapStaticIterator() { };

	staticrecord *First();
	staticrecord *Next();
	void GetTile(tile_st *tile) const;
	UI32 GetPos() const { return pos; }
	UI32 GetLength() const { return length; }
};

const int MapTileWidth = 768;
const int MapTileHeight = 512;

class cMapStuff
{
//Variables
private:
	friend class MapStaticIterator;

        // moved from global vars into here - fur 11/3/1999
        UOXFile *mapfile, *sidxfile, *statfile, *verfile, *tilefile, *multifile, *midxfile;

	// tile caching items
	tile_st tilecache[0x4000];

	// static caching items
	unsigned long StaticBlocks;
	struct StaCache_st
	{
		staticrecord *Cache;
		unsigned short CacheLen;   // i've seen this goto to at least 273 - fur 10/29/1999
	};

	// map caching items
	struct MapCache
	{
		unsigned short xb;
		unsigned short yb;
		unsigned char  xo;
		unsigned char  yo;
		map_st Cache;
	};
	MapCache Map0Cache[MAP0CACHE];

	// version caching items
	versionrecord *versionCache;
	UI32 versionRecordCount;

	// caching functions
	void CacheTiles( void );
	void CacheStatics( void );

public:
	// these used to be [512], thats a little excessive for a filename.. - fur
	char mapname[80], sidxname[80], statname[80], vername[80],
	  tilename[80], multiname[80], midxname[80];
	unsigned long StaMem, TileMem, versionMemory;
	unsigned int Map0CacheHit, Map0CacheMiss;
	// ok this is rather silly, allocating all the memory for the cache, even if
	// they haven't chosen to cache?? - fur
	StaCache_st StaticCache[MapTileWidth][MapTileHeight];
	unsigned char Cache;
	
// Functions
private:
	char VerLand(int landnum, land_st *land);
	//char OldStaWalk(int x, int y, int oldz);
//	int MultiHeight(int i, int x, int y, int oldz);
	signed char MultiHeight(int i, short int x, short int y, signed char oldz);
//	int MultiTile(int i, int x, int y, int oldz);
	int MultiTile(int i, short int x, short int y, signed char oldz);
	SI32 VerSeek(SI32 file, SI32 block);
	char VerTile(int tilenum, tile_st *tile);
	bool IsTileWet(int tilenum);
	bool TileWalk(int tilenum);
	void CacheVersion();

//	int DynTile(int x, int y, int oldz);
	int DynTile( short int x, short int y, signed char oldz );
	bool DoesTileBlock(int tilenum);
//	bool DoesStaticBlock(int x, int y, int oldz);
	bool DoesStaticBlock(short int x, short int y, signed char oldz);
	// unused char MapType(int x, int y);

public:
	cMapStuff();
	~cMapStuff();

	void Load();

	// height functions
	bool IsUnderRoof(short int x, short int y, signed char z);
	signed char StaticTop(short int x, short int y, signed char oldz);
	signed char DynamicElevation(short int x, short int y, signed char oldz);
	signed char MapElevation(short int x, short int y);
	signed char AverageMapElevation(short int x, short int y, int &id);
	signed char TileHeight( int tilenum );
	signed char Height(short int x, short int y, signed char oldz);

	// look at tile functions
	void MultiArea(int i, int *x1, int *y1, int *x2, int *y2);
	void SeekTile(int tilenum, tile_st *tile);
	void SeekMulti(int multinum, UOXFile **mfile, SI32 *length);
	void SeekLand(int landnum, land_st *land);
	map_st SeekMap0( unsigned short x, unsigned short y );
	bool IsRoofOrFloorTile( tile_st *tile );
	bool IsRoofOrFloorTile( unitile_st *tile );

	// misc functions
	bool CanMonsterMoveHere( short int x, short int y, signed char z );
	//char o_Type(int x, int y, int oldz);
};

// use this value whereever you need to return an illegal z value
const signed char illegal_z = -128;	// reduced from -1280 to -128, to fit in with a valid signed char

class cCharStuff
{
private:
	void FindSpotForNPC(int c, int originX, int originY, int xAway, int yAway, int elev);
	int  SearchSubPackForItem( ITEM toSearch, unsigned char type );
	int  SearchSubPackForItem( ITEM toSearch, unsigned char id1, unsigned char id2 );

public:
	void DeleteChar(int k);
	int MemCharFree();
	int AddRandomLoot(int s, char * lootlist);
	int AddRandomNPC(int s, char *npclist, int spawnpoint);
	int AddRespawnNPC(int s, int region, int npcNum, int type);
	int AddNPCxyz(int s, int npcNum, int type, int x1, int y1, signed char z1);
	int Split(int k);
	void CheckAI(unsigned int currenttime, int i);
	void InitChar(int nChar, char ser=1);
	int FindItem( CHARACTER toFind, unsigned char type );
	int FindItem( CHARACTER toFind, unsigned char id1, unsigned char id2 );
};

class cSkills
{
private:
	int GetSubIngotAmt(int p, char id1, char id2, char color1, char color2);
	void DeleIngot(int s, int id1, int id2, int color1, int color2, int amount);
	int DeleSubIngot(int p, int id1, int id2, int color1, int color2, int amount);
	//void AnvilTarget(int s, int m, int color1 = 0x1B, int color2 = 0xF2);
	void AnvilTarget( int s, int m, int makemenu = 1, unsigned char id1 = 0x1B, unsigned char id2 = 0xF2, unsigned char color1 = 0x00, unsigned char color2 = 0x00 );
	void AnvilTargetGold(int s, int m);
	void AnvilTargetSilver(int s, int m);
	void AnvilTargetAdam(int s, int m);
	void AnvilTargetMyth(int s, int m);
	void AnvilTargetBronze(int s, int m);
	void AnvilTargetVerite(int s, int m);
	void AnvilTargetMerk(int s, int m);
	void AnvilTargetCop(int s, int m);
	void AnvilTargetAgap(int s, int m);
	void Atrophy( CHARACTER c, unsigned short sk );
	void Hide(int s);
	void Stealth(int s);
	void PeaceMaking(int s);
	void PlayInstrumentWell(int s, int i);
	void PlayInstrumentPoor(int s, int i);
	int GetInstrument(int s);
	void RandomSteal(int s);
	int TrackingDirection(int s, int i);
	void TellScroll(char *menu_name, int player, long item_param);
	void CollectAmmo(int s, int a, int b);
	void Meditation(int s);
	int CalcRank( int s, int skill ); // by Magius(CHE)
	void ApplyRank( int s, int c, int rank ); // by Magius(CHE)
	void Zero_Itemmake( int s ); // by Magius(CHE)

public:
	void Tracking( int s, int selection );
	void CreatePotion(int s, char type, char sub, int mortar);
	void Fish(unsigned int i);
	int GetIngotAmt(int s, unsigned char id1, unsigned char id2, unsigned char color1, unsigned char color2);
	char AdvanceSkill(int s, int sk, char skillused);
	void AdvanceStats(int s, int sk);
	void TinkerAxel(int s);
	void TinkerAwg(int s);
	void TinkerClock(int s);
	void MakeDough(int s);
	void MakePizza(int s);
	void Track(int i);
	void DoPotion(int s, int type, int sub, int mortar);
	void Tailoring(int s);
	void Fletching(int s);
	void BowCraft(int s);
	void Carpentry(int s);
	void Smith(int s);
	void MakeMenuTarget(int s, int x, int skill);
	void MakeMenu(int s, int m, int skill);
	void Mine(int s);
	void GraveDig(int s);
	void SmeltOre(int s);
	void Wheel(int s, int mat);
	void Loom(int s);
	void CookMeat(int s);
	void TreeTarget(int s);
	void DetectHidden(int s);
	void ProvocationTarget1(int s);
	void ProvocationTarget2(int s);
	void EnticementTarget1(int s);
	void EnticementTarget2(int s);
	void AlchemyTarget(int s);
	void BottleTarget(int s);
	void PotionToBottle(int s, int mortar);
	char CheckSkill(int s, int sk, int low, int high);
	void CreateBandageTarget(int s);
	void HealingSkillTarget(int s);
	void SpiritSpeak(int s);
	void ArmsLoreTarget(int s);
	void ItemIdTarget(int s);
	void Evaluate_int_Target(int s);
	void AnatomyTarget(int s);
	void TameTarget(int s);
	void FishTarget(int s);
	int GetCombatSkill(int i);
	int GetShield(int i);
	void SkillUse(int s, int x);
	void StealingTarget(int s);
	void CreateTrackingMenu(int s, int m);
	void TrackingMenu(int s, int gmindex);
	void BeggingTarget(int s);
	void AnimalLoreTarget(int s);
	void ForensicsTarget(int s);
	void PoisoningTarget(int s);
	int Inscribe(int s, long snum);
	int EngraveAction(int s, int i, int cir, int spl);
	void updateSkillLevel(int c, int s);
	void LockPick(int s);
	void TDummy(int s);
	void NewDummy(unsigned int currenttime);
	void Tinkering(int s);
	void AButte(int s1, int x);
	void Persecute( UOXSOCKET s ); // AntiChrist persecute stuff
};

class cTownStones
{
private:
	void Line(int line, int j, char type, int s);
	void Text(int line, int j, char type, int s);
	char *TownMayor(int j);
	char *MayorVote(int s);
	int Population(int j);
public:
	cTownStones(); // LB might not work, but I dont care because nobody uses that unfished thing anymore
	virtual ~cTownStones();
	void Menu(int s, int j, int type);
	char *TownName(int s, int type);
	void CalcNewMayor(int j);
	void VoteForMayorTarget(int s);
};

class cWeight
{
private:
	double RecursePacks(int bp);
	int WhereSub(int i, int p);
	char CheckMaxWeightPack(int chars);
	void AddItemWeight(int i, int s);
	void SubtractItemWeight(int i, int s);
	void SubtractQuanWeight(int i, int s, int total);
	void AddAmountWeight(int i, int s, int amount);
	int WhereItem(int p, int i, int s);
public:
	int CheckWeight(int s, int k);
	int CheckWeight2(int s);
	void NewCalc(int p);
	double CalcWeightPack(int backpack);
	int ItemWeight(int item);
	int CheckWhereItem(int pack, int i, int s);
};

class cTargets
{
private:
	void GuardTarget( UOXSOCKET s );
	void GlowTarget( UOXSOCKET s );
	void UnglowTarget( UOXSOCKET s );
	void PlVBuy(int s);
	void RenameTarget(int s);
	void AddTarget(int s);
	void TeleTarget(int s);
	void RemoveTarget(int s);
	void DyeTarget(int s);
	void NewzTarget(int s);
	void TypeTarget(int s);
	void XgoTarget(int s);
	void MoreXYZTarget(int s);
	void MoreXTarget(int s);
	void MoreYTarget(int s);
	void MoreZTarget(int s);
	void PrivTarget(int s);
	void MoreTarget(int s);
	void KeyTarget(int s);
	void IstatsTarget(int s);
	void CstatsTarget(int s);
	void WstatsTarget(int s);
	void GMTarget(int s);
	void CnsTarget(int s);
	void KillTarget(int s, int ly);
	void FontTarget(int s);
	void GhostTarget(int s);
	void AmountTarget(int s);
	void SetAmount2Target(int s);
	void CloseTarget(int s);
	void VisibleTarget(int s);
	void OwnerTarget(int s);
	void ColorsTarget(int s);
	void DvatTarget(int s);
	void AddNpcTarget(int s);
	void FreezeTarget(int s);
	void UnfreezeTarget(int s);
	void AllSetTarget(int s);
	void InfoTarget(int s);
	void TweakTarget(int s);
	void LoadCannon(int s);
	void SetInvulFlag(int s);
	void Tiling(int s);
	void ExpPotionTarget(int s);
	void SquelchTarg(int s);
	void TeleStuff(int s);
	void SwordTarget(int s);
	void CorpseTarget(int s);
	void CarveTarget(int s, int feat, int ribs, int hides, int fur, int wool);
	void newCarveTarget( UOXSOCKET s, ITEM i );
	void TitleTarget(int s);
	void NpcTarget(int s);
	void NpcTarget2(int s);
	void NpcRectTarget(int s);
	void NpcCircleTarget(int s);
	void NpcWanderTarget(int s);
	void NpcAITarget(int s);
	void xBankTarget(int s);
	void xSpecialBankTarget( int s ); // AntiChrist
	void DupeTarget(int s);
	void MoveToBagTarget(int s);
	void SellStuffTarget(int s);
	void GmOpenTarget(int s);
	void StaminaTarget(int s);
	void ManaTarget(int s);
	void MakeShopTarget(int s);
	void AttackTarget(int s);
	void FollowTarget(int s);
	void TransferTarget(int s);
	void BuyShopTarget(int s);
	void SetValueTarget(int s);
	void SetRestockTarget(int s);
	void permHideTarget(int s);
	void unHideTarget(int s);
	void SetWipeTarget(int s);
	void SetSpeechTarget(int s);
	void SetSpAttackTarget(int s);
	void SetPoisonTarget(int s);
	void SetPoisonedTarget(int s);
	void FullStatsTarget(int s);
	void SetAdvObjTarget(int s);
	void CanTrainTarget(int s);
	void SetSplitTarget(int s);
	void SetSplitChanceTarget(int s);
	void AxeTarget(int s);
	void ObjPrivTarget(int s);
	void SetSpaDelayTarget(int s);
	void NewXTarget(int s);
	void NewYTarget(int s);
	void IncXTarget(int s);
	void IncYTarget(int s);
	void BoltTarget(int s);
	void MovableTarget(int s);
	void SetDirTarget(int s);
	void HouseOwnerTarget(int s);
	void HouseEjectTarget(int s);
	void HouseBanTarget(int s);
	void HouseFriendTarget(int s);
	void HouseUnlistTarget(int s);
	void BanTarg(int s);
	void triggertarget( int ts ); // By Magius(CHE)
	void ShowSkillTarget( int s );
	void ResurrectionTarget( UOXSOCKET s );
	void SetMurderCount( int s );	// Abaddon 12 Sept 1999
	void HouseLockdown( UOXSOCKET s ); // Abaddon 17th December, 1999
	void HouseRelease( UOXSOCKET s ); // Abaddon 17th December 1999
	void ShowDetail( UOXSOCKET s ); // Abaddon 11th January, 2000
public:
	void GetAccount( int s );
	void IDtarget(int s);
	void MultiTarget(int s);
	void Wiping(int s);
	int NpcMenuTarget(int s);
	void NpcResurrectTarget(int s);
	void JailTarget(int s, int c);
	void ReleaseTarget(int s, int c);
	int AddMenuTarget(int s, int x, int addmitem);
	void XTeleport(int s, int x);
	int BuyShop(int s,int c);
};

class cNetworkStuff
{
public:
	cNetworkStuff();
	~cNetworkStuff();
	void xSend(int s, void *point, int length, int test);
	void Disconnect(int s);
	void ClearBuffers();
	void CheckConn();
	void CheckMessage();
	void SockClose();
	void FlushBuffer(int s);
	int kr,faul; // needed because global varaibles cant be changes in constructores LB
	void UDPInit( void );
	void UDPCheckConn( void ); // Check for connection requests
private:
	void GenTable(int s, char a1, char a2, char a3, char a4);
	void DoStreamCode(int s);
#if CLIENTVERSION_M==25
	char Crypt(int s, char c);
#endif 
	int xRecv(int s);
	void Processed(int s, int i);
	void Login1(int s);
	void Relay(int s);
	void GoodAuth(int s);
	void FailAuth(int s);
	void AuthTest(int s);
	void CharList(int s);
	int Receive(int s, int x, int a);
	void GetMsg(int s);
	void LogOut(int s);
	void pSplit(char *pass0);
	void sockInit( void );
	
};

class cMagic
{
public:
	//:Terrin: adding constructor/destructor
	cMagic();
	~cMagic(); // no need for a virtual destructor as long as no subclasses us

	void LoadScript( void ); //:Terrin: adding function for spell system "cache"
	void SpellBook(int s);
	char GateCollision(int s);
	void GateDestruction(unsigned int currenttime);
	bool newSelectSpell2Cast( int s, int num );
	bool requireTarget( unsigned char num );
	bool reqItemTarget( int num );
	bool reqLocTarget( int num );
	bool reqCharTarget( int num );
	bool spellReflectable( int num );
	bool travelSpell( int num );
	stat_st getStatEffects( int num );
	move_st getMoveEffects( int num );
	sound_st getSoundEffects( int num );
	bool aggressiveSpell( int num );
	bool fieldSpell( int num );
	void doMoveEffect( int num, int target, int source );
	void doStaticEffect( int source, int num );
	void playSound( int source, int num );
	void NewDelReagents( CHARACTER s, reag_st reags );
	void NewCastSpell( UOXSOCKET s );
//	void SpellTarget( UOXSOCKET s );
//	void InvisTarget(int s);
//	void Reveal(int s);
//	void MagicArrowTarget(int s);
//	void EVTarget(int s);
//	void BSTarget(int s);
//	void FlameStrikeTarget(int s);
//	void ExplosionTarget(int s);
//	void CannonTarget(int s);
//	void LightningTarget(int s);
//	void Fireballtarget(int s);
//	void EBoltTarget(int s);
//	void HealTarget(int s);
//	void GreaterHealTarget(int s);
//	void Harmtarget(int s);
	void SbOpenContainer(int s);
//	void WallofStoneTarget(int s);
//	void ParaFieldTarget(int s);
//	void EnergyFieldTarget(int s);
//	void FireFieldTarget(int s);
//	void PoisonFieldTarget(int s);
//	void DispelFieldTarget(int s);
//	void ParalyzeTarget(int s);
//	void MindBlastTarget(int s);
//	void DispelTarget(int s);
//	void NightSightTarget(int s);
//	void ClumsyTarget(int s);
//	void FeebleMindTarget(int s);
//	void WeakenTarget(int s);
//	void AgilityTarget(int s);
//	void CunningTarget(int s);
//	void StrengthTarget(int s);
//	char CheckResist(int s);
	char CheckResist( CHARACTER attacker, CHARACTER defender, int circle );	// umm, why?
	void PoisonDamage(int p, int posion);
	void CheckFieldEffects2(unsigned int currenttime, int c, char timecheck);
//	void CheckFieldEffects(unsigned int currenttime);
//	void CurseTarget(int s);
//	void PoisonTarget(int s);
//	void CureTarget(int s);
//	void ManaDrainTarget(int s);
//	void ManaVampireTarget(int s);
//	void MeteorSwarmPTarget(int s);
//	void ChainLightningTarget(int s);
//	void ArchCureTarget(int s);
//	void ArchProtection(int s);
//	void MassDispelTarget(int s);
//	void MagicLockTarget(int s);
//	void MagicTrapTarget(int s);
//	void MagicUntrapTarget(int s);
	void PFireballTarget(int i, int k, int j);
//	void CreateFoodTarget(int s);
//	void ResurrectTarget(int s);
	void NPCFireballTarget(int nAttacker, int nDefender);
	void NPCLightningTarget(int nAttacker, int nDefender);
	void NPCCurseTarget(int nAttacker, int nDefender);
	void NPCWeakenTarget(int s, int t);
	void NPCFeebleMindTarget(int s, int t);
	void NPCCLumsyTarget(int s, int t);
	void NPCMindBlastTarget(int s, int t);
	void NPCMagicArrowTarget(int s, int t);
	void NPCClumsyTarget(int s, int t);
	void NPCHarmTarget(int s, int t);
	void NPCHarmtarget(int s, int t);
	void NPCParalyzeTarget(int s, int t);
	void NPCEBoltTarget(int s, int t);
	void NPCExplosionTarget(int s, int t);
	void NPCCannonTarget(int s, int t);
	char CheckParry(int player, int circle);
	void NPCFlameStrikeTarget(int s, int t);
	void MagicArrowSpellItem(int attacker, int defender);
	void ClumsySpellItem(int attacker, int defender);
	void FeebleMindSpellItem(int attacker, int defender);
	void WeakenSpellItem(int attacker, int defender);
	void HarmSpellItem(int attacker, int defender);
	void FireballSpellItem(int attacker, int defender);
	void CurseSpellItem(int attacker, int defender);
	void LightningSpellItem(int attacker, int defender);
	void MindBlastSpellItem(int attacker, int defender);
	void ParalyzeSpellItem(int attacker, int defender);
	void ExplosionSpellItem(int attacker, int defender);
	void FlameStrikeSpellItem(int attacker, int defender);
//	void FireballTarget(int s);
//	void HarmTarget(int s);
//	char CheckResist(int player, int circle);
//	void BlessTarget(int s);
//	void MassCurseTarget(int s);
	int CheckBook(int circle, int spell, int i);
//	char CheckReagents(int s, int ash, int drake, int garlic, int ginseng, int moss, int pearl, int shade, int silk);
	char CheckReagents( int s, reag_st reagents );
//	char CheckMana(int s, int circle);
	char CheckMana( int s, int num );
	void DeleReagents(int s, int ash, int drake, int garlic, int ginseng, int moss, int pearl, int shade, int silk);
	void Recall( UOXSOCKET s); // we need these four for the commands (separately) !!!
	void Mark( UOXSOCKET s);
	void Gate( UOXSOCKET s);
	void Heal( UOXSOCKET s);
//	void BuildCannon(int s);
	char CheckMagicReflect(int i);
	void MagicDamage(int p, int amount);
	void SpellFail(int s);
	char SubtractMana(int s, int mana);
//	void ReactiveArmorTarget(int s);  // moved here by AntiChrist (9/99)
	void MagicTrap(int s, int i);	// moved here by AntiChrist (9/99)
	void Polymorph( int s, int gmindex, int creaturenumer); // added by AntiChrist (9/99)


private:
//	void EarthQuake(int s);
	void SummonMonster(int s, unsigned char d1, unsigned char id2, char *monstername, unsigned char color1, unsigned char color2, int x, int y, int z);
	void MagicReflect(int s);
	void BoxSpell(int s, int& x1, int& x2, int& y1, int& y2, int& z1, int& z2);
	//void RegMsg(int s);
	int RegMsg( CHARACTER s, reag_st failmsg );
	void DirectDamage(int p, int amount);
	void PolymorphMenu( int s, int gmindex ); // added by AntiChrist (9/99)

//	splInfo_st *spells; //:Terrin: adding variable for spell system "cache" had to make global for skills.cpp as a quick fix
};

class cMovement
{
	// Variables:
private:
//	signed short z, dispz;
	signed char z, dispz;
	// Functions:
public:
	void CombatWalk( int s );
//	int validNPCMove( int x, int y, int z, CHARACTER s );
	int validNPCMove( short int x, short int y, signed char z, CHARACTER s );
	void NpcMovement( unsigned int currenttime, int i );
	void Walking( CHARACTER s, int dir, int seq );
private:
	void NpcWalk( CHARACTER i, int j, int type );
	char UniBlock( CHARACTER s, unitile_st xyblock );
	unsigned short GetXfromDir( int dir, unsigned short x );
	unsigned short GetYfromDir( int dir, unsigned short y );
	void PathFind( CHARACTER c, unsigned short gx, unsigned short gy );

	// Walking() used to be a huge monolithic function, its now been
	// broken down into pieces
	bool VerifySequence(CHARACTER c, UOXSOCKET socket, int sequence);
	bool CheckWeightFirst(CHARACTER c, UOXSOCKET socket);
	bool CheckForFrozen(CHARACTER c, UOXSOCKET socket);
	bool CheckForRunning(CHARACTER c, UOXSOCKET socket, int dir);
	bool CheckForStealth(CHARACTER c, UOXSOCKET socket);
	bool CheckForHouseBan(CHARACTER c, UOXSOCKET socket);
	void MoveCharForDirection(CHARACTER c, int dir);
	void FillXYBlockStuff(CHARACTER c, unitile_st *xyblock, int &xycount);
//	bool CrazyXYBlockStuff(CHARACTER c, UOXSOCKET socket, int oldx, int oldy, int sequence);
	bool CrazyXYBlockStuff(CHARACTER c, UOXSOCKET socket, short int oldx, short int oldy, int sequence );
	void HandleRegionStuffAfterMove(CHARACTER c, short int oldx, short int oldy);
	void SendWalkToPlayer(CHARACTER c, UOXSOCKET socket, short int sequence);
	void SendWalkToOtherPlayers(CHARACTER c, int dir, short int oldx, short int oldy);
	void OutputShoveMessage(CHARACTER c, UOXSOCKET socket, short int oldx, short int oldy);
	void HandleItemCollision(CHARACTER c, UOXSOCKET socket, bool amTurning);
	void HandleTeleporters(CHARACTER c, UOXSOCKET socket, short int oldx, short int oldy);
	void HandleWeatherChanges(CHARACTER c, UOXSOCKET socket);
	void HandleGlowItems(CHARACTER c, UOXSOCKET socket);
	bool IsGMBody(CHARACTER c);
//	int  CheckWalkable( CHARACTER c, unitile_st *xyblock, int xycount );
	signed char CheckWalkable( CHARACTER c, unitile_st *xyblock, int xycount );
};

// This class is designed as a replacement for the teffect array (which is nasty, and too big)
// It'll grow and shrink as required, and will hopefully help reduce memory troubles
class cTEffect
{
private:
	vector< teffect_st * > internalData;
	UI16 effectCount;
	UI16 currentEffect;
	bool delFlag;

public:
	cTEffect();
	~cTEffect();
	teffect_st *First( void );				// returns the first entry
	teffect_st *Current( void );			// returns current entry
	teffect_st *Next( void );				// returns the next entry
	bool AtEnd( void );						// have we hit the end?
	bool Add( teffect_st toAdd );			// adds another entry
	bool DelCurrent( void );				// deletes the current entry
	UI16 Count( void );						// returns count of number of effects
	teffect_st *GrabSpecific( UI16 index );	// grabs a specific index
};

#endif
