#include "uox3.h"
#include "debug.h"

#define DBGFILE "combat.cpp"
#define SWINGAT (unsigned int)1.75 * CLOCKS_PER_SEC


//#define __COMBATDEBUG__		// if this is defined, then the combat debug messages are printed

int cCombat::GetSwingRate( int iNPC, int weapon )
{
	// PRE: Get calculate swing rate
	// POST: The amount of seconds for one swing
	int sRate = 0;
	int speed = 1;

	Skills->GetCombatSkill( iNPC );

	if( weapon==-1) weapon = GetWeapon( iNPC );

	int stamina = chars[iNPC].stm;
#ifdef __COMBATDEBUG__
	printf("Stamina is %i...", stamina );
#endif
	if( weapon != -1 )
	{
		speed = items[weapon].spd;
#ifdef __COMBATDEBUG__
		printf("Item %s [%i]...", items[weapon].name, weapon );
#endif
	}
	else speed = combat.wrestleSpeed;
#ifdef __COMBATDEBUG__
	printf("Speed is %i...", speed );
#endif
	sRate = 16000 / ( ( ( stamina+100 ) * speed ) + 1 );		// Abaddon, was 15000, increased because of slightly slow swing speed
#ifdef __COMBATDEBUG__
	printf("sRate is %i\n", sRate );
#endif
	if( sRate <= 0 ) sRate = 1;

	return sRate;
}


int cCombat::GetBowType(int i)
{
	int j,serial,serhash,ci;
	serial=chars[i].serial;
	serhash=serial%HASHMAX;
	for (ci=0;ci<contsp[serhash].max;ci++)
	{
		j=contsp[serhash].pointer[ci];
		if (j!=-1)
		if ((items[j].contserial==serial) && ((items[j].layer==1) || (items[j].layer==2)))
		{
			if ((items[j].id1==0x13)&&(items[j].id2==0xB1)) return(1); // Bows
			if ((items[j].id1==0x13)&&(items[j].id2==0xB2)) return(1);
			if ((items[j].id1==0x0F)&&(items[j].id2==0x4F)) return(2); // Crossbows
			if ((items[j].id1==0x0F)&&(items[j].id2==0x50)) return(2);
			if ((items[j].id1==0x13)&&(items[j].id2==0xFC)) return(3); // Heavy Crossbows
			if ((items[j].id1==0x13)&&(items[j].id2==0xFD)) return(3);
		}
	}
	return 0;
}

int cCombat::CalcDefA( int defend, int HitLoc_1, int damage )
{
	int serial, serhash, ci;

	int armor = -1;
	int ARarmor = 0;

	serial = chars[defend].serial;
	serhash = serial%HASHMAX;

	for( ci = 0; ci < contsp[serhash].max; ci++ )
	{
		armor = contsp[serhash].pointer[ci];
		if(( armor != -1 ) && ( items[armor].contserial == serial ) && ( items[armor].layer > 1 ) && ( items[armor].layer < 25 ) )
		{
			switch( items[armor].layer )
			{
			case 22:
				if( HitLoc_1==1 ) ARarmor = items[armor].def;
				break;
			case 19:
				if( HitLoc_1==2 ) ARarmor = items[armor].def;
				break;
			case 6:
				if( HitLoc_1==3 ) ARarmor = items[armor].def;
				break;
			case 24:
				if( HitLoc_1==4 ) ARarmor = items[armor].def;
				break;
			case 10:
				if( HitLoc_1==5 ) ARarmor = items[armor].def;
				break;
			case 7:
				if( HitLoc_1==6 ) ARarmor = items[armor].def;
				break;
			default:
				break;
			}
		}
	}

	if( damage > 0 && armor != -1 )
	{
		if( damage > ARarmor )
		{
			items[armor].hp -= rand()%3 + 1;
			items[armor].def -= rand()%3 + 2;

			return 0;
		}
		else
		{
			items[armor].hp--;
			items[armor].def--;
		}

		if( items[armor].hp < 1 )
		{
			char dArmor[512];

			sprintf( dArmor, "Your %s has been destroyed", items[armor].name );
			sysmessage( defend, dArmor );
			Items->DeleItem( armor );
		}
		return ARarmor;
	}
	return 0;
}

int cCombat::GetArrowType( int j )
{
	if( j == -1 ) return 0;
	if(( items[j].id1 == 0x13 ) && ( items[j].id2 == 0xB1 )) return( ARROW ); // Bows
	if(( items[j].id1 == 0x13 ) && ( items[j].id2 == 0xB2 )) return( ARROW );
	if(( items[j].id1 == 0x0F ) && ( items[j].id2 == 0x4F )) return( BOLT ); // Crossbows
	if(( items[j].id1 == 0x0F ) && ( items[j].id2 == 0x50 )) return( BOLT );
	if(( items[j].id1 == 0x13 ) && ( items[j].id2 == 0xFC )) return( BOLT ); // Heavy Crossbows
	if(( items[j].id1 == 0x13 ) && ( items[j].id2 == 0xFD )) return( BOLT );
	return 0;
}


//NEW FUNCTION -- AntiChrist merging codes -- (24/6/99)
void cCombat::ItemCastSpell(int s, int c, int i)//S=Socket c=Char # Target i=Item // Itemid
{
	if(i==-1) return;
	unsigned short int spellnum=((items[i].morex*8)-8)+items[i].morey;
	unsigned short int tempmana=chars[currchar[s]].mn;//Save their mana so we can give it back.
	unsigned short int tempmage=chars[currchar[s]].skill[MAGERY];//Easier than writing new functions for all these spells
	

	if(items[i].type!=15) return;
	
	if(items[i].morez<=0) return;
	
	chars[currchar[s]].skill[MAGERY]=rand()%400+600;//For damage
	
	switch(spellnum)
	{
	case 1: Magic->NPCClumsyTarget(currchar[s],c); break; //LB
	case 3: Magic->NPCFeebleMindTarget(currchar[s],c); break; //LB
	case 5:	Magic->NPCMagicArrowTarget(currchar[s],c);	break; // lB
	case 8: Magic->NPCWeakenTarget(currchar[s],c); break; //LB
	case 18: Magic->NPCFireballTarget(currchar[s],c); break; //LB
	case 22: Magic->NPCHarmTarget(currchar[s],c); break; //LB
	case 27: Magic->NPCCurseTarget(currchar[s],c); break; //LB
	case 30: Magic->NPCLightningTarget(currchar[s],c); break; //lb
	case 37: Magic->NPCMindBlastTarget(currchar[s],c); break;
	case 38: Magic->NPCParalyzeTarget(currchar[s],c);	break; //lb
	case 42: Magic->NPCEBoltTarget(currchar[s],c); break;
	case 43: Magic->NPCExplosionTarget(currchar[s],c); break;
	case 51: Magic->NPCFlameStrikeTarget(currchar[s],c); break;
	default:
		staticeffect(currchar[s], 0x37, 0x35, 0, 30);
		soundeffect2(currchar[s], 0x00, 0x5C);
		break;
	}
	if( chars[currchar[s]].mn!=tempmana )
		chars[currchar[s]].mn+=tempmana;
	chars[currchar[s]].skill[MAGERY]=tempmage;
	if(chars[currchar[s]].in<chars[currchar[s]].mn) chars[currchar[s]].mn=chars[currchar[s]].in;//Shouldn't happen, but just in case;
	updatestats(s, 1);
	
	items[i].morez--;
	if(items[i].morez==0)//JUST lost it's charge....
		sysmessage(s, "This item is out of charges.");
}
//NEW FUNCTION END -- AntiChrist merging codes --

void cCombat::CombatHit(int attack, int defend, unsigned int currenttime, signed int arrowType )
// PARAM WARNING: arrowType and currenttime are unreferenced parameters
// Arrowtype was originally meant for bolt vs arrow, and weather based stuff, so a fire ele would be weak to ice arrow
{
	// Do this right away so we can save few 0.00000001 milliseconds on going through other voids like LOS()
	
	chars[attack].swingtarg=-1;

	if (defend==-1) return;
	if (defend==attack) return;
	if( chars[defend].dead )
	{	// invalidate attacker here!!!
		if( chars[attack].npcaitype==4 ) //LB change from 0x40 to 4
		{
			chars[attack].summontimer=(uiCurrentTime+(CLOCKS_PER_SEC*20));    
			chars[attack].npcWander=2;
			chars[attack].npcmovetime=(unsigned int)((uiCurrentTime+double(NPCSPEED*CLOCKS_PER_SEC)));
			npctalkall(attack,"Thou have suffered thy punishment, scoundrel.", 0);
		}
		chars[attack].targ = -1;
		chars[attack].timeout = 0;
		if( chars[attack].attacker > -1 && chars[attack].attacker < cmem )
		{
			chars[chars[attack].attacker].attackfirst=0;
			chars[chars[attack].attacker].attacker=-1;
		}
		chars[attack].attacker=-1;
		chars[attack].attackfirst=0;
		if( chars[attack].npc && !chars[attack].dead && chars[attack].npcaitype != 17 && chars[attack].war ) 
			npcToggleCombat( attack ); // ripper
		return;
	}

	// Now we check for LOS, get the weapon and skill and check to see if they are in range.
	char hit;
	signed short s1=calcSocketFromChar(attack), s2=calcSocketFromChar(defend);
	
 	unsigned short fightskill = Skills->GetCombatSkill( attack ), bowtype = GetBowType( attack ), splitnum, splitcount, hitin;
 	//Homey 2/19/2000 lets check distance first, and if NPC
 	//isn't close enough to melle strike or using archery, lets break and avoid the 
 	//huge LOS code, big speed up here...
 	if((chardist(attack,defend)>1 && fightskill!=ARCHERY)) 
		return;
	//	Homey	-	End
	unsigned short los = line_of_sight(s1,chars[attack].x,chars[attack].y,chars[attack].z,chars[defend].x,chars[defend].y,chars[defend].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING);
	unsigned int c, BaseDamage;

	Skills->GetCombatSkill(attack); // This will get skill and weapon

	int damage; // removed from unsigne by Magius(CHE)
	signed int x;
	// Magius(CHE) - For armour absorbtion system
	char t[512],debabs[512]; 
	int maxabs, maxnohabs, tmpj;

	int weapon=GetWeapon(attack);//AntiChrist - get the weapon item only once

	*debabs='\0'; 
	*t='\0';
	// End here - Magius(CHE) - For armour absorbtion system

	//chars[attack].swing=-1;
	chars[attack].swingtarg=-1;

	hit=Skills->CheckSkill(attack, fightskill, 0, 1000);  // increase fighting skill for attacker and defender

	/*if (chars[k].skill[fightskill]>500)
		x=(int)(100*(chars[i].skill[fightskill]/500.0)/((chars[k].skill[fightskill]/500.0)*2.0));  // Chance to hit
	else x=(int)(100*(chars[i].skill[fightskill]/500.0));  // defender has no fightskill
	if ((rand()%100)<=x) combathit=1;
	else combathit=0;*/
	if (!hit)
	{
		if ((fightskill==ARCHERY)&&(los))
		{
			//if (!chars[attack].npc) soundeffect2(attack, 0x2, 0x38);
			if (!chars[attack].npc) doMissedSoundEffect(attack);

			if (rand()%3-1)//-1 0 or 1
			{
				//c=memitemfree();
				//inititem(c);
				c=Items->SpawnItem(s1,1,"#",1,0x0E,0x75,0,0,0,0);
				if (bowtype==1)
				{
					items[c].id1=0x0F; 
					items[c].id2=0x3F;
				} else {
					items[c].id1=0x1B;
					items[c].id2=0xFB;
				}
				
	            mapRegions->RemoveItem(c);

				items[c].x=chars[defend].x;
				items[c].y=chars[defend].y;
				items[c].z=chars[defend].z;
				items[c].priv=1;

			
				mapRegions->AddItem(c);
				
				//sendinrange(c);
				RefreshItem(c);//AntiChrist
			}
		//} else if (!chars[attack].npc) soundeffect2(attack, 0x2, 0x38);
		} else if (!chars[attack].npc) doMissedSoundEffect(attack);
	} else {
		if (!(chars[defend].priv&4))
		{
			Skills->CheckSkill(attack, TACTICS, 0, 1000);
			if (chars[defend].xid2==0x91) soundeffect2(defend,0x01,0x4b);
			if (chars[defend].xid2==0x90) soundeffect2(defend,0x01,0x56);
			playmonstersound(defend, chars[defend].id1, chars[defend].id2, SND_DEFEND);
			//AntiChrist -- for poisoned weapons
			if ((chars[attack].poison)&&(chars[defend].poisoned<chars[attack].poison))
			{
				if (rand()%3==0 || fightskill==FENCING)//0 1 or 2 //fencing always poisons :) - AntiChrist
				{
					//if(chars[defend].poisoned<chars[attack].poison) chars[defend].poisoned=chars[attack].poison; //this's a double check - look at the if above - AntiChrist
					chars[defend].poisoned=chars[attack].poison;
					chars[defend].poisontime=uiCurrentTime+(CLOCKS_PER_SEC*(40/chars[defend].poisoned)); // a lev.1 poison takes effect after 40 secs, a deadly pois.(lev.4) takes 40/4 secs - AntiChrist
					//chars[defend].poisonwearofftime=uiCurrentTime+(CLOCKS_PER_SEC*server_data.poisontimer); // lb, poison wear off timer setting
					chars[defend].poisonwearofftime=chars[defend].poisontime+(CLOCKS_PER_SEC*server_data.poisontimer); //wear off starts after poison takes effect - AntiChrist
					if (s2!=-1) impowncreate(s2,defend,1); //Lb, sends the green bar ! 
					//npctalkall(s2,"You have been poisoned!");
					if (s2!=-1) sysmessage(s2,"You have been poisoned!");//AntiChrist 
				}
			}			
			//Algaran 11-24-98 chars[k].priv2=chars[k].priv2&0xFD;
			if ((chars[defend].dx>0)) chars[defend].priv2=chars[defend].priv2&0xFD;

			if (fightskill!=WRESTLING)
				if (los) ItemSpell(attack, defend);
			
			if ((chars[defend].poison)&&(chars[attack].poisoned<chars[defend].poison))
			{
				if (rand()%3==0)
				{
					chars[attack].poisoned=chars[defend].poison;
					chars[attack].poisontime=uiCurrentTime+(CLOCKS_PER_SEC*(40/chars[attack].poisoned)); // a lev.1 poison takes effect after 40 secs, a deadly pois.(lev.4) takes 40/4 secs - AntiChrist
					chars[attack].poisonwearofftime=chars[attack].poisontime+(CLOCKS_PER_SEC*server_data.poisontimer); //wear off starts after poison takes effect - AntiChrist
					//chars[attack].poisonwearofftime=uiCurrentTime+(CLOCKS_PER_SEC*server_data.poisontimer); // lb, poison wear off timer setting
					if (s1!=-1) impowncreate(s1,attack,1); //Lb, sends the green bar ! 
					//sprintf(temp,"*%s has poisoned %s!*",chars[defend].name,chars[attack].name);
					//npctalkall(a,temp);
					if (s1!=-1) sysmessage(s1,"You have been poisoned!");//AntiChrist
				}
			}
			if (fightskill!=WRESTLING || chars[attack].npc==1) BaseDamage=CalcAtt(attack); // Calc base damage
			else
			{
				if ((chars[attack].skill[WRESTLING]/100) > 0) BaseDamage=rand()%(chars[attack].skill[WRESTLING]/100);
				else BaseDamage=rand()%2;
			}
			// Race Dmg Modification: Bonus percentage.
			int RaceDamage = Races->getFightPercent( fightskill, chars[attack].race );
			if( RaceDamage == 0 )
				RaceDamage = 100;
			BaseDamage+= BaseDamage/RaceDamage;

			// Check to see if weapons affect defender's race.
			if( fightskill!= WRESTLING )
			{
				if( items[weapon].racialEffect == chars[defend].race ) BaseDamage *= 2;
			}
			damage=(int)(BaseDamage*((chars[attack].skill[TACTICS]+500.0)/1000.0)); // Add Tactical bonus
			damage=damage+(int)((BaseDamage*(chars[attack].st/500.0))); // Add Strength bonus

			/////////////////////////////////
			//Adds a BONUS DAMAGE for ANATOMY
			//Anatomy=100 -> Bonus +20% Damage - AntiChrist (11/10/99)
			//printf("NORMAL DAMAGE: %d\n",damage);
			float multiplier=(((chars[attack].skill[ANATOMY]*20)/1000.0)/100)+1;
			//printf("MULTIPLIER: %f\n",multiplier);
			damage=(int)  (damage * multiplier);
			//printf("DAMAGE WITH ANAT: %d\n",damage);
		
			//////////////////////////////////
			//Adds a BONUS DEFENCE for TACTICS
			//Tactics=100 -> Bonus -20% Damage - AntiChrist (11/10/99)
			//printf("NORMAL DAMAGE: %d\n",damage);
			multiplier=1-(((chars[defend].skill[TACTICS]*20)/1000.0)/100);
			//printf("MULTIPLIER: %f\n",multiplier);
			damage=(int)  (damage * multiplier);
			//printf("DAMAGE WITH TAC: %d\n",damage);
	
			//
			// this 3 lines commented out by LB
			// this gives undefeatable super-npcs :(
			//
			// 11/10 AntiChrist note: i reprogrammed the above lines
			// ..now it should work..
			// I tested it and it seems to work...
			// pleaz leave it enabled and tell me what happens! thnx
			////////////////

			x=Skills->GetShield(defend);
			if(x>-1)
			{
				if (Skills->CheckSkill(defend, PARRYING, 0, 1000))// chance to block with shield
				{
					//Algaran 11-24-98 damage-=rand()%(items[j].def/2)+items[j].def/2;  // damage absorbed by shield
					damage-=rand()%(items[x].def);  // damage absorbed by shield
					if(rand()%2) items[x].hp--; //Take off a hit point
					if(items[x].hp<=0)
					{
						sysmessage(s2,"Your shield has been destroyed");
						Items->DeleItem(x);
					}
				}
			}
			x=rand()%100;// determine area of body hit
			if (server_data.combathitmessage!=1)
			{
				if (x<=44) x=1; // body
				else if (x<=58) x=2; // arms
				else if (x<=72) x=3; // head
				else if (x<=86) x=4; // legs
				else if (x<=93) x=5; // neck
				else x=6; // hands
			}
			if (server_data.combathitmessage==1)
			{
				// Removed by Magius(CHE) Was: ((!chars[defend].npc)&& (s2 != -1))
					hitin = rand()%2;
					if (x<=44)
					{
						x=1;       // body
						switch (hitin)
						{
						case 1:
							//later take into account dir facing attacker during battle
							if (damage < 10) strcpy(temp,"hits you in your Chest!");
							if (damage >=10) strcpy(temp,"lands a terrible blow to your Chest!");
							break;
						case 2:
							if (damage < 10) strcpy(temp,"lands a blow to your Stomach!");
							if (damage >=10) strcpy(temp,"knocks the wind out of you!");
							break;
						default:
							if (damage < 10) strcpy(temp,"hits you in your Ribs!");
							if (damage >=10) strcpy(temp,"broken your Rib?!");
							break;
						}
					}
					else if (x<=58)
					{
						x=2;  // arms
						switch (hitin)
						{
						case 1:
							if (damage > 1) strcpy(temp,"hits you in Left Arm!");
							break;
						case 2:
							if (damage > 1) strcpy(temp,"hits you in Right Arm!");
							break;
						default:
							if (damage > 1) strcpy(temp,"hits you in Right Arm!");
							break;
						}
					}
					else if (x<=72)
					{
						x=3;  // head
						switch (hitin)
						{
						case 1:
							if (damage < 10) strcpy(temp,"hits you you straight in the Face!");
							if (damage >=10) strcpy(temp,"lands a stunning blow to your Head!");
							break;
						case 2:
							if (damage < 10) strcpy(temp,"hits you to your Head!"); //kolours - (09/19/98)
							if (damage >=10) strcpy(temp,"smashed a blow across your Face!");
							break;
						default:
							if (damage < 10) strcpy(temp,"hits you you square in the Jaw!");
							if (damage >=10) strcpy(temp,"lands a terrible hit to your Temple!");
							break;
						}
					}
					else if (x<=86) 
					{
						x=4;  // legs
						switch (hitin)
						{
						case 1:
							strcpy(temp,"hits you in Left Thigh!");
							break;
						case 2:
							strcpy(temp,"hits you in Right Thigh!");
							break;
						default:
							strcpy(temp,"hits you in Groin!");
							break;
						}
					}
					else if (x<=93)
					{
						x=5;  // neck
						strcpy(temp,"hits you to your Throat!");
					}
					else
					{
						x=6;  // hands
						switch (hitin)
						{
						case 1:
							if (damage > 1) strcpy(temp,"hits you in Left Hand!");
							break;
						case 2:
							if (damage > 1) strcpy(temp,"hits you in Right Hand!");
							break;
						default:
							if (damage > 1) strcpy(temp,"hits you in Right Hand!");
							break;
						}
					}
					sprintf(temp2,"%s %s",chars[attack].name, temp);//AntiChrist
					if (!chars[defend].npc) sysmessage(s2, temp2); //kolours -- hit display
				//} Removed by Magius(CHE)
			}
			//printf("\n%s Hitten in %i\n",chars[defend].name,x);
			x=CalcDef(defend,x);
			
			// Magius(CHE) - For armour absorbtion system
			maxabs=20; //
			           // there are monsters with DEF >20, this makes them undefeatable
			maxnohabs=100;
			if (server_data.maxabsorbtion>0) maxabs=server_data.maxabsorbtion;
			else {
				printf("SERVER.SCP:CombatHit() Error in MAX_ABSORBTION. Reset to Deafult (20).\n");
				server_data.maxabsorbtion=maxabs;
			}
			if (server_data.maxnohabsorbtion>0) maxnohabs=server_data.maxnohabsorbtion;
			else {
				printf("SERVER.SCP:CombatHit() Error in MAX_NON_HUMAN_ABSORBTION. Reset to Deafult (100).\n");
				server_data.maxnohabsorbtion=maxnohabs;
			}
			if (!ishuman(defend)) maxabs=maxnohabs;
			//printf("Damage Before Abs: %i\n",damage);
			tmpj=(int) (damage*x)/maxabs; // Absorbtion by Magius(CHE)
			damage=damage-tmpj;
			if (damage<0) damage=0;
			//printf("MaxAbs: %i\nArmour: %i\nDamage: %i\nSubstract: %i\n",maxabs,x,damage,tmpj);
			if (chars[defend].npc==0) damage=damage/server_data.npcdamage; // Rate damage against other players
			// End Armour Absorbtion by Magius(CHE) (See alse reactive armour spell damage)

			if (!chars[attack].npc)//Zippy
					ItemCastSpell(s1,defend,weapon);

			//AntiChrist - 26/10/99
			//when hitten and damage >1, defender fails if casting a spell!
			if(damage>1 && !chars[defend].npc)//only if damage>1 and against a player
			{
				if(chars[defend].casting && currentSpellType[s2]==0 )
				{//if casting a normal spell (scroll: no concentration loosen)
					currentSpellType[s2]=0;
					//chars[defend].spellCast=-1;
					//chars[defend].casting=0;
					//chars[defend].spelltime=0;
					chars[defend].priv2=chars[defend].priv2&0xfd; // unfreeze, bugfix LB
					//Magic->SpellFail(s2);
				}
			}

			if(damage>0)
			{
				if (chars[defend].ra) // For reactive armor spell
				{
					int damage1;
					damage1=(int)( damage*(chars[defend].skill[MAGERY]/2000.0));
					chars[defend].hp -= damage-damage1;
					if (chars[defend].npc) damage1 = damage1 * server_data.npcdamage; // by Magius(CHE)
					chars[attack].hp -= damage1;
					staticeffect(defend, 0x37, 0x4A, 0, 15);//RA effect - AntiChrist (9/99)
					//printf("protected by RA!--------\n");
					//printf("original damage: %i\n",damage);
					//printf("damage with protection: %i\n",damage-damage1);
					//printf("reflected damage: %i\n",damage1);
				}
				else chars[defend].hp-=damage;                 // Remove damage
				/////////  For Splitting NPCs ///  McCleod
				if ((chars[defend].split>0)&&(chars[defend].hp>=1))
				{
					if (rand()%100<=chars[defend].splitchnc)
					{
						if (chars[defend].split==1) splitnum=1;
						else splitnum=rand()%chars[defend].split+1;
						
						for (splitcount=0;splitcount<splitnum;splitcount++)
							Npcs->Split(defend);
					}
				}
				////////      End of spliting NPCs
			}
			if (!chars[attack].npc)
				if(((fightskill==ARCHERY)&&(los))||(fightskill!=ARCHERY))
					doSoundEffect(attack, fightskill, weapon);//AntiChrist
			/*{
				if ((fightskill==ARCHERY)&&(los)) soundeffect2(attack, 0x2, 0x34);
				else if ((fightskill!=WRESTLING)&&(fightskill!=ARCHERY)) soundeffect2(attack, 0x2, 0x3B);
			}*/

			if (chars[defend].hp<0) chars[defend].hp=0;
			updatestats(defend, 0);
			x=(chars[defend].id1<<8)+chars[defend].id2;
			if (x>=0x0190)
			{
				if (!chars[defend].onhorse) npcaction(defend, 0x14);
			}
		}
	}
}

void cCombat::DoCombat(int attack, unsigned int currenttime)
{
	int x, defend, fightskill, spattacks, spattackbit, arrowsquant, bowtype = 0; // spamanachecking, tmp;
	int j, los;
	int weapon = GetWeapon( attack );

	if (attack < 0 || attack >= cmem)
	{
		LogMessage("combat() - bad attacker (%i)\n"_ attack);
		return;
	}
	int s1 = calcSocketFromChar( attack ), s2 = -1;
	if( chars[attack].free ) return;
	defend = chars[attack].targ;
	if( defend == -1 )		// we may as well dump completely out of the this routine if there's no defender!
	{
		if( chars[attack].war )
		{
			chars[attack].war = 0; // LB
			chars[attack].timeout = 0;
			chars[attack].attacker = -1;
			chars[attack].attackfirst = 0;
		}
		return;
	}

	if( chars[defend].dead )	// we're attacking a ghost, a BIG NO NO!!!!!!!
	{	// invalidate attacker here!!!
		if( chars[attack].npcaitype==4 ) //LB change from 0x40 to 4
		{
			chars[attack].summontimer=(uiCurrentTime+(CLOCKS_PER_SEC*20));    
			chars[attack].npcWander=2;
			chars[attack].npcmovetime=(unsigned int)((uiCurrentTime+double(NPCSPEED*CLOCKS_PER_SEC)));
			npctalkall(attack,"Thou have suffered thy punishment, scoundrel.", 0);
		}
		chars[attack].targ = -1;
		chars[attack].timeout = 0;
		if( chars[attack].attacker > -1 && chars[attack].attacker < cmem )
		{
			chars[chars[attack].attacker].attackfirst=0;
			chars[chars[attack].attacker].attacker=-1;
		}
		chars[attack].attacker=-1;
		chars[attack].attackfirst=0;
		if( chars[attack].npc && !chars[attack].dead && chars[attack].npcaitype != 17 && chars[attack].war ) 
			npcToggleCombat( attack ); // ripper
		return;
	}

	if (((chars[attack].npc)||(online(attack)))&&(defend!=-1))
	{			
		if (defend<=-1 || defend>=cmem) return;
		if (chars[defend].free) return;

		s2=calcSocketFromChar(defend);
		los=line_of_sight(-1,chars[attack].x,chars[attack].y,chars[attack].z,chars[defend].x,chars[defend].y,chars[defend].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING);
		
		if(los==0) //Homey lag fixin, there's no need to run any further cause we dont have LOS...
   		 return;
		
	  if ((chars[defend].npc)&&(chars[defend].npcaitype!=17)|| (online(defend)&&(!chars[defend].dead))) // ripper		
		{
			if (chardist(attack,defend)>=10)
			{
				if ((chars[attack].npcaitype==4)&&((region[chars[attack].region].priv&1))) // changed from 0x40 to 4, LB
				{
					//printf("HALT: %s, %s\n",chars[i].name,chars[attack].name);
					mapRegions->RemoveItem(attack+1000000);  // lb

					chars[attack].x=chars[defend].x;
					chars[attack].y=chars[defend].y;
					chars[attack].dispz=chars[attack].z=chars[defend].z;

					mapRegions->AddItem(attack+1000000); // lb

					teleport(attack);
					soundeffect2( attack, 0x01, 0xFE ); // crashfix, LB
					staticeffect(attack, 0x37, 0x2A, 0x09, 0x06);
					npctalkall(attack,"Halt, scoundrel!", 1);
					npcattacktarget( defend, attack );
				}
				else 
				{
					chars[attack].targ=-1;
					chars[attack].timeout=0;
					if (chars[attack].attacker>=0 && chars[attack].attacker<cmem)
					{
						chars[chars[attack].attacker].attackfirst=0;
						chars[chars[attack].attacker].attacker=-1;  // lb crashfix
					}
					chars[attack].attacker=-1;
					chars[attack].attackfirst=0;
					if( chars[attack].npc && chars[attack].npcaitype!=17 && !chars[attack].dead && chars[attack].war ) npcToggleCombat( attack );  // ripper
				}
			}
			if (chardist(attack,defend)<combat.maxRange) 
			{
				if (chars[attack].targ==-1)
				{
					npcsimpleattacktarget(attack,defend);
					x = ((( 100 - chars[attack].dx ) * CLOCKS_PER_SEC ) /25 ) + ( 1 * CLOCKS_PER_SEC ); // Yet another attempt.
					chars[attack].timeout=uiCurrentTime + x;
					return;
				}
				if (TimerOk(attack))
				{
					fightskill = Skills->GetCombatSkill( attack );
					x = 0;
					if( fightskill == ARCHERY )
					{
						if (los)
						{
							bowtype = GetBowType( attack );
							if( bowtype == 1 ) arrowsquant = getamount( attack, 0x0F, 0x3F );
							else arrowsquant = getamount( attack, 0x1B, 0xFB );
							if( arrowsquant > 0 ) x = 1;
							if( arrowsquant <= 0 ) sysmessage( s1, "You are out of ammunitions!" );

						}
					}
					if ((chardist(attack,defend)<2)&&(fightskill!=ARCHERY)) x = 1;
					if( x )
					{
						// - Do stamina maths - AntiChrist (6) -
						if(abs(server_data.attackstamina)>0 && !(chars[attack].priv&1))
						{
							if((server_data.attackstamina<0)&&(chars[attack].stm<abs(server_data.attackstamina)))
							{
       							sysmessage(s1,"You are too tired to attack.");
								j = weapon; //Get the number of the weapon
								if (j!=-1) 
								{ 
									if (items[j].spd==0) items[j].spd=35;
								    x = (15000 / ((chars[attack].dx+100) * items[j].spd)*CLOCKS_PER_SEC); //Calculate combat delay
								}
								else 
								{
									j=30;
									if(chars[attack].skill[WRESTLING]>200) j=35;
									if(chars[attack].skill[WRESTLING]>400) j=40;
									if(chars[attack].skill[WRESTLING]>600) j=45;
									if(chars[attack].skill[WRESTLING]>800) j=50;
									x = (15000 / ((chars[attack].dx+100) * j)*CLOCKS_PER_SEC);
								}
								chars[attack].timeout=uiCurrentTime+x;
       							return;
       						}
        					chars[attack].stm += server_data.attackstamina;
							if (chars[attack].stm>chars[attack].dx) chars[attack].stm=chars[attack].dx;
							if (chars[attack].stm<0) chars[attack].stm=0;
        					updatestats(attack,2); //LB, crashfix, was currchar[attack]
							//printf("ATTACKSTAMINA %i\n",server_data.attackstamina);
							// --------ATTACK STAMINA END ------
						}

						x=(chars[attack].id1<<8)+chars[attack].id2;
						int cc,aa,bb;
						if (x<0x0190)
						{
							aa=4+(rand()%3); // bugfix, LB, some creatures dont have animation #4
                            cc=(creatures[x].who_am_i)&0x2; // anti blink bit set ?
	                        if (cc==2)
							{
                              aa++;
							  if (x==5) // eagles need special treatment
							  {
                                bb=rand()%3;
								switch (bb)
								{
									case 0: aa=0x1;  break;
									case 1: aa=0x14; break;
									case 2: aa=0x4;  break;
								}
							  }

							}

							npcaction(attack,aa); 
							playmonstersound(attack, chars[attack].id1, chars[attack].id2, SND_ATTACK);

						}
						else if (chars[attack].onhorse)
						{
							//combatonhorse(attack) determines weapon in hand and runs animation
							CombatOnHorse(attack); //kolours - single inline function (09/19/98)
						}
						else
						{
							//combatonfoot(attack) determines weapon in hand and runs animation
							CombatOnFoot(attack); //kolours - single inline function (09/19/98)
						}
						if (fightskill==ARCHERY)
						{
							if (los)
							{
								if (bowtype==1)
								{
									delequan(attack, 0x0F, 0x3F, 1);
									movingeffect(attack, defend, 0x0F, 0x42, 0x08, 0x00, 0x00);
								}
								else
								{
									delequan(attack, 0x1B, 0xFB, 1);
									movingeffect(attack, defend, 0x1B, 0xFE, 0x08, 0x00, 0x00);
								}
							}
						}
						// Formulas take from OSI's combat formulas
						// attack speed should be determined here.
						// attack speed = 15000 / ((DEX+100) * weapon speed)
						if (((chardist(attack,defend)<2)||(fightskill==ARCHERY))&&!(chars[attack].npcaitype==4)) // changed from 0x40 to 4
                        {
							if (los)
							{
								npcsimpleattacktarget(attack,defend);
							}
						}
						if (fightskill==ARCHERY) CombatHit(attack,defend,currenttime);
						else chars[attack].swingtarg=defend;
  					}
					j = weapon; //Get the number of the weapon
					if (j!=-1)
					{
					    if (items[j].spd==0) items[j].spd=35;
						x = (15000 / ((chars[attack].dx+100) * items[j].spd)*CLOCKS_PER_SEC); //Calculate combat delay
					}
					
					if (j==-1)
					{
						j=30;
						if(chars[attack].skill[WRESTLING]>200) j=35;
						if(chars[attack].skill[WRESTLING]>400) j=40;
						if(chars[attack].skill[WRESTLING]>600) j=45;
						if(chars[attack].skill[WRESTLING]>800) j=50;
						x = (15000 / ((chars[attack].dx+100) * j)*CLOCKS_PER_SEC);
					}
					chars[attack].timeout=uiCurrentTime+x;
					if (fightskill!=ARCHERY) CombatHit(attack,defend,currenttime); // LB !!!
				}
			}

			if (chars[defend].hp<1)//Highlight //Repsys
			{
				Karma(attack,defend,(0-(chars[defend].karma)));
				Fame(attack,chars[defend].fame);
				if(chars[attack].npcaitype==4 && chars[defend].npc)  // changed from 0x40 to 4
				{
					npcaction(defend, 0x15);
					
					if (chars[defend].xid1==0x01 && chars[defend].xid2==0x91)
						soundeffect2(defend,0x01,0x51); // Female Death
					else if (chars[defend].xid1==0x01 && chars[defend].xid2==0x90)
						soundeffect2(defend,0x01,0x5a); // Male Death
					else playmonstersound(defend, chars[defend].xid1, chars[defend].xid2, SND_DIE);

					Npcs->DeleteChar(defend);//Guards, don't give body
				} else { /*printf("combat-killed :%s\n",chars[defend].name);*/deathstuff(defend);}
				//murder count \/

				if ((!chars[attack].npc)&&(!chars[defend].npc))//Player vs Player
				{
					if(chars[defend].flag==0x04 && Guilds->Compare(attack,defend)==0 && Races->Compare( attack, defend ) == 0 )
					{
						chars[attack].kills++;
						sprintf(temp, "You have killed %i innocent people.", chars[attack].kills);
						sysmessage(calcSocketFromChar(attack),temp);
						//printf("DEBUG %s's kills are now -> %i\n",chars[attack].name,chars[attack].kills);
						if (chars[attack].kills==repsys.maxkills+1)
							sysmessage(calcSocketFromChar(attack),"You are now a murderer!");
					}
					
					sprintf(temp,"%s was killed by %s!\n",chars[defend].name,chars[attack].name);
					savelog(temp,"PvP.log");
				}
				npcToggleCombat(attack);
				return; // LB
			}

			if (!(chars[defend].priv&4))
			{
				if (chars[attack].spatimer<=currenttime)
				{
					spattacks = numbitsset( chars[attack].spattack );
					if ((!chars[defend].dead)&&(chardist(attack,defend)<combat.maxRangeSpell)&&( spattacks > 0 ))
					{
						if (los)
						{

								spattackbit=rand()%(spattacks) + 1;
								switch(whichbit(chars[attack].spattack, spattackbit))
								{
								case 1:
									if (chars[attack].mn>=4)
									{
										npcaction(attack, 6);
										Magic->NPCMagicArrowTarget(attack,defend);
									}
									break;
								case 2:
									if (chars[attack].mn>=6)
									{
										npcaction(attack, 6);
										Magic->NPCHarmTarget(attack,defend);
									}
									break; // lb
								case 3:
									if (chars[attack].mn>=4)
									{
										npcaction(attack, 6);
										Magic->NPCClumsyTarget(attack,defend);
									}
									break; // LB
								case 4:
									if (chars[attack].mn>=4)
									{
										npcaction(attack,  6);
										Magic->NPCFeebleMindTarget(attack, defend);
									}
									break; // LB
								case 5:
									if (chars[attack].mn>=4)
									{
										npcaction(attack,  6);
										Magic->NPCWeakenTarget(attack, defend);
									}
									break; //LB
								case 6:
									if (chars[attack].mn>=9)
									{
										npcaction(attack,  6);
										Magic->NPCFireballTarget(attack, defend);
									}
									break; //LB
								case 7:
									if (chars[attack].mn>=11)
									{
										npcaction(attack,  6);
										Magic->NPCCurseTarget(attack, defend);
									}
									break; //LB
								case 8:
									if (chars[attack].mn>=11)
									{
										npcaction(attack,  6);
										Magic->NPCLightningTarget(attack, defend);
									}
									break; //lb
								case 9:
									if (chars[attack].mn>=14)
									{
										npcaction(attack,  6);
										Magic->NPCParalyzeTarget(attack, defend);
									}
									break; //lb
								case 10:
									if (chars[attack].mn>=14)
									{
										npcaction(attack,  6);
										Magic->NPCMindBlastTarget(attack, defend);
									}
									break;
								case 11:
									if (chars[attack].mn>=20)
									{
										npcaction(attack,  6);
										Magic->NPCEBoltTarget(attack, defend);
									}
									break;
								case 12:
									if (chars[attack].mn>=20)
									{
										npcaction(attack,  6);
										Magic->NPCExplosionTarget(attack, defend);
									}
									break;
								case 13:
									if (chars[attack].mn>=40)
									{
										npcaction(attack,  6);
										Magic->NPCFlameStrikeTarget(attack, defend);
									}
									break;
								case 14:
									npcaction(attack,  6);
									Magic->PFireballTarget(attack,  defend, 10);
									break;
								case 15:
									npcaction(attack,  6);
									Magic->PFireballTarget(attack,  defend, 20);
									break;
								case 16:
									npcaction(attack,  6);
									Magic->PFireballTarget(attack,  defend, 40);
									break;
								}
						}			
					}
					chars[attack].spatimer=currenttime+(chars[attack].spadelay*CLOCKS_PER_SEC); // LB bugkilling
				}
			}
		}
	}
}

int cCombat::CalcAtt(int p) // Calculate total attack powerer
{
	char p1, p2, p3, p4;
	int total=0, i, j,serial,serhash,ci;
	
	if(chars[p].npc==1) 
	{
		//Compatibility for use with older scripts
		if((chars[p].lodamage==0)&&(chars[p].hidamage==0)) return(chars[p].att);
		
		//Code for new script commands
		if(chars[p].lodamage==chars[p].hidamage) //Avoids divide by zero error
		{
			return(chars[p].lodamage);
		}
		if(!(chars[p].hidamage<=2))
		{
			j=chars[p].hidamage-chars[p].lodamage;
			total=(rand()%(j))+chars[p].lodamage;
		}
		
		if(total<1) total=1;
		return(total);
	}
	
	p1=chars[p].ser1;
	p2=chars[p].ser2;
	p3=chars[p].ser3;
	p4=chars[p].ser4;
	serial=chars[p].serial;
	serhash=serial%HASHMAX;
	for (ci=0;ci<contsp[serhash].max;ci++)
	{
		i=contsp[serhash].pointer[ci];
		if (i!=-1) 
			if ((items[i].contserial==serial) && ((items[i].layer==1) || (items[i].layer==2)))
		{
			if (items[i].lodamage == items[i].hidamage) total+=items[i].lodamage;
			else if ((items[i].lodamage>0)&&(items[i].hidamage>0))
			{
				total+=(rand()%(items[i].hidamage-items[i].lodamage))+(items[i].lodamage);
			}
			else if ((items[i].lodamage==0)&&(items[i].hidamage==0)) total+=items[i].att;
		}
	}
	if (total<1) total=1;
	return total;
}

int cCombat::CalcDef(int p,int x) // Calculate total defense power
{
	char p1, p2, p3, p4;
	int i=-1, j=-1, k,serial,serhash,ci;
	int total;
	tile_st tile;
	
	total=chars[p].def;
	p1=chars[p].ser1;
	p2=chars[p].ser2;
	p3=chars[p].ser3;
	p4=chars[p].ser4;
	serial=chars[p].serial;
	serhash=serial%HASHMAX;
	if( ishuman(p)) { // Added by Magius(CHE)
		for (ci=0;ci<contsp[serhash].max;ci++)
		{
			i=contsp[serhash].pointer[ci];
			if (i!=-1) 
				if((items[i].contserial==serial) && (items[i].layer>1) && (items[i].layer<25))
				{
					if (x==0) total+=items[i].def;
					else
					{
						switch (items[i].layer)
						{
						case 5:
						case 13:
						case 17:
						case 20:
						case 22: if (x==1 && items[i].def>total) 
								 {
									 total=items[i].def;
									 j=i;
								 }
							break;
						case 19: if (x==2 && items[i].def>total)
								 {
									 total=items[i].def;
									 j=i;
								 }
							break;
						case 6:  if (x==3 && items[i].def>total) 
								 {
									 total=items[i].def; 
									 j=i;
								 }
							break;
						case 3:
						case 4:
						case 12:
						case 23:
						case 24: if (x==4 && items[i].def>total) 
								 {
									 total=items[i].def;
									 j=i;
								 }
							break;
						case 10: if (x==5 && items[i].def>total) 
								 {
									 total=items[i].def;
									 j=i;
								 }
							break;
						case 7:  if (x==6 && items[i].def>total) 
								 {
									 total=items[i].def; 
									 j=i;
								 }
							break;
						default:
							break;
						}
					}
				}
			}
	} else j = -1;
	k=calcSocketFromChar(p);
	if (j!=-1 && k!=-1)
	{
		if((rand()%2)==0) items[j].hp--; //Take off a hit point
		if(items[j].hp<=0)
		{
			if (items[j].name[0]!='#') //AntiChrist BUGFIX
			{
				sprintf(temp,"Your %s has been destroyed",items[j].name);
			}
			else
			{
				Map->SeekTile((items[j].id1<<8)+items[j].id2, &tile);
				sprintf(temp,"Your %s has been destroyed",tile.name);
			}
			sysmessage(k,temp);
			Items->DeleItem(j);
		}
		statwindow(k,currchar[k]);
	}
	if (total<2) total=2;
	return total;
}

int cCombat::TimerOk(int c)
{
	int d=0;
//	if (chars[c].timeout<getclock()) d=1;
	if( chars[c].timeout < uiCurrentTime ) d=1;
	if (overflow) d=1;
	return d;
}

int cCombat::GetWeapon(int i)
{
	int j,serial,serhash,ci;
	
	serial=chars[i].serial;
	serhash=serial%HASHMAX;
	for (ci=0;ci<contsp[serhash].max;ci++)
	{
		j=contsp[serhash].pointer[ci];
		if (j!=-1)
			if ( ( items[j].contserial == serial ) && ( (items[j].layer == 1) || (( items[j].layer == 2 ) && (Skills->GetShield( i ) == -1)) ) ) // Morrolan don't check for shields
			{
				return (j);
			}
	}
	return(-1);
}

//play animation for weapon in hand during combat on a horse //kolours - modularized (09/20/98)
void cCombat::CombatOnHorse(int i)
{
	int j;
	
	//      if (chars[i].npc != 0) return; //return if char is not a player
	
	j = GetWeapon(i); //find out which weapon the player is holding

	if (j!=-1)
	{
	  if ((items[j].id1==0x13)&&(items[j].id2==0xB2))
	  {
		npcaction(i, 0x1B); //bow
		return;
	  }
	  if ((items[j].id1==0x0F)&&(items[j].id2==0x4F) || //xbow 
		(items[j].id1==0x13)&&(items[j].id2==0xFD)  ) //hxbow
	  {
		npcaction(i, 0x1C); //crossbow - regular
		return;
	  }
	  if ((items[j].id1==0x13)&&(items[j].id2>=0xB5)&&(items[j].id2<=0xBA) || //swords 
	 	(items[j].id1==0x0E)&&(items[j].id2>=0xC1)&&(items[j].id2<=0xC5) || //swords
		(items[j].id1==0x0F)&&(items[j].id2>=0x5E)&&(items[j].id2<=0x61) || //swords
		(items[j].id1==0x13)&&(items[j].id2==0xFA)||(items[j].id2==0xFB) || //swords
		(items[j].id1==0x13)&&(items[j].id2==0xFE)||(items[j].id2==0xFF) || //swords
		(items[j].id1==0x0D)&&(items[j].id2>=0xF0)&&(items[j].id2<=0xF5) || //maces
		(items[j].id1==0x14)&&(items[j].id2>=0x38)&&(items[j].id2<0x3C)  || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xB3)||(items[j].id2==0xB4) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0x5C)||(items[j].id2==0x5D) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0xB4)||(items[j].id2==0xB5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xAF)||(items[j].id2==0xB0) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xE3)||(items[j].id2==0xE4) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF4)||(items[j].id2==0xF5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF8)||(items[j].id2==0xF9) || //maces
		(items[j].id1==0x14)&&(items[j].id2==0x3C)||                        //maces - hammer pick
		(items[j].id1==0x14)&&(items[j].id2==0x06)||(items[j].id2==0x07) || //maces - 1H war mace
		(items[j].id1==0x0E)&&(items[j].id2==0x81)||(items[j].id2==0x82) || //maces
		(items[j].id1==0x0E)&&(items[j].id2==0x89)||(items[j].id2==0x8A) || //maces
		(items[j].id1==0x14)&&(items[j].id2<=0x05) || //fencing
		(items[j].id1==0x0F)&&(items[j].id2==0x51)||(items[j].id2==0x52)  ) //fencing - kryss
	{
		npcaction(i, 0x1A);
		return;
	}
	if ((items[j].id1==0x0F)&&(items[j].id2>=0x43)&&(items[j].id2<=0x4E) || //2H axes 
		(items[j].id1==0x14)&&(items[j].id2>=0x3E)&&(items[j].id2<=0x43) || //halberd
		(items[j].id1==0x0F)&&(items[j].id2==0x62)||(items[j].id2==0x63) || //fencing - spear
		(items[j].id1==0x0E)&&(items[j].id2==0x87)||(items[j].id2==0x88)  ) //fencing - pitchfork
	{
		npcaction(i, 0x1D); //2H axes
		return;
	}
	} // end of !=-1
	else
	{
		npcaction(i, 0x1A); //fist fighting
		return;
	}
	
}

//play animation for weapon in hand for combat on foot //kolours - (09/20/98)
void cCombat::CombatOnFoot(int i)
{
	int j;
	int m;
	
	//      if (chars[i].npc != 0) return; //return if char is not a player
	
	j = GetWeapon(i); //identify the weapon the player is holding
	m = rand()%4; //randomize the animation sequence

	if (j!=-1)
	{
	  if ((items[j].id1==0x13)&&(items[j].id2==0xB2)) 
	  {
	  	npcaction(i, 0x12); //bow
		return;
	  }
	  if ((items[j].id1==0x0F)&&(items[j].id2==0x4F) || //xbow
		(items[j].id1==0x13)&&(items[j].id2==0xFD)  ) //xhbow
	  {
		npcaction(i, 0x13); //crossbow - regular
		return;
	  }
	  if ((items[j].id1==0x13)&&(items[j].id2>=0xB5)&&(items[j].id2<=0xBA) || //1H swords 
		(items[j].id1==0x0F)&&(items[j].id2>=0x5E)&&(items[j].id2<=0x61) || //1H swords
		(items[j].id1==0x0E)&&(items[j].id2>=0xC1)&&(items[j].id2<=0xC5) || //1H swords
		(items[j].id1==0x13)&&(items[j].id2==0xFA)||						//1H swords
		(items[j].id1==0x13)&&(items[j].id2==0xFE)||(items[j].id2==0xFF)  ) //1H swords
	{
		switch (m) //swords
		{
		case 0:
			npcaction(i, 0x0D); //side swing
			return;
		case 1:
			npcaction(i, 0x0A); //poke
			return;
		default:
			npcaction(i, 0x09); //top-down swing
			return;
		}
	}
	if ((items[j].id1==0x0D)&&(items[j].id2>=0xF0)&&(items[j].id2<=0xF5) || //maces 
		(items[j].id1==0x13)&&(items[j].id2==0xB3)||(items[j].id2==0xB4) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0x5C)||(items[j].id2==0x5D) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0xB4)||(items[j].id2==0xB5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xAF)||(items[j].id2==0xB0) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xE3)||(items[j].id2==0xE4) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF4)||(items[j].id2==0xF5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF8)||(items[j].id2==0xF9) || //maces
		(items[j].id1==0x14)&&(items[j].id2==0x3C)||						//maces - hammer pick
		(items[j].id1==0x14)&&(items[j].id2==0x06)||(items[j].id2==0x07) || //maces
		(items[j].id1==0x0E)&&(items[j].id2==0x81)||(items[j].id2==0x82) || //maces
		(items[j].id1==0x0E)&&(items[j].id2==0x89)||(items[j].id2==0x8A)  ) //maces
	{
		switch (m) //maces
		{
		case 0:
			npcaction(i, 0x0D); //side swing
			return;
		default:
			npcaction(i, 0x09); //top-down swing
			return;
		}
	}
	if ((items[j].id1==0x14)&&(items[j].id2>=0x38)&&(items[j].id2<0x3C) || //2H maces - 2H war hammer
		(items[j].id1==0x14)&&(items[j].id2>=0x3E)&&(items[j].id2<=0x43)|| //Halberd
		(items[j].id1==0x13)&&(items[j].id2==0xFB)||					   //War Axe
		(items[j].id1==0x0F)&&(items[j].id2>=0x43)&&(items[j].id2<=0x4E) ) //2H Axes
	{
		switch (m)
		{
		case 0:
			npcaction(i, 0x0D); //2H top-down
			return;
		case 1:
			npcaction(i, 0x0C); //2H swing
			return;
		default:
			npcaction(i, 0x0D); //2H top-down
			return;
		}
	}
	if ((items[j].id1==0x14)&&(items[j].id2<0x05) || //kryss - fencing
		(items[j].id1==0x0F)&&(items[j].id2==0x51)||(items[j].id2==0x52)|| //fencing
		(items[j].id1==0x14)&&(items[j].id2==0x05)) //fencing
	{
		switch (m) //fencing
		{
		case 0:
			npcaction(i, 0x09); //top-down
			return;
		case 1:
			npcaction(i, 0x0D); //side-swipe
			return;
		default:
			npcaction(i, 0x0A); //default: poke
			return;
		}
	}
	if ((items[j].id1==0x0E)&&(items[j].id2==0x87)||(items[j].id2==0x88) || //pitchfork 
		(items[j].id1==0x0F)&&(items[j].id2==0x62)||(items[j].id2==0x63)  ) //spear
	{
		switch (m) //pitchfork
		{
		case 0:
			npcaction(i, 0x0D); //top-down
			return;
		default:
			npcaction(i, 0x0E); //default: 2-handed poke
			return;
		}
	}
	} // end of !=-1
	else
	{
		switch (m) //fist fighting
		{
		case 0:
			npcaction(i, 0x0a); //fist straight-punch
			return;
		case 1:
			npcaction(i, 0x09); //fist top-down
			return;
		default:
			npcaction(i, 0x1F); //default: //fist over-head
			return;
		}
	}
}

//s: char#
void cCombat::SpawnGuard( CHARACTER s, CHARACTER i, int x, int y, signed char z)
{
	int t,c, j;
	char b;
	//printf("spawnguard called !!\n");

	if( i < 0 || i >= cmem || s < 0 || s >= cmem ) return;
	j = i;
	i=chars[i].region; 
	b=chars[s].priv&4;

	if(!(region[chars[j].region].priv&0x01 == 1 ) ) return;
	if( server_data.guardsactive && !b ) // bugfix, lb
	{
//		t=RandomNum(1000,1001);
		t=region[i].guardnum[(rand()%10)+1];
		c=Npcs->AddNPCxyz( calcSocketFromChar(s), t, 0, x, y, z); 

		if( c!=-1)
		{
			chars[c].npcaitype=4; // CITY GUARD, LB, bugfix, was 0x40 -> not existing
			chars[c].attackfirst=1;
			chars[c].attacker = s;
			chars[c].targ = s;
			chars[c].npcWander=2;  //set wander mode Tauriel
			npcToggleCombat(c);
			chars[c].npcmovetime=(unsigned int)(uiCurrentTime+(double)(NPCSPEED*CLOCKS_PER_SEC));
			chars[c].summontimer=(uiCurrentTime + CLOCKS_PER_SEC*25);

			soundeffect2(c, 0x01, 0xFE);  //Tauriel 1-9-99 changed to stop crashing used to call soundeffect (expeted socket)
			staticeffect(c, 0x37, 0x2A, 0x09, 0x06);
			
			updatechar(c);
			npctalkall(c,"Thou shalt regret thine actions, swine!", 1);
		}
	}
}

void cCombat::ItemSpell(int attaker, int defender)
{
	int i,serial,serhash,ci;
	currentSpellType[attaker]=2;
	serial=chars[attaker].serial;
    serhash=serial%HASHMAX;
	for (ci=0;ci<contsp[serhash].max;ci++)
	{
		i=contsp[serhash].pointer[ci];
		if (i!=-1)
		if ((items[i].contserial==serial) && 
			((items[i].layer==1 && items[i].type!=9) || (items[i].layer==2)))
		{
			if (items[i].offspell && (items[i].att||items[i].hidamage) && items[i].type == 15)
			{
				switch(items[i].offspell)
				{
				case 1:
					{
						Magic->ClumsySpellItem(attaker,defender);
						break;
					}
				case 2:
					{
						Magic->FeebleMindSpellItem(attaker,defender);
						break;
					}
				case 3:
					{
						Magic->MagicArrowSpellItem(attaker,defender);
						break;
					}
				case 4:
					{
						Magic->WeakenSpellItem(attaker,defender);
						break;
					}
				case 5:
					{
						Magic->HarmSpellItem(attaker,defender);
						break;
					}
				case 6:
					{
						Magic->FireballSpellItem(attaker,defender);
						break;
					}
				case 8:
					{
						Magic->CurseSpellItem(attaker,defender);
						break;
					}
				case 9:
					{
						Magic->LightningSpellItem(attaker,defender);
						break;
					}
				case 11:
					{
						Magic->MindBlastSpellItem(attaker,defender);
						break;
					}
				case 12:
					{
						Magic->ParalyzeSpellItem(attaker,defender);
						break;
					}
				case 14:
					{
						Magic->ExplosionSpellItem(attaker,defender);
						break;
					}
				case 15:
					{
						Magic->FlameStrikeSpellItem(attaker,defender);
						break;
					}
					
				}
				items[i].morez--;
				if (items[i].morez == 0)
				{
					items[i].type = items[i].type2;
					items[i].morex = 0;
					items[i].morey = 0;
					items[i].offspell = 0;
				}
			}
			return;
		}
    }
}

bool cCombat::weapon2Handed( int weapon )
//PRE:			true
//POST:			returns true if weapon 2 handed, otherwise false
//DATE:			16 Sept 1999
//PROGRAMMER:	Abaddon
{
	if( weapon == -1 ) return false;
	if ((items[weapon].id1==0x0F)&&(items[weapon].id2==0x4F) || //xbow 
		(items[weapon].id1==0x13)&&(items[weapon].id2==0xFD)  ) //hxbow
		return true;
	if ((items[weapon].id1==0x13)&&(items[weapon].id2==0xB2))
		return true;
	if ((items[weapon].id1==0x0F)&&(items[weapon].id2>=0x43)&&(items[weapon].id2<=0x4E) || //2H axes 
		(items[weapon].id1==0x14)&&(items[weapon].id2>=0x3E)&&(items[weapon].id2<=0x43) || //halberd
		(items[weapon].id1==0x0F)&&(items[weapon].id2==0x62)||(items[weapon].id2==0x63) || //fencing - spear
		(items[weapon].id1==0x13)&&(items[weapon].id2==0xFA)||(items[weapon].id2==0xFB) || 
		(items[weapon].id1==0x0E)&&(items[weapon].id2==0x87)||(items[weapon].id2==0x88)  ) //fencing - pitchfork
		return true;
	return false;
}

//AntiChrist - do the sound effect ( only if HITTEN! )
void cCombat::doSoundEffect(CHARACTER p, int fightskill, ITEM weapon)
{
	bool heavy=false;
	int a=rand()%4;

	//check if a heavy weapon
	if (weapon>-1)
	if ((items[weapon].id1==0x0F)&&(items[weapon].id2>=0x43)&&(items[weapon].id2<=0x4E) || //2H axes 
	(items[weapon].id1==0x14)&&((items[weapon].id2==0x3E)||(items[weapon].id2==0x3F)) || //halberd
	(items[weapon].id1==0x14)&&((items[weapon].id2==0x42)||(items[weapon].id2==0x43))) //two handed axe
		heavy=true;

	if(heavy)
	{
		if (a==0 || a==1) soundeffect2(p, 0x02, 0x36);
		else soundeffect2(p, 0x02, 0x37);
		return;
	}		

	switch(fightskill)
	{
	case ARCHERY:
		soundeffect2(p, 0x02, 0x34);
		break;
	case FENCING:
	case SWORDSMANSHIP:
		if (a==0 || a==1) soundeffect2(p, 0x02, 0x3B);
		else soundeffect2(p, 0x02, 0x3C);
		break;
	case MACEFIGHTING:
		if (a==0 || a==1) soundeffect2(p, 0x02, 0x32);
		else if (a==2) soundeffect2(p, 0x01, 0x39);
		else soundeffect2(p, 0x02, 0x33);
		break;
	case WRESTLING:
		if (a==0) soundeffect2(p, 0x01, 0x35);
		else if (a==1) soundeffect2(p, 0x01, 0x37);
		else if (a==2) soundeffect2(p, 0x01, 0x3D);
		else soundeffect2(p, 0x01, 0x3B);
		break;
	default:
		soundeffect2(p, 0x01, 0x3D);
	}
}


//AntiChrist - do the "MISSED" sound effect
void cCombat::doMissedSoundEffect(CHARACTER p)
{
	int a=rand()%3;

	if (a==0) soundeffect2(p, 0x02, 0x38);
	else if (a==1) soundeffect2(p, 0x02, 0x39);
	else soundeffect2(p, 0x02, 0x3A);
}
