/*
Module : necro.cpp
Purpose: store all necromancy related functions
Created: Genesis 11-12-1998
History: None
*/

#include "uox3.h"
#include "debug.h"

#define DBGFILE "necro.cpp"


int SpawnRandomMonster(int nCharID, char* cScript, char* cList, char* cNpcID)
{
	/*This function gets the random monster number from the from
	the script and list specified.
	Npcs->AddRespawnNPC passing the new number*/

	char sect[512];
	int i=0,item[256]={0};
 	openscript(cScript);
 	sprintf(sect, "%s %s", cList, cNpcID);
	if(!(strcmp("necro.scp",cScript)))
	{
		if(!i_scripts[necro_script]->find(sect))
		{
  			closescript();
  			return -1;
 		}
	}
	else
	{
		if(!i_scripts[npc_script]->find(sect))
 		{
  			closescript();
			if (n_scripts[custom_npc_script][0]!=0)
			{
				openscript(n_scripts[custom_npc_script]);
				if (!i_scripts[custom_npc_script]->find(sect))
				{
					closescript();
					return -1;
				}
			} else return -1;
		}
	}
 	do
 	{
  		read1();
		if(script1[0]!='}')
		{
			item[i]=str2num(script1);
			i++;
		}
 	}
 	while(script1[0]!='}');
 	closescript();
 	if(i>0)
 	{
  		i=rand()%(i);
		if(item[i]!=-1)
		{
			Npcs->AddRespawnNPC(nCharID,-1,item[i],0);
			return item[i];
		}
	}
	return -1;
}

int SpawnRandomItem(UOXSOCKET nCharID,int nInPack, char* cScript, char* cList, char* cItemID)
{
 	/*This function gets the random item number from the list and recalls
 	  SpawnItemBackpack2 passing the new number*/
	char sect[512];
	int i=0,item[256]={0};
 	openscript(cScript);
	sprintf(sect, "%s %s", cList, cItemID);
	if(!(strcmp("necro.scp",cScript)))
	{
		if(!i_scripts[necro_script]->find(sect))
		{
			closescript();
			return -1;
		}
	}
	else
	{
		if(!i_scripts[items_script]->find(sect))
		{
			closescript();
			if (n_scripts[custom_item_script][0]!=0)
			{
				openscript(n_scripts[custom_item_script]);
				if (!i_scripts[custom_item_script]->find(sect))
				{
					closescript();
					return -1;
				}
			} else return -1;
		}
	}
 	do
 	{
  		read1();
  		if (script1[0]!='}')
  		{
			item[i]=str2num(script1);
   			i++;
		}
	}
	while(script1[0]!='}');
	closescript();
 	if(i>0)
 	{
  		i=rand()%(i);
		if(item[i]!=-1)
		if(nInPack)
		{
			Items->SpawnItemBackpack2(nCharID,currchar[nCharID],item[i],1);
			return item[i];
		}
	}
	return -1;
}

void vialtarget(int nSocket) // bug & crashfixed by LB 25 September 1999
{
	int serial,nVialID=-1,nTargetID=-1,nDagger=-1,nItemID,nDist=0, item, serhash, i, dag, ci;
	int p=packitem(currchar[nSocket]);
	
	if(buffer[nSocket][11]==0xFF && buffer[nSocket][12]==0xFF && buffer[nSocket][13]==0xFF && buffer[nSocket][14]==0xFF) 
		return; // check if user canceled operation
	
	nVialID = addx[nSocket]; // LB
	serial=calcserial(buffer[nSocket][7],buffer[nSocket][8],buffer[nSocket][9],buffer[nSocket][10]);
	nItemID=findbyserial(&charsp[serial%HASHMAX], serial, 1); // targeted a living creature ?
	if (nItemID!=-1) nTargetID=nItemID;

	serial=calcserial(buffer[nSocket][7],buffer[nSocket][8],buffer[nSocket][9],buffer[nSocket][10]);
	nItemID=findbyserial(&itemsp[serial%HASHMAX], serial, 0); // or a corpse/different item ?
	if ((nItemID!=-1) && (nTargetID==-1)) nTargetID=nItemID;

	serial = chars[currchar[nSocket]].serial; // search for a dagger in the players hand
	serhash = serial%HASHMAX;
	item = -1;
	for( ci = 0; ci < contsp[serhash].max; ci++ )
	{
		i = contsp[serhash].pointer[ci];
		if( i != -1 )
		{
			printf("Name: %s id1: %i id2: %i\n", items[i].name, items[i].id1, items[i].id2 );
			if( items[i].id1 = 0x0F && ( items[i].id2 == 0x51 || items[i].id2 == 0x52 ) ) dag = 1; else dag = 0;
			if((( items[i].layer == 1 ) && ( items[i].contserial == serial ) && dag ))
			{
				item = i;
				break;
			}
		}
	}

	nDagger = item;

	if( nVialID < 0 ) return; // should never happen

//	if(nVialID!=-1 && nTargetID!=-1 && nDagger!=-1) return; CRAP_ALERT !!! LB
	if( nVialID != -1 && nTargetID != -1 && nDagger != -1 )
	{
		items[nVialID].more1=0;
		if(chars[nTargetID].npc<=1 && items[nTargetID].corpse!=1)
		{
			// checkskill hmmm what skill/s has/have to add here LB ...
			if(((unsigned int) nTargetID) ==currchar[nSocket])
			{
				if(chars[nTargetID].hp<=10)
				{
					sysmessage(nSocket,"You are too wounded to continue.");
					return;
				}
				else
				{
					sysmessage(nSocket,"You prick your finger and fill the vial.");
					chars[nTargetID].hp=(chars[nTargetID].hp-((rand()%6)+2));
					MakeNecroReg(nSocket,nVialID,0x0E,0x24);
					return;
				}
			}
			else
			{
				nDist=chardist(currchar[nSocket],nTargetID);
				if((inrange1p(currchar[nSocket],nTargetID))&&
					(nDist<=2))
				{
					sprintf(temp,"%s has pricked you with a dagger and sampled your blood.",chars[currchar[nSocket]].name);
					if(chars[nTargetID].npc==1)
					{
						Karma(currchar[nSocket],nTargetID,(0-(chars[nTargetID].karma)));
						if((chars[nTargetID].id1==0x00)&&((chars[nTargetID].id2==0x0c)||(chars[nTargetID].id2>=0x3b)&&(chars[nTargetID].id2<=0x3d)))
							items[nVialID].more1=1;
						chars[nTargetID].hp=(chars[nTargetID].hp-((rand()%6)+2));
						MakeNecroReg(nSocket,nVialID,0x0E,0x24);
						// Guard be summuned if in town and good npc
						// if good flag criminal
						// if evil npc attack necromancer but don't flag criminal
					}
					else
					{
						Karma(currchar[nSocket],nTargetID,(0-(chars[nTargetID].karma)));
						chars[nTargetID].hp=(chars[nTargetID].hp-((rand()%6)+2));
						sysmessage(calcSocketFromChar(nTargetID),temp);
						MakeNecroReg(nSocket,nVialID,0x0E,0x24);
						// flag criminal						
					}
				}
				else 
				{
					sysmessage(nSocket,"That individual is not anywhere near you.");
					return;
				}
			}
		}
		else
			if(items[nTargetID].corpse==1)
			{
				items[nVialID].more1=items[nTargetID].more1;
				Karma(currchar[nSocket],-1,-1000);
				if(items[nTargetID].more2<4)
				{
					sysmessage(nSocket,"You take a sample of blood from the corpse.");
					MakeNecroReg(nSocket,nVialID,0x0E,0x24);
					items[nTargetID].more2++;
				}
				else sysmessage(nSocket,"You examine the corpse but, decide any further blood samples would be to contaminated.");
			}
			else sysmessage(nSocket,"That is not a person or a corpse!");
	}		
	if(nDagger==-1) sysmessage(nSocket,"You do not have a dagger in your pack.");	
}

void MakeNecroReg(int nSocket,int nItem,char cItemID1,char cItemID2)
{
	int iCharID,iItem=0;
	int p=packitem(currchar[nSocket]);

	iCharID = currchar[nSocket];

	if((cItemID1==0x1b)&&((cItemID2>=0x11)&&(cItemID2<=0x1c))) // Make bone powder.
	{
		sprintf(temp,"%s is grinding some bone into powder.", chars[iCharID].name);
		npcemoteall(currchar[nSocket], temp, 1);
		tempeffect(currchar[nSocket], currchar[nSocket], 9, 0, 0, 0);
		tempeffect(currchar[nSocket], currchar[nSocket], 9, 0, 3, 0);
		tempeffect(currchar[nSocket], currchar[nSocket], 9, 0, 6, 0);
		tempeffect(currchar[nSocket], currchar[nSocket], 9, 0, 9, 0);
		iItem=Items->SpawnItem(nSocket,1,"bone powder",1,0x0F,0x8F,0,0,1,1);
		if( iItem == -1 ) return;
		items[iItem].morex = 666;
		items[iItem].more1=1; // this will fill more with info to tell difference between ash and bone
		Items->DeleItem(nItem);
		
	}
	if((cItemID1==0x0E)&&(cItemID2==0x24)) // Make vial of blood.
	{
		if(items[nItem].more1==1)
		{
			iItem=Items->SpawnItem(nSocket,1,"#",1,0x0F,0x82,0,0,1,1);
			if( iItem == -1 ) return;
			items[iItem].value=15;
			items[iItem].morex = 666;
		}
		else
		{
			iItem=Items->SpawnItem(nSocket,1,"#",1,0x0F,0x7D,0,0,1,1);
			if( iItem == -1 ) return;
			items[iItem].value=10;
			items[iItem].morex = 666;
		}
		if(items[nItem].amount>1)
		{
			items[nItem].amount--;
			if(items[nItem].amount==1) //senditem(nItem,currchar[nSocket]);
				RefreshItem( nItem ); // AntiChrist
		}
		else
			Items->DeleItem(nItem);
	}
}
