#include "uox3.h"
#if CLIENTVERSION_M==25
#include "srvkey.h"
#endif
#include "debug.h"

#ifdef __LINUX__
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif


#define DBGFILE "Network.cpp"

#ifndef __NT__
#define closesocket(s)	close(s)
#endif

#if CLIENTVERSION_M==26
void cNetworkStuff::DoStreamCode( int s )
{
	if( s==-1 ) return;
	int len = pCrypt[s]->Pack( outbuffer[s], xoutbuffer, boutlength[s] );
	send( client[s], xoutbuffer, len, 0 );
}
#endif

#if CLIENTVERSION_M==25
void cNetworkStuff::DoStreamCode(int s)
{
	int actByte = 0, bitByte = 0, nrBits;
	unsigned int value;
	
	// if (s<0 || s>MAXCLIENT) return; //LB deactived for now for a more effective -1 hunt 
	
	for(int tempPos = 0; tempPos <= boutlength[s]; tempPos++)
	{
		if(tempPos == boutlength[s]) value = keyid[256];
		else value = keyid[(unsigned char)outbuffer[s][tempPos]];
		nrBits = value & 0xF;
		value >>= 4;
		while(nrBits)
		{
			xoutbuffer[actByte] = (char)(((unsigned int)xoutbuffer[actByte] << 1) + ((value >> (nrBits - 1)) & 0x1));
			nrBits--;
			bitByte++;
			if(bitByte == 8)
			{
				bitByte = 0;
				actByte++;
			}
		}
	}
	if(bitByte)
	{
		while(bitByte < 8)
		{
			xoutbuffer[actByte] <<= 1;
			bitByte++;
		}
		actByte++;
	}
	send(client[s], xoutbuffer, actByte, 0);
}
#endif

#if CLIENTVERSION_M==25
char cNetworkStuff::Crypt (int s, char c)
{ //2 key encryption for versions other than version 36 client
	unsigned int mask[2];
	mask[0] = cryptmask[s][0];
	mask[1] = cryptmask[s][1];
	
	cryptmask[s][1] = (((((mask[1] >> 1) | (mask[0] << 31)) ^ MASTERKEY1) >> 1) | (mask[0] << 31)) ^ MASTERKEY1;
	cryptmask[s][0] = ((mask[0] >> 1) | (mask[1] << 31)) ^ MASTERKEY2;
	return c ^ (char)mask[0];
	
}

#endif

int cNetworkStuff::xRecv(int s) // Better Receive routine than the one currently used; not intergrated yet
{
	int count, i;
#ifdef DEBUG_NETWORK
	int x, y = 0, j;
	char st[10], txt[17];
#endif
	
	count=recv(client[s], &buffer[s][binlength[s]], MAXBUFFER-binlength[s], 0);
#ifdef DEBUG_NETWORK
	printf("REC:\n");
	x=0;
#endif
#if CLIENTVERSION_M==25
	for (i=binlength[s];i<binlength[s]+count;i++)
	{
		buffer[s][i]=Crypt(s, buffer[s][i]);
#ifdef DEBUG_NETWORK
		y=x%16;
		if ((y)==0)
		{
			sprintf(st, "%x", x);
			printf("C%i [",s);
			for (j=4-strlen(st);j>0;j--) printf("0");
			printf("%s] ", st);
		}
		sprintf(st, "%X", buffer[s][i]);
		if (strlen(st)==2) printf("%s ", st); else printf("0%s ", st);
		if (!(iscntrl(buffer[s][i]))) txt[y]=buffer[s][i]; else txt[y]='.';
		if (y==15)
		{
			txt[16]=0;
			printf("%s\n", txt);
		}
		x++;
#endif
	}
#endif
#if CLIENTVERSION_M==26
	i=binlength[s]+count;
	pCrypt[s]->Decrypt( &buffer[s][i], &buffer[s][i], count );
#endif
	binlength[s]+=count;
#ifdef DEBUG_NETWORK
	if ((y)!=15)
	{
		txt[y+1]=0;
		for (j=15-y;j>0;j--) printf("   ");
		printf("%s\n",txt);
	}
#endif
	return count;
}

void cNetworkStuff::Processed(int s, int i) // To be used later together with xrecv
{
	memcpy(buffer[s], &buffer[s][i], binlength[s]-i);
	binlength[s]-=i;
	if (binlength[s]<0) binlength[s]=0;
}

void cNetworkStuff::FlushBuffer(int s) // Sends buffered data at once
{
	if (boutlength[s]>0)
	{
		//  printf("S = %i, bout = %i, cc = %i\n", s, boutlength[s], cryptclient[s]);
		if (cryptclient[s])
		{
			DoStreamCode(s);
		}
		else
		{
			send(client[s], outbuffer[s], boutlength[s], 0);
		}
		boutlength[s]=0;
		//  printf("Done\n");
	}
}

void cNetworkStuff::ClearBuffers() // Sends ALL buffered data
{
	int i;
	
	for (i=0;i<now;i++)
	{
		FlushBuffer(i);
	}
}

void cNetworkStuff::xSend(int s, void *point, int length, int test) // Buffering send function
{
	if( s == -1 ) return;
	if (boutlength[s]+length>MAXBUFFER) FlushBuffer(s);
#ifdef DEBUG_NETWORK
	int buf2c, i, j;
	char buf2[32];
	
	printf("*** xSend\n"); fflush(stdout);
	
	buf2c=0;
	for(i=0;i<length;i++)
	{
		buf2[buf2c]=((unsigned char *)point)[i];
		buf2c++;
		if ((buf2c==16)||(i==length-1))
		{
			printf("C%02x %02x : ",s,((i%256)/16)*16);
			for (j=0;j<buf2c;j++)
			{
				printf("%2x ",buf2[j]);
			}
			
			for (j=0;j<buf2c;j++)
			{
				if ((isalnum(buf2[j]))||(isprint(buf2[j]))) printf("%c",buf2[j]); else printf(".");
			}
			for(;j<16;j++) printf(".");
			buf2c=0;
			printf("]\n");
		}
	}
	fflush(stdout);
#endif
	memcpy(&outbuffer[s][boutlength[s]], point, length);
	boutlength[s]+=length;
	// printf("%i\n", boutlength[s]);
}

#if CLIENTVERSION_M==25
void cNetworkStuff::GenTable (int n, char a1, char a2, char a3, char a4) // Initialize encryption table
{
	unsigned int seed = ((unsigned int)a1 << 24) + ((unsigned int)a2 << 16) + ((unsigned int)a3 << 8) + (unsigned int)a4;
	
	cryptmask[n][0] = (((~seed) ^ 0x00001357) << 16) | ((seed ^ 0xffffaaaa) & 0x0000ffff);
	cryptmask[n][1] = ((seed ^ 0x43210000) >> 16) | (((~seed) ^ 0xabcdffff) & 0xffff0000);
}
#endif

// set the laston character member value to the current date/time
void setLastOn(UOXSOCKET s)
{
	assert(s != -1);
	
	time_t ltime;
	time( &ltime );
	char *t = ctime(&ltime);
	// just to be paranoid and avoid crashing
	if (NULL == t)
		t = "";
	else
	{
		// some ctime()s like to stick \r\n on the end, we don't want that
		for (int end = strlen(t) - 1; end >= 0 && isspace(t[end]); --end)
			t[end] = '\0';
	}
	safeCopy(chars[currchar[s]].laston, t, MAX_LASTON);
}

void cNetworkStuff::Disconnect (int s) // Force disconnection of player //Instalog
{
	int j;
	
	setLastOn(s);
	if( xgm )
	{
		if( xGM[s]->isClient )
		{
			printf("UOX3: Client %i (XGM) disconnected. [Total:%i]\n", s, now-1 );
			xGM[s]->isClient = 0;
		} else
			printf("UOX3: Client %i disconnected. [Total: %i]\n", s, now - 1 );
	} else
		printf("UOX3: Client %i disconnected. [Total:%i]\n",s,now-1);
	if (usedfree[s]) freelogins++;
	FlushBuffer(s);
	closesocket(client[s]);
	
#if CLIENTVERSION_M==26
	delete pCrypt[s];
#endif
	
	if ((chars[currchar[s]].account==acctno[s])&&(server_data.partmsg)) 
	{
		sprintf(temp,"%s has left the realm",chars[currchar[s]].name);
		sysbroadcast(temp);//message upon leaving a server 
	} 
	if (acctno[s]!=-1) 
		acctinuse[acctno[s]]=0; //Bug clearing logged in accounts!
	acctno[s]=-1;
	/*for (i=0;i<now;i++)//Instalog
	if ((i!=s)&&(perm[i]))
	{
	removeitem[1]=chars[currchar[s]].ser1;
	removeitem[2]=chars[currchar[s]].ser2;
	removeitem[3]=chars[currchar[s]].ser3;
	removeitem[4]=chars[currchar[s]].ser4;
	xSend(i, removeitem, 5, 0);
}*/
	for (j=s;j<now-1;j++)
	{
		client[j]=client[j+1];
		newclient[j]=newclient[j+1];
		currchar[j]=currchar[j+1];
		clientip[j][0]=clientip[j+1][0];
		clientip[j][1]=clientip[j+1][1];
		clientip[j][2]=clientip[j+1][2];
		clientip[j][3]=clientip[j+1][3];
		acctno[j]=acctno[j+1];
		//  war[j]=war[j+1];
		perm[j]=perm[j+1];
		addid1[j]=addid1[j+1];
		addid2[j]=addid2[j+1];
		addid3[j]=addid3[j+1];
		addid4[j]=addid4[j+1];
		addx[j]=addx[j+1];
		addy[j]=addy[j+1];
		addz[j]=addz[j+1];
		cryptclient[j]=cryptclient[j+1];
#if CLIENTVERSION_M==25
		cryptmask[j][0]=cryptmask[j+1][0];
		cryptmask[j][1]=cryptmask[j+1][1];
#endif
#if CLIENTVERSION_M==26
		pCrypt[j] = pCrypt[j+1];
#endif
	}
	//Instalog
	LogOut(s);
	currchar[now]=0;
	now--;
}


void cNetworkStuff::Login1(int s) // Initial login (Login on "loginserver", new format) // Revana*
{
	int i;
	unsigned long int j, tlen, t;
	unsigned long int ip;
	char acctused[3]="\x82\x01";
	char newlist1[7]="\xA8\x01\x23\xFF\x00\x01";
	char newlist2[41]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x01\x7F\x00\x00\x01";
	
	acctno[s]=-1;
	for (i=0;i<acctcount;i++)
	{
		t=0;
		if (strlen(&buffer[s][1])==strlen(acctx[i].name))
		{
			printf("Searching under account %i (%s) for (%s)\n", i, acctx[i].name, &buffer[s][1] );
			t=1;
			for (j=0;j<strlen(&buffer[s][1]);j++)
				if (toupper(buffer[s][j+1])!=toupper(acctx[i].name[j])) t=0;
				if (strlen(&buffer[s][1])==0) t=0;
		}
		if (t==1) acctno[s]=i;
	}
	if (acctno[s]==-1)
	{
		if ( server_data.auto_a_create )
		{
			t=1;
			sprintf(temp, "%x.%x.%x.%x",clientip[s][0],clientip[s][1],clientip[s][2],clientip[s][3]);
			for (j=0;j<acctcount;j++)
			{
				if ( (!(strcmp(temp,acctx[j].tempIP))) || ( acctx[j].ip1 == clientip[s][0] && acctx[j].ip2 == clientip[s][1] && acctx[j].ip3 == clientip[s][2] && acctx[j].ip4 == clientip[s][3] ) )
				{
					t=0;
					break;
				}
			}
			
			if (t)
			{
				printf("AUTOACCT: New account \"%s\":\"%s\" created for %x.%x.%x.%x\n",&buffer[s][1],&buffer[s][31],clientip[s][0],clientip[s][1],clientip[s][2],clientip[s][3]);
				memset(acctx + acctcount,0,sizeof(acct_st));
				strcpy(acctx[acctcount].name, &buffer[s][1]);
				strcmp(acctx[acctcount].pass, &buffer[s][31]);
				acctno[s] = acctcount;
				acctx[acctcount].ip1 = clientip[s][0];
				acctx[acctcount].ip2 = clientip[s][1];
				acctx[acctcount].ip3 = clientip[s][2];
				acctx[acctcount].ip4 = clientip[s][3];
				//	EviLDeD	-	February 10, 2000
				//	Default runtime additions are set as public on the webpage
				acctx[acctcount].listpublic=true;
				//	EviLDeD	-	End
				cwmWorldState->saveAccount();
				acctcount++;
			} else {
				xSend(s, acctused, 2, 0);
				return;
			}
			t=0;
		}
	}
	
	if (acctno[s]!=-1)
	{
		printf("Password Sent: %s\n", &buffer[s][31] );
		pSplit(&buffer[s][31]);
		t=0;
		printf("The password [%s], the account password: [%i] [%s]\n", pass1, acctno[s], acctx[acctno[s]].pass );
		if (strlen(pass1)==strlen(acctx[acctno[s]].pass))
		{
			t=1;
			for (j=0;j<strlen(pass1);j++)
				if (toupper(pass1[j])!=toupper(acctx[acctno[s]].pass[j])) t=0;
				if (strlen(pass1)==0) t=0;
				//if ((acctx[acctno[s]][1][0]=='x')&&(acctx[acctno[s]][1][1]=='x')&&(acctx[acctno[s]][1][2]=='x'))
				//account banning by Anthracks 1-3-99
				printf("Wipe %i Ban %i\n", acctx[acctno[s]].wipe, acctx[acctno[s]].ban );
				if( acctx[acctno[s]].ban==1 ) // They are banned
					t = 2;
				if( acctx[acctno[s]].wipe == 1 )
				{
					t = 3;
					acctno[s] = -1;
				}
		}
		
		if (t==0)
		{
			acctno[s]=-1;
			xSend(s, nopass, 2, 0);
			//   disconnect(s);
		}
		if (t==2)
		{
			acctno[s]=-1;
			xSend(s, acctblock, 2, 0);
			//   disconnect(s);
		}
		if( t == 3 )
		{
			acctno[s] = -1;
			xSend( s, noaccount, 2, 0 );
		}
	}
	else
	{
		xSend(s, noaccount, 2, 0);
		//  disconnect(s);
	}
	if (acctinuse[acctno[s]])
	{
		acctno[s]=-1;
		xSend(s, acctused, 2, 0);
		//  disconnect(s);
	}
	if (acctno[s]!=-1)
	{
#ifndef __NT__
/*		getpeername(s, (struct sockaddr*) &client_addr, &len_connection_addr);
		//UI32 tmpip = htonl(client_addr.sin_addr.s_addr);
		UI32 tmpip = ntohl(client_addr.sin_addr.s_addr);		// Tseramed, already in network byte order
#ifdef DEBUG_NETWORK
		printf("Client connected from %lu\n", tmpip);
#endif*/
		acctx[acctno[s]].ip1 = (char) clientip[s][0];
		acctx[acctno[s]].ip2 = (char) clientip[s][1];
		acctx[acctno[s]].ip3 = (char) clientip[s][2];
		acctx[acctno[s]].ip4 = (char) clientip[s][3];
#else
		acctx[acctno[s]].ip1 = client_addr.sin_addr.S_un.S_un_b.s_b1;
		acctx[acctno[s]].ip2 = client_addr.sin_addr.S_un.S_un_b.s_b2;
		acctx[acctno[s]].ip3 = client_addr.sin_addr.S_un.S_un_b.s_b3;
		acctx[acctno[s]].ip4 = client_addr.sin_addr.S_un.S_un_b.s_b4;
#endif
		sprintf(temp,"Client [%i.%i.%i.%i] connected using Account '%s'.\n",
			acctx[acctno[s]].ip1, acctx[acctno[s]].ip2, acctx[acctno[s]].ip3, acctx[acctno[s]].ip4, &buffer[s][1]);
		savelog(temp,"server.log");
		printf( temp );
		
		acctinuse[acctno[s]]=1;
		tlen=6+(servcount*40);
		newlist1[1]=(char)(tlen>>8);
		newlist1[2]=(char)(tlen%256);
		newlist1[4]=(char)(servcount>>8);
		newlist1[5]=(char)(servcount%256);
		xSend(s, newlist1, 6, 0);
		for (i=0;i<servcount;i++)
		{
#if CLIENTVERSION_M==25
			newlist2[0]=(char)(i>>8);
			newlist2[1]=(char)(i%256);
#endif
#if CLIENTVERSION_M==26
			newlist2[0]=(char)((i+1)>>8);
			newlist2[1]=(char)((i+1)%256);
#endif
			strcpy(&newlist2[2], serv[i][0]);
			ip=htonl(inet_addr(serv[i][1]));
			newlist2[36]=(char) (ip>>24);
			newlist2[37]=(char) (ip>>16);
			newlist2[38]=(char) (ip>>8);
			newlist2[39]=(char) (ip%256);
			xSend(s, newlist2, 40, 0);
		}
	}
}

void cNetworkStuff::Relay(int s) // Relay player to a certain IP
{
#ifdef DEBUG_NETWORK
	printf("Going to relay...\n");
#endif
	
	unsigned long int ip;
#if CLIENTVERSION_M==25
	ip = htonl(inet_addr(serv[buffer[s][2]][1]));
#endif
#if CLIENTVERSION_M==26
	ip = htonl(inet_addr( serv[buffer[s][2]-1][1] ));
#endif
	//C00 00 : 8c ce e4 3d 6d  a 21 7f  0  0  1 ...=m.!.........]
	//C00 00 : 8c 6d 3d e4 ce  a 21 7f  0  0  1 .m=...!.........]
	
	login03[1]=(char) (ip>>24);
	login03[2]=(char) (ip>>16);
	login03[3]=(char) (ip>>8);
	login03[4]=(char) (ip%256);
	login03[5]=UOX_PORT>>8;
	login03[6]=UOX_PORT%256;
	srand(ip+acctno[s]+now+uiCurrentTime); // Perform randomize
	login03[7]=127;
	login03[8]=0;
	login03[9]=0;
	login03[10]=1;
	xSend(s, login03, 11, 0);
}

void cNetworkStuff::GoodAuth(int s) // Revana*
{
	int i, j, tlen;
	bool passed = false;
	
	tlen=4+(5*60)+1+(startcount*63);
	login04a[1]=tlen>>8;
	login04a[2]=tlen%256;
	login04a[3]=5;
	xSend(s, login04a, 4, 0);
	j=0;
	for (i=0;i<charcount;i++)
	{
		if ((chars[i].account==acctno[s])&&(chars[i].free==0)&&(strlen(chars[i].name)>0))
			//if (chars[i].account==acctno[s])
		{
			//   for (k=0;k<strlen(chars[i].name);k++) login04b[k]=chars[i].name[k];
			passed = false;
			/*for( a = 0; a < MAX_ACCT_LOCK; a++ )
			{
				if( acctx[acctno[s]].lock[a] == chars[i].serial )
				{
					sprintf( login04b, "%s [L]", chars[i].name );
					xSend( s, login04b, 60, 0 );
					j++;
					passed = true;
				}
			}*/
			if( passed == false )
			{
				strcpy(login04b, chars[i].name);
				xSend(s, login04b, 60, 0);
				j++;
			}
		}
	}
	for (i=0;i<60;i++) login04b[i]=0;
	for (i=j;i<5;i++)
	{
		xSend(s, login04b, 60, 0);
	}
	buffer[s][0]=startcount;
	xSend(s, buffer[s], 1, 0);
	for (i=0;i<startcount;i++)
	{
		login04d[0]=i;
		for (j=0;j<=strlen(start[i][0]);j++) login04d[j+1]=start[i][0][j];
		for (j=0;j<=strlen(start[i][1]);j++) login04d[j+32]=start[i][1][j];
		xSend(s, login04d, 63, 0);
	}
	if( xgm )
	{
		for( i = 0; i < now; i++ )
		{
			if( xGM[i]->isClient && xGM[i]->Acct == acctno[s] && acctx[acctno[s]].xGM )
			{ // Check to see if they are an XGM, if so, log 'em in.
				xGM[i]->ClientSock = s;
				break;
			}
		}
	}
}

void cNetworkStuff::FailAuth(int s)
{
	char noauth[3]="\x53\x01";
#ifdef DEBUG_NETWORK
	printf("Character doesn't exist!\n");
#endif
	xSend(s, noauth, 2, 0); // Say "Character doesnt exist" and close client
	Disconnect(s);
	return;
}

void cNetworkStuff::AuthTest(int s)
{
	int auth;
	char answer[3];
	
	auth=1;
	recv(server[s], answer, 2, 0);
	if ((answer[0]!=0xA8)&&(answer[0]!=0x81)) auth=0;
	closesocket(server[s]);
	server[s]=-1;
	if (auth)
	{
		printf("AUTH: Authentication successful\n");
		GoodAuth(s);
	}
	else
	{
		printf("AUTH: Authentication failed\n");
		FailAuth(s);
	}
	// sysbroadcast("Normal server operation resumed.");
}

void cNetworkStuff::CharList(int s) // Gameserver login and character listing // Revana*
{
	int i, j, t;
#ifdef LSERVCHECK
#ifdef NOSINGLEONLY
	int ls, ls2, auth;
	int lcode, positive;
	char verify1[5]="\x12\x34\x56\x78";
	// char verify1[5]="\xC2\xC3\xCA\x6C";
	char verify2[63]="\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
#endif
#endif
	
	acctno[s]=-1;
	for (i=0;i<acctcount;i++)
	{
		t=0;
		if (strlen(&buffer[s][5])==strlen(acctx[i].name))
		{
			t=1;
			for (j=0;j<strlen(&buffer[s][5]);j++)
				if (toupper(buffer[s][j+5])!=toupper(acctx[i].name[j])) t=0;
				if (strlen(&buffer[s][5])==0) t=0;
		}
		if (t==1) acctno[s]=i;
	}
	if (acctno[s]!=-1)
	{
		pSplit(&buffer[s][35]);
		t=0;
		if (strlen(pass1)==strlen(acctx[acctno[s]].pass))
		{
			t=1;
			for (j=0;j<strlen(pass1);j++)
				if (toupper(pass1[j])!=toupper(acctx[acctno[s]].pass[j])) t=0;
				if (strlen(pass1)==0) t=0;
				if( acctx[acctno[s]].ban == 1 )
					t=2;
				if( acctx[acctno[s]].wipe == 1 )
					t = 3;
		}
		if( t == 3 )
		{
#ifdef DEBUG_NETWORK
			printf("No account!\n");
#endif
			acctno[s] = -1;
			xSend( s, noaccount, 2, 0 );
			Disconnect( s );
		}
		
		if (t==0)
		{
#ifdef DEBUG_NETWORK
			printf("No password!\n");
#endif
			acctno[s]=-1;
			xSend(s, nopass, 2, 0);
			Disconnect(s);
			return;
		}
		if (t==2)
		{
#ifdef DEBUG_NETWORK
			printf("Player blocked!\n");
#endif
			acctno[s]=-1;
			xSend(s, acctblock, 2, 0);
			Disconnect(s);
			return;
		}
	}
	else
	{
#ifdef DEBUG_NETWORK
		printf("No account!\n");
#endif
		xSend(s, noaccount, 2, 0);
		Disconnect(s);
		return;
	}
	if (acctno[s]==0) GoodAuth(s);
	else
	{
#ifdef LSERVCHECK
#ifdef NOSINGLEONLY
		auth=1;
		if (acctno[s]!=0)
			//  sysbroadcast("Excuse the delay, player logging in.");
			ls=0;
		positive=0;
		do
		{
			server[s]=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
			connection.sin_family=AF_INET;
			if ((ls==0)||(ls==1))
			{
				connection.sin_addr.s_addr=0xE1D218DD; // Encrypted IP adress of loginserver
			}
			if ((ls==2)||(ls==3))
			{
				connection.sin_addr.s_addr=0xF0D218DD;
			}
			connection.sin_addr.s_addr=(connection.sin_addr.s_addr^0x9D54F712);
			if ((ls==0)||(ls==2))
			{
				connection.sin_port=0x5F1E;
			}
			if ((ls==1)||(ls==3))
			{
				connection.sin_port=0x601E;
			}
			printf("AUTH: Trying loginserver %i...\n",ls+1);
			len_connection_addr=sizeof (struct sockaddr);
			lcode=connect(server[s],(struct sockaddr *)&connection, len_connection_addr);
			if (lcode>=0)
			{
				positive=1;
			}
			ls++;
		}
		while (! ((ls==4)||(positive)) );
		if (!positive)
		{
			printf("AUTH: Could not connect to loginserver\n");
			if (freelogins>0)
			{
				printf("AUTH: Using offline login for player. (%i out of 4)\n", 5-freelogins);
				freelogins--;
				usedfree[s]=1;
				goodauth(s);
			}
			else
			{
				printf("AUTH: Out of offline logins. Disconnecting player.\n");
				failauth(s);
			}
		}
		else
		{
			printf("AUTH: Connected to loginserver\n");
			gentable(MAXCLIENT+1,0x12,0x34,0x56,0x78);
			//   gentable(MAXCLIENT+1, 194, 195, 202, 108);
			send(server[s], verify1, 4, 0);
			verify2[0]=0x80;
			strcpy(&verify2[1], &buffer[s][5]);
			strcpy(&verify2[31], pass2);
			verify2[61]=0x12;
			for (ls2=0;ls2<62;ls2++)
			{
				verify2[ls2]=verify2[ls2]^ctable[MAXCLIENT+1][ls2];
			}
			send(server[s], verify2, 62, 0);
		}
#endif
#endif
#ifdef SINGLEONLY
		if (acctno[s]!=0) // This is for single-player testing releases
		{
			printf("AUTH: Only server operator is allowed to login with this version\n");
			FailAuth(s);
		}
#endif
#ifdef NOLSERVCHECK
		GoodAuth(s);
#endif
	}
}

void cNetworkStuff::pSplit (char *pass0) // Split login password into UOX password and UO password
{
	int i;
	i=0;
	pass1[0]=0;
	while (pass0[i]!='/' && pass0[i]!=0) i++;
	strncpy(pass1,pass0,i);
	pass1[i]=0;
	if (pass0[i]!=0) strcpy(pass2, pass0+i+1);
}

//Boats->added multi checking to instalog.
void cNetworkStuff::LogOut(int s)//Instalog
{
	int p=currchar[s], a, valid=0;
	int x=chars[currchar[s]].x, y=chars[currchar[s]].y;
	int multi, b, ci;

	if(chars[p].priv&1 || chars[p].priv&80 || chars[p].account==0) 
		valid=1;
	else {
		for(a=0;a<logoutcount;a++)
		{
			if (logout[a].x1<=x && logout[a].y1<=y && logout[a].x2>=x && logout[a].y2>=y)
			{
				valid=1;
				break;
			}
		}
	}

	if ( !valid )
	{
		if (chars[p].multis==-1)
			multi=findmulti(chars[p].x,chars[p].y,chars[p].z);
		else multi=findbyserial(&itemsp[chars[p].multis%HASHMAX],chars[p].multis,0);
	}
	
	if (multi!=-1 && !valid)//It they are in a multi... and it's not already valid (if it is why bother checking?)
	{
		b=packitem(p);
		if (b!=-1)
		{
			for (a=0;a<contsp[items[b].serial%HASHMAX].max;a++)
			{
				ci=contsp[items[b].serial%HASHMAX].pointer[a];
				if (ci!=-1)
				{
					if (items[ci].type==7 && items[ci].contserial == items[b].serial && (
						items[ci].more1==items[multi].ser1 && items[ci].more2==items[multi].ser2 &&
						items[ci].more3==items[multi].ser3 && items[ci].more4==items[multi].ser4))
					{//a key to this multi
						valid=1;//Log 'em out now!
						break;
					}
				}
			}
		}
	}
	
	if (valid)// || region[chars[p].region].priv&0x17 )
	{
		inworld[chars[p].account]=-1;
		chars[p].logout=-1;
	} else {
		inworld[chars[p].account]=p;
		chars[p].logout=uiCurrentTime+server_data.quittime*CLOCKS_PER_SEC;
	}
	teleport(p);
}

int cNetworkStuff::Receive(int s, int x, int a) // Old socket receive function (To be replaced soon)
{
#if CLIENTVERSION_M==25
	int i;
#endif
	//	int i, count;
	int count;
#ifdef DEBUG_NETWORK
	int j;
	int buf2c;
	char buf2[32];
#endif
	
	if (a) count=0; // Just to get rid of warning message
	do
	{
		count=recv(client[s], &buffer[s][recvcount], x-recvcount, 0);
		if (count>0)
		{
#if CLIENTVERSION_M==25
			for (i=recvcount;i<recvcount+count;i++) buffer[s][i]=Crypt(s, buffer[s][i]);
#endif
#if CLIENTVERSION_M==26
			pCrypt[s]->Decrypt( &buffer[s][recvcount], &buffer[s][recvcount], count );
#endif
			recvcount+=count;
#ifdef DEBUG_NETWORK
			buf2c=0;
			if (((recvcount==x)||(x==2560))&&(a))
			{
				printf("*** xRecv\n");
				for (int i=0;i<recvcount;i++)
				{
					buf2[buf2c]=buffer[s][i];
					buf2c++;
					if ((buf2c==16)||(i==recvcount-1))
					{
						printf("C%i %2x : ",s,((i%256)/16)*16);
						for (j=0;j<buf2c;j++)
						{
							printf("%2x ",buf2[j]);
						}
						printf("[");
						for (j=0;j<buf2c;j++)
						{
							if ((isalnum(buf2[j]))||(isprint(buf2[j]))) printf("%c",buf2[j]); else printf(".");
						}
						buf2c=0;
						printf("]\n");
					}
				}
			}
#endif
		}
	}
	while ((x!=2560)&&(x!=recvcount)&&(count>0));
	return count;
}

void cNetworkStuff::sockInit()
{
	int i;
	char h1=0, h2=0, h3=0, h4=0;
	int bcode;
	int on=1, off=0;
	
	kr=1;
	faul=0;
	
#ifdef __NT__
	wVersionRequested=MAKEWORD(2, 0);
	err=WSAStartup(wVersionRequested, &wsaData);
	if (err)
	{
		printf("\nERROR: Winsock 2.0^ not found...\n");
		keeprun=0;
		error=1;
		kr=0;
		faul=1;
		Shutdown( FATAL_UOX3_ALLOC_NETWORK );
		return;
	}
#endif
	
	a_socket=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (a_socket<0)
	{
		printf("\nERROR: Unable to create socket ");
#ifdef __NT__
		printf("error code %i\n", WSAGetLastError());
#else
		printf("\n");
#endif
		keeprun=0;
		error=1;
		kr=0;
		faul=1;
		Shutdown( FATAL_UOX3_ALLOC_NETWORK );
		return;
	}
#ifndef __NT__
	setsockopt(a_socket, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
#endif
	/* gethostname(hname,40);
	he=gethostbyname(hname);
	conns=0;
	if (he==NULL)
	{
	printf("NOTE: No available connections. Using loopback adress for offline operation.\n");
	printf("      Remember that this may cause client crashes on startup. Read the readme!.txt\n");
	printf("      chapter 'Setup Instructions' on information about how to solve this.");
	h1=127;
	h2=0;
	h3=0;
	h4=1;
	}
	else
	{
	do
	{
	p=(*he).h_addr_list[conns];
	if (p!=NULL) conns++;
	}
	while (p!=NULL);
	if (conns==0)
	{
	printf("NOTE: No available connections. Using loopback adress for offline operation.");
	h1=127;
	h2=0;
	h3=0;
	h4=1;
	}
	else if (conns==1)
	{
	printf("NOTE: Available connection found.");
	h1=(*he).h_addr_list[0][0];
	h2=(*he).h_addr_list[0][1];
	h3=(*he).h_addr_list[0][2];
	h4=(*he).h_addr_list[0][3];
	}
	else
	{
	printf("NOTE: Multiple available connections found.\n");
	printf("IP adresses:\n");
	for (i=0;i<conns;i++)
	{
	printf("%i : %i.%i.%i.%i\n",i+1,(*he).h_addr_list[i][0],(*he).h_addr_list[i][1],
	(*he).h_addr_list[i][2],(*he).h_addr_list[i][3]);
	}
	printf("\n");
	do
	{
	printf("Choose connection number (1-%i): ",conns);
	scanf("%i",&number);
	number--;
	}
	while ((number<0)||(number>conns-1));
	h1=(*he).h_addr_list[number][0];
	h2=(*he).h_addr_list[number][1];
	h3=(*he).h_addr_list[number][2];
	h4=(*he).h_addr_list[number][3];
	}
	}
	sprintf(ipa,"%i.%i.%i.%i",h1,h2,h3,h4); */
	
	len_connection_addr=sizeof (struct sockaddr_in);
	memset((char *) &connection, 0, len_connection_addr);
	connection.sin_family=AF_INET;
	connection.sin_addr.s_addr=htonl(INADDR_ANY);
	connection.sin_port=htons(UOX_PORT);
	bcode=bind(a_socket, (struct sockaddr *)&connection, len_connection_addr);
	
	if (bcode<0)
	{
		printf("\nERROR: Unable to bind socket 1 - Error code: %i\n",bcode);
		keeprun=0;
		error=1;
		kr=0;
		faul=1;
		Shutdown( FATAL_UOX3_ALLOC_NETWORK );
		return;
	}
    
	
	listen(a_socket, 42);
	// printf("\nUOX3: Listening on connection (%i.%i.%i.%i:%i)\n",h1,h2,h3,h4,UOX_PORT);
	login03[1]=h1;
	login03[2]=h2;
	login03[3]=h3;
	login03[4]=h4;
	login03[7]=h1;
	login03[8]=h2;
	login03[9]=h3;
	login03[10]=h4;
	for (i=0;i<servcount;i++) if (serv[i][1][0]=='*') sprintf(serv[i][1],"%i.%i.%i.%i",h1,h2,h3,h4);
	ph1=h1;
	ph2=h2;
	ph3=h3;
	ph4=h4;
}

#if CLIENTVERSION_M==25 && CLIENTVERSION==36
char cNetworkStuff::Crypt(int s, char c)
{ // 6 key encryption (v 36 client)
	unsigned int mask[2];
	mask[0] = cryptmask[s][0];
	mask[1] = cryptmask[s][1];
	
	cryptmask[s][1] =
		(MASTERKEY1 >> ((5 * mask[1] * mask[1]) & 0xff))
		+ (mask[1] * MASTERKEY1)
		+ (mask[0] * mask[0] * MASTERKEY2)
		+ MASTERKEY3;
	cryptmask[s][0] =
		(MASTERKEY4 >> ((3 * mask[0] * mask[0]) & 0xff))
		+ (mask[0] * MASTERKEY4)
		- (cryptmask[s][1] * cryptmask[s][1] * MASTERKEY5)
		+ MASTERKEY6;
	
	return c ^ (char)mask[0];
	
}
#endif

void cNetworkStuff::SockClose () // Close all sockets for shutdown
{
	int i;
	closesocket(a_socket);
	for (i=0;i<now;i++) closesocket(client[i]);
}

void cNetworkStuff::CheckConn() // Check for connection requests
{
	int s;
	int len;
	
	if (now<MAXIMUM)
	{
		FD_ZERO(&conn);
		FD_SET(a_socket, &conn);
		nfds=a_socket+1;
		s=select(nfds, &conn, NULL, NULL, &uoxtimeout);
		if (s>0)
		{
			len=sizeof (struct sockaddr_in);
			//   printf("Waiting at accept()\n");
#ifndef __LINUX__
			client[now]=accept(a_socket, (struct sockaddr *)&client_addr, &len);
#else
			client[now]=accept(a_socket, (struct sockaddr *)&client_addr, (unsigned int *)&len );
#endif
			//   printf("Done! :)\n");
			if (client[now]<0)
			{
				printf("ERROR: Error at client connection!\n");
				error=1;
				keeprun=1;			// Leviathan suggested, Abaddon put in... old clients shut the server down
				return;
			}
			server[now]=-1;
			newclient[now]=1;
			acctno[now]=-1;
			addid1[now]=0;
			addid2[now]=0;
			addid3[now]=0;
			addid4[now]=0;
			perm[now]=0;
			funnypack[now]=0;
			binlength[now]=0;
			boutlength[now]=0;
			cryptclient[now]=0;
#if CLIENTVERSION_M==25
			cryptmask[now][0]=0;
			cryptmask[now][1]=0;
#endif
#if CLIENTVERSION_M==26
			pCrypt[now] = new CCrypt();
#endif
			usedfree[now]=0;
			walksequence[now]=-1;
#ifdef __NT__
			printf("UOX3: Client %i [%i.%i.%i.%i] connected [Total:%i].\n",now,client_addr.sin_addr.S_un.S_un_b.s_b1 _ client_addr.sin_addr.S_un.S_un_b.s_b2 _ client_addr.sin_addr.S_un.S_un_b.s_b3 _ client_addr.sin_addr.S_un.S_un_b.s_b4,now+1);
#else
			printf("UOX3: Client %i connected [Total:%i].\n",now,now+1);
#endif
			now++;
			return;
		}
		if (s<0)
		{
			printf("ERROR: Select (Conn) failed!\n");
			keeprun=0;
			error=1;
			return;
		}
	}
}

cNetworkStuff::~cNetworkStuff()
{
	int i, s=0;
	for (i=0;i<now;i++)
	{
		FlushBuffer(i);
		closesocket(client[i]);
		s = max(s, client[i]+1);
	}
	closesocket(s);
#ifdef _WIN32
	WSACleanup();
#endif
}

void cNetworkStuff::CheckMessage () // Check for messages from the clients
{
	int s, i, oldnow;
	
	FD_ZERO(&all);
	FD_ZERO(&errsock);
	nfds=0;
	for (i=0;i<now;i++)
	{
		FD_SET(client[i],&all);
		FD_SET(client[i],&errsock);
		if (client[i]+1>nfds) nfds=client[i]+1;
		if (server[i]>=0)
		{
			FD_SET(server[i],&all);
			FD_SET(server[i],&errsock);
			if (server[i]+1>nfds) nfds=server[i]+1;
		}
	}
	s=select(nfds, &all, NULL, &errsock, &uoxtimeout);
	if (s>0)
	{
		oldnow=now;
		for (i=0;i<now;i++)
		{
			if (FD_ISSET(client[i],&errsock))
			{
				Disconnect(i);
			}
			if (server[i] >= 0) {
				if (FD_ISSET(server[i],&errsock))
				{
					closesocket(server[i]);
					FailAuth(i);
				}
			}
			if ((FD_ISSET(client[i],&all))&&(oldnow==now))
			{
				GetMsg(i);
				if (executebatch) batchcheck(i); //LB, bugfix (uncommenting this line) for server info 
				// not working and much more scripted things
				// it's an odd place to do that check
				// feel free to place it straticaly better,
				// but DONT leave it out, that breaks a LOT !!!!
				// (whoever commented it out, it took me hours to find it, grrr)
				
				
			}
			if (server[i] >= 0)
			{
				if ((FD_ISSET(server[i],&all))&&(oldnow==now))
				{
					AuthTest(i);
				}
			}
		}
	}
	/* if (s<0)
	{
	printf("ERROR: Select (Mess) failed!\n");
	keeprun=0;
	error=1;
	return;
} */
}


cNetworkStuff::cNetworkStuff() // Initialize sockets
{
	sockInit();
}

