# This makefile is used to compile under Solaris
# Use make -f solaris.makefile to avoid conflicts with the standard makefile

#CC = insure
CC = gcc
SH = /usr/local/src/SmartHeap_4.00

# Optimization
#OPT = -O2

# Name of executable
EXE = uox3

# Debugging
#DEBUG = -g

# Libraries
LIBS =  -lgcc -lsocket -lnsl -lm
#LIBS = -L$(SH)/lib -lmyshlibd -lsmartheapd -lgcc -lsocket -lnsl -lm


# Warning level
WARN = -pedantic -Wstrict-prototypes -Wmissing-prototypes -funsigned-char

# Other c-flags
OTHER = -I$(SH)/include -D__LINUX__ -funsigned-char -fconserve-space -DDEBUG -g -D_BSD_SOURCE  -DMEM_DEBUG=1 -DDEFINE_NEW_MACRO=1 -DSHI_ARRAY_NEW=1 -DUSE_SH
#OTHER = -D__LINUX__ -funsigned-char -fconserve-space -DDEBUG -g -D_BSD_SOURCE

# Source
SRC = boats.cpp crypt.cpp network.cpp admin.cpp archive.cpp craces.cpp cweather.cpp \
	cmdtable.cpp combat.cpp commands.cpp data.cpp dbl_sinlge_click.cpp debug.cpp \
	globals.cpp guildstones.cpp gumps.cpp house.cpp html.cpp im.cpp items.cpp \
	magic.cpp mapstuff.cpp msgboard.cpp necro.cpp newbie.cpp npcs.cpp p_ai.cpp \
	pointer.cpp regions.cpp scriptc.cpp shop.cpp skills.cpp targeting.cpp \
	townstones.cpp trigger.cpp uox3.cpp walking.cpp weight.cpp worldmain.cpp \
	xgm.cpp fileio.cpp

# Objects
OBJS = boats.o crypt.o network.o admin.o archive.o craces.o cweather.o \
	cmdtable.o combat.o commands.o data.o dbl_sinlge_click.o debug.o \
	globals.o guildstones.o gumps.o house.o html.o im.o items.o \
	magic.o mapstuff.o msgboard.o necro.o newbie.o npcs.o p_ai.o \
	pointer.o regions.o scriptc.o shop.o skills.o targeting.o \
	townstones.o trigger.o uox3.o walking.o weight.o worldmain.o \
	xgm.o fileio.o

C_FLAGS = $(WARN) $(OTHER) $(OPT) $(DEBUG)

all: $(EXE)

$(EXE): $(OBJS)
	$(CC) -o $(EXE) $(OBJS) $(LIBS)


boats.o: boats.cpp boats.h uox3.h
	$(CC) -c $(C_FLAGS) boats.cpp

crypt.o: crypt.cpp crypt.h uox3.h
	$(CC) -c $(C_FLAGS) crypt.cpp

network.o: network.cpp uox3.h
	$(CC) -c $(C_FLAGS) network.cpp

admin.o: admin.cpp uox3.h
	$(CC) -c $(C_FLAGS) admin.cpp

archive.o: archive.cpp uox3.h
	$(CC) -c $(C_FLAGS) archive.cpp

craces.o: craces.cpp craces.h uox3.h
	$(CC) -c $(C_FLAGS) craces.cpp

cweather.o: cweather.cpp cweather.hpp uox3.h
	$(CC) -c $(C_FLAGS) cweather.cpp

cmdtable.o: cmdtable.cpp cmdtable.h uox3.h
	$(CC) -c $(C_FLAGS) cmdtable.cpp

combat.o: combat.cpp uox3.h
	$(CC) -c $(C_FLAGS) combat.cpp

commands.o: commands.cpp uox3.h
	$(CC) -c $(C_FLAGS) commands.cpp

data.o: data.cpp uox3.h
	$(CC) -c $(C_FLAGS) data.cpp

dbl_sinlge_click.o: dbl_sinlge_click.cpp uox3.h
	$(CC) -c $(C_FLAGS) dbl_sinlge_click.cpp

debug.o: debug.cpp uox3.h
	$(CC) -c $(C_FLAGS) debug.cpp

fileio.o: fileio.cpp fileio.h
	$(CC) -c $(C_FLAGS) fileio.cpp

globals.o: globals.cpp uox3.h
	$(CC) -c $(C_FLAGS) globals.cpp

guildstones.o: guildstones.cpp uox3.h
	$(CC) -c $(C_FLAGS) guildstones.cpp

gumps.o: gumps.cpp uox3.h
	$(CC) -c $(C_FLAGS) gumps.cpp

house.o: house.cpp uox3.h
	$(CC) -c $(C_FLAGS) house.cpp

html.o: html.cpp uox3.h
	$(CC) -c $(C_FLAGS) html.cpp

im.o: im.cpp im.h uox3.h
	$(CC) -c $(C_FLAGS) im.cpp

items.o: items.cpp uox3.h
	$(CC) -c $(C_FLAGS) items.cpp

magic.o: magic.cpp uox3.h
	$(CC) -c $(C_FLAGS) magic.cpp

mapstuff.o: mapstuff.cpp uox3.h
	$(CC) -c $(C_FLAGS) mapstuff.cpp

msgboard.o: msgboard.cpp uox3.h
	$(CC) -c $(C_FLAGS) msgboard.cpp

necro.o: necro.cpp uox3.h
	$(CC) -c $(C_FLAGS) necro.cpp

newbie.o: newbie.cpp uox3.h
	$(CC) -c $(C_FLAGS) newbie.cpp

npcs.o: npcs.cpp uox3.h
	$(CC) -c $(C_FLAGS) npcs.cpp

p_ai.o: p_ai.cpp uox3.h
	$(CC) -c $(C_FLAGS) p_ai.cpp

pointer.o: pointer.cpp uox3.h
	$(CC) -c $(C_FLAGS) pointer.cpp

regions.o: regions.cpp regions.h uox3.h
	$(CC) -c $(C_FLAGS) regions.cpp

scriptc.o: scriptc.cpp scriptc.h uox3.h
	$(CC) -c $(C_FLAGS) scriptc.cpp

shop.o: shop.cpp uox3.h
	$(CC) -c $(C_FLAGS) shop.cpp

skills.o: skills.cpp uox3.h
	$(CC) -c $(C_FLAGS) skills.cpp

targeting.o: targeting.cpp uox3.h
	$(CC) -c $(C_FLAGS) targeting.cpp

townstones.o: townstones.cpp uox3.h
	$(CC) -c $(C_FLAGS) townstones.cpp

trigger.o: trigger.cpp uox3.h
	$(CC) -c $(C_FLAGS) trigger.cpp

uox3.o: uox3.cpp uox3.h
	$(CC) -c $(C_FLAGS) uox3.cpp

walking.o: walking.cpp uox3.h
	$(CC) -c $(C_FLAGS) walking.cpp

weight.o: weight.cpp uox3.h
	$(CC) -c $(C_FLAGS) weight.cpp

worldmain.o: worldmain.cpp worldmain.h uox3.h
	$(CC) -c $(C_FLAGS) worldmain.cpp

xgm.o: xgm.cpp xgm.h uox3.h
	$(CC) -c $(C_FLAGS) xgm.cpp

clean:
	rm -f *.o uox3 *.cpp~ *.h~ foo foo~
	
