#include "uox3.h"

void cWhoList::Update( void )
// PRE:		WhoList class is active
// POST:	If multiple GMs using, doesn't actually update (deferred update)
//			Otherwise updates the arrays, and resets the update flag
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	if( gmCount > 1 )
	{
		printf("WhoList entered by multiple GMs and update required, doing a delayed update\n" );
		return;
	}
	// do code
	Delete();
	int linenum=1, buttonnum = 7, position = 40;
	int charCount = 0;
	whoStuff toAdd;
	int i = 0;
	// Array 1 FULL USER LIST
	for( i = 0; i < charcount; i++ )		// for every single character
	{
		if( (chars[i].account != -1 && chars[i].free == 0 ) )	// if we have a real player (ie not an npc) and not deleted
		{
			if( charCount > 0 && ( !(charCount%10)))	// if we're on a new page
			{
				position=40;			// reset the position counter
//				pagenum++;				// increment page number
//				sprintf(menuarray[linecount++], "page %i",pagenum);		// print page footer
			}
			charCount++;	// increment real char count
			sprintf( toAdd.line1, "text 40 %i 300 %i", position, linenum );
			sprintf( toAdd.line2, "button 20 %i 1209 1210 1 0 %i", position, buttonnum );
			if( online( i ) )
			{
				sprintf( toAdd.array2, "Player %s [online]", chars[i].name );
				AddOnlineEntry( toAdd );
			}
			else
			{
				sprintf( toAdd.array2, "Player %s [offline]", chars[i].name );
				AddOfflineEntry( toAdd );
			}

			position+=20;		// move our position up 20
			linenum++;			// we have a new line
			buttonnum++;		// we have a new button
		}
	}

	// UPDATE PAGE BOOKMARK (MISCELLANEOUS)
/*	pagenum=1; //lets make some damn buttons
	for( i = 0; i < charCount; i += 10 )	// for each page of 10
	{
		if ( linecount+3 >= maxArraySize ) break;
		sprintf(menuarray[linecount++], "page %i", pagenum);	// print new page info
		if( i >= 10 )	// print back button
			sprintf(menuarray[linecount++], "button 150 300 2223 2223  0 %i",pagenum-1); //back button
		if( ( charCount > 10 ) && ( ( i + 10 ) < charCount ) )	// print forward button while still appropriate
			sprintf(menuarray[linecount++], "button %i 300 2224 2224  0 %i", 150+(20*(pagenum>1)),pagenum+1); //forward button
		pagenum++;	// increment page count
	}		
*/
	// for each

	// Array 2

	ResetUpdateFlag();
	CalcLengths();	
}

void cWhoList::ResetUpdateFlag( void )
// PRE:		WhoList class is active
// POST:	Resets the update flag
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	needsUpdating = false;
	
}

cWhoList::cWhoList()
// PRE:		On creation
// POST:	Initializes the variables of the wholist
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	FlagUpdate();					// first use will force it to update
	headerSent = 0;
	onlineSent = 0;
	offlineSent = 0;
	onlineEntries.resize( 0 );		// make sure our arrays are clear
	offlineEntries.resize( 0 );
	gmCount = 0;					// no GMs currently using it
}

cWhoList::~cWhoList()
// PRE:		WhoList class is active
// POST:	Memory cleared/destroyed
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	ResetUpdateFlag();
	gmCount = 0;
	Delete();
}
void cWhoList::FlagUpdate( void )
// PRE:		WhoList class is active
// POST:	Flags the who list as needing to be updated
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	needsUpdating = true;

}
void cWhoList::SendSocket( UOXSOCKET toSendTo, unsigned char option )
// PRE:		WhoList class is active
// POST:	Sends the wholist to the socket, depending on option
//			0 = On/off line players
//			1 = Online players
//			2 = Offline players
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	if( needsUpdating && gmCount <= 1 )	// If we need to update, do it now while we still can
		Update();
	SendHeader( toSendTo, option );	// send the header
	switch( option )
	{
	default:
	case 0:
		SendOnline( toSendTo );
		SendOffline( toSendTo );
		break;
	case 1:
		SendOnline( toSendTo );
		break;
	case 2:
		SendOffline( toSendTo );
		break;
	}

}

void cWhoList::SendOnline( UOXSOCKET toSendTo )
// PRE:		WhoList class is active
// POST:	Sends the online wholist stuff to the socket
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	onlineSent = 0;
	char sect[104];
	for( int i = 0; i < onlineEntries.size(); i++ )
	{
		sprintf( sect, "{ %s }", onlineEntries[i]->line1 );
		Network->xSend( toSendTo, sect, strlen( sect ), 0 );
		sprintf( sect, "{ %s }", onlineEntries[i]->line2 );
		Network->xSend( toSendTo, sect, strlen( sect ), 0 );
		printf("%s\n%s\n", onlineEntries[i]->line1, onlineEntries[i]->line2 );
	}

	gump2[1]=(onlineEntries.size()+1)>>8;					// tell the client to expect x of text lines
	gump2[2]=(onlineEntries.size()+1)%256;
	
	Network->xSend( toSendTo, gump2, 3, 0);					// send the line count
	printf("%i %i %i\n", gump2[0], gump2[1], gump2[2]);

	sprintf( sect, "Users currently online: %i", onlineEntries.size() );
	gump3[0] = strlen( sect )>>8;			// send in gump3[] the length of line
	gump3[1] = strlen( sect )%256;
	printf("%i\n", strlen( sect ) );
	Network->xSend( toSendTo, gump3, 2, 0);					// send out our 2 bytes
	gump3[0]=0;										// clear the byte
	for( i = 0; i < strlen( sect ); i++ )		// for each byte????? christ, this is dodgy!!! (why do this??? stupid server code =)
	{
		gump3[1] = sect[i];				// send char (perhaps unicode?)
		Network->xSend( toSendTo, gump3, 2, 0 );
		printf("%i ", gump3[1] );
	}

	for( int j = 0; j < onlineEntries.size(); j++ )
	{
			gump3[0] = strlen( onlineEntries[j]->array2 )>>8;			// send in gump3[] the length of line
			gump3[1] = strlen( onlineEntries[j]->array2 )%256;
			printf("%i\n", strlen(onlineEntries[j]->array2) );
			Network->xSend( toSendTo, gump3, 2, 0);					// send out our 2 bytes
			gump3[0]=0;										// clear the byte
			for( i = 0; i < strlen( onlineEntries[j]->array2 ); i++ )		// for each byte????? christ, this is dodgy!!! (why do this??? stupid server code =)
			{
				gump3[1] = onlineEntries[j]->array2[i];				// send char (perhaps unicode?)
				Network->xSend( toSendTo, gump3, 2, 0 );
//				printf("%i%i(%c) ", gump3[0], gump3[1], gump3[1] );
				printf("%i ", gump3[1] );
			}
	}

}
void cWhoList::SendOffline( UOXSOCKET toSendTo )
// PRE:		WhoList class is active
// POST:	Sends the offline wholist to the socket
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	offlineSent = 0;
	char sect[104];
	int i = 0;
	for( i = 0; i < offlineEntries.size(); i++ )
	{
		sprintf( sect, "{ %s }", offlineEntries[i]->line1 );
		Network->xSend( toSendTo, sect, strlen( sect ), 0 );
		sprintf( sect, "{ %s }", offlineEntries[i]->line2 );
		Network->xSend( toSendTo, sect, strlen( sect ), 0 );
	}

	gump2[1]=(offlineEntries.size())>>8;					// tell the client to expect x of text lines
	gump2[2]=(offlineEntries.size())%256;

	printf("%i%i\n", gump2[0], offlineEntries.size() );
	Network->xSend( toSendTo, gump2, 3, 0);					// send the line count

	for( int j = 0; j < offlineEntries.size(); j++ )
	{
			gump3[0] = strlen( offlineEntries[j]->array2 )>>8;			// send in gump3[] the length of line
			gump3[1] = strlen( offlineEntries[j]->array2 )%256;
			printf("%i\n", strlen(offlineEntries[j]->array2) );
			Network->xSend( toSendTo, gump3, 2, 0);					// send out our 2 bytes
			gump3[0]=0;										// clear the byte
			for( i = 0; i < strlen( offlineEntries[j]->array2 ); i++ )		// for each byte????? christ, this is dodgy!!! (why do this??? stupid server code =)
			{
				gump3[1] = offlineEntries[j]->array2[i];				// send char (perhaps unicode?)
				Network->xSend( toSendTo, gump3, 2, 0 );
				printf("%i%i ", gump3[0], gump3[1] );
			}
	}
}
void cWhoList::SendHeader( UOXSOCKET toSendTo, unsigned char option )
// PRE:		WhoList class is active
// POST:	Sends the header of the wholist to the socket, depending on option
//			0 = On/off line players
//			1 = Online players
//			2 = Offline players
// CODER:	Abaddon
// DATE:	12th February, 2000
{

	char menuarray[7][100];
	char sect[516];
	headerSent = 0;
	short int length = headerLength;
	short int length2 = 0;
	switch( option )
	{
	default:
	case 0:
		length += onlineLength + offlineLength;
		length2 = onlineLength2 + offlineLength2;
		break;
	case 1:
		length += onlineLength;
		length2 = onlineLength2;
		break;
	case 2:
		length += offlineLength;
		length2 = offlineLength2;
		break;
	}

	sprintf( sect, "Users currently online: %i", onlineEntries.size() );
	gump1[1] = (length + strlen( sect ) )>>8;
	gump1[2] = (length + strlen( sect ) )%256;
	gump1[7] = 0;
	gump1[8] = 0;
	gump1[9] = 0;
	gump1[10] = 4; // Gump Number
	gump1[19] = length2>>8;
	gump1[20] = length2%256;

	for( int j = 0; j < 21; j++ )
		printf( "%i ", gump1[j] );
	printf( "\n" );
	Network->xSend( toSendTo, gump1, 21, 0);
	headerSent += 21;

	strcpy(menuarray[0], "nomove");
	strcpy(menuarray[1], "noclose");
	strcpy(menuarray[2], "page 0");
	strcpy(menuarray[3], "resizepic 0 0 5120 320 340");    //The background
	strcpy(menuarray[4], "button 20 300 2130 2129 1 0 1"); //OKAY
	strcpy(menuarray[5], "text 20 10 300 0");           //text <Spaces from Left> <Space from top> <Length, Color?> <# in order>
	strcpy(menuarray[6], "page 1" );
	printf("Packet Data:\n" );
	for( int i = 0; i < 7; i++ )
	{
		sprintf(sect, "{ %s }", menuarray[i]);
		headerSent += strlen( sect );
		Network->xSend( toSendTo, sect, strlen(sect), 0);
		printf( "%s\n", menuarray[i] );
	}

}

void cWhoList::CalcLengths( void )
// PRE:		WhoList class is active
// POST:	Sends the wholist to the socket, depending on option
//			0 = On/off line players
//			1 = Online players
//			2 = Offline players
// CODER:	Abaddon
// DATE:	12th February, 2000
{

	char menuarray[7][100];
	int i = 0;

	headerLength = 24;	// for the gump header
	onlineLength = 0;
	onlineLength2 = 0;
	offlineLength = 0;
	offlineLength2 = 0;
	
	strcpy(menuarray[0], "nomove");
	strcpy(menuarray[1], "noclose");
	strcpy(menuarray[2], "page 0");
	strcpy(menuarray[3], "resizepic 0 0 5120 320 340");    //The background
	strcpy(menuarray[4], "button 20 300 2130 2129 1 0 1"); //OKAY
	strcpy(menuarray[5], "text 20 10 300 0");           //text <Spaces from Left> <Space from top> <Length, Color?> <# in order>
	strcpy(menuarray[6], "page 1" );
	
	for( i = 0; i < 7; i++ )
		headerLength += strlen( menuarray[i] ) + 4;	// 4 is for the "{ " and " }"

	for( i = 0; i < onlineEntries.size(); i++ )
	{
		onlineLength += strlen( onlineEntries[i]->line1 );
		onlineLength += strlen( onlineEntries[i]->line2 );
		onlineLength += 8;
		onlineLength += strlen( onlineEntries[i]->array2 ) * 2 + 2;

		onlineLength2 += strlen( onlineEntries[i]->line1 );
		onlineLength2 += strlen( onlineEntries[i]->line2 );
		onlineLength2 += 8;
	}

	for( i = 0; i < offlineEntries.size(); i++ )
	{
		offlineLength += strlen( offlineEntries[i]->line1 );
		offlineLength += strlen( offlineEntries[i]->line2 );
		offlineLength += 8;	// 2 * len of ( " {" + " }" )
		offlineLength += strlen( offlineEntries[i]->array2 ) * 2 + 2;

		offlineLength2 += strlen( offlineEntries[i]->line1 );
		offlineLength2 += strlen( offlineEntries[i]->line2 );
		offlineLength2 += 8;
	}

}

void cWhoList::GMEnter( void )
// PRE:		WhoList class is active
// POST:	Increments the GM counter
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	gmCount++;
}

void cWhoList::GMLeave( void )
// PRE:		WhoList class is active
// POST:	Decrements the GM counter
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	gmCount--;
}

long int cWhoList::GrabSerial( int index )
// PRE:		WhoList class is active
// POST:	Returns serial as refered to by index
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	if( index >= onlineEntries.size() )
		return offlineEntries[index - onlineEntries.size()]->player;
	return onlineEntries[index]->player;
}

void cWhoList::AddOnlineEntry( whoStuff toAdd )
// PRE:		WhoList class is active
// POST:	Adds toAdd to the online entries
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	int index = onlineEntries.size();
	onlineEntries.resize( index + 1 );
	onlineEntries[index] = new whoStuff;
	memcpy( onlineEntries[index], &toAdd, sizeof( whoStuff ) );
	printf("Online Entry:\n%s\n%s\n%s\n", onlineEntries[index]->line1, onlineEntries[index]->line2, onlineEntries[index]->array2 );
}

void cWhoList::AddOfflineEntry( whoStuff toAdd )
// PRE:		WhoList class is active
// POST:	Adds toAdd to the online entries
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	int index = offlineEntries.size();
	offlineEntries.resize( index + 1 );
	offlineEntries[index] = new whoStuff;
	memcpy( offlineEntries[index], &toAdd, sizeof( whoStuff ) );
}

void cWhoList::Delete( void )
// PRE:		WhoList class is active
// POST:	Deletes all the entries
// CODER:	Abaddon
// DATE:	12th February, 2000
{
	int i = 0;
	int minSize;
	minSize = min( onlineEntries.size(), offlineEntries.size() );
	for( i = 0; i < minSize; i++ )		// delete up to the common size
	{
		delete onlineEntries[i];
		delete offlineEntries[i];
	}
	for( i = minSize; i < onlineEntries.size(); i++ )	// delete any remaining online chars
		delete onlineEntries[i];
	for( i = minSize; i < offlineEntries.size(); i++ )	// delete any remaining offline chars
		delete offlineEntries[i];
}