unit anim;

interface


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mmsystem, ExtCtrls,stdctrls;

type
  TAnimForm = class(TForm)
    Timer1: TTimer;
    backimage: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure backimageClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;



TBMP = class(TPersistent)
protected
pBMP : pbitmapinfo;
memsize : longint;

procedure readfromfile(bmpname:string);
function getwidth : longint;
function getheight : longint;
function getncolors : longint;
function getptrtorgbquad : prgbquad;
function getptrtobits : pbyte;
function getbitsize : integer;
function getdibsize : longint;

public
constructor create;
destructor destroy; override;
property source: string write readfromfile;
property width :Longint read GetWidth;
property Height:Longint read GetHeight;
property NumColors : Longint read GetNcolors;
property ptrRGBQuad : PRGBquad read GetPtrToRGBQuad;
property ptrbits : pByte read GetPtrToBits;
property ptrBitmapInfo : PBitmapInfo read pBmp;
end;




Tposition = record
            Left,Top:integer;
            end;

TmovestyleH = (osLeftToRight, osRightToLeft);
TmovestyleV = (osTopToBottom, osBottomToTop);


  TAnimation = class(TObject)
  private
  procedure readbitmapfile(bmpname:string);
  procedure setcurcellnum(value:byte);
  function  getcurcellrect:trect;
  function  getcurdestrect:trect;

  protected
  FAnimation:tbmp;
  FMask:tbmp;
  fcellnum:byte;
  fcellwidth:integer;
  fcellheight:integer;
  fcurcellnum:byte;
  fcurpos:tposition;
  fprvpos:tposition;
  fmovex:integer;
  fmovey:integer;
  fmoveh:tmovestyleh;
  fmovev:tmovestylev;
  freverseh:boolean;
  freversev:boolean;

  public
  constructor create;
  destructor destroy;override;
  property source: string write readbitmapfile;
  property animation:tbmp read fanimation;
  property mask:tbmp read fmask;
  property cellnum: byte read fcellnum write fcellnum;
  property cellwidth: integer read fcellwidth;
  property cellheight: integer read fcellheight;
  property curpos: tposition read fcurpos write fcurpos;
  property prvpos: tposition read fprvpos write fprvpos;
  property movex: integer read fmovex write fmovex;
  property movey: integer read fmovey write fmovey;
  property moveh: tmovestyleh
           read fmoveh write fmoveh
           default oslefttoright;
  property movev: tmovestylev
           read fmovev write fmovev
           default ostoptobottom;
  property reverseh:boolean read freverseh
           write freverseh default false;
  property reversev:boolean read freversev
           write freversev default false;
  property curcellnum: byte read fcurcellnum
           write setcurcellnum;
  property curcellrect: trect read getcurcellrect;
  property curdestrect: trect read getcurdestrect;
end;



  var
  AnimForm: TAnimForm;

implementation

{$R *.DFM}

const
framenum = 8;  //Ӽ
x_move = 20;   //x ̵Ÿ
y_move = 5;    //y ̵Ÿ

var
 aniobject:TAnimation;
  back,combine:hdc;
  oldbmp, combinebmp, backbmp:hbitmap;


constructor tbmp.create;
begin
inherited create;
memsize :=0;
end;

destructor tbmp.destroy;
begin
if memsize <> 0 then
freemem(pbmp, memsize);
inherited destroy;
end;


procedure tbmp.readfromfile(bmpname:string);
begin
with tmemorystream.Create do
begin
loadfromfile(bmpname);
memsize := size - sizeof(tbitmapfileheader);
pbmp:=allocmem(memsize);
seek(sizeof(tbitmapfileheader),0);
read(pbmp^,memsize);
free;
end;
end;



function tbmp.getwidth:longint;
begin
result:= pbmp^.bmiHeader.biWidth;
end;


function tbmp.getheight:longint;
begin
result:= pbmp^.bmiHeader.biheight;
end;





function tbmp.getncolors:longint;
begin
if pbmp^.bmiHeader.biClrUsed >0 then
result := pbmp^.bmiHeader.biClrUsed
else
result := 1 shl pbmp^.bmiHeader.biBitCount;
end;


function tbmp.GetBitSize : integer;
begin

result:= sizeof(TBitmapInfoHeader) +(GetnColors* sizeof(TRGBQuad));
end;


function tbmp.GetDIBsize : integer;
begin
Result := GetBitSize + pbmp^.bmiHeader.biSizeImage;
end;

function TBMP.GetPtrToRGBQuad : PRGBQuad;
begin
Result := pointer(Longint(pBMP) + sizeof(TBitmapInfoHeader));
end;



function TBMP.GetPtrToBits : PByte;
begin
result := pointer(Longint(pBMP) +GetBitSize);
end;

procedure BmpToAnimation(bmp:TBMP);
var
OrgBackColor:byte;
TempPtr : pbyte;
szImageBits :Longint;
i           :Longint;
begin
tempPtr := bmp.ptrBits;
orgbackcolor := tempptr^;
szImagebits := ((bmp.pbmp^.bmiHeader.biWidth +3) and not 3) * bmp.height;

for i:=1 to szImagebits do
begin
if tempptr^ = orgbackcolor then
tempptr^ := 0;
inc(tempptr);
end;
end;



procedure bmptomask(bmp:tbmp);
var
backcolor  :byte;
tempptr    :pbyte;
szImagebits:longint;
i          :longint;
begin
tempptr :=bmp.ptrbits;
backcolor := tempptr^;
szImagebits := ((bmp.pbmp^.bmiHeader.biWidth +3) and not 3)*bmp.pbmp^.bmiHeader.biHeight;

for i:=1 to szImagebits do
begin
if TempPtr^ = BackColor then
TempPtr^ := 255
else
tempptr^ :=0;
inc(TempPtr);
end;
end;

 



constructor tanimation.create;
begin
inherited create;
end;

destructor tanimation.destroy;
begin
FAnimation.Free;
FMask.Free;
inherited Destroy;
end;


procedure tanimation.ReadBitmapFile(BMPName:string);
begin
if FCellNum > 0 then
begin
fanimation := tbmp.create;
fanimation.source := bmpname;
bmptoanimation(fanimation);
fmask:=tbmp.create;
fmask.source := bmpname;
BmpTomask(fmask);
fcellwidth := fanimation.width;
fcellheight := fanimation.height div fcellnum;
fcurcellnum := 1;
end;
end;



procedure tanimation.setcurcellnum(value:byte);
begin
if value < 1 then
value := fcellnum
else if value > fcellnum then
value := 1;
fcurcellnum := value;
end;

function tanimation.GetCurCellRect:TRect;
begin
result:= Rect(0,(FCellNum*FCellHeight) - (FCurCellNum*FCellHeight),FCellWidth,
         FCellHeight);
         end;



function TAnimation.GetCurDestRect:TRect;
var
Pos1,Pos2,Reverse,Bak:integer;
begin


//ʿ ϸ ݴ
if((movex < 0) and (moveh = osLeftToRight)) and ReverseH then
begin
Pos1 := FCurPos.Left + FCellWidth -1;
Reverse := -FCellWidth;
end
else
begin
pos1 := FCurpos.Left;
Reverse :=FCellWidth;
end;


//⿡ ϸ Ʒ
if((movey < 0) and (moveV = osTopToBottom)) and ReverseV then
begin
pos2 := FCurPos.Top + FCellHeight -1;
Bak := -FCellHeight;
end
else
begin
Pos2 := FCurPos.Top;
Bak :=FCellHeight;
end;

Result := Rect(Pos1,Pos2, Reverse,Bak);
end;



procedure moveobject;
var
newinc:tpoint;
newpos:tposition;
begin

with aniobject do
begin
NewInc.x := x_move;
NewInc.y := y_move;

if movex < 0 then
MoveX := -abs(NewInc.x)
else
MoveX := abs(NewInc.x);

if movey < 0 then
MoveY := -abs(NewInc.y)
else
MoveY:=abs(NewInc.y);


PrvPos := CurPos;
NewPos := CurPos;

if((Curpos.Left + CellWidth + MoveX) > animform.BackImage.Width) or
((CurPos.Left + MoveX) < 0) then
MoveX := -MoveX
else inc(NewPos.Left, MoveX);


if((CurPos.Top + CellHeight + MoveY) > animform.BackImage.Height) or
((CurPos.Top + MoveY) < 0) then
MoveY := -MoveY
else inc(newpos.Top, MoveY);
CurPos := NewPos;

CurCellNum := CurCellNum -1;
end;
end;




procedure DrawObject;
var
SrcRect, DstRect, CombineRect :TRect;
DC:hDC;
begin

with AniObject do
begin

if MoveX > 0 then
begin
CombineRect.Left := PrvPos.Left;
CombineRect.Right := CellWidth + MoveX;
end
else
begin
CombineRect.Left := CurPos.Left;
CombineRect.Right := CellWidth + Abs(MoveX);
end;

if MoveY > 0 then
begin
CombineRect.Top := PrvPos.Top;
CombineRect.Bottom := CellHeight + MoveY;
end
else
begin
CombineRect.Top := CurPos.Top;
CombineRect.Bottom := CellHeight + abs(MoveY);
end;
end;


bitblt(Combine, CombineRect.Left, combinerect.Top,CombineRect.Right,
CombineRect.Bottom, Back, CombineRect.Left,CombineRect.Top,SRCCOPY);

SrcRect := AniObject.CurCellRect;
DstRect := AniObject.CurDestRect;

StretchDIBits(Combine, DstRect.Left, DstRect.Top, DstRect.Right, DstRect.Bottom,
SrcRect.Left,SrcRect.Top, SrcRect.Right,SrcRect.Bottom, AniObject.Mask.ptrBits,
AniObject.Mask.ptrBitmapinfo^,DIB_RGB_COLORS,SRCAND);


stretchDIBits(combine,dstrect.Left, dstrect.Top, dstrect.Right,dstrect.Bottom,
srcrect.Left, srcrect.Top, srcrect.Right, srcrect.Bottom, aniobject.FAnimation.ptrbits,
aniobject.FAnimation.ptrbitmapinfo^ , DIB_RGB_COLORS,SRCPAINT);

DC:= GetDC(animform.Handle);
BitBlt(DC,CombineRect.Left, CombineRect.Top+1,combinerect.Right,combinerect.Bottom,
combine,combinerect.Left,combinerect.Top,SRCCOPY);
ReleaseDC(animform.Handle,DC);
end;





procedure TAnimForm.FormCreate(Sender: TObject);
var
TheBitmap:TBitmap;
ScreenDC:HDC;
FirstPos:Tposition;
ImageWidth,ImageHeight:integer;
begin
TheBitmap:=TbitMap.Create;
Thebitmap.Width := screen.Width;
thebitmap.Height := screen.Height;
screenDC := getDC(0);
bitblt(thebitmap.canvas.handle,0,0,screen.width,
screen.Height,screenDC,0,0,SRCCOPY);
ReleaseDC(0,ScreenDC);
BackImage.Picture.Bitmap := TheBitmap;
TheBitmap.Free;


aniobject := tanimation.create;
aniobject.cellnum :=framenum;
aniobject.source := extractfilepath(application.exename)+'rabbit.dat';
FirstPos.left := 50;
FirstPos.top := 50;
aniobject.curpos := firstpos;
aniobject.movex := 2;
aniobject.movey := 2;

imagewidth := backimage.Picture.Bitmap.Width;
imageheight :=backimage.Picture.Bitmap.Height;


back:= createcompatibledc(backimage.Picture.Bitmap.Canvas.Handle);
backbmp := createcompatiblebitmap(backimage.Picture.Bitmap.Canvas.Handle,
           imagewidth,imageheight);

oldbmp := selectobject(back,backbmp);
bitblt(back,0,0,imagewidth,imageheight,backimage.Picture.Bitmap.Canvas.Handle,
       0,1,srccopy);
combine := createcompatibleDC(backimage.Picture.Bitmap.Canvas.Handle);

combinebmp := createcompatiblebitmap(back, imagewidth, imageheight);

selectobject(combine,combinebmp);
end;






procedure TAnimForm.FormDestroy(Sender: TObject);
begin
aniobject.Free;
selectobject(back,oldbmp);
deletedc(back);
selectobject(combine,oldbmp);
deletedc(combine);
deleteobject(backbmp);
deleteobject(combinebmp);
end;


procedure TAnimForm.Timer1Timer(Sender: TObject);
begin
aniobject.reverseh := true;
moveobject;
drawobject;
end;

procedure TAnimForm.backimageClick(Sender: TObject);
begin
close;
end;

procedure TAnimForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
close;
end;

end.
