#include<stdio.h>
#include<stdlib.h>
#include<windows.h>

/* ****************************************************
    ʿԼ 2
	jpeglib.libҰ.
	  #include  ׳ extern 2   
   **************************************************** */
int Raw2Jpeg(int widthPix,int height,unsigned char *dataBuf,char *fileName);
// ϰ 0ϸ  !
BYTE *JpegFileToRGB(char *fileName,UINT *width,UINT *height);
// ̹ , NULL϶  !

#define HAVE_BOOLEAN 

#ifdef __cplusplus
	extern "C" {
#endif // __cplusplus

#include "jpeglib.h"

#ifdef __cplusplus
	}
#endif // __cplusplus
#include <setjmp.h>

struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */

  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

METHODDEF(void) my_error_exit (j_common_ptr cinfo);


METHODDEF(void) my_error_exit (j_common_ptr cinfo)
{
	my_error_ptr myerr = (my_error_ptr) cinfo->err;

	char buffer[JMSG_LENGTH_MAX];

	(*cinfo->err->format_message) (cinfo, buffer);
	longjmp(myerr->setjmp_buffer, 1);
}


void j_putRGBScanline(BYTE *jpegline, int widthPix, BYTE *outBuf, int row)
{
	int offset = row * widthPix * 3;
	int count;
	for (count=0;count<widthPix;count++) 
	{
		*(outBuf + offset + count * 3 + 0) = *(jpegline + count * 3 + 0);
		*(outBuf + offset + count * 3 + 1) = *(jpegline + count * 3 + 1);
		*(outBuf + offset + count * 3 + 2) = *(jpegline + count * 3 + 2);
	}
}

//
//	stash a gray scanline
//
void j_putGrayScanlineToRGB(BYTE *jpegline, int widthPix, BYTE *outBuf, int row)
{
	int offset = row * widthPix * 3;
	int count;
	for (count=0;count<widthPix;count++) {

		BYTE iGray;

		// get our grayscale value
		iGray = *(jpegline + count);

		*(outBuf + offset + count * 3 + 0) = iGray;
		*(outBuf + offset + count * 3 + 1) = iGray;
		*(outBuf + offset + count * 3 + 2) = iGray;
	}
}


///////////////////////////////////////////////////////////////////////////////
//
//
int Raw2Jpeg(int widthPix,int height,unsigned char *dataBuf,char *fileName)
{
	BOOL color = TRUE;		// TRUE : ÷, FALSE : 
	int quality = 50;		// 1 .. 100 
	LPBYTE tmp;

	if(!color)
	{
		tmp = (BYTE*)new BYTE[widthPix*height];
		if (tmp==NULL) return -1;
		UINT row,col;
		for (row=0;row<height;row++) {
			for (col=0;col < widthPix;col++) {
				LPBYTE pRed, pGrn, pBlu;
				pRed = dataBuf + row * widthPix * 3 + col * 3;
				pGrn = dataBuf + row * widthPix * 3 + col * 3 + 1;
				pBlu = dataBuf + row * widthPix * 3 + col * 3 + 2;
				int lum = (int)(.299 * (double)(*pRed) + .587 * (double)(*pGrn) + .114 * (double)(*pBlu));
				LPBYTE pGray;
				pGray = tmp + row * widthPix + col;
				*pGray = (BYTE)lum;
			}
		}
	}

	struct jpeg_compress_struct cinfo;

	FILE * outfile=NULL;			/* target file */
	int row_stride;			/* physical row widthPix in image buffer */

	struct my_error_mgr jerr;
	cinfo.err = jpeg_std_error(&jerr.pub);

	jerr.pub.error_exit = my_error_exit;
	setjmp(jerr.setjmp_buffer);
	if (setjmp(jerr.setjmp_buffer)) {
		jpeg_destroy_compress(&cinfo);
		if (outfile!=NULL)	fclose(outfile);
		if (!color) {
			delete [] tmp;
		}
		return -2;
	}

	jpeg_create_compress(&cinfo);
	if ((outfile = fopen(fileName, "wb")) == NULL) {
		return -3;
	}
	jpeg_stdio_dest(&cinfo, outfile);
	cinfo.image_width = widthPix;
	cinfo.image_height = height;
	if (color) {
		cinfo.input_components = 3;
		cinfo.in_color_space = JCS_RGB;
	} else {
		cinfo.input_components = 1;
		cinfo.in_color_space = JCS_GRAYSCALE;
	}


    jpeg_set_defaults(&cinfo);
    jpeg_set_quality(&cinfo, quality, TRUE);
    jpeg_start_compress(&cinfo, TRUE);
    row_stride = widthPix * 3;
    while (cinfo.next_scanline < cinfo.image_height) {
  		LPBYTE outRow;
		if (color) {
			outRow = dataBuf + (cinfo.next_scanline * widthPix * 3);
		} else {
			outRow = tmp + (cinfo.next_scanline * widthPix);
		}
		(void) jpeg_write_scanlines(&cinfo, &outRow, 1);
	}
	jpeg_finish_compress(&cinfo);
	fclose(outfile);
	jpeg_destroy_compress(&cinfo);
	if (!color)  delete [] tmp;
	return 0;
}


// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
BYTE *JpegFileToRGB(char *fileName,UINT *width,UINT *height)
{
	BYTE *dataBuf = NULL;
	*width=0;
	*height=0;
	struct jpeg_decompress_struct cinfo;
	struct my_error_mgr jerr;
	FILE * infile=NULL;	
	JSAMPARRAY buffer;
	int row_stride;

	if ((infile = fopen(fileName, "rb")) == NULL) {
		return NULL;
	}
	cinfo.err = jpeg_std_error(&jerr.pub);

	jerr.pub.error_exit = my_error_exit;
	if (setjmp(jerr.setjmp_buffer)) 
	{
		jpeg_destroy_decompress(&cinfo);
		if (infile!=NULL)	fclose(infile);
		if (dataBuf!=NULL)   delete [] dataBuf;
		return NULL;
	}
	jpeg_create_decompress(&cinfo);
	jpeg_stdio_src(&cinfo, infile);
	(void) jpeg_read_header(&cinfo, TRUE);
	(void) jpeg_start_decompress(&cinfo);

	dataBuf=(BYTE *)new BYTE[cinfo.output_width * 3 * cinfo.output_height];
	if (dataBuf==NULL) {
		jpeg_destroy_decompress(&cinfo);
		fclose(infile);
		return NULL;
	}

	*width = cinfo.output_width;
	*height = cinfo.output_height;
	
	row_stride = cinfo.output_width * cinfo.output_components;

	buffer = (*cinfo.mem->alloc_sarray)
		((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

	while (cinfo.output_scanline < cinfo.output_height) {
		(void) jpeg_read_scanlines(&cinfo, buffer, 1);
		if (cinfo.out_color_components==3) {
			j_putRGBScanline(buffer[0], 
								*width,
								dataBuf,
								cinfo.output_scanline-1);
		} else if (cinfo.out_color_components==1) {
			j_putGrayScanlineToRGB(buffer[0], 
								*width,
								dataBuf,
								cinfo.output_scanline-1);
		}
	}
	(void) jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);
	fclose(infile);
	return (BYTE *)dataBuf;
	
}

/*
void main()
{
	FILE *fp = fopen("high9.raw","rb");
	unsigned int width,height;
	unsigned char *nBF;
	BYTE *gg;
	nBF = new BYTE[228*172*3];
	fread(nBF,228*172*3,1,fp);
	fclose(fp);
	printf("hohoho");
	printf("%d\n",Raw2Jpeg(228,172,nBF,"test.jpg"));
	gg = JpegFileToRGB("high1.jpg",&width,&height);
	if(gg != NULL)printf("return w:%d, H:%d\n",width,height);
	else printf("fffff!!\n");
	printf("%d\n",Raw2Jpeg(width,height,gg,"test2.jpg"));
	delete []nBF;
}
*/