#include <stdlib.h>
#include <io.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include "_giflib.h"

/**************************************************************************************\
  ڰ ʿ ϴ Լ 
  int Gif2Raw(char *Giffilename,char* n24bitBuffer);
  Giffilename	> Ǿ ִ gif ȭ ̸
  n24bitBuffer  > 24bit ¥ ̹  
\**************************************************************************************/

int Gif2Raw(char *Giffilename,unsigned char* n24bitBuffer,int &nwidth,int &nHeight);

////////////////////////////////////////////////////////////////////////////////////////












typedef struct 
{
	unsigned char R;
	unsigned char G;
	unsigned char B;
} nRGB;


static int ImageNum = 0,  BackGround = 0, OneFileFlag = FALSE,  HelpFlag = FALSE, ColorMapSize = 0,
		   InterlacedOffset[] = { 0, 4, 2, 1 },		/* The way Interlaced image should. */
           InterlacedJumps[] = { 8, 8, 4, 2 };		/* be read - offsets and jumps... */
static GifColorType  *ColorMap;



int Gif2Raw(char *Giffilename,unsigned char* n24bitBuffer,int &nWidth,int &nHeight)
{
    int	i, j, Error, NumFiles, Size, Row, Col, Width, Height; 
		short ExtCode, Count,OutFileFlag = FALSE;
    GifRecordType RecordType;
    GifByteType *Extension;
    char *OutFileName,
	**FileName = NULL;
    GifRowType *ScreenBuffer;
    GifFileType *GifFile;

	n24bitBuffer = NULL;

	if ((GifFile = DGifOpenFileName(Giffilename)) == NULL) {
		return -1;
	}
    if ((ScreenBuffer = (GifRowType *)malloc(GifFile -> SHeight * sizeof(GifRowType *))) == NULL) return -2;
    Size = GifFile -> SWidth * sizeof(GifPixelType);/* Size in bytes one row.*/
    if ((ScreenBuffer[0] = (GifRowType) malloc(Size)) == NULL) 	
	{
		free(ScreenBuffer);
		return -3;
	}

    for (i = 0; i < GifFile -> SWidth; i++)  /* Set its color to BackGround. */
		ScreenBuffer[0][i] = GifFile -> SBackGroundColor;
    for (i = 1; i < GifFile -> SHeight; i++) 
	{
		/* Allocate the other rows, and set their color to background too: */
		if ((ScreenBuffer[i] = (GifRowType) malloc(Size)) == NULL) 
		{
			for(int jh =0; jh <i;jh++) free(ScreenBuffer[jh]);
			free(ScreenBuffer);
			return -4;
		}
		memcpy(ScreenBuffer[i], ScreenBuffer[0], Size);
    }

  do 
  {
	if (DGifGetRecordType(GifFile, &RecordType) == GIF_ERROR) 
	{
		for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
		free(ScreenBuffer);
		return -5;
	}
	switch (RecordType) 
	{
	    case IMAGE_DESC_RECORD_TYPE:
			if (DGifGetImageDesc(GifFile) == GIF_ERROR) 
			{
				for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
				free(ScreenBuffer);
				return -6;
			}
		Row = GifFile -> ITop; /* Image Position relative to Screen. */
		Col = GifFile -> ILeft;
		Width = GifFile -> IWidth;
		Height = GifFile -> IHeight;
		if (GifFile -> ILeft + GifFile -> IWidth > GifFile -> SWidth ||
		   GifFile -> ITop + GifFile -> IHeight > GifFile -> SHeight) {
				for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
				free(ScreenBuffer);
				return -6;
		}
		if (GifFile -> IInterlace) {
		    /* Need to perform 4 passes on the images: */
		    for (Count = i = 0; i < 4; i++)
			for (j = Row + InterlacedOffset[i]; j < Row + Height; j += InterlacedJumps[i]) 
			{
			    if (DGifGetLine(GifFile, &ScreenBuffer[j][Col],Width) == GIF_ERROR) 
				{
					for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
					free(ScreenBuffer);
					return -6;
			    }
			}
		}
		else {
		    for (i = 0; i < Height; i++) 
			{
				if (DGifGetLine(GifFile, &ScreenBuffer[Row++][Col],	Width) == GIF_ERROR) 
				{
					for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
					free(ScreenBuffer);
					return -6;
				}
		    }
		}
		break;
	    case EXTENSION_RECORD_TYPE:
		/* Skip any extension blocks in file: */
			if (DGifGetExtension(GifFile, &ExtCode, &Extension) == GIF_ERROR) 
			{
				for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
				free(ScreenBuffer);
				return -6;
			}
		while (Extension != NULL) {
		    if (DGifGetExtensionNext(GifFile, &Extension) == GIF_ERROR) 
			{
				for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
				free(ScreenBuffer);
				return -6;
		    }
		}
		break;
	    case TERMINATE_RECORD_TYPE:
		break;
	    default:		    /* Should be traps by DGifGetRecordType. */
		break;
	}
    }
    while (RecordType != TERMINATE_RECORD_TYPE);

    BackGround = GifFile -> SBackGroundColor;
    ColorMap = (GifFile -> IColorMap ? GifFile -> IColorMap : GifFile -> SColorMap);
    ColorMapSize = 1 << (GifFile -> IColorMap ? GifFile -> IBitsPerPixel : GifFile -> SBitsPerPixel);

	GifRowType GifRow;
	nRGB *tempBuffer = (nRGB *)malloc((GifFile -> SWidth * GifFile -> SHeight) * sizeof(nRGB));
	n24bitBuffer = (unsigned char *)tempBuffer;
	for(i=0;i< GifFile -> SHeight;i++)
	{
		GifRow = ScreenBuffer[i];
		for(j=0;j<GifFile->SWidth;j++)
		{
			tempBuffer->R = ColorMap[GifRow[j]].Red;
			tempBuffer->G = ColorMap[GifRow[j]].Green;
			tempBuffer->B = ColorMap[GifRow[j]].Blue;
			tempBuffer++;
		}
	}
///////////////////////
	FILE *hf;
	hf = fopen("outputraw.raw","wb");
	fwrite(n24bitBuffer,GifFile -> SWidth * GifFile -> SHeight * 3,1,hf);
	fclose(hf);
///////////////////////
	nWidth = GifFile->SWidth;
	nHeight = GifFile->SHeight;
    if (DGifCloseFile(GifFile) == GIF_ERROR) 
	{
		for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
		free(ScreenBuffer);
		return -6;
    } else
	{
		for(int jh =0; jh <GifFile -> SHeight;jh++) free(ScreenBuffer[jh]);
		free(ScreenBuffer);
	}
	
	return 0;
}