#include "headers.h"

XBomb::XBomb()
{
	m_Sprite = NULL;
	m_Stage = NULL;
}

XBomb::XBomb(int x, int y, int angle, int speed, XImage *sprite, XStageManager *stage)
{
	m_LiveFlag = TRUE;
	m_X = x;
	m_Y = y;
	m_PivotX = x;
	m_PivotY = y;
	m_Time = 0;
	m_XSpeed = (TrigTable.Cos(angle)*speed);
	m_YSpeed = (TrigTable.Sin(angle)*speed);
	m_Frame = 0;
	m_Action = BOMB_ACTION_MOVE;
	m_PrevAction = 0;
	m_Sprite = sprite;
	m_Stage = stage;
}

XBomb::~XBomb()
{
}

bool XBomb::Check()
{
	XBuffer *land = m_Stage->GetLand();

	if(land->GetAddress()[m_X+m_Sprite->GetWidth()/2+
		(m_Y+m_Sprite->GetHeight()/2)*land->GetWidth()] != 0) return TRUE;
	return FALSE;
}

void XBomb::ActionMove()
{
	int temp_x = (int)((float)m_XSpeed*m_Time/(float)256);
	int temp_y = (int)((float)m_YSpeed*m_Time/(float)256 - ((float)50*m_Time*m_Time));
	m_X = m_PivotX + temp_x;
	m_Y = m_PivotY - temp_y;
	m_Time+=(float)0.025;
	if(Check() == TRUE)
	{
		int i, j;
		XBigOffScreen *landview = m_Stage->GetLandView();
		int landview_xcount = landview->GetSmallOffScreenXCount();
		int landview_ycount = landview->GetSmallOffScreenYCount();
		int screen_width = DD.GetWidth();
		int screen_height = DD.GetHeight();
		for(j = 0; j < landview_ycount; j++)
		{
			for(i = 0; i < landview_xcount; i++)
			{
				landview->GetSmallOffScreen(i,j)->GetBuffer()->DrawFillEllipse(m_X-i*screen_width, m_Y-j*screen_height,50,30,0);
				landview->GetSmallOffScreen(i,j)->ReleaseBuffer();
			}
		}
		XBuffer *land = m_Stage->GetLand();
		land->DrawFillEllipse(m_X, m_Y,50,30,0);
		m_Action = BOMB_ACTION_EXPLODE;
	}
}

void XBomb::ActionExplode()
{
}

void XBomb::Action()
{
	switch(m_Action)
	{
	case BOMB_ACTION_MOVE: ActionMove();
		break;
	case BOMB_ACTION_EXPLODE: ActionExplode();
		break;
	}
}

void XBomb::Draw(XBuffer *target)
{
	m_Sprite->Blit(target, m_X-m_Stage->GetViewX(), m_Y-m_Stage->GetViewY());
}

