#ifndef _DIRECTDRAW_H
#define _DIRECTDRAW_H

class XRectangle;
class XBuffer;
class XImage;
class XOffScreen;
class XBigOffScreen;
class XDirectDrawHandler;

class XRectangle
{
public:
	int left, top, right, bottom;
public:
	XRectangle();
	XRectangle(XRectangle& rectangle);
	XRectangle(int left, int top, int right, int bottom);
	virtual ~XRectangle();
	int GetWidth();
	int GetHeight();
	void Arrange();
	int CheckCrash(XRectangle source);
	int CheckCrash(int x, int y);
	void ClipEdge(XRectangle source);
	XRectangle operator = (XRectangle& rectangle);
};

class XBuffer
{
private:
	bool m_AllocateFlag;
	int m_Width, m_Height, m_Pitch;
	char *m_Address;
	XRectangle m_Clipper;
public:
	XBuffer();
	XBuffer(int width, int height);
	virtual ~XBuffer();
	int Create(int width, int height);
	int GetWidth();
	int GetHeight();
	int GetPitch();
	char *GetAddress();
	XRectangle& GetClipper();
	XRectangle GetBorder();
	void SetWidth(int width);
	void SetHeight(int height);
	void SetPitch(int pitch);
	void SetAddress(char *address);
	void SetClipper(XRectangle rectangle);
	void SetClipper(int left, int top, int right, int bottom);
	int LoadBitmap(char *name);
	void Clear(char color);
	void DrawPixel(int x, int y, char color);
	void DrawHLine(int left, int right, int y, char color);
	void DrawVLine(int x, int top, int bottom, char color);
	void DrawLine(int x1, int y1, int x2, int y2, char color);
	void DrawBlankRectangle(XRectangle rectangle, char color);
	void DrawBlankRectangle(int left, int top, int right, int bottom, char color);
	void DrawFillRectangle(XRectangle rectangle, char color);
	void DrawFillRectangle(int left, int top, int right, int bottom, char color);
	void DrawEllipse(int middle_x, int middle_y, int length_x, int length_y, char color);
	void DrawFillEllipse(int middle_x, int middle_y, int length_x, int length_y, char color);
	void Blit(XBuffer *target, int x, int y, XRectangle rectangle);
};

class XImage
{
private:
	bool m_AllocateFlag;
	bool m_CompressFlag;
	int m_Width, m_Height;
	char *m_Address;
	int m_AddressLength;
private:
	int GetCompressCount(XBuffer *source, XRectangle rectangle);
	void GetCompressData(XBuffer *source, XRectangle rectangle);
	void LineForRotate(XBuffer *target, int height, int x1, int y1, int x2, int y2);
public:
	XImage();
	XImage(XBuffer *source, XRectangle rectangle, bool compress=TRUE);
	virtual ~XImage();
	int Create(XBuffer *source, XRectangle rectangle, bool compress=TRUE);
	bool Compress();
	bool Uncompress();
	int GetWidth();
	int GetHeight();
	void Blit(XBuffer *target, int x, int y);
	void RotateBlit(XBuffer *target, int x, int y, int middle_x, int middle_y, int angle);
	void CompressBlit(XBuffer *target, int x, int y);
	void UncompressBlit(XBuffer *target, int x, int y);
};

class XOffScreen
{
private:
	XDirectDrawHandler *m_DirectDrawHandler;
	int m_Width, m_Height;
	DDSURFACEDESC m_Ddsd;
	LPDIRECTDRAWSURFACE m_Surface;
	XBuffer m_Buffer;
public:
	XOffScreen();
	XOffScreen(XDirectDrawHandler *DDH, int width=640, int height=480, int blank_color_start=0, int blank_color_end=0);
	virtual ~XOffScreen();
	int Create(XDirectDrawHandler *DDH, int width=640, int height=480, int blank_color_start=0, int blank_color_end=0);
	int ChangeSize(int width, int height);
	int GetWidth();
	int GetHeight();
	XRectangle GetBorder();
	LPDIRECTDRAWSURFACE GetSurface();
	XBuffer *GetBuffer();
	void ReleaseBuffer();
	int LoadBitmap(char *name);
};

class XBigOffScreen
{
private:
	XDirectDrawHandler *m_DirectDrawHandler;
	int m_Width, m_Height;
	int m_XEdgeFlag, m_YEdgeFlag;
	int m_ScreenXCount, m_ScreenYCount;
	XOffScreen **m_Screen;
public:
	XBigOffScreen();
	XBigOffScreen(XDirectDrawHandler *DDH, int width, int height, int blank_color_start=0, int blank_color_end=0);
	virtual ~XBigOffScreen();
	int Create(XDirectDrawHandler *DDH, int width, int height, int blank_color_start=0, int blank_color_end=0);
	int ChangeSize(int width, int height);
	int GetWidth();
	int GetHeight();
	int GetSmallOffScreenXCount();
	int GetSmallOffScreenYCount();
	int GetSmallOffScreenWidth();
	int GetSmallOffScreenHeight();
	int GetEdgeWidth();
	int GetEdgeHeight();
	XRectangle GetBorder();
	XOffScreen *GetSmallOffScreen(int x, int y);
	int LoadBitmap(char *name);
	void Blit();
};

class XDirectDrawHandler
{
private:
	HWND m_hWnd;
	bool m_FullScreenFlag;
	LPDIRECTDRAW m_DirectDraw;
	int m_Width, m_Height;
	DDSURFACEDESC m_Ddsd;
	LPDIRECTDRAWSURFACE m_PrimarySurface;
	LPDIRECTDRAWSURFACE m_BackSurface;
	LPDIRECTDRAWPALETTE m_Palette;
	LPDIRECTDRAWCLIPPER m_Clipper;
	PALETTEENTRY m_PaletteEntry[256];
	XBuffer m_Buffer;
public:
	XDirectDrawHandler();
	virtual ~XDirectDrawHandler();
	int Create(HWND hWnd, bool full_screen=TRUE, DWORD dwDisplayWidth=640, DWORD dwDisplayHeight=480, DWORD dwBitPlanes=8, DWORD RefreshRate=0);
	LPDIRECTDRAW GetDirectDraw();
	int GetWidth();
	int GetHeight();
	XBuffer *GetBackSurfaceBuffer();
	void ReleaseBackSurfaceBuffer();
	LPDIRECTDRAWSURFACE GetPrimarySurface();
	LPDIRECTDRAWSURFACE GetBackSurface();
	int LoadBitmapPalette(char *name);
	int SetPalette();
};

#endif
