#include <windows.h>
#include "ddraw.h"
#include "etc_func.h"
#include "directdraw.h"
#include "math_func.h"

XImage::XImage()
{
	m_CompressFlag = FALSE;
	m_AllocateFlag = FALSE;
	m_Width = 0;
	m_Height = 0;
	m_Address = NULL;
}

XImage::XImage(XBuffer *source, XRectangle rectangle, bool compress)
{
	Create(source, rectangle, compress);
}

XImage::~XImage()
{
	if(m_AllocateFlag == TRUE)
	{
		delete [] m_Address;
		m_Address = NULL;
	}
}

int XImage::Create(XBuffer *source, XRectangle rectangle, bool compress)
{
	if(m_AllocateFlag == TRUE) return FALSE;
	int source_pitch = source->GetPitch();
	int source_height = source->GetHeight();
	rectangle.ClipEdge(source->GetBorder());
	m_Width = rectangle.GetWidth();
	m_Height = rectangle.GetHeight();
	m_CompressFlag = compress;
	if(m_CompressFlag == FALSE)
	{
		m_Address = new char [m_Width * m_Height];
		if(m_Address == NULL) return FALSE;
		m_AllocateFlag = TRUE;
		m_AddressLength = m_Width * m_Height;
		char *target_address = m_Address;
		char *source_address = source->GetAddress()+rectangle.left+rectangle.top*source_pitch;
		for(int i = 0; i < m_Height; i++)
		{
			MemoryCopy(target_address,source_address,m_Width);
			target_address += m_Width;
			source_address += source_pitch;
		}
	}
	else
	{
		m_AddressLength = GetCompressCount(source, rectangle);
		m_Address = new char [m_AddressLength];
		if(m_Address == NULL) return FALSE;
		m_AllocateFlag = TRUE;
		GetCompressData(source, rectangle);
	}

	return TRUE;
}

int XImage::GetCompressCount(XBuffer *source, XRectangle rectangle)
{
	int i, j;
	int image_count = 0;
	int data_count;
	int width = rectangle.GetWidth();
	int height = rectangle.GetHeight();
	int source_pitch = source->GetPitch();
	int source_add = source_pitch - width;
	char *source_address = source->GetAddress() + rectangle.left + rectangle.top * source_pitch;

	for(j = 0; j < height; j++)
	{
		i = 0;
		while(i < width)
		{
			while(*source_address == 0 && i < width) 
			{
				i++;
				source_address++; 
			}
			image_count += 2;
			data_count = 0;
			while(*source_address != 0 && i < width)
			{
				i++;
				source_address++;
				data_count++;
			}
			if(data_count > 0) image_count += 2 + data_count;
		}
		source_address += source_add;
	}
	return image_count;
}

void XImage::GetCompressData(XBuffer *source, XRectangle rectangle)
{
	int i, j;
	int data_count;
	int width = rectangle.GetWidth();
	int height = rectangle.GetHeight();
	int source_pitch = source->GetPitch();
	int source_add = source_pitch - width;
	char *target_address = m_Address;
	char *source_address = source->GetAddress() + rectangle.left + rectangle.top * source_pitch;
	char *source_count = source->GetAddress() + rectangle.left + rectangle.top * source_pitch;

	for(j = 0; j < height; j++)
	{
		i = 0;
		while(i < width)
		{
			data_count = 0;
			while(*source_count == 0 && i < width) 
			{
				i++;
				source_address++;
				source_count++;
				data_count++;
			}
			MemoryCopy(target_address, (char*)&data_count, 2);
			target_address += 2;

			data_count = 0;
			while(*source_count != 0 && i < width)
			{
				i++;
				source_count++;
				data_count++;
			}
			if(data_count > 0) 
			{
				MemoryCopy(target_address, (char*)&data_count, 2);
				target_address += 2;
				MemoryCopy(target_address, source_address, data_count);
				target_address += data_count;
				source_address += data_count;
			}
		}
		source_address += source_add;
		source_count += source_add;
	}
}

bool XImage::Compress(void)
{
	if(m_CompressFlag == TRUE) return FALSE;
	if(m_AllocateFlag != TRUE) return FALSE;
	XBuffer temp;
	temp.Create(m_Width,m_Height);
	temp.Clear(0);
	Blit(&temp,0,0);
	delete [] m_Address;
	m_AllocateFlag = FALSE;
	m_AddressLength = GetCompressCount(&temp, XRectangle(0,0,m_Width-1,m_Height-1));
	m_Address = new char [m_AddressLength];
	if(m_Address == NULL) return FALSE;
	m_AllocateFlag = TRUE;
	GetCompressData(&temp,XRectangle(0,0,m_Width-1,m_Height-1));
	m_CompressFlag = TRUE;
	return TRUE;
}

bool XImage::Uncompress(void)
{
	if(m_CompressFlag == FALSE) return FALSE;
	if(m_AllocateFlag != TRUE) return FALSE;
	XBuffer temp;
	temp.Create(m_Width,m_Height);
	temp.Clear(0);
	Blit(&temp,0,0);
	delete [] m_Address;
	m_AllocateFlag = FALSE;
	m_AddressLength = m_Width*m_Height;
	m_Address = new char [m_AddressLength];
	if(m_Address == NULL) return FALSE;
	m_AllocateFlag = TRUE;
	MemoryCopy(m_Address, temp.GetAddress(), m_AddressLength);
	m_CompressFlag = FALSE;
	return TRUE;
}

int XImage::GetWidth()
{
	return m_Width;
}

int XImage::GetHeight()
{
	return m_Height;
}

void XImage::Blit(XBuffer *target, int x, int y)
{
	if(m_CompressFlag == TRUE) CompressBlit(target, x, y);
	else UncompressBlit(target, x, y);
}

void XImage::RotateBlit(XBuffer *target, int x, int y, int middle_x, int middle_y, int angle)
{
	int x1, y1, x2, y2, x3, y3;
	int vx1 = -middle_x, vy1 = -middle_y;
	int vx2 = m_Width-1-middle_x, vy2 = m_Height-1-middle_y;

	x += middle_x;
	y += middle_y;
	x1 = x + ((TrigTable.Cos(angle)*vx1 + TrigTable.Sin(angle)*vy1)>>8);
	y1 = y + ((-TrigTable.Sin(angle)*vx1 + TrigTable.Cos(angle)*vy1)>>8);
	x2 = x + ((TrigTable.Cos(angle)*vx2 + TrigTable.Sin(angle)*vy1)>>8);
	y2 = y + ((-TrigTable.Sin(angle)*vx2 + TrigTable.Cos(angle)*vy1)>>8);
	x3 = x + ((TrigTable.Cos(angle)*vx1 + TrigTable.Sin(angle)*vy2)>>8);
	y3 = y + ((-TrigTable.Sin(angle)*vx1 + TrigTable.Cos(angle)*vy2)>>8);

	int error_term = 0;
	int x_diff = x3-x1, y_diff = y3-y1;

	for(int j = 0; j < m_Height; j++)
	{
		x = x_diff*j/m_Height;
		y = y_diff*j/m_Height;
		LineForRotate(target, j, x1+x, y1+y, x2+x, y2+y);
	}
}

void XImage::LineForRotate(XBuffer *target, int height, int x1, int y1, int x2, int y2)
{
	XRectangle clipper = target->GetClipper();
	if((x1 < clipper.left && x2 < clipper.left)||(x1 > clipper.right && x2 > clipper.right)) return;
	if((y1 < clipper.top && y2 < clipper.top)||(y1 > clipper.bottom && y2 > clipper.bottom)) return;

	int now_x = x1, now_y = y1;
	int x_unit, y_unit, y_unit2, x_diff, y_diff;
	int error_term = 0;
	char *address = target->GetAddress()+x1+y1*target->GetPitch();
	char *image = m_Address+height*m_Width;
	int pitch = target->GetPitch();
	int image_diff;
	int image_error_term = 0;
	x_diff = x2-x1;
	y_diff = y2-y1;

	if(y_diff < 0) { y_diff=-y_diff; y_unit = -pitch; y_unit2 = -1; }
	else { y_unit = pitch; y_unit2 = 1; }
	if(x_diff < 0) { x_diff=-x_diff; x_unit = -1; }
	else { x_unit = 1; }

	if(x_diff > y_diff)
	{
		int length = x_diff+1;
		image_diff = ((m_Width-length)<<10)/length;
		for(int i = 0; i < length; i++)
		{
			error_term += y_diff;
			if(error_term > x_diff)
			{
				error_term -= x_diff;
				if(*image && clipper.CheckCrash(now_x,now_y)) *address = *image;
				address += y_unit;
				now_y += y_unit2;
			}
			if(*image && clipper.CheckCrash(now_x,now_y)) *address = *image;
			address += x_unit;
			now_x += x_unit;
			image++;
			image_error_term += image_diff;
			if(image_error_term >= 1024)
			{
				image_error_term -= 1024;
				image++;
			}
		}
	}
	else
	{
		int length = y_diff+1;
		image_diff = ((m_Width-length)<<10)/length;
		for(int i = 0; i < length; i++)
		{
			error_term += x_diff;
			if(error_term > y_diff) 
			{ 
				error_term -= y_diff;
				if(*image && clipper.CheckCrash(now_x,now_y)) *address = *image;
				address += x_unit;
				now_x += x_unit;
			}
			if(*image && clipper.CheckCrash(now_x,now_y)) *address = *image;
			address += y_unit;
			now_y += y_unit2;
			image++;
			image_error_term += image_diff;
			if(image_error_term >= 1024)
			{
				image_error_term -= 1024;
				image++;
			}
		}
	}
}

void XImage::CompressBlit(XBuffer *target, int x, int y)
{
	char *source_address = m_Address;
	char *target_address = target->GetAddress();
	int top_clip=0, left_clip=0, right_clip=0, bottom_clip=0;
	int blit_width = m_Width;
	int blit_height = m_Height;
	int source_width = m_Width;
	int target_pitch = target->GetPitch();
	int target_add;
	XRectangle target_clipper = target->GetClipper();
	if(x+blit_width-1 < target_clipper.left || x > target_clipper.right) return;
	if(y+blit_height-1 < target_clipper.top || y > target_clipper.bottom) return;
	if(x < target_clipper.left)
	{
		left_clip = target_clipper.left-x;
		blit_width -= left_clip;
		x = target_clipper.left;
	}
	if(x+blit_width-1 > target_clipper.right)
	{
		right_clip = (x+blit_width-1) - target_clipper.right;
		blit_width -= right_clip;
	}
	if(y < target_clipper.top)
	{
		top_clip = target_clipper.top-y;
		blit_height -= top_clip;
		y = target_clipper.top;
	}
	if(y+blit_height-1 > target_clipper.bottom)
	{
		bottom_clip = (y+blit_height-1) - target_clipper.bottom;
		blit_height -= bottom_clip;
	}

	target_address += x + y * target_pitch;
	target_add = target_pitch - blit_width;
	__asm
	{
		mov edi, target_address;
		mov esi, source_address;
		mov ebx, top_clip
		mov edx, source_width
		xor eax, eax
// Ŭ 
top_clip1:
		cmp ebx, 0
		je top_clip_end
		mov ecx, edx
top_clip2:
		lodsw
		sub ecx, eax
		jz top_clip3
		lodsw
		add esi, eax
		sub ecx, eax
		jz top_clip3
		jmp top_clip2
top_clip3:
		dec ebx
		jmp top_clip1
top_clip_end:

//ʺ Ŭ 
		mov ecx, blit_height
left_clip1:
		push ecx
		mov ebx, left_clip
		mov edx, blit_width
		cmp ebx, 0
		je right_blank
//  Ŭ
left_clip2:
		lodsw
		cmp ebx, eax
		jg left_clip5
		sub eax, ebx
		cmp eax, edx
		jl left_clip4
		add edi, edx
		sub eax, edx
		mov ebx, right_clip
		sub ebx, eax
		jz line_end
left_clip3:
		lodsw
		add esi, eax
		sub ebx, eax
		je line_end
		lodsw
		sub ebx, eax
		je line_end
		jmp left_clip3
left_clip4:
		add edi, eax
		sub edx, eax
		jz line_end
		jmp right_image
left_clip5:
		sub ebx, eax
// ̹ Ŭ
		lodsw
		cmp ebx, eax
		jg left_clip13
		add esi, ebx
		sub eax, ebx
		cmp eax, edx
		jl left_clip10
		mov ecx, edx
		shr ecx, 1
		jnc left_clip7
		movsb
left_clip7:
		shr ecx, 1
		jnc left_clip8
		movsw
left_clip8:
		rep movsd
		sub eax, edx
		add esi, eax
		mov ebx, right_clip
		sub ebx, eax
		jz line_end
left_clip9:
		lodsw
		sub ebx, eax
		jz line_end
		lodsw
		add esi, eax
		sub ebx, eax
		jz line_end
		jmp left_clip9
left_clip10:
		mov ecx, eax
		shr ecx, 1
		jnc left_clip11
		movsb
left_clip11:
		shr ecx, 1
		jnc left_clip12
		movsw
left_clip12:
		rep movsd
		sub edx, eax
		jz line_end
		jmp right_blank
left_clip13:
		sub ebx, eax
		add esi, eax
		jmp left_clip2
//  Ŭ
right_blank:
		lodsw
		cmp eax, edx
		jle right_blank2
		add edi, edx
		sub eax, edx
		mov ebx, right_clip
		sub ebx, eax
		jz line_end
right_blank1:
		lodsw
		add esi, eax
		sub ebx, eax
		jz line_end
		lodsw
		sub ebx, eax
		jz line_end
		jmp right_blank1
right_blank2:
		add edi, eax
		sub edx, eax
		jnz right_image
		mov ebx, right_clip
		cmp ebx, 0
		je line_end
		jmp right_blank1
//  ̹ Ŭ
right_image:
		lodsw
		cmp eax, edx
		jle right_image4
		mov ecx, edx
		shr ecx, 1
		jnc right_image1
		movsb
right_image1:
		shr ecx, 1
		jnc right_image2
		movsw
right_image2:
		rep movsd
		sub eax, edx
		add esi, eax
		mov ebx, right_clip
		sub ebx, eax
		jz line_end
right_image3:
		lodsw
		sub ebx, eax
		jz line_end
		lodsw
		add esi, eax
		sub ebx, eax
		jz line_end
		jmp right_image3
right_image4:
		mov ecx, eax
		shr ecx, 1
		jnc right_image5
		movsb
right_image5:
		shr ecx, 1
		jnc right_image6
		movsw
right_image6:
		rep movsd
		sub edx, eax
		jnz right_blank
		mov ebx, right_clip
		cmp ebx, 0
		je line_end
		jmp right_image3
//  
line_end:
		pop ecx
		dec ecx
		jz end
		add edi, target_add
		jmp left_clip1
end:
	}
}

void XImage::UncompressBlit(XBuffer *target, int x, int y)
{
	char *source_address = m_Address;
	char *target_address = target->GetAddress();
	int blit_width = m_Width;
	int blit_height = m_Height;
	int source_add, target_add;
	int target_pitch = target->GetPitch();
	XRectangle target_clipper = target->GetClipper();
	if(x+blit_width-1 < target_clipper.left || x > target_clipper.right) return;
	if(y+blit_height-1 < target_clipper.top || y > target_clipper.bottom) return;
	if(x < target_clipper.left)
	{
		source_address += target_clipper.left-x;
		blit_width -= target_clipper.left-x;
		x = target_clipper.left;
	}
	if(x+blit_width-1 > target_clipper.right)
		blit_width -= (x+blit_width-1) - target_clipper.right;
	if(y < target_clipper.top)
	{
		source_address += (target_clipper.top-y)*m_Width;
		blit_height -= target_clipper.top-y;
		y = target_clipper.top;
	}
	if(y+blit_height-1 > target_clipper.bottom)
		blit_height -= (y+blit_height-1) - target_clipper.bottom;

	target_address += x + y * target_pitch;
	source_add = m_Width - blit_width;
	target_add = target_pitch - blit_width;

	__asm
	{
		mov esi, source_address
		mov edi, target_address
		mov edx, blit_height
goto1:	mov ecx, blit_width
goto2:	lodsb
		cmp al, 0
		je goto3
		stosb
		jmp goto4
goto3:	inc edi
goto4:	dec ecx
		jnz goto2
		add esi, source_add
		add edi, target_add
		dec edx
		jnz goto1
	}
}

