#include <windows.h>
#include "ddraw.h"
#include "etc_func.h"
#include "directdraw.h"

XRectangle::XRectangle()
{
	left = 0;
	top = 0;
	right = 0;
	bottom = 0;
}

XRectangle::XRectangle(XRectangle& rectangle)
{
	left = rectangle.left;
	top = rectangle.top;
	right = rectangle.right;
	bottom = rectangle.bottom;
}

XRectangle::XRectangle(int left, int top, int right, int bottom)
{
	if(top > bottom) Swap(top, bottom);
	if(left > right) Swap(left, right);
	this->left = left;
	this->top = top;
	this->right = right;
	this->bottom = bottom;
}

XRectangle::~XRectangle()
{
}

int XRectangle::GetWidth()
{
	return right-left+1;
}

int XRectangle::GetHeight()
{
	return bottom-top+1;
}

void XRectangle::Arrange()
{
	if(top > bottom) Swap(top, bottom);
	if(left > right) Swap(left, right);
}

int XRectangle::CheckCrash(XRectangle source)
{
	if(right >= source.left && left <= source.right && bottom >= source.top && top <= source.bottom) return TRUE;
	return FALSE;
}

int XRectangle::CheckCrash(int x, int y)
{
	if(right >= x && left <= x && bottom >= y && top <= y) return TRUE;
	return FALSE;
}

void XRectangle::ClipEdge(XRectangle source)
{
	if(left < source.left) left = source.left;
	if(right > source.right) right = source.right;
	if(bottom > source.bottom) bottom = source.bottom;
	if(top < source.top) top = source.top;
}

XRectangle XRectangle::operator=(XRectangle& rectangle)
{
	left = rectangle.left;
	top = rectangle.top;
	right = rectangle.right;
	bottom = rectangle.bottom;

	return *this;
}