#include <windows.h>
#define DIRECTINPUT_VERSION 0x0300
#include "dinput.h"
#include "directinput.h"

XDirectInputHandler::XDirectInputHandler()
{
	m_DirectInput = NULL;
	m_Keyboard = NULL;
}

XDirectInputHandler::~XDirectInputHandler()
{
	if(m_Keyboard != NULL) 
	{
		m_Keyboard->Unacquire();
		m_Keyboard->Release();
	}
	m_Keyboard = NULL;

	if(m_DirectInput != NULL) m_DirectInput->Release();
	m_DirectInput = NULL;
}

int XDirectInputHandler::Create(HINSTANCE hInstance, HWND hWnd)
{
	DirectInputCreate(hInstance, DIRECTINPUT_VERSION, &m_DirectInput, NULL);

	m_DirectInput->CreateDevice(GUID_SysKeyboard, &m_Keyboard, NULL);
	m_Keyboard->SetDataFormat(&c_dfDIKeyboard);
	m_Keyboard->SetCooperativeLevel(hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	m_Keyboard->Acquire();

	return TRUE;
}

char *XDirectInputHandler::GetKeyboardState()
{
	while(m_Keyboard->GetDeviceState(sizeof(m_Key), m_Key) == DIERR_INPUTLOST)
		m_Keyboard->Acquire();

	return m_Key;
}
