#include <windows.h>
#include "etc_func.h"

void MemorySet(char *target, char number, int count)
{
	__asm
	{
		mov edi, target
		mov al, number
		mov ah, number
		push ax
		push ax
		pop eax
		mov ecx, count
		shr ecx, 1
		jnc goto1
		stosb
goto1:	shr ecx, 1
		jnc goto2
		stosw
goto2:	rep stosd
	}
}

void MemoryCopy(char *target, char *source, int count)
{
	__asm
	{
		mov edi, target
		mov esi, source
		mov ecx, count
		shr ecx, 1
		jnc goto1
		movsb
goto1:	shr ecx, 1
		jnc goto2
		movsw
goto2:	rep movsd
	}
}

int LoadBitmapHeader(char *name, BITMAPFILEHEADER *bfh, BITMAPINFOHEADER *bih)
{
	unsigned long readbyte;
	HANDLE file;

	file = CreateFile(name, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(file == INVALID_HANDLE_VALUE) return FALSE;

  	ReadFile(file, bfh, sizeof(BITMAPFILEHEADER), &readbyte, NULL);
	ReadFile(file, bih, sizeof(BITMAPINFOHEADER), &readbyte, NULL);

	if(bfh->bfType != 0x4D42) return FALSE;
	if(bih->biSize != sizeof(BITMAPINFOHEADER)) return FALSE;
	if(bih->biBitCount > 8) return FALSE;
	if(bih->biCompression) return FALSE;
	if(bih->biClrUsed == 0) bih->biClrUsed=256;

	CloseHandle(file);

	return TRUE;
}

int LoadBitmapData(char *name, char *target)
{
	int i;
	unsigned long readbyte;
	HANDLE file;

	BITMAPFILEHEADER bfh;
	BITMAPINFOHEADER bih;

	if(LoadBitmapHeader(name, &bfh, &bih) == FALSE) return FALSE;

	file = CreateFile(name, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(file == INVALID_HANDLE_VALUE) return FALSE;

  	SetFilePointer(file, sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER), NULL, FILE_CURRENT);
	SetFilePointer(file, sizeof(PALETTEENTRY)*bih.biClrUsed, NULL, FILE_CURRENT);

	char *loadpoint = target+bih.biWidth*bih.biHeight;
	loadpoint -= bih.biWidth;
	for(i = 0; i < bih.biHeight; i++) 
	{
		ReadFile(file, loadpoint, bih.biWidth, &readbyte, NULL);
		if(bih.biWidth%4)
			SetFilePointer(file, 4-(bih.biWidth%4), NULL, FILE_CURRENT);
		loadpoint -= bih.biWidth;
	}

	CloseHandle(file);

	return TRUE;
}

int LoadBitmapDataForPitch(char *name, char *target, int pitch)
{
	int i;
	unsigned long readbyte;
	HANDLE file;

	BITMAPFILEHEADER bfh;
	BITMAPINFOHEADER bih;

	if(LoadBitmapHeader(name, &bfh, &bih) == FALSE) return FALSE;

	file = CreateFile(name, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(file == INVALID_HANDLE_VALUE) return FALSE;

  	SetFilePointer(file, sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER), NULL, FILE_CURRENT);
	SetFilePointer(file, sizeof(PALETTEENTRY)*bih.biClrUsed, NULL, FILE_CURRENT);

	char *loadpoint = target+pitch*bih.biHeight;
	loadpoint -= pitch;
	for(i = 0; i < bih.biHeight; i++) 
	{
		ReadFile(file, loadpoint, bih.biWidth, &readbyte, NULL);
		if(bih.biWidth%4)
			SetFilePointer(file, 4-(bih.biWidth%4), NULL, FILE_CURRENT);
		loadpoint -= pitch;
	}

	CloseHandle(file);

	return TRUE;
}

int LoadBitmapPalette(char *name, PALETTEENTRY *paletteentry)
{
	unsigned long readbyte;
	HANDLE file;

	BITMAPFILEHEADER bfh;
	BITMAPINFOHEADER bih;

	if(LoadBitmapHeader(name, &bfh, &bih) == FALSE) return FALSE;

	file = CreateFile(name, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(file == INVALID_HANDLE_VALUE) return FALSE;

  	SetFilePointer(file, sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER), NULL, FILE_CURRENT);
	int temp;
  	ReadFile(file, paletteentry, sizeof(PALETTEENTRY)*bih.biClrUsed, &readbyte, NULL);
	for(int i=0;i<256;i++) 
	{
		temp = paletteentry[i].peBlue;
		paletteentry[i].peBlue = paletteentry[i].peRed;
		paletteentry[i].peRed = temp;
	}

	CloseHandle(file);

	return TRUE;
}