#ifndef _LIST_H
#define _LIST_H

template <class X>
class XList
{
public:
	struct XListElement
	{
		X m_Data;
		XListElement *m_Prev, *m_Next;
	};
	typedef XListElement XIterator;
private:
	int m_MaxCount;
	XListElement *m_Begin, *m_End;
public:
	XList()
	{
		m_MaxCount = 0;
		m_Begin = new XListElement;
		m_End = new XListElement;
		m_Begin->m_Prev = m_Begin;
		m_Begin->m_Next = m_End;
		m_End->m_Prev = m_Begin;
		m_End->m_Next = m_End;
	}

	virtual ~XList() 
	{ 
		delete m_Begin; 
		delete m_End; 
	}

	int GetMaxCount() 
	{ 
		return m_MaxCount; 
	}

	int IsBegin(XIterator *iterator) 
	{ 
		if(iterator == m_Begin) return TRUE; 
		return FALSE; 
	}

	int IsEnd(XIterator *iterator) 
	{ 
		if(iterator == m_End) return TRUE; 
		return FALSE; 
	}
	
	X GetData(XIterator *iterator)  
	{ 
		return iterator->m_Data; 
	}

	X GoFirstElement(XIterator **iterator) 
	{ 
		*iterator = m_Begin->m_Next;
		return (*iterator)->m_Data;
	}

	X GoLastElement(XIterator **iterator)  
	{ 
		*iterator = m_End->m_Prev; 
		return (*iterator)->m_Data;
	}

	X GoPrev(XIterator **iterator, int num=1) 
	{ 
		for(int i = 0; i < num; i++) 
			*iterator = (*iterator)->m_Prev; 
		return (*iterator)->m_Data;
	}

	X GoNext(XIterator **iterator, int num=1)
	{ 
		for(int i = 0; i < num; i++) 
			*iterator = (*iterator)->m_Next; 
		return (*iterator)->m_Data;
	}

	X GoAt(XIterator **iterator, int num) 
	{ 
		*iterator = m_Begin->m_Next; 
		for(int i = 0; i < num; i++) 
			*iterator = (*iterator)->m_Next;
		return (*iterator)->m_Data;
	}
	
	void AddBegin(X data)
	{
		XListElement *temp = new XListElement;
		temp->m_Data = data;
		temp->m_Prev = m_Begin;
		temp->m_Next = m_Begin->m_Next;
		m_Begin->m_Next->m_Prev = temp;
		m_Begin->m_Next = temp;
		m_MaxCount++;
	}
	
	void AddEnd(X data)
	{
		XListElement *temp = new XListElement;
		temp->m_Data = data;
		temp->m_Prev = m_End->m_Prev;
		temp->m_Next = m_End;
		m_End->m_Prev->m_Next = temp;
		m_End->m_Prev = temp;
		m_MaxCount++;
	}
	
	bool AddNext(XIterator **iterator, X data)
	{
		if(*iterator == m_End) return false;
		if(*iterator == m_Begin) { AddBegin(data); return true; }
		XListElement *temp = new XListElement;
		temp->m_Data = data;
		temp->m_Prev = (*iterator)->m_Prev;
		temp->m_Next = *iterator;
		(*iterator)->m_Prev->m_Next = temp;
		(*iterator)->m_Prev = temp;
		m_MaxCount++;
		return true;
	}
	
	bool AddPrev(XIterator **iterator, X data)
	{
		if(*iterator == m_Begin) return false;
		if(*iterator == m_End) { AddEnd(data); return true;}
		XListElement *temp = new XListElement;
		temp->m_Data = data;
		temp->m_Prev = *iterator;
		temp->m_Next = (*iterator)->m_Next;
		(*iterator)->m_Next->m_Prev = temp;
		(*iterator)->m_Next = temp;
		m_MaxCount++;
		return true;
	}
	
	bool InsertAt(int num, X data)
	{
		if(num > m_MaxCount) return false;
		XIterator *temp_iterator = m_Begin->m_Next;
		for(int i = 0; i < num; i++)
			temp_iterator = temp_iterator->m_Next;
		XListElement *temp = new XListElement;
		temp->m_Data = data;
		temp->m_Prev = temp_iterator->m_Prev;
		temp->m_Next = temp_iterator;
		temp_iterator->m_Prev->m_Next = temp;
		temp_iterator->m_Prev = temp;
		m_MaxCount++;
		return true;
	}

	bool RemoveAt(int num)
	{
		XIterator *temp_iterator = m_Begin->m_Next;
		for(int i = 0; i < num; i++)
			temp_iterator = temp_iterator->m_Next;
		if(temp_iterator == m_End) return false;
		XListElement *temp = temp_iterator->m_Prev;
		temp->m_Next->m_Next->m_Prev = temp;
		temp->m_Next = temp->m_Next->m_Next;
		delete temp_iterator;
		m_MaxCount--;
		return true;
	}

	bool Remove(XIterator **iterator)
	{
		if(*iterator == m_Begin) return false;
		if(*iterator == m_End) return false;
		XListElement *temp = (*iterator)->m_Prev;
		temp->m_Next->m_Next->m_Prev = temp;
		temp->m_Next = temp->m_Next->m_Next;
		delete *iterator;
		m_MaxCount--;
		*iterator = temp;
		return true;
	}

	void RemoveAll()
	{
		while(RemoveAt(0) == true);
	}
};

#endif