#include "headers.h"
//#define __DEBUG

int isActive = 1;

XDirectDrawHandler DD;
XDirectInputHandler DI;
char *key;

XImage tank_image;
XImage bomb_image;

void InitAll()
{
	srand( (unsigned)time( NULL ) );

	XBuffer tank_buffer(1,1);
	tank_buffer.LoadBitmap("tank.bmp");
	tank_image.Create(&tank_buffer,tank_buffer.GetBorder(),FALSE);

	XBuffer bomb_buffer(1,1);
	bomb_buffer.LoadBitmap("bomb.bmp");
	bomb_image.Create(&bomb_buffer,bomb_buffer.GetBorder(),FALSE);
}

void ShutDownAll()
{
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_KEYDOWN :
		switch(wParam)
		{
		case VK_ESCAPE :
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			return 0;
		}
		break;
	case WM_ACTIVATEAPP:
		isActive = wParam;
		if(isActive && DD.GetDirectDraw() != NULL)
		{	
			if(DD.GetPrimarySurface()->IsLost() == DDERR_SURFACELOST ) DD.GetPrimarySurface()->Restore();
			if(DD.GetBackSurface()->IsLost() == DDERR_SURFACELOST ) DD.GetBackSurface()->Restore();
		}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	HWND hWnd;
	MSG message;
	WNDCLASS WndClass;

	if(!hPrevInstance)
	{
		WndClass.hInstance = hInstance;
		WndClass.lpszClassName = "Test";
		WndClass.lpfnWndProc = WndProc;
		WndClass.style = 0;
		WndClass.hIcon = LoadIcon(NULL,IDI_APPLICATION);
		WndClass.hCursor = LoadCursor(NULL,IDC_ARROW);
		WndClass.lpszMenuName = NULL;
		WndClass.cbClsExtra = 0;
		WndClass.cbWndExtra = 0;
		WndClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);

		RegisterClass(&WndClass);
	}

#ifdef __DEBUG 
	hWnd = CreateWindow( "Test", "׽Ʈ߿", WS_OVERLAPPEDWINDOW, 0, 0, 640, 480, HWND_DESKTOP, NULL, hInstance, NULL);
	ShowWindow(hWnd, nShowCmd);
	UpdateWindow(hWnd);
	DD.Create(hWnd,FALSE);
#else 
	hWnd = CreateWindow( "Test", "׽Ʈ߿", WS_POPUP, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, HWND_DESKTOP, NULL, hInstance, NULL);
	ShowWindow(hWnd, nShowCmd);
	UpdateWindow(hWnd);
	DD.Create(hWnd,TRUE,640,480);
#endif

	DI.Create(hInstance, hWnd);
	DD.LoadBitmapPalette("background.bmp");
	DD.SetPalette();

	InitAll();

	XStageManager stage;
	stage.Create(&DD, "land.bmp", "background.bmp");
	stage.AddTank(new XTank(rand()%stage.GetLand()->GetWidth(),0,&tank_image,&stage));
	stage.AddTank(new XTank(rand()%stage.GetLand()->GetWidth(),0,&tank_image,&stage));
	stage.AddTank(new XTank(rand()%stage.GetLand()->GetWidth(),0,&tank_image,&stage));
	stage.AddTank(new XTank(rand()%stage.GetLand()->GetWidth(),0,&tank_image,&stage));

	XList<XObject*>::XIterator *iterator;
	stage.GetTankManager()->GoFirstElement(&iterator);
	stage.SetActiveTank(iterator->m_Data);
	stage.SetScrollObject(iterator->m_Data);

	int exit_game = 0;
	while(!exit_game)
	{
		if(PeekMessage(&message,NULL,NULL,NULL,PM_NOREMOVE) != 0)
		{
			if(GetMessage(&message, NULL, NULL, NULL) == 0) 
			{
				exit_game = 1;
				break;
			}
			TranslateMessage(&message);
			DispatchMessage(&message);
		}
		else if(isActive)
		{
			XObject *scroll_object = stage.GetScrollObject();
			if(scroll_object != NULL)
			{
				stage.SetViewX(scroll_object->GetX()-320);
				stage.SetViewY(scroll_object->GetY()-240);
			}

			key = DI.GetKeyboardState();
			stage.Action();
			stage.Draw(&DD);
#ifdef __DEBUG
			DD.GetPrimarySurface()->Blt(NULL,DD.GetBackSurface(),NULL,DDBLT_WAIT,NULL);
#else
			DD.GetPrimarySurface()->Flip(NULL,DDFLIP_WAIT);
#endif
		}
		else WaitMessage();
	}

	return message.wParam;
}