#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "math_func.h"

XTrigTable TrigTable;

XTrigTable::XTrigTable(int cycle, int multiple)
{
	if(m_AllocateFlag == true) return;

	m_Multiple = multiple;
	m_Cycle = cycle;
	if(m_Cycle <= 0) return;

	m_Table = new int [m_Cycle*2-1];
	if(m_Table == NULL) return;
	m_TanTable = new int [m_Cycle*2-1];
	if(m_TanTable == NULL) return;
	m_AllocateFlag = true;

	double angle = 0;
	double angle_add = 6.283185307178;
	angle_add /= (double)cycle;

	int i = 0;
	for(i = m_Cycle-1; i <= (m_Cycle-1)*2; i++)
	{
		m_Table[i] = (int)(sin(angle)*(double)(m_Multiple));
		m_TanTable[i] = (int)(tan(angle)*(double)(m_Multiple));
		angle += angle_add;
	}
	angle = -angle_add;
	for(i = m_Cycle-2; i >= 0; i--)
	{
		m_Table[i] = (int)(sin(angle)*(double)(m_Multiple));
		m_TanTable[i] = (int)(tan(angle)*(double)(m_Multiple));
		angle -= angle_add;
	}
}

XTrigTable::~XTrigTable()
{
	if(m_AllocateFlag == true) 
	{
		delete [] m_Table;
		delete [] m_TanTable;
	}
}

int XTrigTable::GetCycle()
{
	return m_Cycle;
}

int XTrigTable::GetMultiple()
{
	return m_Multiple;
}

int XTrigTable::Sin(int angle)
{
	if(angle >= m_Cycle) angle %= m_Cycle;
	if(angle <= -m_Cycle) angle %= -m_Cycle;
	return m_Table[m_Cycle-1+angle];
}

int XTrigTable::Cos(int angle)
{
	angle += (m_Cycle>>2);
	if(angle >= m_Cycle) angle %= m_Cycle;
	if(angle <= -m_Cycle) angle %= -m_Cycle;
	return m_Table[m_Cycle-1+angle];
}

int XTrigTable::Tan(int angle)
{
	if(angle >= m_Cycle) angle %= m_Cycle;
	if(angle <= -m_Cycle) angle %= -m_Cycle;
	return m_TanTable[m_Cycle-1+angle];
}

